/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc;

import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import io.grpc.protobuf.services.ProtoReflectionService;
import java.lang.reflect.GenericDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lognet.springboot.grpc.GRpcService;
import org.lognet.springboot.grpc.GRpcServicesRegistry;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.context.GRpcServerInitializedEvent;
import org.lognet.springboot.grpc.health.ManagedHealthStatusService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;

public class GRpcServerRunner
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(GRpcServerRunner.class);
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private Optional<ManagedHealthStatusService> healthStatusManager = Optional.empty();
    @Autowired
    private AbstractApplicationContext applicationContext;
    @Autowired
    private GRpcServerProperties gRpcServerProperties;
    @Autowired
    private GRpcServicesRegistry registry;
    private final Consumer<ServerBuilder<?>> configurator;
    private Server server;
    private final ServerBuilder<?> serverBuilder;
    private CountDownLatch latch;

    public GRpcServerRunner(Consumer<ServerBuilder<?>> configurator, ServerBuilder<?> serverBuilder) {
        this.configurator = configurator;
        this.serverBuilder = serverBuilder;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        log.info("Starting gRPC Server ...");
        this.latch = new CountDownLatch(1);
        try {
            Collection<ServerInterceptor> globalInterceptors = this.registry.getGlobalInterceptors();
            ArrayList serviceNames = new ArrayList();
            this.registry.getBeanNameToServiceBeanMap().forEach((name, srv) -> {
                ServerServiceDefinition serviceDefinition = srv.bindService();
                GRpcService gRpcServiceAnn = (GRpcService)this.applicationContext.findAnnotationOnBean(name, GRpcService.class);
                serviceDefinition = this.bindInterceptors(serviceDefinition, gRpcServiceAnn, globalInterceptors);
                this.serverBuilder.addService(serviceDefinition);
                if (srv instanceof HealthGrpc.HealthImplBase) {
                    if (!(srv instanceof ManagedHealthStatusService)) {
                        throw new FatalBeanException(String.format("Please inherit %s from %s rather than directly from %s", srv.getClass().getName(), ManagedHealthStatusService.class.getName(), HealthGrpc.HealthImplBase.class.getName()));
                    }
                    if (this.healthStatusManager.isPresent()) {
                        throw new FatalBeanException(String.format("Only 1 single %s service instance is allowed", ManagedHealthStatusService.class.getName()));
                    }
                    this.healthStatusManager = Optional.of((ManagedHealthStatusService)((Object)srv));
                } else {
                    serviceNames.add(serviceDefinition.getServiceDescriptor().getName());
                }
                log.info("'{}' service has been registered.", (Object)srv.getClass().getName());
            });
            this.healthStatusManager.ifPresent(h -> serviceNames.forEach(serviceName -> h.setStatus((String)serviceName, HealthCheckResponse.ServingStatus.SERVING)));
            if (this.gRpcServerProperties.isEnableReflection()) {
                this.serverBuilder.addService(ProtoReflectionService.newInstance());
                log.info("'{}' service has been registered.", (Object)ProtoReflectionService.class.getName());
            }
            this.configurator.accept(this.serverBuilder);
            this.server = this.serverBuilder.build().start();
            this.isRunning.set(true);
            this.startDaemonAwaitThread();
            log.info("gRPC Server started, listening on port {}.", (Object)this.server.getPort());
            this.applicationContext.publishEvent((ApplicationEvent)new GRpcServerInitializedEvent((ApplicationContext)this.applicationContext, this.server));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start GRPC server", e);
        }
    }

    private ServerServiceDefinition bindInterceptors(ServerServiceDefinition serviceDefinition, GRpcService gRpcService, Collection<ServerInterceptor> globalInterceptors) {
        Stream<ServerInterceptor> privateInterceptors = Stream.of(gRpcService.interceptors()).map(interceptorClass -> {
            try {
                return 0 < this.applicationContext.getBeanNamesForType(interceptorClass).length ? (ServerInterceptor)this.applicationContext.getBean(interceptorClass) : (ServerInterceptor)interceptorClass.newInstance();
            }
            catch (Exception e) {
                throw new BeanCreationException("Failed to create interceptor instance.", (Throwable)e);
            }
        });
        List interceptors = Stream.concat(gRpcService.applyGlobalInterceptors() ? globalInterceptors.stream() : Stream.empty(), privateInterceptors).distinct().sorted(this.serverInterceptorOrderComparator()).collect(Collectors.toList());
        return ServerInterceptors.intercept((ServerServiceDefinition)serviceDefinition, interceptors);
    }

    private Comparator<Object> serverInterceptorOrderComparator() {
        return new AnnotationAwareOrderComparator().withSourceProvider(o -> {
            ArrayList sources = new ArrayList(2);
            Optional<RootBeanDefinition> rootBeanDefinition = Stream.of(this.applicationContext.getBeanNamesForType(o.getClass())).filter(n -> this.applicationContext.getBean(n) == o).findFirst().map(name -> this.applicationContext.getBeanFactory().getBeanDefinition(name)).filter(RootBeanDefinition.class::isInstance).map(RootBeanDefinition.class::cast);
            rootBeanDefinition.map(RootBeanDefinition::getResolvedFactoryMethod).ifPresent(sources::add);
            rootBeanDefinition.map(RootBeanDefinition::getTargetType).filter(t -> t != o.getClass()).ifPresent(sources::add);
            Stream.of(rootBeanDefinition.map(RootBeanDefinition::getResolvedFactoryMethod), Optional.of(o.getClass())).filter(Optional::isPresent).map(opt -> ((GenericDeclaration)opt.get()).getAnnotation(Order.class)).filter(Objects::nonNull).filter(order -> Integer.MAX_VALUE == order.value()).forEach(order -> sources.add(() -> 0x7FFFFFFE));
            return sources.toArray();
        }).reversed();
    }

    private void startDaemonAwaitThread() {
        Thread awaitThread = new Thread(() -> {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                log.error("gRPC server awaiter interrupted.", (Throwable)e);
            }
            finally {
                this.isRunning.set(false);
            }
        });
        awaitThread.setName("grpc-server-awaiter");
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    public void stop() {
        Optional.ofNullable(this.server).ifPresent(s -> {
            log.info("Shutting down gRPC server ...");
            this.healthStatusManager.ifPresent(ManagedHealthStatusService::onShutdown);
            s.shutdown();
            int shutdownGrace = this.gRpcServerProperties.getShutdownGrace();
            try {
                if (shutdownGrace < 0) {
                    s.awaitTermination();
                } else if (shutdownGrace > 0) {
                    s.awaitTermination((long)shutdownGrace, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException e) {
                log.error("gRPC server interrupted during destroy.", (Throwable)e);
            }
            finally {
                this.latch.countDown();
            }
            log.info("gRPC server stopped.");
        });
    }

    public int getPhase() {
        return this.gRpcServerProperties.getStartUpPhase();
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }
}

