/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core;

import com.luckyframework.common.StringUtils;
import com.luckyframework.httpclient.core.ContentType;
import com.luckyframework.serializable.JsonSerializationScheme;
import com.luckyframework.serializable.SerializationException;
import com.luckyframework.serializable.SerializationSchemeFactory;
import com.luckyframework.serializable.XmlSerializationScheme;
import java.nio.charset.Charset;

public class BodyObject {
    private static final JsonSerializationScheme jsonScheme = SerializationSchemeFactory.getJsonScheme();
    private static final XmlSerializationScheme xmlScheme = SerializationSchemeFactory.getXmlScheme();
    private final ContentType contentType;
    private final String body;

    BodyObject(ContentType contentType, String body) {
        this.contentType = contentType;
        this.body = body;
    }

    public static BodyObject builder(String mimeType, String charset, String body) {
        return new BodyObject(new ContentType(mimeType, Charset.forName(charset)), body);
    }

    public static BodyObject builder(ContentType contentType, String body) {
        return new BodyObject(contentType, body);
    }

    public static BodyObject jsonBody(String jsonBody) {
        return new BodyObject(ContentType.APPLICATION_JSON, jsonBody);
    }

    public static BodyObject jsonBody(Object jsonBody) {
        try {
            return new BodyObject(ContentType.APPLICATION_JSON, jsonScheme.serialization(jsonBody));
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public static BodyObject xmlBody(String xmlBody) {
        return new BodyObject(ContentType.APPLICATION_XML, xmlBody);
    }

    public static BodyObject xmlBody(Object xmlBody) {
        try {
            return new BodyObject(ContentType.APPLICATION_XML, xmlScheme.serialization(xmlBody));
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public String getBody() {
        return this.body;
    }

    public String toString() {
        return StringUtils.format((String)"[{0}] {1}", (Object[])new Object[]{this.contentType, this.body});
    }
}

