/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core;

import com.luckyframework.common.ContainerUtils;
import com.luckyframework.common.TempPair;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ContentType
implements Serializable {
    public static final ContentType APPLICATION_ATOM_XML = ContentType.create("application/atom+xml", StandardCharsets.ISO_8859_1);
    public static final ContentType APPLICATION_FORM_URLENCODED = ContentType.create("application/x-www-form-urlencoded", StandardCharsets.ISO_8859_1);
    public static final ContentType APPLICATION_JSON = ContentType.create("application/json", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_OCTET_STREAM = ContentType.create("application/octet-stream", (Charset)null);
    public static final ContentType APPLICATION_SVG_XML = ContentType.create("application/svg+xml", StandardCharsets.ISO_8859_1);
    public static final ContentType APPLICATION_XHTML_XML = ContentType.create("application/xhtml+xml", StandardCharsets.ISO_8859_1);
    public static final ContentType APPLICATION_XML = ContentType.create("application/xml", StandardCharsets.ISO_8859_1);
    public static final ContentType MULTIPART_FORM_DATA = ContentType.create("multipart/form-data", StandardCharsets.ISO_8859_1);
    public static final ContentType TEXT_HTML = ContentType.create("text/html", StandardCharsets.ISO_8859_1);
    public static final ContentType TEXT_PLAIN = ContentType.create("text/plain", StandardCharsets.ISO_8859_1);
    public static final ContentType TEXT_XML = ContentType.create("text/xml", StandardCharsets.ISO_8859_1);
    public static final ContentType WILDCARD = ContentType.create("*/*", (Charset)null);
    public static final ContentType DEFAULT_TEXT = TEXT_PLAIN;
    public static final ContentType DEFAULT_BINARY = APPLICATION_OCTET_STREAM;
    private final String mimeType;
    private final Charset charset;
    private final TempPair<String, String>[] params;

    ContentType(String mimeType, Charset charset) {
        this.mimeType = mimeType;
        this.charset = charset;
        this.params = null;
    }

    ContentType(String mimeType, TempPair<String, String>[] params) {
        this.mimeType = mimeType;
        this.params = params;
        String s = this.getParameter("charset");
        this.charset = StringUtils.hasText((String)s) ? Charset.forName(s) : StandardCharsets.UTF_8;
    }

    public String getParameter(String name) {
        Assert.notNull((Object)name, (String)"Parameter name is null");
        if (this.params == null) {
            return null;
        }
        for (TempPair<String, String> param : this.params) {
            if (!((String)param.getOne()).equalsIgnoreCase(name)) continue;
            return (String)param.getTwo();
        }
        return null;
    }

    public static ContentType create(String mimeType, Charset charset) {
        Assert.notNull((Object)mimeType, (String)"MIME type is null");
        String type = mimeType.toLowerCase(Locale.ENGLISH);
        Assert.isTrue((boolean)ContentType.valid(type), (String)"MIME type may not contain reserved characters");
        return new ContentType(type, charset);
    }

    public static ContentType create(String mimeType, String charset) throws UnsupportedCharsetException {
        return ContentType.create(mimeType, StringUtils.hasText((String)charset) ? Charset.forName(charset) : null);
    }

    public static ContentType create(String mimeType, TempPair<String, String>[] params) throws UnsupportedCharsetException {
        return new ContentType(mimeType, params);
    }

    private static boolean valid(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != '\"' && ch != ',' && ch != ';') continue;
            return false;
        }
        return true;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public TempPair<String, String>[] getParams() {
        return this.params;
    }

    public String toString() {
        String paramStr;
        String charsetTemp = this.charset == null ? "" : "charset=" + this.charset;
        StringBuilder paramTemp = new StringBuilder();
        if (!ContainerUtils.isEmptyArray((Object[])this.params)) {
            for (TempPair<String, String> param : this.params) {
                paramTemp.append((String)param.getOne()).append("=").append((String)param.getTwo()).append(";");
            }
        }
        paramStr = (paramStr = paramTemp.toString()).endsWith(";") ? paramStr.substring(0, paramStr.length() - 1) : paramStr;
        String result = this.mimeType;
        if (StringUtils.hasText((String)charsetTemp)) {
            result = result + ";" + charsetTemp;
        }
        if (StringUtils.hasText((String)paramStr)) {
            result = result + ";" + paramStr;
        }
        return result;
    }
}

