/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class Header {
    private final HeaderType headerType;
    private final String name;
    private final Object value;
    private final Map<String, String> nameValuePairMap;

    public Header(String name, Object value, HeaderType headerType) {
        this.name = name;
        this.headerType = headerType;
        this.value = value;
        this.nameValuePairMap = Collections.unmodifiableMap(this.initNameValuePairMap());
    }

    public Map<String, String> initNameValuePairMap() {
        LinkedHashMap<String, String> nameValuePairMap = new LinkedHashMap<String, String>();
        if (this.value != null && StringUtils.hasText((String)this.value.toString().trim())) {
            String[] nameValueStrArray;
            for (String nameValueStr : nameValueStrArray = this.value.toString().trim().split(";")) {
                int index = nameValueStr.indexOf("=");
                if (index == -1 || nameValueStr.endsWith("==")) {
                    nameValuePairMap.put(this.name, nameValueStr.trim().toLowerCase());
                    continue;
                }
                nameValuePairMap.put(nameValueStr.substring(0, index).trim().toLowerCase(), nameValueStr.substring(index + 1));
            }
        }
        return nameValuePairMap;
    }

    public static Header builderAdd(String name, Object value) {
        return new Header(name, value, HeaderType.ADD);
    }

    public static Header builderSet(String name, Object value) {
        return new Header(name, value, HeaderType.SET);
    }

    public static Header builderShow(String name, Object value) {
        return new Header(name, value, HeaderType.SHOW);
    }

    public String getInternalValue(String internalName) {
        return this.nameValuePairMap.get(internalName.toLowerCase());
    }

    public HeaderType getHeaderType() {
        return this.headerType;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public Map<String, String> getNameValuePairMap() {
        return this.nameValuePairMap;
    }

    public String getHeaderString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.nameValuePairMap.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String toString() {
        switch (this.headerType) {
            case ADD: {
                return "(A)" + this.name + ": " + this.value;
            }
            case SET: {
                return "(S)" + this.name + ": " + this.value;
            }
        }
        return this.name + ": " + this.value;
    }

    public int size() {
        return this.nameValuePairMap.size();
    }

    public boolean isEmpty() {
        return this.nameValuePairMap.isEmpty();
    }

    public boolean containsKey(String name) {
        return this.nameValuePairMap.containsKey(name.toLowerCase());
    }

    public boolean containsValue(Object headerValue) {
        return this.nameValuePairMap.containsKey(headerValue);
    }

    public static enum HeaderType {
        ADD,
        SET,
        SHOW;

    }
}

