/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core;

import com.luckyframework.io.MultipartFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;

public class HttpFile
implements InputStreamSource {
    private final InputStreamSource inputStreamSource;
    private final Supplier<String> fileNameSupp;
    private InputStream inputStream;
    private String fileName;

    public HttpFile(InputStreamSource inputStreamSource, Supplier<String> fileNameSupp) {
        this.inputStreamSource = inputStreamSource;
        this.fileNameSupp = fileNameSupp;
    }

    public HttpFile(File file) {
        this(() -> Files.newInputStream(file.toPath(), new OpenOption[0]), file::getName);
    }

    public HttpFile(File file, String fileName) {
        this(() -> Files.newInputStream(file.toPath(), new OpenOption[0]), () -> fileName);
    }

    public HttpFile(MultipartFile multipartFile) {
        this((InputStreamSource)multipartFile, () -> ((MultipartFile)multipartFile).getOriginalFileName());
    }

    public HttpFile(MultipartFile multipartFile, String fileName) {
        this((InputStreamSource)multipartFile, () -> fileName);
    }

    public HttpFile(Resource resource) {
        this((InputStreamSource)resource, () -> ((Resource)resource).getFilename());
    }

    public HttpFile(Resource resource, String fileName) {
        this((InputStreamSource)resource, () -> fileName);
    }

    public HttpFile(InputStream inputStream, String fileName) {
        this(() -> inputStream, () -> fileName);
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            return this.inputStreamSource.getInputStream();
        }
        return this.inputStream;
    }

    public String getFileName() {
        if (this.fileName == null) {
            this.fileName = this.fileNameSupp.get();
        }
        return this.fileName;
    }
}

