/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core;

import com.luckyframework.common.ContainerUtils;
import com.luckyframework.common.TempPair;
import com.luckyframework.httpclient.core.ContentType;
import com.luckyframework.httpclient.core.Header;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public interface HttpHeaderManager {
    public HttpHeaderManager addHeader(String var1, Object var2);

    public HttpHeaderManager setHeader(String var1, Object var2);

    public HttpHeaderManager putHeader(String var1, Object var2);

    public HttpHeaderManager removerHeader(String var1);

    public HttpHeaderManager setHeaders(Map<String, List<Header>> var1);

    default public Header getFirstHeader(String name) {
        List<Header> headerList = this.getHeader(name);
        if (ContainerUtils.isEmptyCollection(headerList)) {
            return null;
        }
        return headerList.get(0);
    }

    default public Header getLastHeader(String name) {
        List<Header> headerList = this.getHeader(name);
        if (ContainerUtils.isEmptyCollection(headerList)) {
            return null;
        }
        return headerList.get(headerList.size() - 1);
    }

    default public ContentType getContentType() {
        Header header = this.getFirstHeader("Content-Type");
        if (header == null || header.getValue() == null) {
            return ContentType.DEFAULT_TEXT;
        }
        String[] contents = header.getValue().toString().split(";");
        String mimeType = null;
        ArrayList<TempPair> paramsList = new ArrayList<TempPair>();
        for (String content : contents) {
            if (!(content = content.trim()).contains("=") && mimeType == null) {
                mimeType = content;
                continue;
            }
            if (!content.contains("=")) continue;
            String[] nameValue = content.split("=");
            String name = nameValue[0].trim().toLowerCase();
            String value = nameValue.length == 1 ? "" : nameValue[1].trim().toLowerCase();
            paramsList.add(TempPair.of((Object)name, (Object)value));
        }
        mimeType = mimeType == null ? ContentType.DEFAULT_TEXT.getMimeType() : mimeType;
        return ContentType.create(mimeType, paramsList.toArray(new TempPair[0]));
    }

    default public HttpHeaderManager setContentType(String contentType) {
        return this.setHeader("Content-Type", contentType);
    }

    default public HttpHeaderManager setContentType(ContentType contentType) {
        return this.setHeader("Content-Type", contentType.toString());
    }

    public List<Header> getHeader(String var1);

    public HttpHeaderManager removerFirstHeader(String var1);

    public HttpHeaderManager removerLastHeader(String var1);

    public HttpHeaderManager removerHeader(String var1, int var2);

    public Map<String, List<Header>> getHeaderMap();

    default public List<Header> getHeaders() {
        LinkedList<Header> headers = new LinkedList<Header>();
        for (List<Header> headerList : this.getHeaderMap().values()) {
            headers.addAll(headerList);
        }
        return headers;
    }

    default public HttpHeaderManager setAuthorization(String username, String password) {
        String auth = username + ":" + password;
        byte[] encodeAuth = Base64.getEncoder().encode(auth.getBytes());
        String authHeader = "Basic " + new String(encodeAuth, StandardCharsets.UTF_8);
        this.addHeader("Authorization", authHeader);
        return this;
    }

    default public void check(String name, Object header) {
        this.checkHeaderName(name);
        this.checkHeaderValue(header);
    }

    default public void checkHeaderName(String name) {
        Assert.notNull((Object)name, (String)"Header name is null");
    }

    default public void checkHeaderValue(Object value) {
        Assert.notNull((Object)value, (String)"Header value is null");
    }
}

