/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core;

import com.luckyframework.common.StringUtils;
import com.luckyframework.httpclient.core.Header;
import com.luckyframework.httpclient.core.HttpHeaderManager;
import com.luckyframework.httpclient.core.RequestMethod;
import com.luckyframework.httpclient.core.RequestParameter;
import com.luckyframework.httpclient.core.impl.DefaultRequest;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;

public interface Request
extends RequestParameter,
HttpHeaderManager {
    public static final Integer DEF_CONNECTION_TIME_OUT = 60000;
    public static final Integer DEF_READ_TIME_OUT = 20000;
    public static final Integer DEF_WRITER_TIME_OUT = 20000;

    public String getUrl();

    public RequestMethod getRequestMethod();

    public HttpHeaderManager getHeaderManager();

    public RequestParameter getRequestParameter();

    public Integer getConnectTimeout();

    public Request setConnectTimeout(Integer var1);

    public Integer getReadTimeout();

    public Request setReadTimeout(Integer var1);

    public Integer getWriterTimeout();

    public Request setWriterTimeout(Integer var1);

    public Request setProxy(Proxy var1);

    public Proxy getProxy();

    default public Request setProxy(String ip, int port) {
        return this.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ip, port)));
    }

    default public Request addCookie(String name, String value) {
        this.addHeader("Cookie", name + "=" + value);
        return this;
    }

    default public String getCookie(String name) {
        List<Header> cookieList = this.getHeader("Cookie");
        for (Header header : cookieList) {
            if (!header.containsKey(name)) continue;
            return header.getInternalValue(name);
        }
        return null;
    }

    default public List<Header> getCookies() {
        return this.getHeader("Cookie");
    }

    default public Request removeCookie(String name) {
        List<Header> cookieList = this.getHeader("Cookie");
        cookieList.removeIf(header -> header.containsKey(name));
        return this;
    }

    public static DefaultRequest builder(String url, RequestMethod requestMethod, Object ... pathParams) {
        url = StringUtils.format((String)url, (Object[])pathParams);
        return new DefaultRequest(url, requestMethod);
    }

    public static DefaultRequest get(String url, Object ... pathParams) {
        return Request.builder(url, RequestMethod.GET, pathParams);
    }

    public static DefaultRequest post(String url, Object ... pathParams) {
        return Request.builder(url, RequestMethod.POST, pathParams);
    }

    public static DefaultRequest delete(String url, Object ... pathParams) {
        return Request.builder(url, RequestMethod.DELETE, pathParams);
    }

    public static DefaultRequest put(String url, Object ... pathParams) {
        return Request.builder(url, RequestMethod.PUT, pathParams);
    }

    public static DefaultRequest head(String url, Object ... pathParams) {
        return Request.builder(url, RequestMethod.HEAD, pathParams);
    }

    public static DefaultRequest patch(String url, Object ... pathParams) {
        return Request.builder(url, RequestMethod.PATCH, pathParams);
    }

    public static DefaultRequest connect(String url, Object ... pathParams) {
        return Request.builder(url, RequestMethod.CONNECT, pathParams);
    }

    public static DefaultRequest options(String url, Object ... pathParams) {
        return Request.builder(url, RequestMethod.OPTIONS, pathParams);
    }

    public static DefaultRequest trace(String url, Object ... pathParams) {
        return Request.builder(url, RequestMethod.TRACE, pathParams);
    }
}

