/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core;

import com.luckyframework.conversion.ConversionUtils;
import com.luckyframework.httpclient.core.BodyObject;
import com.luckyframework.httpclient.core.HttpExecutorException;
import com.luckyframework.httpclient.core.HttpFile;
import com.luckyframework.io.HttpResource;
import com.luckyframework.io.MultipartFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public interface RequestParameter {
    public Map<String, Object> getRequestParameters();

    public Map<String, Object> getPathParameters();

    public Map<String, List<Object>> getQueryParameters();

    public RequestParameter setBody(BodyObject var1);

    public BodyObject getBody();

    public RequestParameter addPathParameter(String var1, Object var2);

    public RequestParameter setPathParameter(Map<String, Object> var1);

    public RequestParameter addRequestParameter(String var1, Object var2);

    public RequestParameter setRequestParameter(Map<String, Object> var1);

    public RequestParameter addQueryParameter(String var1, Object var2);

    public RequestParameter setQueryParameter(String var1, Object var2);

    public RequestParameter setQueryParameters(Map<String, List<Object>> var1);

    public RequestParameter removerRequestParameter(String var1);

    public RequestParameter removerPathParameter(String var1);

    public RequestParameter removerQueryParameter(String var1);

    public RequestParameter removerQueryParameter(String var1, int var2);

    default public RequestParameter addFormParameter(String name, Object value) {
        this.addRequestParameter(name, value);
        return this;
    }

    default public RequestParameter addHttpFiles(String name, HttpFile ... httpFiles) {
        this.addRequestParameter(name, httpFiles);
        return this;
    }

    default public RequestParameter addInputStream(String name, String fileName, InputStream inputStream) {
        this.addHttpFiles(name, new HttpFile(inputStream, name));
        return this;
    }

    default public RequestParameter addFiles(String name, File ... files) {
        this.addRequestParameter(name, files);
        return this;
    }

    default public RequestParameter addFiles(String name, String ... filePaths) {
        this.addFiles(name, (File[])ConversionUtils.conversion((Object)filePaths, File[].class));
        return this;
    }

    default public RequestParameter addResources(String name, Resource ... resources) {
        this.addRequestParameter(name, Stream.of(resources).filter(Objects::nonNull).map(r -> {
            try {
                String protocol = r.getURL().getProtocol();
                if ("http".equals(protocol) || "https".equals(protocol)) {
                    return new HttpResource((UrlResource)r);
                }
                return r;
            }
            catch (IOException e) {
                throw new HttpExecutorException(e);
            }
        }).toArray(Resource[]::new));
        return this;
    }

    default public RequestParameter addResources(String name, String ... resourcePaths) {
        this.addResources(name, (Resource[])ConversionUtils.conversion((Object)resourcePaths, Resource[].class));
        return this;
    }

    default public RequestParameter addMultipartFiles(String name, MultipartFile ... multipartFiles) {
        this.addRequestParameter(name, multipartFiles);
        return this;
    }

    default public RequestParameter setJsonBody(Object jsonBody) {
        this.setBody(BodyObject.jsonBody(jsonBody));
        return this;
    }

    default public RequestParameter setJsonBody(String jsonBodyString) {
        this.setBody(BodyObject.jsonBody(jsonBodyString));
        return this;
    }

    default public RequestParameter setXmlBody(Object xmlBody) {
        this.setBody(BodyObject.jsonBody(xmlBody));
        return this;
    }

    default public RequestParameter setXmlBody(String xmlBodyString) {
        this.setBody(BodyObject.jsonBody(xmlBodyString));
        return this;
    }
}

