/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core;

import com.luckyframework.common.DateUtils;
import com.luckyframework.common.NanoIdUtils;
import com.luckyframework.common.StringUtils;
import com.luckyframework.httpclient.core.Header;
import com.luckyframework.httpclient.core.HttpHeaderManager;
import com.luckyframework.httpclient.core.ResponseMetaData;
import com.luckyframework.web.ContentTypeUtils;

public class ResourceNameParser {
    public static String getResourceName(ResponseMetaData responseMetaData) {
        HttpHeaderManager headerManager = responseMetaData.getResponseHeader();
        Header header = headerManager.getFirstHeader("Content-Disposition");
        if (header != null && header.containsKey("filename")) {
            return StringUtils.trimBothEndsChars((String)header.getInternalValue("filename").trim(), (String)"\"").trim();
        }
        if (headerManager.getFirstHeader("Content-Type") != null) {
            String fileExtension = ContentTypeUtils.getFileExtension((String)headerManager.getContentType().getMimeType());
            if (fileExtension != null) {
                return StringUtils.format((String)"{}-{}.{}", (Object[])new Object[]{NanoIdUtils.randomNanoId((int)5), DateUtils.time(), fileExtension});
            }
            return StringUtils.getUrlResourceName((String)responseMetaData.getRequest().getUrl());
        }
        return StringUtils.getUrlResourceName((String)responseMetaData.getRequest().getUrl());
    }
}

