/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core;

import com.j256.simplemagic.ContentInfo;
import com.j256.simplemagic.ContentInfoUtil;
import com.luckyframework.common.ConfigurationMap;
import com.luckyframework.httpclient.core.ContentType;
import com.luckyframework.httpclient.core.Header;
import com.luckyframework.httpclient.core.HttpHeaderManager;
import com.luckyframework.httpclient.core.Request;
import com.luckyframework.httpclient.core.ResourceNameParser;
import com.luckyframework.httpclient.core.ResponseMetaData;
import com.luckyframework.io.MultipartFile;
import com.luckyframework.serializable.JsonSerializationScheme;
import com.luckyframework.serializable.SerializationException;
import com.luckyframework.serializable.SerializationSchemeFactory;
import com.luckyframework.serializable.SerializationTypeToken;
import com.luckyframework.serializable.XmlSerializationScheme;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.io.InputStreamSource;
import org.springframework.lang.Nullable;

public interface Response {
    public static final JsonSerializationScheme jsonScheme = SerializationSchemeFactory.getJsonScheme();
    public static final XmlSerializationScheme xmlScheme = SerializationSchemeFactory.getXmlScheme();

    public Request getRequest();

    public int getState();

    public HttpHeaderManager getHeaderManager();

    public byte[] getResult();

    public ResponseMetaData getResponseMetaData();

    default public ContentType getContentType() {
        return this.getHeaderManager().getContentType();
    }

    default public String getCookie(String name) {
        List<Header> cookieList = this.getHeaderManager().getHeader("Set-Cookie");
        for (Header header : cookieList) {
            if (!header.containsKey(name)) continue;
            return header.getInternalValue(name);
        }
        return null;
    }

    default public List<Header> getCookies() {
        return this.getHeaderManager().getHeader("Set-Cookie");
    }

    default public String getStringResult() {
        return this.getStringResult(this.getContentType().getCharset());
    }

    default public String getStringResult(Charset charset) {
        return new String(this.getResult(), charset);
    }

    default public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getResult());
    }

    default public InputStreamSource getInputStreamSource() {
        return this::getInputStream;
    }

    default public MultipartFile getMultipartFile() {
        return new MultipartFile(this.getInputStream(), ResourceNameParser.getResourceName(this.getResponseMetaData()));
    }

    @Nullable
    default public ContentInfo getResultContentInfo() {
        return new ContentInfoUtil().findMatch(this.getResult());
    }

    default public <T> T getEntity(Type type) {
        if (type == MultipartFile.class) {
            return (T)this.getMultipartFile();
        }
        if (InputStream.class == type || ByteArrayInputStream.class == type) {
            return (T)this.getInputStream();
        }
        if (type == InputStreamSource.class) {
            return (T)this.getInputStreamSource();
        }
        if (type == byte[].class) {
            return (T)this.getResult();
        }
        String strResult = this.getStringResult();
        if (type == String.class) {
            return (T)strResult;
        }
        try {
            if (this.isJsonType()) {
                return this.jsonStrToEntity(type);
            }
            if (this.isXmlType()) {
                return this.xmlStrToEntity(type);
            }
            throw new SerializationException("This method only supports the conversion of response bodies of type 'JSON' and 'XML'.");
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
    }

    default public <T> T getEntity(SerializationTypeToken<T> typeToken) {
        return this.getEntity(typeToken.getType());
    }

    default public <T> T getEntity(Class<T> entityClass) {
        return this.getEntity((Type)entityClass);
    }

    default public Map<String, Object> getMapResult() {
        return this.getEntity(new SerializationTypeToken<Map<String, Object>>(){});
    }

    default public List<Map<String, Object>> getMapListResult() {
        return this.getEntity(new SerializationTypeToken<List<Map<String, Object>>>(){});
    }

    default public ConfigurationMap getConfigMapResult() {
        ConfigurationMap configurationMap = new ConfigurationMap();
        configurationMap.addProperties(this.getMapResult());
        return configurationMap;
    }

    default public List<ConfigurationMap> getConfigMapListResult() {
        return this.getMapListResult().stream().map(map -> {
            ConfigurationMap configurationMap = new ConfigurationMap();
            configurationMap.addProperties(map);
            return configurationMap;
        }).collect(Collectors.toList());
    }

    default public <T> T jsonStrToEntity(Type type) {
        try {
            return (T)jsonScheme.deserialization(this.getStringResult(), type);
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
    }

    default public <T> T jsonStrToEntity(SerializationTypeToken<T> typeToken) {
        return this.jsonStrToEntity(typeToken.getType());
    }

    default public <T> T jsonStrToEntity(Class<T> entityClass) {
        return this.jsonStrToEntity((Type)entityClass);
    }

    default public Map<String, Object> jsonStrToMap() {
        return this.jsonStrToEntity(new SerializationTypeToken<Map<String, Object>>(){});
    }

    default public List<Map<String, Object>> jsonStrToMapList() {
        return this.jsonStrToEntity(new SerializationTypeToken<List<Map<String, Object>>>(){});
    }

    default public ConfigurationMap jsonStrToConfigMap() {
        ConfigurationMap configMap = new ConfigurationMap();
        configMap.addProperties(this.jsonStrToMap());
        return configMap;
    }

    default public List<ConfigurationMap> jsonStrToConfigMapList() {
        return this.jsonStrToMapList().stream().map(map -> {
            ConfigurationMap configMap = new ConfigurationMap();
            configMap.addProperties(map);
            return configMap;
        }).collect(Collectors.toList());
    }

    default public <T> T xmlStrToEntity(Type type) {
        try {
            return (T)xmlScheme.deserialization(this.getStringResult(), type);
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
    }

    default public <T> T xmlStrToEntity(SerializationTypeToken<T> typeToken) {
        return this.xmlStrToEntity(typeToken.getType());
    }

    default public <T> T xmlStrToEntity(Class<T> entityClass) {
        return this.xmlStrToEntity((Type)entityClass);
    }

    default public Map<String, Object> xmlStrToMap() {
        return this.xmlStrToEntity(new SerializationTypeToken<Map<String, Object>>(){});
    }

    default public List<Map<String, Object>> xmlStrToMapList() {
        return this.xmlStrToEntity(new SerializationTypeToken<List<Map<String, Object>>>(){});
    }

    default public ConfigurationMap xmlStrToConfigMap() {
        ConfigurationMap configMap = new ConfigurationMap();
        configMap.addProperties(this.xmlStrToMap());
        return configMap;
    }

    default public List<ConfigurationMap> xmlStrToConfigMapList() {
        return this.xmlStrToMapList().stream().map(map -> {
            ConfigurationMap configMap = new ConfigurationMap();
            configMap.addProperties(map);
            return configMap;
        }).collect(Collectors.toList());
    }

    default public boolean isJsonType() {
        return this.getContentType().getMimeType().equalsIgnoreCase(ContentType.APPLICATION_JSON.getMimeType());
    }

    default public boolean isXmlType() {
        ContentType contentType = this.getContentType();
        return contentType.getMimeType().equalsIgnoreCase(ContentType.APPLICATION_XML.getMimeType()) || contentType.equals(ContentType.TEXT_XML);
    }
}

