/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core;

import com.luckyframework.httpclient.core.HttpHeaderManager;
import com.luckyframework.httpclient.core.InputStreamFactory;
import com.luckyframework.httpclient.core.Request;
import com.luckyframework.httpclient.core.ResourceNameParser;
import java.io.IOException;
import java.io.InputStream;

public class ResponseMetaData {
    private final Request request;
    private final int status;
    private final HttpHeaderManager responseHeader;
    private final InputStreamFactory inputStreamFactory;
    private String downloadFilename;

    public ResponseMetaData(Request request, int status, HttpHeaderManager responseHeader, InputStreamFactory inputStreamFactory) {
        this.request = request;
        this.status = status;
        this.responseHeader = responseHeader;
        this.inputStreamFactory = inputStreamFactory;
    }

    public Request getRequest() {
        return this.request;
    }

    public int getStatus() {
        return this.status;
    }

    public HttpHeaderManager getResponseHeader() {
        return this.responseHeader;
    }

    public InputStream getInputStream() throws IOException {
        return this.inputStreamFactory.getInputStream();
    }

    public boolean isSuccess() {
        return this.status == 200;
    }

    public String getRequestUrl() {
        return this.request.getUrl();
    }

    public String getDownloadFilename() {
        if (this.downloadFilename == null) {
            this.downloadFilename = ResourceNameParser.getResourceName(this);
        }
        return this.downloadFilename;
    }
}

