/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core;

import com.luckyframework.httpclient.core.HttpExecutorException;
import com.luckyframework.httpclient.core.Request;
import com.luckyframework.httpclient.core.ResponseMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface ResponseProcessor {
    public static final Logger log = LoggerFactory.getLogger(ResponseProcessor.class);
    public static final ResponseProcessor DO_NOTHING_PROCESSOR = rmd -> {
        if (!rmd.isSuccess()) {
            log.warn("Unsuccessful return code [{}], the current request is: {}", (Object)rmd.getStatus(), (Object)rmd.getRequest());
        }
    };

    public void process(ResponseMetaData var1);

    default public void exceptionHandler(Request request, Exception e) {
        if (e instanceof HttpExecutorException) {
            throw (HttpExecutorException)((Object)e);
        }
        throw new HttpExecutorException("An exception occurred while executing an HTTP request: " + request, e);
    }
}

