/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core.executor;

import com.luckyframework.common.ContainerUtils;
import com.luckyframework.httpclient.core.BodyObject;
import com.luckyframework.httpclient.core.Header;
import com.luckyframework.httpclient.core.HttpExecutorException;
import com.luckyframework.httpclient.core.HttpFile;
import com.luckyframework.httpclient.core.HttpHeaderManager;
import com.luckyframework.httpclient.core.Request;
import com.luckyframework.httpclient.core.RequestParameter;
import com.luckyframework.httpclient.core.ResponseMetaData;
import com.luckyframework.httpclient.core.ResponseProcessor;
import com.luckyframework.httpclient.core.executor.HttpExecutor;
import com.luckyframework.httpclient.core.impl.DefaultHttpHeaderManager;
import com.luckyframework.httpclient.exception.NotFindRequestException;
import com.luckyframework.web.ContentTypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

public class HttpClientExecutor
implements HttpExecutor {
    private final HttpClientBuilder builder;

    public HttpClientExecutor(HttpClientBuilder builder) {
        this.builder = builder;
    }

    public HttpClientExecutor() {
        this.builder = this.defaultHttpClientBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(Request request, ResponseProcessor processor) throws Exception {
        CloseableHttpResponse response = null;
        try {
            CloseableHttpClient client = this.builder.build();
            HttpRequestBase httpRequestBase = this.createHttpClientRequest(request);
            this.requestConfigSetting(httpRequestBase, request);
            this.httpRequestSetting(httpRequestBase, request);
            response = client.execute((HttpUriRequest)httpRequestBase);
            this.resultProcess(request, processor, response);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                throw new HttpExecutorException("An exception occurred when releasing resources after the request ended:" + request, e);
            }
        }
    }

    private void requestConfigSetting(HttpRequestBase httpRequestBase, Request request) {
        Integer connectTimeout = request.getConnectTimeout();
        Integer readTimeout = request.getReadTimeout();
        RequestConfig.Builder reqConfigBuilder = RequestConfig.custom();
        if (request.getProxy() != null) {
            InetSocketAddress address = (InetSocketAddress)request.getProxy().address();
            reqConfigBuilder.setProxy(new HttpHost(address.getHostName(), address.getPort()));
        }
        if (connectTimeout != null && connectTimeout > 0) {
            reqConfigBuilder.setConnectTimeout(connectTimeout.intValue());
        }
        if (readTimeout != null && readTimeout > 0) {
            reqConfigBuilder.setSocketTimeout(readTimeout.intValue());
        }
        httpRequestBase.setConfig(reqConfigBuilder.build());
    }

    protected void httpRequestSetting(HttpRequestBase httpRequestBase, Request request) {
        this.doHeaderSetting(httpRequestBase, request);
    }

    protected void doHeaderSetting(HttpRequestBase httpRequestBase, Request request) {
        Map<String, List<Header>> headerMap = request.getHeaderMap();
        for (Map.Entry<String, List<Header>> entry : headerMap.entrySet()) {
            String headerName = entry.getKey();
            List<Header> headerList = entry.getValue();
            if (ContainerUtils.isEmptyCollection(headerList)) continue;
            for (Header header : headerList) {
                Object headerValue = header.getValue();
                if (headerValue == null) continue;
                switch (header.getHeaderType()) {
                    case ADD: {
                        httpRequestBase.addHeader(headerName, headerValue.toString());
                        break;
                    }
                    case SET: {
                        httpRequestBase.setHeader(headerName, headerValue.toString());
                    }
                }
            }
        }
    }

    protected HttpClientBuilder defaultHttpClientBuilder() {
        HttpClientBuilder builder = HttpClients.custom();
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        requestConfig.setConnectTimeout(Request.DEF_CONNECTION_TIME_OUT.intValue());
        requestConfig.setConnectionRequestTimeout(5000);
        requestConfig.setSocketTimeout(Request.DEF_CONNECTION_TIME_OUT.intValue());
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(10);
        connectionManager.setDefaultConnectionConfig(ConnectionConfig.custom().setCharset(StandardCharsets.UTF_8).build());
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(30000).setSoReuseAddress(true).build();
        connectionManager.setDefaultSocketConfig(socketConfig);
        builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        builder.setDefaultRequestConfig(requestConfig.build());
        return builder;
    }

    protected void resultProcess(Request request, ResponseProcessor processor, CloseableHttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        org.apache.http.Header[] allHeaders = response.getAllHeaders();
        HttpEntity entity = response.getEntity();
        HttpHeaderManager httpHeaderManager = this.changeToLuckyHeader(allHeaders);
        processor.process(new ResponseMetaData(request, code, httpHeaderManager, () -> ((HttpEntity)entity).getContent()));
    }

    private HttpHeaderManager changeToLuckyHeader(org.apache.http.Header[] allHeaders) {
        DefaultHttpHeaderManager httpHeaderManager = new DefaultHttpHeaderManager();
        for (org.apache.http.Header header : allHeaders) {
            httpHeaderManager.putHeader(header.getName(), header.getValue());
        }
        return httpHeaderManager;
    }

    private HttpRequestBase createHttpClientRequest(Request request) throws IOException {
        switch (request.getRequestMethod()) {
            case GET: {
                return this.createHttpGet(request);
            }
            case POST: {
                return this.createHttpPost(request);
            }
            case DELETE: {
                return this.createHttpDelete(request);
            }
            case PUT: {
                return this.createHttpPut(request);
            }
            case HEAD: {
                return this.createHttpHead(request);
            }
            case OPTIONS: {
                return this.createHttpOptions(request);
            }
            case TRACE: {
                return this.createHttpTrace(request);
            }
            case PATCH: {
                return this.createHttpPatch(request);
            }
        }
        throw new NotFindRequestException("Apache Http Client does not support requests of type ['" + (Object)((Object)request.getRequestMethod()) + "'].");
    }

    private HttpRequestBase createHttpPatch(Request request) throws IOException {
        HttpPatch patch = new HttpPatch(request.getUrl());
        HttpEntity entity = this.getHttpEntity(request);
        if (entity != null) {
            patch.setEntity(entity);
        }
        return patch;
    }

    private HttpRequestBase createHttpTrace(Request request) {
        return new HttpTrace(request.getUrl());
    }

    private HttpRequestBase createHttpOptions(Request request) {
        return new HttpOptions(request.getUrl());
    }

    private HttpRequestBase createHttpGet(Request request) {
        return new HttpGet(request.getUrl());
    }

    private HttpRequestBase createHttpPost(Request request) throws IOException {
        HttpPost post = new HttpPost(request.getUrl());
        HttpEntity entity = this.getHttpEntity(request);
        if (entity != null) {
            post.setEntity(entity);
        }
        return post;
    }

    private HttpRequestBase createHttpDelete(Request request) {
        return new HttpDelete(request.getUrl());
    }

    private HttpRequestBase createHttpPut(Request request) throws IOException {
        HttpPut put = new HttpPut(request.getUrl());
        HttpEntity entity = this.getHttpEntity(request);
        if (entity != null) {
            put.setEntity(entity);
        }
        return put;
    }

    private HttpRequestBase createHttpHead(Request request) {
        return new HttpHead(request.getUrl());
    }

    private HttpEntity getHttpEntity(Request request) throws IOException {
        RequestParameter requestParameter = request.getRequestParameter();
        BodyObject body = requestParameter.getBody();
        Map<String, Object> nameValuesMap = requestParameter.getRequestParameters();
        if (body != null) {
            return new StringEntity(body.getBody(), body.getContentType().getCharset());
        }
        if (ContainerUtils.isEmptyMap(nameValuesMap)) {
            return null;
        }
        return HttpExecutor.isFileRequest(nameValuesMap) ? this.getFileHttpEntity(nameValuesMap) : HttpClientExecutor.getUrlEncodedFormEntity(nameValuesMap);
    }

    private HttpEntity getFileHttpEntity(Map<String, Object> multipartFileParams) throws IOException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(StandardCharsets.UTF_8);
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (Map.Entry<String, Object> paramEntry : multipartFileParams.entrySet()) {
            String paramName = paramEntry.getKey();
            Object paramValue = paramEntry.getValue();
            if (HttpExecutor.isResourceParam(paramValue)) {
                HttpFile[] httpFiles;
                for (HttpFile httpFile : httpFiles = HttpExecutor.toHttpFiles(paramValue)) {
                    InputStream inputStream = httpFile.getInputStream();
                    String fileName = httpFile.getFileName();
                    String mimeType = ContentTypeUtils.getMimeType((String)fileName);
                    ContentType contentType = mimeType == null ? ContentType.TEXT_PLAIN : ContentType.create((String)mimeType);
                    builder.addBinaryBody(paramName, inputStream, contentType, fileName);
                }
                continue;
            }
            builder.addTextBody(paramName, String.valueOf(paramValue), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
        }
        return builder.build();
    }

    private static HttpEntity getUrlEncodedFormEntity(Map<String, Object> params) {
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, Object> paramEntry : params.entrySet()) {
            list.add(new BasicNameValuePair(paramEntry.getKey(), String.valueOf(paramEntry.getValue())));
        }
        return new UrlEncodedFormEntity(list, StandardCharsets.UTF_8);
    }
}

