/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core.executor;

import com.luckyframework.common.ConfigurationMap;
import com.luckyframework.common.ContainerUtils;
import com.luckyframework.httpclient.core.HttpFile;
import com.luckyframework.httpclient.core.Request;
import com.luckyframework.httpclient.core.Response;
import com.luckyframework.httpclient.core.ResponseProcessor;
import com.luckyframework.httpclient.core.impl.DefaultRequest;
import com.luckyframework.httpclient.core.impl.DefaultResponse;
import com.luckyframework.httpclient.core.impl.SaveResultResponseProcessor;
import com.luckyframework.io.MultipartFile;
import com.luckyframework.serializable.SerializationTypeToken;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;

@FunctionalInterface
public interface HttpExecutor {
    public static final Logger logger = LoggerFactory.getLogger(HttpExecutor.class);

    public void doExecute(Request var1, ResponseProcessor var2) throws Exception;

    default public void execute(Request request, ResponseProcessor processor) {
        if (request instanceof DefaultRequest) {
            ((DefaultRequest)request).init();
        }
        try {
            this.doExecute(request, processor);
        }
        catch (Exception e) {
            processor.exceptionHandler(request, e);
        }
    }

    default public Response execute(Request request, SaveResultResponseProcessor processor) {
        this.execute(request, (ResponseProcessor)processor);
        return processor.getResponse();
    }

    default public Response execute(Request request) {
        return this.execute(request, DefaultResponse.getCommonProcessor());
    }

    default public String getString(Request request) {
        return this.execute(request).getStringResult();
    }

    default public byte[] getBytes(Request request) {
        return this.execute(request).getResult();
    }

    default public InputStream getInputStream(Request request) {
        return this.execute(request).getInputStream();
    }

    default public InputStreamSource getInputStreamSource(Request request) {
        return this.execute(request).getInputStreamSource();
    }

    default public MultipartFile getMultipartFile(Request request) {
        return this.execute(request).getMultipartFile();
    }

    default public <T> T getEntity(Request request, Class<T> tClass) {
        return this.execute(request).getEntity(tClass);
    }

    default public <T> T getEntity(Request request, SerializationTypeToken<T> typeToken) {
        return this.execute(request).getEntity(typeToken);
    }

    default public <T> T getEntity(Request request, Type type) {
        return this.execute(request).getEntity(type);
    }

    default public Map<String, Object> getMap(Request request) {
        return this.execute(request).getMapResult();
    }

    default public List<Map<String, Object>> getMapList(Request request) {
        return this.execute(request).getMapListResult();
    }

    default public ConfigurationMap getConfigMap(Request request) {
        return this.execute(request).getConfigMapResult();
    }

    default public List<ConfigurationMap> getConfigMapList(Request request) {
        return this.execute(request).getConfigMapListResult();
    }

    default public void get(String url, Object ... urlParams) {
        this.execute((Request)Request.get(url, urlParams), ResponseProcessor.DO_NOTHING_PROCESSOR);
    }

    default public String getForString(String url, Object ... urlParams) {
        return this.execute(Request.get(url, urlParams)).getStringResult();
    }

    default public byte[] getForBytes(String url, Object ... urlParams) {
        return this.execute(Request.get(url, urlParams)).getResult();
    }

    default public InputStream getForInputStream(String url, Object ... urlParams) {
        return this.execute(Request.get(url, urlParams)).getInputStream();
    }

    default public InputStreamSource getForInputStreamSource(String url, Object ... urlParams) {
        return this.execute(Request.get(url, urlParams)).getInputStreamSource();
    }

    default public MultipartFile getForMultipartFile(String url, Object ... urlParams) {
        return this.execute(Request.get(url, urlParams)).getMultipartFile();
    }

    default public <T> T getForEntity(String url, Class<T> tClass, Object ... urlParams) {
        return this.execute(Request.get(url, urlParams)).getEntity(tClass);
    }

    default public <T> T getForEntity(String url, SerializationTypeToken<T> typeToken, Object ... urlParams) {
        return this.execute(Request.get(url, urlParams)).getEntity(typeToken);
    }

    default public <T> T getForEntity(String url, Type type, Object ... urlParams) {
        return this.execute(Request.get(url, urlParams)).getEntity(type);
    }

    default public Map<String, Object> getForMap(String url, Object ... urlParams) {
        return this.execute(Request.get(url, urlParams)).getMapResult();
    }

    default public List<Map<String, Object>> getForMapList(String url, Object ... urlParams) {
        return this.execute(Request.get(url, urlParams)).getMapListResult();
    }

    default public ConfigurationMap getForConfigMap(String url, Object ... urlParams) {
        return this.execute(Request.get(url, urlParams)).getConfigMapResult();
    }

    default public List<ConfigurationMap> getForConfigMapList(String url, Object ... urlParams) {
        return this.execute(Request.get(url, urlParams)).getConfigMapListResult();
    }

    default public void post(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        this.execute((Request)Request.post(url, urlParams).setRequestParameter((Map)requestParamMap), ResponseProcessor.DO_NOTHING_PROCESSOR);
    }

    default public String postForString(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.post(url, urlParams).setRequestParameter((Map)requestParamMap)).getStringResult();
    }

    default public byte[] postForBytes(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.post(url, urlParams).setRequestParameter((Map)requestParamMap)).getResult();
    }

    default public InputStream postForInputStream(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.post(url, urlParams).setRequestParameter((Map)requestParamMap)).getInputStream();
    }

    default public InputStreamSource postForInputStreamSource(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.post(url, urlParams).setRequestParameter((Map)requestParamMap)).getInputStreamSource();
    }

    default public MultipartFile postForMultipartFile(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.post(url, urlParams).setRequestParameter((Map)requestParamMap)).getMultipartFile();
    }

    default public <T> T postForEntity(String url, Map<String, Object> requestParamMap, Class<T> tClass, Object ... urlParams) {
        return this.execute((Request)Request.post(url, urlParams).setRequestParameter((Map)requestParamMap)).getEntity(tClass);
    }

    default public <T> T postForEntity(String url, Map<String, Object> requestParamMap, SerializationTypeToken<T> typeToken, Object ... urlParams) {
        return this.execute((Request)Request.post(url, urlParams).setRequestParameter((Map)requestParamMap)).getEntity(typeToken);
    }

    default public <T> T postForEntity(String url, Map<String, Object> requestParamMap, Type type, Object ... urlParams) {
        return this.execute((Request)Request.post(url, urlParams).setRequestParameter((Map)requestParamMap)).getEntity(type);
    }

    default public Map<String, Object> postForMap(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.post(url, urlParams).setRequestParameter((Map)requestParamMap)).getMapResult();
    }

    default public List<Map<String, Object>> postForMapList(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.post(url, urlParams).setRequestParameter((Map)requestParamMap)).getMapListResult();
    }

    default public ConfigurationMap postForConfigMap(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.post(url, urlParams).setRequestParameter((Map)requestParamMap)).getConfigMapResult();
    }

    default public List<ConfigurationMap> postForConfigMapList(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.post(url, urlParams).setRequestParameter((Map)requestParamMap)).getConfigMapListResult();
    }

    default public void delete(String url, Object ... urlParams) {
        this.execute((Request)Request.delete(url, urlParams), ResponseProcessor.DO_NOTHING_PROCESSOR);
    }

    default public String deleteForString(String url, Object ... urlParams) {
        return this.execute(Request.delete(url, urlParams)).getStringResult();
    }

    default public byte[] deleteForBytes(String url, Object ... urlParams) {
        return this.execute(Request.delete(url, urlParams)).getResult();
    }

    default public InputStream deleteForInputStream(String url, Object ... urlParams) {
        return this.execute(Request.delete(url, urlParams)).getInputStream();
    }

    default public InputStreamSource deleteForInputStreamSource(String url, Object ... urlParams) {
        return this.execute(Request.delete(url, urlParams)).getInputStreamSource();
    }

    default public MultipartFile deleteForMultipartFile(String url, Object ... urlParams) {
        return this.execute(Request.delete(url, urlParams)).getMultipartFile();
    }

    default public <T> T deleteForEntity(String url, Class<T> tClass, Object ... urlParams) {
        return this.execute(Request.delete(url, urlParams)).getEntity(tClass);
    }

    default public <T> T deleteForEntity(String url, SerializationTypeToken<T> typeToken, Object ... urlParams) {
        return this.execute(Request.delete(url, urlParams)).getEntity(typeToken);
    }

    default public <T> T deleteForEntity(String url, Type type, Object ... urlParams) {
        return this.execute(Request.delete(url, urlParams)).getEntity(type);
    }

    default public Map<String, Object> deleteForMap(String url, Object ... urlParams) {
        return this.execute(Request.delete(url, urlParams)).getMapResult();
    }

    default public List<Map<String, Object>> deleteForMapList(String url, Object ... urlParams) {
        return this.execute(Request.delete(url, urlParams)).getMapListResult();
    }

    default public ConfigurationMap deleteForConfigMap(String url, Object ... urlParams) {
        return this.execute(Request.delete(url, urlParams)).getConfigMapResult();
    }

    default public List<ConfigurationMap> deleteForConfigMapList(String url, Object ... urlParams) {
        return this.execute(Request.delete(url, urlParams)).getConfigMapListResult();
    }

    default public void put(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        DefaultRequest request = Request.put(url, urlParams);
        request.setRequestParameter(requestParamMap);
        this.execute((Request)request, ResponseProcessor.DO_NOTHING_PROCESSOR);
    }

    default public String putForString(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.put(url, urlParams).setRequestParameter((Map)requestParamMap)).getStringResult();
    }

    default public byte[] putForBytes(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.put(url, urlParams).setRequestParameter((Map)requestParamMap)).getResult();
    }

    default public InputStream putForInputStream(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.put(url, urlParams).setRequestParameter((Map)requestParamMap)).getInputStream();
    }

    default public InputStreamSource putForInputStreamSource(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.put(url, urlParams).setRequestParameter((Map)requestParamMap)).getInputStreamSource();
    }

    default public MultipartFile putForMultipartFile(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.put(url, urlParams).setRequestParameter((Map)requestParamMap)).getMultipartFile();
    }

    default public <T> T putForEntity(String url, Map<String, Object> requestParamMap, Class<T> tClass, Object ... urlParams) {
        return this.execute((Request)Request.put(url, urlParams).setRequestParameter((Map)requestParamMap)).getEntity(tClass);
    }

    default public <T> T putForEntity(String url, Map<String, Object> requestParamMap, SerializationTypeToken<T> typeToken, Object ... urlParams) {
        return this.execute((Request)Request.put(url, urlParams).setRequestParameter((Map)requestParamMap)).getEntity(typeToken);
    }

    default public <T> T putForEntity(String url, Map<String, Object> requestParamMap, Type type, Object ... urlParams) {
        return this.execute((Request)Request.put(url, urlParams).setRequestParameter((Map)requestParamMap)).getEntity(type);
    }

    default public Map<String, Object> putForMap(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.put(url, urlParams).setRequestParameter((Map)requestParamMap)).getMapResult();
    }

    default public List<Map<String, Object>> putForMapList(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.put(url, urlParams).setRequestParameter((Map)requestParamMap)).getMapListResult();
    }

    default public ConfigurationMap putForConfigMap(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.put(url, urlParams).setRequestParameter((Map)requestParamMap)).getConfigMapResult();
    }

    default public List<ConfigurationMap> putForConfigMapList(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.put(url, urlParams).setRequestParameter((Map)requestParamMap)).getConfigMapListResult();
    }

    default public void head(String url, Object ... urlParams) {
        this.execute((Request)Request.head(url, urlParams), ResponseProcessor.DO_NOTHING_PROCESSOR);
    }

    default public String headForString(String url, Object ... urlParams) {
        return this.execute(Request.head(url, urlParams)).getStringResult();
    }

    default public byte[] headForBytes(String url, Object ... urlParams) {
        return this.execute(Request.head(url, urlParams)).getResult();
    }

    default public InputStream headForInputStream(String url, Object ... urlParams) {
        return this.execute(Request.head(url, urlParams)).getInputStream();
    }

    default public InputStreamSource headForInputStreamSource(String url, Object ... urlParams) {
        return this.execute(Request.head(url, urlParams)).getInputStreamSource();
    }

    default public MultipartFile headForMultipartFile(String url, Object ... urlParams) {
        return this.execute(Request.head(url, urlParams)).getMultipartFile();
    }

    default public <T> T headForEntity(String url, Class<T> tClass, Object ... urlParams) {
        return this.execute(Request.head(url, urlParams)).getEntity(tClass);
    }

    default public <T> T headForEntity(String url, SerializationTypeToken<T> typeToken, Object ... urlParams) {
        return this.execute(Request.head(url, urlParams)).getEntity(typeToken);
    }

    default public <T> T headForEntity(String url, Type type, Object ... urlParams) {
        return this.execute(Request.head(url, urlParams)).getEntity(type);
    }

    default public Map<String, Object> headForMap(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.head(url, urlParams).setRequestParameter((Map)requestParamMap)).getMapResult();
    }

    default public List<Map<String, Object>> headForMapList(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.head(url, urlParams).setRequestParameter((Map)requestParamMap)).getMapListResult();
    }

    default public ConfigurationMap headForConfigMap(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.head(url, urlParams).setRequestParameter((Map)requestParamMap)).getConfigMapResult();
    }

    default public List<ConfigurationMap> headForConfigMapList(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.head(url, urlParams).setRequestParameter((Map)requestParamMap)).getConfigMapListResult();
    }

    default public void patch(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        this.execute((Request)Request.patch(url, urlParams).setRequestParameter((Map)requestParamMap), ResponseProcessor.DO_NOTHING_PROCESSOR);
    }

    default public String patchForString(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.patch(url, urlParams).setRequestParameter((Map)requestParamMap)).getStringResult();
    }

    default public byte[] patchForBytes(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.patch(url, urlParams).setRequestParameter((Map)requestParamMap)).getResult();
    }

    default public InputStream patchForInputStream(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.patch(url, urlParams).setRequestParameter((Map)requestParamMap)).getInputStream();
    }

    default public InputStreamSource patchForInputStreamSource(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.patch(url, urlParams).setRequestParameter((Map)requestParamMap)).getInputStreamSource();
    }

    default public MultipartFile patchForMultipartFile(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        DefaultRequest request = Request.patch(url, urlParams);
        request.setRequestParameter(requestParamMap);
        return this.execute(request).getMultipartFile();
    }

    default public <T> T patchForEntity(String url, Map<String, Object> requestParamMap, Class<T> tClass, Object ... urlParams) {
        return this.execute((Request)Request.patch(url, urlParams).setRequestParameter((Map)requestParamMap)).getEntity(tClass);
    }

    default public <T> T patchForEntity(String url, Map<String, Object> requestParamMap, SerializationTypeToken<T> typeToken, Object ... urlParams) {
        return this.execute((Request)Request.patch(url, urlParams).setRequestParameter((Map)requestParamMap)).getEntity(typeToken);
    }

    default public <T> T patchForEntity(String url, Map<String, Object> requestParamMap, Type type, Object ... urlParams) {
        return this.execute((Request)Request.patch(url, urlParams).setRequestParameter((Map)requestParamMap)).getEntity(type);
    }

    default public Map<String, Object> patchForMap(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.patch(url, urlParams).setRequestParameter((Map)requestParamMap)).getMapResult();
    }

    default public List<Map<String, Object>> patchForMapList(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.patch(url, urlParams).setRequestParameter((Map)requestParamMap)).getMapListResult();
    }

    default public ConfigurationMap patchForConfigMap(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.patch(url, urlParams).setRequestParameter((Map)requestParamMap)).getConfigMapResult();
    }

    default public List<ConfigurationMap> patchForConfigMapList(String url, Map<String, Object> requestParamMap, Object ... urlParams) {
        return this.execute((Request)Request.patch(url, urlParams).setRequestParameter((Map)requestParamMap)).getConfigMapListResult();
    }

    default public void connect(String url, Object ... urlParams) {
        this.execute((Request)Request.connect(url, urlParams), ResponseProcessor.DO_NOTHING_PROCESSOR);
    }

    default public String connectForString(String url, Object ... urlParams) {
        return this.execute(Request.connect(url, urlParams)).getStringResult();
    }

    default public byte[] connectForBytes(String url, Object ... urlParams) {
        return this.execute(Request.connect(url, urlParams)).getResult();
    }

    default public InputStream connectForInputStream(String url, Object ... urlParams) {
        return this.execute(Request.connect(url, urlParams)).getInputStream();
    }

    default public InputStreamSource connectForInputStreamSource(String url, Object ... urlParams) {
        return this.execute(Request.connect(url, urlParams)).getInputStreamSource();
    }

    default public MultipartFile connectForMultipartFile(String url, Object ... urlParams) {
        return this.execute(Request.connect(url, urlParams)).getMultipartFile();
    }

    default public <T> T connectForEntity(String url, Class<T> tClass, Object ... urlParams) {
        return this.execute(Request.connect(url, urlParams)).getEntity(tClass);
    }

    default public <T> T connectForEntity(String url, SerializationTypeToken<T> typeToken, Object ... urlParams) {
        return this.execute(Request.connect(url, urlParams)).getEntity(typeToken);
    }

    default public <T> T connectForEntity(String url, Type type, Object ... urlParams) {
        return this.execute(Request.connect(url, urlParams)).getEntity(type);
    }

    default public Map<String, Object> connectForMap(String url, Object ... urlParams) {
        return this.execute(Request.connect(url, urlParams)).getMapResult();
    }

    default public List<Map<String, Object>> connectForMapList(String url, Object ... urlParams) {
        return this.execute(Request.connect(url, urlParams)).getMapListResult();
    }

    default public ConfigurationMap connectForConfigMap(String url, Object ... urlParams) {
        return this.execute(Request.connect(url, urlParams)).getConfigMapResult();
    }

    default public List<ConfigurationMap> connectForConfigMapList(String url, Object ... urlParams) {
        return this.execute(Request.connect(url, urlParams)).getConfigMapListResult();
    }

    default public void options(String url, Object ... urlParams) {
        this.execute((Request)Request.options(url, urlParams), ResponseProcessor.DO_NOTHING_PROCESSOR);
    }

    default public String optionsForString(String url, Object ... urlParams) {
        return this.execute(Request.options(url, urlParams)).getStringResult();
    }

    default public byte[] optionsForBytes(String url, Object ... urlParams) {
        return this.execute(Request.options(url, urlParams)).getResult();
    }

    default public InputStream optionsForInputStream(String url, Object ... urlParams) {
        return this.execute(Request.options(url, urlParams)).getInputStream();
    }

    default public InputStreamSource optionsForInputStreamSource(String url, Object ... urlParams) {
        return this.execute(Request.options(url, urlParams)).getInputStreamSource();
    }

    default public MultipartFile optionsForMultipartFile(String url, Object ... urlParams) {
        return this.execute(Request.options(url, urlParams)).getMultipartFile();
    }

    default public <T> T optionsForEntity(String url, Class<T> tClass, Object ... urlParams) {
        return this.execute(Request.options(url, urlParams)).getEntity(tClass);
    }

    default public <T> T optionsForEntity(String url, SerializationTypeToken<T> typeToken, Object ... urlParams) {
        return this.execute(Request.options(url, urlParams)).getEntity(typeToken);
    }

    default public <T> T optionsForEntity(String url, Type type, Object ... urlParams) {
        return this.execute(Request.options(url, urlParams)).getEntity(type);
    }

    default public Map<String, Object> optionsForMap(String url, Object ... urlParams) {
        return this.execute(Request.options(url, urlParams)).getMapResult();
    }

    default public List<Map<String, Object>> optionsForMapList(String url, Object ... urlParams) {
        return this.execute(Request.options(url, urlParams)).getMapListResult();
    }

    default public ConfigurationMap optionsForConfigMap(String url, Object ... urlParams) {
        return this.execute(Request.options(url, urlParams)).getConfigMapResult();
    }

    default public List<ConfigurationMap> optionsForConfigMapList(String url, Object ... urlParams) {
        return this.execute(Request.options(url, urlParams)).getConfigMapListResult();
    }

    default public void trace(String url, Object ... urlParams) {
        this.execute((Request)Request.trace(url, urlParams), ResponseProcessor.DO_NOTHING_PROCESSOR);
    }

    default public String traceForString(String url, Object ... urlParams) {
        return this.execute(Request.trace(url, urlParams)).getStringResult();
    }

    default public byte[] traceForBytes(String url, Object ... urlParams) {
        return this.execute(Request.trace(url, urlParams)).getResult();
    }

    default public InputStream traceForInputStream(String url, Object ... urlParams) {
        return this.execute(Request.trace(url, urlParams)).getInputStream();
    }

    default public InputStreamSource traceForInputStreamSource(String url, Object ... urlParams) {
        return this.execute(Request.trace(url, urlParams)).getInputStreamSource();
    }

    default public MultipartFile traceForMultipartFile(String url, Object ... urlParams) {
        return this.execute(Request.trace(url, urlParams)).getMultipartFile();
    }

    default public <T> T traceForEntity(String url, Class<T> tClass, Object ... urlParams) {
        return this.execute(Request.trace(url, urlParams)).getEntity(tClass);
    }

    default public <T> T traceForEntity(String url, SerializationTypeToken<T> typeToken, Object ... urlParams) {
        return this.execute(Request.trace(url, urlParams)).getEntity(typeToken);
    }

    default public <T> T traceForEntity(String url, Type type, Object ... urlParams) {
        return this.execute(Request.trace(url, urlParams)).getEntity(type);
    }

    default public Map<String, Object> traceForMap(String url, Object ... urlParams) {
        return this.execute(Request.trace(url, urlParams)).getMapResult();
    }

    default public List<Map<String, Object>> traceForMapList(String url, Object ... urlParams) {
        return this.execute(Request.trace(url, urlParams)).getMapListResult();
    }

    default public ConfigurationMap traceForConfigMap(String url, Object ... urlParams) {
        return this.execute(Request.trace(url, urlParams)).getConfigMapResult();
    }

    default public List<ConfigurationMap> traceForConfigMapList(String url, Object ... urlParams) {
        return this.execute(Request.trace(url, urlParams)).getConfigMapListResult();
    }

    public static boolean isFileRequest(Map<String, Object> params) {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (!HttpExecutor.isResourceParam(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean isResourceParam(Object param) {
        if (param == null) {
            return false;
        }
        Class elementType = ContainerUtils.getElementType((Object)param);
        return File.class.isAssignableFrom(elementType) || Resource.class.isAssignableFrom(elementType) || MultipartFile.class.isAssignableFrom(elementType) || HttpFile.class.isAssignableFrom(elementType);
    }

    public static boolean isResourceParam(ResolvableType paramType) {
        Class elementType = ContainerUtils.getElementType((ResolvableType)paramType);
        return File.class.isAssignableFrom(elementType) || Resource.class.isAssignableFrom(elementType) || MultipartFile.class.isAssignableFrom(elementType) || HttpFile.class.isAssignableFrom(elementType);
    }

    public static HttpFile toHttpFile(Object param) {
        if (param instanceof HttpFile) {
            return (HttpFile)param;
        }
        if (param instanceof File) {
            return new HttpFile((File)param);
        }
        if (param instanceof Resource) {
            return new HttpFile((Resource)param);
        }
        if (param instanceof MultipartFile) {
            return new HttpFile((MultipartFile)param);
        }
        throw new IllegalArgumentException("Unable to convert '" + param + "' to '" + HttpFile.class + "'");
    }

    public static HttpFile[] toHttpFiles(Object params) {
        if (ContainerUtils.isIterable((Object)params)) {
            ArrayList<HttpFile> httpFileList = new ArrayList<HttpFile>();
            Iterator iterator = ContainerUtils.getIterator((Object)params);
            while (iterator.hasNext()) {
                httpFileList.add(HttpExecutor.toHttpFile(iterator.next()));
            }
            return httpFileList.toArray(new HttpFile[0]);
        }
        HttpFile[] httpFiles = new HttpFile[]{HttpExecutor.toHttpFile(params)};
        return httpFiles;
    }
}

