/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core.executor;

import com.luckyframework.common.ContainerUtils;
import com.luckyframework.httpclient.core.BodyObject;
import com.luckyframework.httpclient.core.Header;
import com.luckyframework.httpclient.core.HttpFile;
import com.luckyframework.httpclient.core.HttpHeaderManager;
import com.luckyframework.httpclient.core.Request;
import com.luckyframework.httpclient.core.RequestParameter;
import com.luckyframework.httpclient.core.ResponseMetaData;
import com.luckyframework.httpclient.core.ResponseProcessor;
import com.luckyframework.httpclient.core.executor.HttpExecutor;
import com.luckyframework.httpclient.core.impl.DefaultHttpHeaderManager;
import com.luckyframework.httpclient.core.impl.DefaultRequestParameter;
import com.luckyframework.httpclient.exception.NotFindRequestException;
import com.luckyframework.web.ContentTypeUtils;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JdkHttpExecutor
implements HttpExecutor {
    private final String end = "\r\n";
    private final String twoHyphens = "--";
    private final String boundary = "LuckyBoundary";
    private final URLConnectionFactory connectionFactory;

    public JdkHttpExecutor(URLConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public JdkHttpExecutor() {
        this(request -> {
            URL url = new URL(request.getUrl());
            Proxy proxy = request.getProxy();
            return proxy == null ? url.openConnection() : url.openConnection(proxy);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(Request request, ResponseProcessor processor) throws Exception {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)this.connectionFactory.createURLConnection(request);
            this.connectionConfigSetting(connection, request);
            this.connectionHeaderSetting(connection, request);
            this.connectionParamsSetting(connection, request);
            connection.connect();
            int code = connection.getResponseCode();
            HttpHeaderManager httpHeaderManager = this.getHttpHeaderManager(connection);
            processor.process(new ResponseMetaData(request, code, httpHeaderManager, connection::getInputStream));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @NotNull
    private HttpHeaderManager getHttpHeaderManager(HttpURLConnection connection) {
        DefaultHttpHeaderManager httpHeaderManager = new DefaultHttpHeaderManager();
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
            String name = entry.getKey();
            if (name == null) continue;
            List<String> valueList = entry.getValue();
            for (String value : valueList) {
                httpHeaderManager.putHeader(name, value);
            }
        }
        return httpHeaderManager;
    }

    private void connectionConfigSetting(HttpURLConnection connection, Request request) {
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setConnectTimeout(Request.DEF_CONNECTION_TIME_OUT);
        connection.setReadTimeout(Request.DEF_READ_TIME_OUT);
        Integer connectTimeout = request.getConnectTimeout();
        Integer readTimeout = request.getReadTimeout();
        if (connectTimeout != null && connectTimeout > 0) {
            connection.setConnectTimeout(connectTimeout);
        }
        if (readTimeout != null && readTimeout > 0) {
            connection.setReadTimeout(readTimeout);
        }
    }

    protected void connectionHeaderSetting(HttpURLConnection connection, Request request) {
        Map<String, List<Header>> headerMap = request.getHeaderMap();
        for (Map.Entry<String, List<Header>> entry : headerMap.entrySet()) {
            String name = entry.getKey();
            List<Header> valueList = entry.getValue();
            for (Header header : valueList) {
                Object headerValue = header.getValue();
                if (headerValue == null) continue;
                switch (header.getHeaderType()) {
                    case ADD: {
                        connection.addRequestProperty(name, String.valueOf(headerValue));
                        break;
                    }
                    case SET: {
                        connection.setRequestProperty(name, String.valueOf(headerValue));
                    }
                }
            }
        }
    }

    protected void connectionParamsSetting(HttpURLConnection connection, Request request) throws IOException {
        switch (request.getRequestMethod()) {
            case GET: {
                this.getSetting(request, connection);
                break;
            }
            case POST: {
                this.postSetting(request, connection);
                break;
            }
            case DELETE: {
                this.deleteSetting(request, connection);
                break;
            }
            case PUT: {
                this.putSetting(request, connection);
                break;
            }
            case OPTIONS: {
                this.optionsSetting(request, connection);
                break;
            }
            case HEAD: {
                this.headSetting(request, connection);
                break;
            }
            case TRACE: {
                this.traceSetting(request, connection);
                break;
            }
            default: {
                throw new NotFindRequestException("Jdk HttpURLConnection does not support requests of type ['" + (Object)((Object)request.getRequestMethod()) + "'].");
            }
        }
    }

    private void getSetting(Request request, HttpURLConnection connection) throws ProtocolException {
        connection.setRequestMethod("GET");
    }

    private void postSetting(Request request, HttpURLConnection connection) throws IOException {
        connection.setRequestMethod("POST");
        this.setRequestParameters(connection, request);
    }

    private void deleteSetting(Request request, HttpURLConnection connection) throws ProtocolException {
        connection.setRequestMethod("DELETE");
    }

    private void putSetting(Request request, HttpURLConnection connection) throws IOException {
        connection.setRequestMethod("PUT");
        this.setRequestParameters(connection, request);
    }

    private void optionsSetting(Request request, HttpURLConnection connection) throws ProtocolException {
        connection.setRequestMethod("OPTIONS");
    }

    private void headSetting(Request request, HttpURLConnection connection) throws ProtocolException {
        connection.setRequestMethod("HEAD");
    }

    private void traceSetting(Request request, HttpURLConnection connection) throws ProtocolException {
        connection.setRequestMethod("TRACE");
    }

    private void setRequestParameters(HttpURLConnection connection, Request request) throws IOException {
        RequestParameter requestParameter = request.getRequestParameter();
        BodyObject body = requestParameter.getBody();
        Map<String, Object> nameValuesMap = requestParameter.getRequestParameters();
        if (body != null) {
            connection.setRequestProperty("Content-Type", body.getContentType().toString());
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
            writer.write(body.getBody());
            writer.flush();
            writer.close();
            return;
        }
        if (ContainerUtils.isEmptyMap(nameValuesMap)) {
            return;
        }
        if (HttpExecutor.isFileRequest(nameValuesMap)) {
            this.setMultipartFormData(connection, request);
        } else {
            this.setFormParam(connection, request);
        }
    }

    private void setFormParam(HttpURLConnection connection, Request request) throws IOException {
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8;");
        DataOutputStream ds = new DataOutputStream(connection.getOutputStream());
        ds.writeBytes(((DefaultRequestParameter)request.getRequestParameter()).getUrlencodedParameterString());
        ds.flush();
        ds.close();
    }

    private void setMultipartFormData(HttpURLConnection connection, Request request) throws IOException {
        connection.setRequestProperty("Content-Type", "multipart/form-data;charset=utf-8;boundary=LuckyBoundary");
        DataOutputStream ds = new DataOutputStream(connection.getOutputStream());
        for (Map.Entry<String, Object> paramEntry : request.getRequestParameters().entrySet()) {
            String paramName = paramEntry.getKey();
            Object paramValue = paramEntry.getValue();
            if (HttpExecutor.isResourceParam(paramValue)) {
                HttpFile[] httpFiles;
                for (HttpFile httpFile : httpFiles = HttpExecutor.toHttpFiles(paramValue)) {
                    InputStream inputStream = httpFile.getInputStream();
                    this.writerFileData(ds, paramName, httpFile.getFileName(), inputStream);
                }
                continue;
            }
            ds.writeBytes("--LuckyBoundary\r\n");
            ds.writeBytes("Content-Disposition: form-data; name=\"" + paramName + "\"" + "\r\n" + "\r\n");
            ds.write(String.valueOf(paramValue).getBytes(StandardCharsets.UTF_8));
            ds.writeBytes("\r\n");
        }
        ds.writeBytes("--LuckyBoundary--\r\n");
        ds.flush();
        ds.close();
    }

    private void writerFileData(DataOutputStream ds, String name, String fileName, InputStream inputStream) throws IOException {
        int length;
        ds.writeBytes("--LuckyBoundary\r\n");
        ds.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"" + "\r\n");
        ds.writeBytes("Content-Type: " + ContentTypeUtils.getMimeType((String)fileName) + "\r\n");
        ds.writeBytes("\r\n");
        int bufferSize = 4096;
        byte[] buffer = new byte[bufferSize];
        while ((length = inputStream.read(buffer)) != -1) {
            ds.write(buffer, 0, length);
        }
        ds.writeBytes("\r\n");
        inputStream.close();
    }

    public static interface URLConnectionFactory {
        public URLConnection createURLConnection(Request var1) throws IOException;
    }
}

