/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core.executor;

import com.luckyframework.common.ContainerUtils;
import com.luckyframework.httpclient.core.BodyObject;
import com.luckyframework.httpclient.core.Header;
import com.luckyframework.httpclient.core.HttpFile;
import com.luckyframework.httpclient.core.Request;
import com.luckyframework.httpclient.core.RequestParameter;
import com.luckyframework.httpclient.core.ResponseMetaData;
import com.luckyframework.httpclient.core.ResponseProcessor;
import com.luckyframework.httpclient.core.executor.HttpExecutor;
import com.luckyframework.httpclient.core.impl.DefaultHttpHeaderManager;
import com.luckyframework.httpclient.exception.NotFindRequestException;
import com.luckyframework.reflect.FieldUtils;
import com.luckyframework.web.ContentTypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.util.FileCopyUtils;

public class OkHttpExecutor
implements HttpExecutor {
    private final OkHttpClient.Builder builder;

    public OkHttpExecutor(OkHttpClient.Builder builder) {
        this.builder = builder;
    }

    public OkHttpExecutor() {
        this.builder = this.defaultOkHttpClientBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(Request request, ResponseProcessor processor) throws Exception {
        Call call = null;
        try (Response okhttpResponse = null;){
            OkHttpClient client = this.createOkHttpClient(request);
            okhttp3.Request okhttpRequest = this.changeToOkHttpRequest(request);
            call = client.newCall(okhttpRequest);
            okhttpResponse = call.execute();
            this.resultProcess(request, processor, okhttpResponse);
        }
    }

    protected OkHttpClient.Builder defaultOkHttpClientBuilder() {
        return new OkHttpClient.Builder().connectTimeout((long)Request.DEF_CONNECTION_TIME_OUT.intValue(), TimeUnit.MILLISECONDS).readTimeout((long)Request.DEF_READ_TIME_OUT.intValue(), TimeUnit.MILLISECONDS).writeTimeout((long)Request.DEF_WRITER_TIME_OUT.intValue(), TimeUnit.MILLISECONDS).connectionPool(new ConnectionPool(10, 5L, TimeUnit.MINUTES));
    }

    private OkHttpClient createOkHttpClient(Request request) {
        OkHttpClient client = this.builder.build();
        FieldUtils.setValue((Object)client, (String)"proxy", (Object)request.getProxy());
        Integer connectTimeout = request.getConnectTimeout();
        Integer readTimeout = request.getReadTimeout();
        Integer writerTimeout = request.getWriterTimeout();
        if (connectTimeout != null && connectTimeout > 0) {
            FieldUtils.setValue((Object)client, (String)"connectTimeoutMillis", (Object)connectTimeout);
        }
        if (readTimeout != null && readTimeout > 0) {
            FieldUtils.setValue((Object)client, (String)"readTimeoutMillis", (Object)readTimeout);
        }
        if (writerTimeout != null && writerTimeout > 0) {
            FieldUtils.setValue((Object)client, (String)"writeTimeoutMillis", (Object)writerTimeout);
        }
        return client;
    }

    private okhttp3.Request changeToOkHttpRequest(Request request) throws IOException {
        Request.Builder builder = new Request.Builder().url(request.getUrl());
        this.headerSetting(request, builder);
        this.requestParameterSetting(request, builder);
        return builder.build();
    }

    private void headerSetting(Request request, Request.Builder builder) {
        Map<String, List<Header>> headerMap = request.getHeaderMap();
        for (Map.Entry<String, List<Header>> entry : headerMap.entrySet()) {
            String headerName = entry.getKey();
            List<Header> headerList = entry.getValue();
            if (ContainerUtils.isEmptyCollection(headerList)) continue;
            for (Header header : headerList) {
                Object headerValue = header.getValue();
                if (headerValue == null) continue;
                switch (header.getHeaderType()) {
                    case ADD: {
                        builder.addHeader(headerName, headerValue.toString());
                        break;
                    }
                    case SET: {
                        builder.header(headerName, headerValue.toString());
                    }
                }
            }
        }
    }

    private void requestParameterSetting(Request request, Request.Builder builder) throws IOException {
        switch (request.getRequestMethod()) {
            case GET: {
                this.getSetting(request, builder);
                break;
            }
            case POST: {
                this.postSetting(request, builder);
                break;
            }
            case DELETE: {
                this.deleteSetting(request, builder);
                break;
            }
            case PUT: {
                this.putSetting(request, builder);
                break;
            }
            case HEAD: {
                this.headSetting(request, builder);
                break;
            }
            case PATCH: {
                this.patchSetting(request, builder);
                break;
            }
            default: {
                throw new NotFindRequestException("okHttp does not support requests of type ['" + (Object)((Object)request.getRequestMethod()) + "'].");
            }
        }
    }

    private void getSetting(Request request, Request.Builder builder) {
        builder.get();
    }

    private void postSetting(Request request, Request.Builder builder) throws IOException {
        RequestBody requestBody = this.getRequestBody(request);
        builder.post(requestBody);
    }

    private void deleteSetting(Request request, Request.Builder builder) throws IOException {
        RequestBody requestBody = this.getRequestBody(request);
        builder.delete(requestBody);
    }

    private void putSetting(Request request, Request.Builder builder) throws IOException {
        RequestBody requestBody = this.getRequestBody(request);
        builder.put(requestBody);
    }

    private void headSetting(Request request, Request.Builder builder) {
        builder.head();
    }

    private void patchSetting(Request request, Request.Builder builder) throws IOException {
        RequestBody requestBody = this.getRequestBody(request);
        builder.patch(requestBody);
    }

    private RequestBody getRequestBody(Request request) throws IOException {
        RequestParameter requestParameter = request.getRequestParameter();
        BodyObject body = requestParameter.getBody();
        Map<String, Object> nameValuesMap = requestParameter.getRequestParameters();
        if (body != null) {
            return RequestBody.Companion.create(body.getBody(), MediaType.parse((String)body.getContentType().toString()));
        }
        if (ContainerUtils.isEmptyMap(nameValuesMap)) {
            return new FormBody.Builder().build();
        }
        return HttpExecutor.isFileRequest(nameValuesMap) ? this.getFileBody(nameValuesMap) : this.getFormBody(nameValuesMap);
    }

    private RequestBody getFormBody(Map<String, Object> nameValuesMap) {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, Object> entry : nameValuesMap.entrySet()) {
            builder.add(entry.getKey(), entry.getValue().toString());
        }
        return builder.build();
    }

    private RequestBody getFileBody(Map<String, Object> nameValuesMap) throws IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MultipartBody.FORM);
        for (Map.Entry<String, Object> paramEntry : nameValuesMap.entrySet()) {
            String paramName = paramEntry.getKey();
            Object paramValue = paramEntry.getValue();
            if (HttpExecutor.isResourceParam(paramValue)) {
                HttpFile[] httpFiles;
                for (HttpFile httpFile : httpFiles = HttpExecutor.toHttpFiles(paramValue)) {
                    InputStream in = httpFile.getInputStream();
                    String fileName = httpFile.getFileName();
                    MediaType mediaType = MediaType.parse((String)ContentTypeUtils.getMimeTypeOrDefault((String)fileName, (String)"text/plain"));
                    builder.addFormDataPart(paramName, httpFile.getFileName(), RequestBody.Companion.create(FileCopyUtils.copyToByteArray((InputStream)in), mediaType));
                }
                continue;
            }
            builder.addFormDataPart(paramName, String.valueOf(paramValue));
        }
        return builder.build();
    }

    private void resultProcess(Request request, ResponseProcessor processor, Response okhttpResponse) {
        int code = okhttpResponse.code();
        Headers headers = okhttpResponse.headers();
        Map headerMap = headers.toMultimap();
        DefaultHttpHeaderManager httpHeaderManager = new DefaultHttpHeaderManager();
        for (Map.Entry entry : headerMap.entrySet()) {
            String name = (String)entry.getKey();
            List valueList = (List)entry.getValue();
            for (String value : valueList) {
                httpHeaderManager.putHeader(name, value);
            }
        }
        processor.process(new ResponseMetaData(request, code, httpHeaderManager, () -> Objects.requireNonNull(okhttpResponse.body()).byteStream()));
    }
}

