/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core.impl;

import com.luckyframework.common.ContainerUtils;
import com.luckyframework.httpclient.core.Header;
import com.luckyframework.httpclient.core.HttpHeaderManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DefaultHttpHeaderManager
implements HttpHeaderManager {
    private final Map<String, List<Header>> headers = new LinkedHashMap<String, List<Header>>();

    @Override
    public DefaultHttpHeaderManager addHeader(String name, Object header) {
        this.check(name, header);
        name = name.toLowerCase();
        if (this.headers.containsKey(name)) {
            this.headers.get(name).add(Header.builderAdd(name, header));
        } else {
            ArrayList<Header> list = new ArrayList<Header>();
            list.add(Header.builderAdd(name, header));
            this.headers.put(name, list);
        }
        return this;
    }

    @Override
    public DefaultHttpHeaderManager setHeader(String name, Object header) {
        this.check(name, header);
        name = name.toLowerCase();
        if (this.headers.containsKey(name)) {
            this.headers.get(name).add(Header.builderSet(name, header));
        } else {
            ArrayList<Header> list = new ArrayList<Header>();
            list.add(Header.builderSet(name, header));
            this.headers.put(name, list);
        }
        return this;
    }

    @Override
    public DefaultHttpHeaderManager putHeader(String name, Object header) {
        this.check(name, header);
        name = name.toLowerCase();
        if (this.headers.containsKey(name)) {
            this.headers.get(name).add(Header.builderShow(name, header));
        } else {
            ArrayList<Header> list = new ArrayList<Header>();
            list.add(Header.builderShow(name, header));
            this.headers.put(name, list);
        }
        return this;
    }

    @Override
    public DefaultHttpHeaderManager setHeaders(Map<String, List<Header>> headers) {
        headers.forEach((k, v) -> headers.put((String)k, new LinkedList(v)));
        return this;
    }

    @Override
    public DefaultHttpHeaderManager removerHeader(String name) {
        this.checkHeaderName(name);
        name = name.toLowerCase();
        this.headers.remove(name);
        return this;
    }

    @Override
    public List<Header> getHeader(String name) {
        this.checkHeaderName(name);
        name = name.toLowerCase();
        return this.headers.get(name);
    }

    @Override
    public DefaultHttpHeaderManager removerFirstHeader(String name) {
        this.checkHeaderName(name);
        name = name.toLowerCase();
        List<Header> headerList = this.headers.get(name);
        if (!ContainerUtils.isEmptyCollection(headerList)) {
            headerList.remove(0);
        }
        return this;
    }

    @Override
    public DefaultHttpHeaderManager removerLastHeader(String name) {
        this.checkHeaderName(name);
        name = name.toLowerCase();
        List<Header> headerList = this.headers.get(name);
        if (!ContainerUtils.isEmptyCollection(headerList)) {
            headerList.remove(headerList.size() - 1);
        }
        return this;
    }

    @Override
    public DefaultHttpHeaderManager removerHeader(String name, int index) {
        this.checkHeaderName(name);
        name = name.toLowerCase();
        List<Header> headerList = this.headers.get(name);
        if (!ContainerUtils.isEmptyCollection(headerList)) {
            headerList.remove(index);
        }
        return this;
    }

    @Override
    public Map<String, List<Header>> getHeaderMap() {
        return this.headers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HEADERS: {");
        for (Map.Entry<String, List<Header>> entry : this.headers.entrySet()) {
            String name = entry.getKey();
            List<Header> valueList = entry.getValue();
            if (ContainerUtils.isEmptyCollection(valueList)) {
                sb.append(name).append("=,");
                continue;
            }
            StringBuilder lb = new StringBuilder(name).append("=[");
            for (Header header : valueList) {
                lb.append(header).append(", ");
            }
            String ls = lb.toString();
            ls = ls.endsWith(", ") ? ls.substring(0, ls.length() - 2) : ls;
            ls = ls + "]";
            sb.append(ls).append(",");
        }
        String ss = sb.toString();
        ss = ss.endsWith(",") ? ss.substring(0, ss.length() - 1) : ss;
        ss = ss + "}";
        return ss;
    }
}

