/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.core.impl;

import com.luckyframework.httpclient.core.HttpHeaderManager;
import com.luckyframework.httpclient.core.Request;
import com.luckyframework.httpclient.core.Response;
import com.luckyframework.httpclient.core.ResponseMetaData;
import com.luckyframework.httpclient.core.impl.SaveResultResponseProcessor;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.util.FileCopyUtils;

public class DefaultResponse
implements Response {
    private static SaveResultResponseProcessor commonProcessor;
    private final ResponseMetaData responseMetaData;
    private final byte[] result;

    public DefaultResponse(ResponseMetaData responseMetaData) throws IOException {
        this.responseMetaData = responseMetaData;
        this.result = FileCopyUtils.copyToByteArray((InputStream)responseMetaData.getInputStream());
    }

    public static SaveResultResponseProcessor getCommonProcessor() {
        return commonProcessor == null ? new SaveResultResponseProcessor() : commonProcessor;
    }

    public static void setCommonProcessor(SaveResultResponseProcessor commonProcessor) {
        DefaultResponse.commonProcessor = commonProcessor;
    }

    @Override
    public Request getRequest() {
        return this.responseMetaData.getRequest();
    }

    @Override
    public int getState() {
        return this.responseMetaData.getStatus();
    }

    @Override
    public HttpHeaderManager getHeaderManager() {
        return this.responseMetaData.getResponseHeader();
    }

    @Override
    public byte[] getResult() {
        return this.result;
    }

    @Override
    public ResponseMetaData getResponseMetaData() {
        return this.responseMetaData;
    }
}

