/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.proxy;

import com.luckyframework.common.ConfigurationMap;
import com.luckyframework.common.ContainerUtils;
import com.luckyframework.common.StringUtils;
import com.luckyframework.common.TempPair;
import com.luckyframework.conversion.ConversionUtils;
import com.luckyframework.httpclient.core.HttpExecutorException;
import com.luckyframework.httpclient.core.Request;
import com.luckyframework.httpclient.core.RequestMethod;
import com.luckyframework.httpclient.core.Response;
import com.luckyframework.httpclient.core.ResponseProcessor;
import com.luckyframework.httpclient.core.executor.HttpExecutor;
import com.luckyframework.httpclient.core.executor.JdkHttpExecutor;
import com.luckyframework.httpclient.core.impl.SaveResultResponseProcessor;
import com.luckyframework.httpclient.proxy.HttpExceptionHandle;
import com.luckyframework.httpclient.proxy.ObjectCreator;
import com.luckyframework.httpclient.proxy.ParameterSetter;
import com.luckyframework.httpclient.proxy.ParameterSetterWrapper;
import com.luckyframework.httpclient.proxy.RequestAfterProcessor;
import com.luckyframework.httpclient.proxy.ResponseAfterProcessor;
import com.luckyframework.httpclient.proxy.ResponseConvert;
import com.luckyframework.httpclient.proxy.SpELConvert;
import com.luckyframework.httpclient.proxy.StaticParamResolver;
import com.luckyframework.httpclient.proxy.URLGetter;
import com.luckyframework.httpclient.proxy.annotations.Async;
import com.luckyframework.httpclient.proxy.annotations.ConvertProhibition;
import com.luckyframework.httpclient.proxy.annotations.DomainName;
import com.luckyframework.httpclient.proxy.annotations.DynamicParam;
import com.luckyframework.httpclient.proxy.annotations.ExceptionHandle;
import com.luckyframework.httpclient.proxy.annotations.HttpRequest;
import com.luckyframework.httpclient.proxy.annotations.RequestAfterHandle;
import com.luckyframework.httpclient.proxy.annotations.ResponseAfterHandle;
import com.luckyframework.httpclient.proxy.annotations.ResultConvert;
import com.luckyframework.httpclient.proxy.annotations.StaticParam;
import com.luckyframework.httpclient.proxy.impl.CachedReflectObjectCreator;
import com.luckyframework.httpclient.proxy.impl.DefaultHttpExceptionHandle;
import com.luckyframework.io.MultipartFile;
import com.luckyframework.proxy.ProxyFactory;
import com.luckyframework.reflect.ASMUtil;
import com.luckyframework.reflect.AnnotationUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.concurrent.CompletableToListenableFutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;

public class HttpClientProxyObjectFactory {
    private static SpELConvert spELConverter = new SpELConvert();
    private static final Map<String, Object> expressionParams = new HashMap<String, Object>();
    private Integer connectionTimeout;
    private Integer readTimeout;
    private Integer writeTimeout;
    private ConfigurationMap headers;
    private ConfigurationMap pathParams;
    private ConfigurationMap queryParams;
    private ConfigurationMap requestParams = new ConfigurationMap();
    private final List<RequestAfterProcessor> requestAfterProcessorList = new ArrayList<RequestAfterProcessor>();
    private final List<ResponseAfterProcessor> responseAfterProcessorList = new ArrayList<ResponseAfterProcessor>();
    private Executor executor;
    private Supplier<Executor> executorSupplier = () -> new SimpleAsyncTaskExecutor("http-task-");
    private ObjectCreator objectCreator = new CachedReflectObjectCreator();
    private HttpExecutor httpExecutor = new JdkHttpExecutor();
    private HttpExceptionHandle exceptionHandle = new DefaultHttpExceptionHandle();
    private ResponseConvert responseConvert;

    public HttpClientProxyObjectFactory(Executor executor) {
        this.executor = executor;
    }

    public HttpClientProxyObjectFactory() {
    }

    public static SpELConvert getSpELConverter() {
        return spELConverter;
    }

    public static void setSpELConverter(SpELConvert spELConverter) {
        HttpClientProxyObjectFactory.spELConverter = spELConverter;
    }

    public static void addExpressionParam(String name, Object value) {
        expressionParams.put(name, value);
    }

    public static void removeExpressionParam(String ... names) {
        for (String name : names) {
            expressionParams.remove(name);
        }
    }

    public static void addExpressionParams(Map<String, Object> confMap) {
        expressionParams.putAll(confMap);
    }

    public static void setExpressionParams(Map<String, Object> confMap) {
        confMap.clear();
        expressionParams.putAll(confMap);
    }

    public static Map<String, Object> getExpressionParams() {
        return expressionParams;
    }

    public Executor getExecutor() {
        if (this.executor == null) {
            this.executor = this.executorSupplier.get();
        }
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setExecutorSupplier(Supplier<Executor> executorSupplier) {
        this.executorSupplier = executorSupplier;
    }

    public void setObjectCreator(ObjectCreator objectCreator) {
        this.objectCreator = objectCreator;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Integer getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public HttpExecutor getHttpExecutor() {
        return this.httpExecutor;
    }

    public void setHttpExecutor(HttpExecutor httpExecutor) {
        this.httpExecutor = httpExecutor;
    }

    public HttpExceptionHandle getExceptionHandle() {
        return this.exceptionHandle;
    }

    public void setExceptionHandle(HttpExceptionHandle exceptionHandle) {
        this.exceptionHandle = exceptionHandle;
    }

    public List<RequestAfterProcessor> getRequestAfterProcessorList() {
        return this.requestAfterProcessorList;
    }

    public List<ResponseAfterProcessor> getResponseAfterProcessorList() {
        return this.responseAfterProcessorList;
    }

    public void addRequestAfterProcessors(RequestAfterProcessor ... requestAfterProcessors) {
        this.requestAfterProcessorList.addAll(Arrays.asList(requestAfterProcessors));
    }

    public void addRequestAfterProcessors(Collection<RequestAfterProcessor> requestAfterProcessors) {
        this.requestAfterProcessorList.addAll(requestAfterProcessors);
    }

    public void addResponseAfterProcessors(ResponseAfterProcessor ... responseAfterProcessors) {
        this.responseAfterProcessorList.addAll(Arrays.asList(responseAfterProcessors));
    }

    public void addResponseAfterProcessors(Collection<ResponseAfterProcessor> requestAfterProcessors) {
        this.responseAfterProcessorList.addAll(requestAfterProcessors);
    }

    public ResponseConvert getResponseConvert() {
        return this.responseConvert;
    }

    public void setResponseConvert(ResponseConvert responseConvert) {
        this.responseConvert = responseConvert;
    }

    public void setHeaders(ConfigurationMap headerMap) {
        this.headers = headerMap;
    }

    public void setProxyClassHeaders(Class<?> proxyClass, Map<String, Object> proxyClassHeaders) {
        this.headers.put(proxyClass.getName(), proxyClassHeaders);
    }

    public void setPathParameters(ConfigurationMap pathMap) {
        this.pathParams = pathMap;
    }

    public void setProxyClassPathParameters(Class<?> proxyClass, Map<String, Object> proxyClassPathParameters) {
        this.pathParams.put(proxyClass.getName(), proxyClassPathParameters);
    }

    public void setQueryParameters(ConfigurationMap queryMap) {
        this.queryParams = queryMap;
    }

    public void setProxyClassQueryParameter(Class<?> proxyClass, Map<String, Object> proxyClassQueryParameters) {
        this.queryParams.put(proxyClass.getName(), proxyClassQueryParameters);
    }

    public void setFormParameters(ConfigurationMap formMap) {
        this.requestParams = formMap;
    }

    public void setProxyClassFormParameter(Class<?> proxyClass, Map<String, Object> proxyClassFormParameters) {
        this.requestParams.put(proxyClass.getName(), proxyClassFormParameters);
    }

    public void addInputStream(String name, String fileName, InputStream inputStream) {
        MultipartFile mf = new MultipartFile(inputStream, fileName);
        this.requestParams.put(name, (Object)mf);
    }

    public void addFiles(String name, File ... files) {
        this.requestParams.put(name, (Object)files);
    }

    public void addFiles(String name, String ... filePaths) {
        this.addFiles(name, (File[])ConversionUtils.conversion((Object)filePaths, File[].class));
    }

    public void addResources(String name, Resource ... resources) {
        this.requestParams.put(name, (Object)resources);
    }

    public void addResources(String name, String ... resourcePaths) {
        this.addResources(name, (Resource[])ConversionUtils.conversion((Object)resourcePaths, Resource[].class));
    }

    public void addMultipartFiles(String name, MultipartFile ... multipartFiles) {
        this.requestParams.put(name, (Object)multipartFiles);
    }

    public <T> T getCglibProxyObject(Class<T> interfaceClass) {
        return (T)ProxyFactory.getCglibProxyObject(interfaceClass, Enhancer::create, (Callback)new CglibHttpRequestMethodInterceptor(interfaceClass));
    }

    public <T> T getJdkProxyObject(Class<T> interfaceClass) {
        return (T)ProxyFactory.getJdkProxyObject((ClassLoader)interfaceClass.getClassLoader(), (Class[])new Class[]{interfaceClass}, (InvocationHandler)new JdkHttpRequestInvocationHandler(interfaceClass));
    }

    public void shutdown() {
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
        }
    }

    public void shutdownNow() {
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdownNow();
        }
    }

    static class RequestBaseInfo {
        private final String url;
        private final RequestMethod method;

        public RequestBaseInfo(String url, RequestMethod method) {
            this.url = url;
            this.method = method;
        }

        public Request createRequest() {
            return Request.builder(this.url, this.method, new Object[0]);
        }
    }

    static class StaticParamCacheEntry {
        private final ParameterSetter setter;
        private final List<TempPair<String, Object>> staticParamPairs;

        public StaticParamCacheEntry(ParameterSetter setter, List<TempPair<String, Object>> staticParamPairs) {
            this.setter = setter;
            this.staticParamPairs = staticParamPairs;
        }

        public ParameterSetter getSetter() {
            return this.setter;
        }

        public List<TempPair<String, Object>> getStaticParamPairs() {
            return this.staticParamPairs;
        }
    }

    class HttpRequestProxy {
        private final Class<?> interfaceClass;
        private final Set<String> proxyClassInheritanceStructure;
        private final Map<AnnotatedElement, List<StaticParamCacheEntry>> staticParams = new ConcurrentHashMap<AnnotatedElement, List<StaticParamCacheEntry>>(16);
        private final Map<Method, RequestBaseInfo> methodBaseRequests = new ConcurrentHashMap<Method, RequestBaseInfo>(16);
        private Map<String, Object> commonHeaderParams;
        private Map<String, Object> commonQueryParams;
        private Map<String, Object> commonPathParams;
        private Map<String, Object> commonRequestParams;

        HttpRequestProxy(Class<?> interfaceClass) {
            this.interfaceClass = interfaceClass;
            this.proxyClassInheritanceStructure = this.getProxyClassInheritanceStructure();
        }

        public Object methodProxy(Object proxy, Method method, Object[] args) throws IOException {
            if (ReflectionUtils.isEqualsMethod((Method)method)) {
                return proxy.getClass() == args[0].getClass();
            }
            if (ReflectionUtils.isHashCodeMethod((Method)method)) {
                return proxy.getClass().hashCode();
            }
            if (ReflectionUtils.isToStringMethod((Method)method)) {
                return proxy.getClass().toString();
            }
            return this.invokeHttpProxyMethod(method, args);
        }

        public Object invokeHttpProxyMethod(Method method, Object[] args) throws IOException {
            Request request = this.createBaseRequest(method);
            this.commonParamSetting(request);
            this.staticParamSetting(request, this.interfaceClass);
            this.staticParamSetting(request, method);
            this.methodArgsParamSetting(request, method, args);
            this.requestAfterProcessor(request, method);
            HttpExceptionHandle finalExceptionHandle = this.getFinallyHttpExceptionHandle(method);
            if (this.isVoidMethod(method)) {
                ResponseProcessor finalRespProcessor = this.getFinalVoidResponseProcessor(args);
                if (this.isAsyncMethod(method)) {
                    HttpClientProxyObjectFactory.this.getExecutor().execute(() -> this.executeVoidRequest(request, finalRespProcessor, finalExceptionHandle));
                } else {
                    this.executeVoidRequest(request, finalRespProcessor, finalExceptionHandle);
                }
                return null;
            }
            if (this.isFutureMethod(method)) {
                CompletableToListenableFutureAdapter completableFuture = CompletableFuture.supplyAsync(() -> this.executeNonVoidRequest(method, request, this.getRealMethodReturnType(method), finalExceptionHandle), HttpClientProxyObjectFactory.this.getExecutor());
                return ListenableFuture.class.isAssignableFrom(method.getReturnType()) ? new CompletableToListenableFutureAdapter((CompletableFuture)completableFuture) : completableFuture;
            }
            return this.executeNonVoidRequest(method, request, this.getRealMethodReturnType(method), finalExceptionHandle);
        }

        private Request createBaseRequest(Method method) {
            RequestBaseInfo requestBaseInfo = this.methodBaseRequests.get(method);
            if (requestBaseInfo == null) {
                HttpRequest httpReqAnn;
                DomainName domainNameAnn = (DomainName)AnnotationUtils.findMergedAnnotation(this.interfaceClass, DomainName.class);
                String classUrl = "";
                if (domainNameAnn != null) {
                    classUrl = this.createURL(domainNameAnn.getter(), domainNameAnn.getterMsg(), domainNameAnn.value());
                }
                if ((httpReqAnn = (HttpRequest)AnnotationUtils.findMergedAnnotation((AnnotatedElement)method, HttpRequest.class)) == null) {
                    throw new HttpExecutorException("The interface method is not an HTTP method: " + method);
                }
                String methodUrl = this.createURL(httpReqAnn.urlGetter(), httpReqAnn.urlGetterMsg(), httpReqAnn.url());
                requestBaseInfo = new RequestBaseInfo(StringUtils.joinUrlPath((String)classUrl, (String)methodUrl), httpReqAnn.method());
                this.methodBaseRequests.put(method, requestBaseInfo);
            }
            return requestBaseInfo.createRequest();
        }

        private String createURL(Class<? extends URLGetter> getterClass, String getterMsg, String configValue) {
            if (getterClass != URLGetter.class || StringUtils.hasText((String)getterMsg)) {
                return HttpClientProxyObjectFactory.this.objectCreator.newObject(getterClass, getterMsg).getUrl(configValue);
            }
            return configValue;
        }

        private void commonParamSetting(Request request) {
            Integer connectionTimeout = HttpClientProxyObjectFactory.this.getConnectionTimeout();
            Integer readTimeout = HttpClientProxyObjectFactory.this.getReadTimeout();
            Integer writeTimeout = HttpClientProxyObjectFactory.this.getWriteTimeout();
            if (connectionTimeout != null && connectionTimeout > 0) {
                request.setConnectTimeout(connectionTimeout);
            }
            if (readTimeout != null && readTimeout > 0) {
                request.setReadTimeout(readTimeout);
            }
            if (writeTimeout != null && writeTimeout > 0) {
                request.setWriterTimeout(writeTimeout);
            }
            this.headersSetting(request);
            this.queryParamsSetting(request);
            this.pathParamsSetting(request);
            this.requestParamsSetting(request);
        }

        private void headersSetting(Request request) {
            Map<String, Object> headerParams = this.getCommonHeaderParams();
            headerParams.forEach((n, v) -> {
                if (ContainerUtils.isIterable((Object)v)) {
                    ContainerUtils.getIterable((Object)v).forEach(ve -> request.addHeader((String)n, ve));
                } else {
                    request.addHeader((String)n, v);
                }
            });
        }

        private void queryParamsSetting(Request request) {
            Map<String, Object> queryParams = this.getCommonQueryParams();
            queryParams.forEach((n, v) -> {
                if (ContainerUtils.isIterable((Object)v)) {
                    ContainerUtils.getIterable((Object)v).forEach(ve -> request.addQueryParameter((String)n, ve));
                } else {
                    request.addQueryParameter((String)n, v);
                }
            });
        }

        private void pathParamsSetting(Request request) {
            request.setPathParameter(this.getCommonPathParams());
        }

        private void requestParamsSetting(Request request) {
            request.setRequestParameter(this.getCommonRequestParams());
        }

        private Map<String, Object> getCommonPathParams() {
            if (this.commonPathParams == null) {
                this.commonPathParams = this.getCommonMapParam((Map<String, Object>)HttpClientProxyObjectFactory.this.pathParams);
            }
            return this.commonPathParams;
        }

        private Map<String, Object> getCommonRequestParams() {
            if (this.commonRequestParams == null) {
                this.commonRequestParams = this.getCommonMapParam((Map<String, Object>)HttpClientProxyObjectFactory.this.requestParams);
            }
            return this.commonRequestParams;
        }

        private Map<String, Object> getCommonQueryParams() {
            if (this.commonQueryParams == null) {
                this.commonQueryParams = this.getCommonMapParam((Map<String, Object>)HttpClientProxyObjectFactory.this.queryParams);
            }
            return this.commonQueryParams;
        }

        private Map<String, Object> getCommonHeaderParams() {
            if (this.commonHeaderParams == null) {
                this.commonHeaderParams = this.getCommonMapParam((Map<String, Object>)HttpClientProxyObjectFactory.this.headers);
            }
            return this.commonHeaderParams;
        }

        private Map<String, Object> getCommonMapParam(Map<String, Object> mapParam) {
            LinkedHashMap<String, Object> realMapParam = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : mapParam.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (this.proxyClassInheritanceStructure.contains(key) && value instanceof Map) {
                    realMapParam.putAll((Map)value);
                    continue;
                }
                try {
                    Class.forName(key);
                }
                catch (ClassNotFoundException e) {
                    if (value instanceof Map) {
                        realMapParam.put(key, new ArrayList(((Map)value).values()));
                        continue;
                    }
                    realMapParam.put(key, value);
                }
            }
            return realMapParam;
        }

        private Set<String> getProxyClassInheritanceStructure() {
            HashSet<String> proxyClassNameSet = new HashSet<String>();
            for (Class<?> proxyClass = this.interfaceClass; proxyClass != null; proxyClass = proxyClass.getSuperclass()) {
                proxyClassNameSet.add(proxyClass.getName());
            }
            return proxyClassNameSet;
        }

        private void staticParamSetting(Request request, AnnotatedElement annotatedElement) {
            List<StaticParamCacheEntry> staticParamCacheEntries = this.getStaticParam(annotatedElement);
            for (StaticParamCacheEntry staticParamCacheEntry : staticParamCacheEntries) {
                ParameterSetter parameterSetter = staticParamCacheEntry.getSetter();
                List<TempPair<String, Object>> staticParamPairs = staticParamCacheEntry.getStaticParamPairs();
                for (TempPair<String, Object> staticParamPair : staticParamPairs) {
                    parameterSetter.set(request, (String)staticParamPair.getOne(), staticParamPair.getTwo());
                }
            }
        }

        private List<StaticParamCacheEntry> getStaticParam(AnnotatedElement annotatedElement) {
            List<StaticParamCacheEntry> staticParamCacheEntries = this.staticParams.get(annotatedElement);
            if (staticParamCacheEntries == null) {
                staticParamCacheEntries = new ArrayList<StaticParamCacheEntry>();
                Set staticParamAnnSet = AnnotationUtils.getAnnotationsByContain((AnnotatedElement)annotatedElement, StaticParam.class);
                for (Annotation staticParamAnn : staticParamAnnSet) {
                    Class paramSetterClass = (Class)AnnotationUtils.getValue((Annotation)staticParamAnn, (String)"paramSetter");
                    String paramSetterMsg = (String)AnnotationUtils.getValue((Annotation)staticParamAnn, (String)"paramSetterMsg");
                    ParameterSetter parameterSetter = (ParameterSetter)HttpClientProxyObjectFactory.this.objectCreator.newObject(paramSetterClass, paramSetterMsg);
                    Class paramResolverClass = (Class)AnnotationUtils.getValue((Annotation)staticParamAnn, (String)"paramResolver");
                    String paramResolverMsg = (String)AnnotationUtils.getValue((Annotation)staticParamAnn, (String)"paramResolverMsg");
                    StaticParamResolver staticParamResolver = (StaticParamResolver)HttpClientProxyObjectFactory.this.objectCreator.newObject(paramResolverClass, paramResolverMsg);
                    staticParamCacheEntries.add(new StaticParamCacheEntry(parameterSetter, staticParamResolver.parser(staticParamAnn)));
                }
                this.staticParams.put(annotatedElement, staticParamCacheEntries);
            }
            return staticParamCacheEntries;
        }

        private void methodArgsParamSetting(Request request, Method method, Object[] args) throws IOException {
            List asmParamNameList = ASMUtil.getClassOrInterfaceMethodParamNames((Method)method);
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < method.getParameterCount(); ++i) {
                Object parameterValue = args[i];
                if (parameterValue instanceof ResponseProcessor) continue;
                Parameter parameter = parameters[i];
                String paramName = this.getParamName(parameter, (String)asmParamNameList.get(i));
                ParameterSetterWrapper finalParamSetterWrapper = ParameterSetterWrapper.createByAnnotatedElement(parameter, HttpClientProxyObjectFactory.this.objectCreator);
                finalParamSetterWrapper.setRequest(request, paramName, parameterValue, ResolvableType.forMethodParameter((Method)method, (int)i));
            }
        }

        private TempPair<ResponseConvert, Annotation> getFinalResponseConvertPair(Method method) {
            ResultConvert combinationAnnotation = (ResultConvert)AnnotationUtils.getCombinationAnnotation((AnnotatedElement)method, ResultConvert.class);
            if (combinationAnnotation != null) {
                ResponseConvert convert = HttpClientProxyObjectFactory.this.objectCreator.newObject(combinationAnnotation.convert(), combinationAnnotation.convertMsg());
                return TempPair.of((Object)convert, (Object)combinationAnnotation);
            }
            return TempPair.of((Object)HttpClientProxyObjectFactory.this.getResponseConvert(), () -> ResultConvert.class);
        }

        private ResponseProcessor getFinalVoidResponseProcessor(Object[] args) {
            if (ContainerUtils.isEmptyArray((Object[])args)) {
                return ResponseProcessor.DO_NOTHING_PROCESSOR;
            }
            for (Object arg : args) {
                if (!(arg instanceof ResponseProcessor)) continue;
                return (ResponseProcessor)arg;
            }
            return ResponseProcessor.DO_NOTHING_PROCESSOR;
        }

        private HttpExceptionHandle getFinallyHttpExceptionHandle(Method method) {
            ExceptionHandle combinationAnnotation = (ExceptionHandle)AnnotationUtils.getCombinationAnnotation((AnnotatedElement)method, ExceptionHandle.class);
            if (combinationAnnotation != null) {
                return HttpClientProxyObjectFactory.this.objectCreator.newObject(combinationAnnotation.value(), combinationAnnotation.handleMsg());
            }
            return HttpClientProxyObjectFactory.this.getExceptionHandle();
        }

        private void requestAfterProcessor(Request request, Method method) {
            HttpClientProxyObjectFactory.this.getRequestAfterProcessorList().forEach(rap -> rap.requestProcess(request, null));
            ArrayList<Annotation> reqProcessorList = new ArrayList<Annotation>(AnnotationUtils.getAnnotationsByContain((AnnotatedElement)method, RequestAfterHandle.class));
            reqProcessorList.addAll(AnnotationUtils.getAnnotationsByContain(this.interfaceClass, RequestAfterHandle.class));
            reqProcessorList.sort(Comparator.comparingInt(a -> (Integer)AnnotationUtils.getValue((Annotation)a, (String)"requestPriority", Integer.TYPE)));
            for (Annotation annotation : reqProcessorList) {
                Class reqProcessClass = (Class)AnnotationUtils.getValue((Annotation)annotation, (String)"requestProcessor");
                if (RequestAfterProcessor.class == reqProcessClass) continue;
                String processorMsg = (String)AnnotationUtils.getValue((Annotation)annotation, (String)"requestProcessorMsg", String.class);
                ((RequestAfterProcessor)HttpClientProxyObjectFactory.this.objectCreator.newObject(reqProcessClass, processorMsg)).requestProcess(request, annotation);
            }
        }

        private void responseAfterProcessor(Response response, Method method) {
            HttpClientProxyObjectFactory.this.getResponseAfterProcessorList().forEach(rap -> rap.responseProcess(response, null));
            ArrayList<Annotation> respProcessorList = new ArrayList<Annotation>(AnnotationUtils.getAnnotationsByContain((AnnotatedElement)method, ResponseAfterHandle.class));
            respProcessorList.addAll(AnnotationUtils.getAnnotationsByContain(this.interfaceClass, ResponseAfterHandle.class));
            respProcessorList.sort(Comparator.comparingInt(a -> (Integer)AnnotationUtils.getValue((Annotation)a, (String)"responsePriority", Integer.TYPE)));
            for (Annotation annotation : respProcessorList) {
                Class reqProcessClass = (Class)AnnotationUtils.getValue((Annotation)annotation, (String)"responseProcessor");
                if (ResponseAfterProcessor.class == reqProcessClass) continue;
                String processorMsg = (String)AnnotationUtils.getValue((Annotation)annotation, (String)"responseProcessorMsg", String.class);
                ((ResponseAfterProcessor)HttpClientProxyObjectFactory.this.objectCreator.newObject(reqProcessClass, processorMsg)).responseProcess(response, annotation);
            }
        }

        private void executeVoidRequest(Request request, ResponseProcessor responseProcessor, HttpExceptionHandle handle) {
            try {
                if (responseProcessor instanceof SaveResultResponseProcessor) {
                    HttpClientProxyObjectFactory.this.getHttpExecutor().execute(request, (SaveResultResponseProcessor)responseProcessor);
                } else {
                    HttpClientProxyObjectFactory.this.getHttpExecutor().execute(request, responseProcessor);
                }
            }
            catch (Exception e) {
                handle.exceptionHandler(request, e);
            }
        }

        private Object executeNonVoidRequest(Method method, Request request, Type methodResultType, HttpExceptionHandle handle) {
            try {
                Response response = HttpClientProxyObjectFactory.this.getHttpExecutor().execute(request);
                this.responseAfterProcessor(response, method);
                boolean isProhibition = this.isConvertProhibition(method);
                if (isProhibition) {
                    return response.getEntity(methodResultType);
                }
                TempPair<ResponseConvert, Annotation> finalResponseConvertPair = this.getFinalResponseConvertPair(method);
                ResponseConvert convert = (ResponseConvert)finalResponseConvertPair.getOne();
                Annotation annotation = (Annotation)finalResponseConvertPair.getTwo();
                if (convert != null) {
                    return convert.convert(response, methodResultType, annotation);
                }
                return response.getEntity(methodResultType);
            }
            catch (Exception e) {
                handle.exceptionHandler(request, e);
                return null;
            }
        }

        private Type getRealMethodReturnType(Method method) {
            if (this.isFutureMethod(method)) {
                ResolvableType methodReturnType = ResolvableType.forMethodReturnType((Method)method);
                return methodReturnType.hasGenerics() ? methodReturnType.getGeneric(new int[]{0}).getType() : Object.class;
            }
            return ResolvableType.forMethodReturnType((Method)method).getType();
        }

        private boolean isVoidMethod(Method method) {
            return method.getReturnType() == Void.TYPE;
        }

        private boolean isAsyncMethod(Method method) {
            return AnnotationUtils.isAnnotated((AnnotatedElement)method, Async.class) || AnnotationUtils.isAnnotated(this.interfaceClass, Async.class);
        }

        private boolean isFutureMethod(Method method) {
            return Future.class.isAssignableFrom(method.getReturnType());
        }

        private boolean isConvertProhibition(Method method) {
            return AnnotationUtils.isAnnotated((AnnotatedElement)method, ConvertProhibition.class);
        }

        private String getParamName(Parameter parameter, String asmParamName) {
            DynamicParam dynamicParamAnn = (DynamicParam)AnnotationUtils.findMergedAnnotation((AnnotatedElement)parameter, DynamicParam.class);
            String paramName = StringUtils.hasText((String)asmParamName) ? asmParamName : parameter.getName();
            return dynamicParamAnn != null && StringUtils.hasText((String)dynamicParamAnn.name()) ? dynamicParamAnn.name() : paramName;
        }
    }

    class JdkHttpRequestInvocationHandler
    extends HttpRequestProxy
    implements InvocationHandler {
        JdkHttpRequestInvocationHandler(Class<?> interfaceClass) {
            super(interfaceClass);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.methodProxy(proxy, method, args);
        }
    }

    class CglibHttpRequestMethodInterceptor
    extends HttpRequestProxy
    implements MethodInterceptor {
        CglibHttpRequestMethodInterceptor(Class<?> interfaceClass) {
            super(interfaceClass);
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            return this.methodProxy(proxy, method, args);
        }
    }
}

