/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.proxy;

import com.luckyframework.common.ContainerUtils;
import com.luckyframework.common.StringUtils;
import com.luckyframework.common.TempPair;
import com.luckyframework.httpclient.core.BodyObject;
import com.luckyframework.httpclient.core.Request;
import com.luckyframework.httpclient.core.ResponseProcessor;
import com.luckyframework.httpclient.core.executor.HttpExecutor;
import com.luckyframework.httpclient.proxy.ObjectCreator;
import com.luckyframework.httpclient.proxy.ParameterProcessor;
import com.luckyframework.httpclient.proxy.ParameterSetter;
import com.luckyframework.httpclient.proxy.annotations.DynamicParam;
import com.luckyframework.httpclient.proxy.annotations.NotHttpParam;
import com.luckyframework.httpclient.proxy.annotations.OverDynamicParam;
import com.luckyframework.httpclient.proxy.impl.CachedReflectObjectCreator;
import com.luckyframework.httpclient.proxy.impl.NotProcessor;
import com.luckyframework.httpclient.proxy.impl.QueryParameterSetter;
import com.luckyframework.reflect.AnnotationUtils;
import com.luckyframework.reflect.ClassUtils;
import com.luckyframework.reflect.FieldUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.ResolvableType;

public class ParameterSetterWrapper {
    private final ObjectCreator objectCreator;
    private final ParameterSetter parameterSetter;
    private final ParameterProcessor parameterProcessor;
    private final Annotation annotationInstance;

    public ParameterSetterWrapper(ObjectCreator objectCreator, ParameterSetter parameterSetter, ParameterProcessor parameterProcessor, Annotation annotationInstance) {
        this.objectCreator = objectCreator;
        this.parameterSetter = parameterSetter;
        this.parameterProcessor = parameterProcessor;
        this.annotationInstance = annotationInstance;
    }

    public ParameterSetterWrapper(ObjectCreator objectCreator, ParameterSetter parameterSetter, ParameterProcessor parameterProcessor) {
        this(objectCreator, parameterSetter, parameterProcessor, null);
    }

    public ParameterSetterWrapper(ObjectCreator objectCreator) {
        this(objectCreator, new QueryParameterSetter(), new NotProcessor());
    }

    public ParameterSetterWrapper(ParameterSetter parameterSetter, ParameterProcessor parameterProcessor) {
        this(new CachedReflectObjectCreator(), parameterSetter, parameterProcessor);
    }

    public ParameterSetterWrapper() {
        this(new QueryParameterSetter(), new NotProcessor());
    }

    public static ParameterSetterWrapper createByAnnotatedElement(AnnotatedElement annotatedElement, ObjectCreator objectCreator) {
        DynamicParam dynamicParam = (DynamicParam)AnnotationUtils.getCombinationAnnotation((AnnotatedElement)annotatedElement, DynamicParam.class);
        OverDynamicParam overDynamicParam = (OverDynamicParam)AnnotationUtils.getCombinationAnnotation((AnnotatedElement)annotatedElement, OverDynamicParam.class);
        if (dynamicParam == null && overDynamicParam == null) {
            return new ParameterSetterWrapper(objectCreator);
        }
        if (dynamicParam == null) {
            TempPair<ParameterSetter, ParameterProcessor> parameterPair = ParameterSetterWrapper.createParameter(objectCreator, overDynamicParam.overParamSetterMsg(), overDynamicParam.overParamProcessorMsg(), overDynamicParam.overParamSetter(), overDynamicParam.overParamProcessor());
            return new ParameterSetterWrapper(objectCreator, (ParameterSetter)parameterPair.getOne(), (ParameterProcessor)parameterPair.getTwo(), overDynamicParam);
        }
        if (overDynamicParam == null || !dynamicParam.acceptOverlay()) {
            TempPair<ParameterSetter, ParameterProcessor> parameterPair = ParameterSetterWrapper.createParameter(objectCreator, dynamicParam.paramSetterMsg(), dynamicParam.paramProcessorMsg(), dynamicParam.paramSetter(), dynamicParam.paramProcessor());
            return new ParameterSetterWrapper(objectCreator, (ParameterSetter)parameterPair.getOne(), (ParameterProcessor)parameterPair.getTwo(), dynamicParam);
        }
        Class<ParameterSetter> setterClass = ParameterSetterWrapper.select(overDynamicParam.overParamSetter(), dynamicParam.paramSetter(), ParameterSetter.class);
        Class<ParameterProcessor> processorClass = ParameterSetterWrapper.select(overDynamicParam.overParamProcessor(), dynamicParam.paramProcessor(), ParameterProcessor.class);
        String setterMsg = ParameterSetterWrapper.select(overDynamicParam.overParamSetterMsg(), dynamicParam.paramSetterMsg(), "");
        String processorMsg = ParameterSetterWrapper.select(overDynamicParam.overParamProcessorMsg(), dynamicParam.paramProcessorMsg(), "");
        TempPair<ParameterSetter, ParameterProcessor> parameterPair = ParameterSetterWrapper.createParameter(objectCreator, setterMsg, processorMsg, setterClass, processorClass);
        return new ParameterSetterWrapper(objectCreator, (ParameterSetter)parameterPair.getOne(), (ParameterProcessor)parameterPair.getTwo(), AnnotationUtils.createCombinationAnnotation(DynamicParam.class, (Annotation[])new Annotation[]{dynamicParam, overDynamicParam}));
    }

    private static TempPair<ParameterSetter, ParameterProcessor> createParameter(ObjectCreator objectCreator, String setterMsg, String processorMsg, Class<? extends ParameterSetter> setterClass, Class<? extends ParameterProcessor> processorClass) {
        QueryParameterSetter setter = setterClass == ParameterSetter.class ? new QueryParameterSetter() : objectCreator.newObject(setterClass, setterMsg);
        NotProcessor processor = processorClass == ParameterProcessor.class ? new NotProcessor() : objectCreator.newObject(processorClass, processorMsg);
        return TempPair.of((Object)setter, (Object)processor);
    }

    private static <T> T select(T high, T low, T def) {
        if (high == null && low == null) {
            return def;
        }
        if (high == null) {
            return low;
        }
        if (low == null) {
            return high;
        }
        return high.equals(def) ? low : high;
    }

    public void setRequest(Request request, String paramName, Object paramValue, ResolvableType paramType) {
        if (paramValue == null) {
            return;
        }
        if (paramValue instanceof ResponseProcessor) {
            return;
        }
        if (HttpExecutor.isResourceParam(paramType)) {
            request.addHttpFiles(paramName, HttpExecutor.toHttpFiles(paramValue));
        } else if (paramValue instanceof BodyObject) {
            request.setBody((BodyObject)paramValue);
        } else if (ClassUtils.isSimpleBaseType(paramValue.getClass())) {
            this.parameterSetter.set(request, paramName, this.parameterProcessor.paramProcess(paramValue, this.annotationInstance));
        } else if (paramValue instanceof Map) {
            this.mapParamSetting(request, paramName, (Map)paramValue, paramType);
        } else if (ContainerUtils.isIterable((Object)paramValue)) {
            this.iterateParamSetting(request, paramName, ContainerUtils.getIterator((Object)paramValue), paramType);
        } else {
            this.entityParamSetting(request, paramName, paramValue);
        }
    }

    protected void mapParamSetting(Request request, String paramName, Map<?, ?> mapParam, ResolvableType paramType) {
        if (this.parameterProcessor.needExpansionAnalysis()) {
            mapParam.forEach((name, value) -> this.setRequest(request, String.valueOf(name), value, paramType.getGeneric(new int[]{1})));
        } else {
            this.parameterSetter.set(request, paramName, this.parameterProcessor.paramProcess(mapParam, this.annotationInstance));
        }
    }

    protected void iterateParamSetting(Request request, String paramName, Iterator<?> iterator, ResolvableType paramType) {
        if (this.parameterProcessor.needExpansionAnalysis()) {
            ResolvableType elementType;
            ResolvableType resolvableType = elementType = paramType.isArray() ? paramType.getComponentType() : paramType.getGeneric(new int[]{0});
            while (iterator.hasNext()) {
                this.setRequest(request, paramName, iterator.next(), elementType);
            }
        } else {
            this.parameterSetter.set(request, paramName, this.parameterProcessor.paramProcess(iterator, this.annotationInstance));
        }
    }

    protected void entityParamSetting(Request request, String paramName, Object paramValue) {
        if (this.parameterProcessor.needExpansionAnalysis()) {
            Field[] fields;
            Class<?> paramValueClass = paramValue.getClass();
            DynamicParam classParamAnn = (DynamicParam)AnnotationUtils.findMergedAnnotation(paramValueClass, DynamicParam.class);
            for (Field field : fields = ClassUtils.getAllFields(paramValueClass)) {
                if (AnnotationUtils.isAnnotated((AnnotatedElement)field, NotHttpParam.class)) continue;
                DynamicParam fieldParamAnn = (DynamicParam)AnnotationUtils.findMergedAnnotation((AnnotatedElement)field, DynamicParam.class);
                String fieldParamName = fieldParamAnn != null && StringUtils.hasText((String)fieldParamAnn.name()) ? fieldParamAnn.name() : field.getName();
                Object fieldValue = FieldUtils.getValue((Object)paramValue, (Field)field);
                DynamicParam finalParamAnn = this.getFinalHttpParam(classParamAnn, fieldParamAnn);
                if (finalParamAnn == null) {
                    this.setRequest(request, fieldParamName, fieldValue, ResolvableType.forField((Field)field));
                    continue;
                }
                ParameterSetter annParamSetter = this.objectCreator.newObject(finalParamAnn.paramSetter(), finalParamAnn.paramSetterMsg());
                ParameterProcessor annParamProcessor = this.objectCreator.newObject(finalParamAnn.paramProcessor(), finalParamAnn.paramProcessorMsg());
                if (finalParamAnn.acceptOverlay()) {
                    annParamSetter = this.parameterSetter;
                    annParamProcessor = this.parameterProcessor;
                }
                annParamSetter.set(request, fieldParamName, annParamProcessor.paramProcess(fieldValue, finalParamAnn));
            }
        } else {
            this.parameterSetter.set(request, paramName, this.parameterProcessor.paramProcess(paramValue, this.annotationInstance));
        }
    }

    private DynamicParam getFinalHttpParam(DynamicParam classParamAnn, DynamicParam methodParamAnn) {
        if (methodParamAnn != null) {
            return methodParamAnn;
        }
        return classParamAnn;
    }
}

