/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.proxy.impl;

import com.luckyframework.httpclient.core.BodyObject;
import com.luckyframework.httpclient.core.BodySerialization;
import com.luckyframework.httpclient.proxy.ParameterProcessor;
import com.luckyframework.reflect.AnnotationUtils;
import com.luckyframework.reflect.ClassUtils;
import java.lang.annotation.Annotation;

public class BodyParameterProcessor
implements ParameterProcessor {
    private static final String MIME_TYPE = "mimeType";
    private static final String CHARSET = "charset";
    private static final String SERIALIZATION_CLASS = "serializationClass";

    @Override
    public BodyObject paramProcess(Object originalParam, Annotation dynamicParamAnn) {
        if (originalParam == null) {
            return null;
        }
        String mimeType = (String)AnnotationUtils.getValue((Annotation)dynamicParamAnn, (String)MIME_TYPE, String.class);
        String charset = (String)AnnotationUtils.getValue((Annotation)dynamicParamAnn, (String)CHARSET, String.class);
        Class serializationClass = (Class)AnnotationUtils.getValue((Annotation)dynamicParamAnn, (String)SERIALIZATION_CLASS);
        BodySerialization serializationScheme = (BodySerialization)ClassUtils.newObject((Class)serializationClass, (Object[])new Object[0]);
        try {
            return BodyObject.builder(mimeType, charset, serializationScheme.serialization(originalParam));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Request body parameter serialization exception.", e);
        }
    }

    @Override
    public boolean needExpansionAnalysis() {
        return false;
    }
}

