/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.proxy.impl;

import com.luckyframework.common.ContainerUtils;
import com.luckyframework.conversion.ConversionUtils;
import com.luckyframework.httpclient.core.HttpFile;
import com.luckyframework.httpclient.proxy.HttpClientProxyObjectFactory;
import com.luckyframework.httpclient.proxy.ParameterProcessor;
import com.luckyframework.httpclient.proxy.SpELConvert;
import com.luckyframework.reflect.AnnotationUtils;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;

public class InputStreamParameterProcessor
implements ParameterProcessor {
    private static final String FILE_NAME = "filename";

    public HttpFile[] paramProcess(Object originalParam, Annotation dynamicParamAnn) {
        if (originalParam == null) {
            return null;
        }
        InputStream[] inputStreams = (InputStream[])ConversionUtils.conversion((Object)originalParam, InputStream[].class);
        String filenameEx = (String)AnnotationUtils.getValue((Annotation)dynamicParamAnn, (String)FILE_NAME, String.class);
        SpELConvert spELConverter = HttpClientProxyObjectFactory.getSpELConverter();
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put("p", originalParam);
        Object filenameResult = spELConverter.parseExpression(filenameEx, parameters);
        if (ContainerUtils.isIterable((Object)filenameResult)) {
            int filenameLength = ContainerUtils.getIteratorLength((Object)filenameResult);
            if (inputStreams.length != filenameLength) {
                throw new IllegalStateException("The length of the name returned by the filename expression does not match the length of the input stream array.");
            }
            HttpFile[] httpFiles = new HttpFile[filenameLength];
            Iterator iterator = ContainerUtils.getIterator((Object)filenameResult);
            int i = 0;
            while (iterator.hasNext()) {
                httpFiles[i] = new HttpFile(inputStreams[i], String.valueOf(iterator.next()));
            }
            return httpFiles;
        }
        if (inputStreams.length == 1) {
            return new HttpFile[]{new HttpFile(inputStreams[0], String.valueOf(filenameResult))};
        }
        throw new IllegalStateException("The filename expression is a file, but the input stream in the argument is an array.");
    }

    @Override
    public boolean needExpansionAnalysis() {
        return false;
    }
}

