/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.proxy.impl;

import com.luckyframework.common.ConfigurationMap;
import com.luckyframework.common.StringUtils;
import com.luckyframework.httpclient.core.Response;
import com.luckyframework.httpclient.exception.ResponseProcessException;
import com.luckyframework.httpclient.proxy.HttpClientProxyObjectFactory;
import com.luckyframework.httpclient.proxy.ResponseConvert;
import com.luckyframework.reflect.AnnotationUtils;
import com.luckyframework.spel.ParamWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;

public class ResponseSelectConvert
implements ResponseConvert {
    private static final Logger log = LoggerFactory.getLogger(ResponseSelectConvert.class);
    private static final String CONVENTION_PREFIX = "@resp";

    @Override
    public <T> T convert(Response response, Type resultType, Annotation resultConvertAnn) throws Exception {
        String mapKey = (String)AnnotationUtils.getValue((Annotation)resultConvertAnn, (String)"key", String.class);
        String defaultValueSpEL = (String)AnnotationUtils.getValue((Annotation)resultConvertAnn, (String)"defaultValue", String.class);
        if (!StringUtils.hasText((String)mapKey)) {
            return response.getEntity(resultType);
        }
        ConfigurationMap resultMap = new ConfigurationMap();
        if (response.isJsonType()) {
            resultMap.addProperty(CONVENTION_PREFIX, response.jsonStrToEntity(Object.class));
        } else if (response.isXmlType()) {
            resultMap.addProperty(CONVENTION_PREFIX, response.xmlStrToEntity(Object.class));
        }
        if (resultMap.containsConfigKey(mapKey)) {
            return (T)resultMap.getEntry(mapKey, resultType);
        }
        if (StringUtils.hasText((String)defaultValueSpEL)) {
            log.warn("The content specified by '{}' does not exist in the response body. The default configuration is enabled", (Object)mapKey);
            return (T)HttpClientProxyObjectFactory.getSpELConverter().getSpELRuntime().getValueForType(new ParamWrapper(defaultValueSpEL).setParserContext((ParserContext)new TemplateParserContext()).setExpectedResultType(resultType));
        }
        throw new ResponseProcessException("A value for '{}' does not exist in the response body, and the default value configuration is not checked", mapKey);
    }
}

