/*
 * Decompiled with CFR 0.152.
 */
package com.luckyframework.httpclient.proxy.impl;

import com.luckyframework.httpclient.core.HttpExecutorException;
import com.luckyframework.httpclient.proxy.ParameterProcessor;
import com.luckyframework.reflect.AnnotationUtils;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;

public class URLEncoderParameterProcessor
implements ParameterProcessor {
    private static final String CHARSET = "charset";

    @Override
    public String paramProcess(Object originalParam, Annotation dynamicParamAnn) {
        if (originalParam == null) {
            return null;
        }
        String charset = (String)AnnotationUtils.getValue((Annotation)dynamicParamAnn, (String)CHARSET, String.class);
        try {
            return URLEncoder.encode(String.valueOf(originalParam), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpExecutorException("url encoding(" + charset + ") exception: value='" + originalParam + "'", e);
        }
    }
}

