/*
 * Decompiled with CFR 0.152.
 */
package com.luck.lib.camerax;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.display.DisplayManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Display;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseGroup;
import androidx.camera.core.VideoCapture;
import androidx.camera.core.ZoomState;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import com.google.common.util.concurrent.ListenableFuture;
import com.luck.lib.camerax.CustomCameraConfig;
import com.luck.lib.camerax.R;
import com.luck.lib.camerax.SimpleCameraX;
import com.luck.lib.camerax.listener.CameraListener;
import com.luck.lib.camerax.listener.CameraXOrientationEventListener;
import com.luck.lib.camerax.listener.CameraXPreviewViewTouchListener;
import com.luck.lib.camerax.listener.CaptureListener;
import com.luck.lib.camerax.listener.ClickListener;
import com.luck.lib.camerax.listener.ImageCallbackListener;
import com.luck.lib.camerax.listener.TypeListener;
import com.luck.lib.camerax.permissions.PermissionChecker;
import com.luck.lib.camerax.permissions.PermissionResultCallback;
import com.luck.lib.camerax.permissions.SimpleXPermissionUtil;
import com.luck.lib.camerax.utils.CameraUtils;
import com.luck.lib.camerax.utils.DensityUtil;
import com.luck.lib.camerax.utils.FileUtils;
import com.luck.lib.camerax.utils.SimpleXSpUtils;
import com.luck.lib.camerax.widget.CaptureLayout;
import com.luck.lib.camerax.widget.FocusImageView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CustomCameraView
extends RelativeLayout
implements CameraXOrientationEventListener.OnOrientationChangedListener {
    private static final double RATIO_4_3_VALUE = 1.3333333333333333;
    private static final double RATIO_16_9_VALUE = 1.7777777777777777;
    private static final int TYPE_FLASH_AUTO = 33;
    private static final int TYPE_FLASH_ON = 34;
    private static final int TYPE_FLASH_OFF = 35;
    private int typeFlash = 35;
    private PreviewView mCameraPreviewView;
    private ProcessCameraProvider mCameraProvider;
    private ImageCapture mImageCapture;
    private ImageAnalysis mImageAnalyzer;
    private VideoCapture mVideoCapture;
    private int displayId = -1;
    private int buttonFeatures;
    private String outPutCameraDir;
    private String outPutCameraFileName;
    private int videoFrameRate;
    private int videoBitRate;
    private int recordVideoMinSecond;
    private boolean isDisplayRecordTime;
    private String imageFormat;
    private String imageFormatForQ;
    private String videoFormat;
    private String videoFormatForQ;
    private int useCameraCases = 1;
    private int lensFacing = 1;
    private boolean isManualFocus;
    private boolean isZoomPreview;
    private boolean isAutoRotation;
    private long recordTime = 0L;
    private CameraListener mCameraListener;
    private ClickListener mOnClickListener;
    private ImageCallbackListener mImageCallbackListener;
    private ImageView mImagePreview;
    private View mImagePreviewBg;
    private ImageView mSwitchCamera;
    private ImageView mFlashLamp;
    private TextView tvCurrentTime;
    private CaptureLayout mCaptureLayout;
    private MediaPlayer mMediaPlayer;
    private TextureView mTextureView;
    private DisplayManager displayManager;
    private DisplayListener displayListener;
    private CameraXOrientationEventListener orientationEventListener;
    private CameraInfo mCameraInfo;
    private CameraControl mCameraControl;
    private FocusImageView focusImageView;
    private Executor mainExecutor;
    private Activity activity;
    private final TextureView.SurfaceTextureListener surfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            String outputPath = SimpleCameraX.getOutputPath(CustomCameraView.this.activity.getIntent());
            CustomCameraView.this.startVideoPlay(outputPath);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            return false;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }
    };

    private boolean isImageCaptureEnabled() {
        return this.useCameraCases == 1;
    }

    public CustomCameraView(Context context) {
        super(context);
        this.initView();
    }

    public CustomCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public CustomCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        CustomCameraView.inflate((Context)this.getContext(), (int)R.layout.picture_camera_view, (ViewGroup)this);
        this.activity = (Activity)this.getContext();
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_black));
        this.mCameraPreviewView = (PreviewView)this.findViewById(R.id.cameraPreviewView);
        this.mTextureView = (TextureView)this.findViewById(R.id.video_play_preview);
        this.focusImageView = (FocusImageView)this.findViewById(R.id.focus_view);
        this.mImagePreview = (ImageView)this.findViewById(R.id.cover_preview);
        this.mImagePreviewBg = this.findViewById(R.id.cover_preview_bg);
        this.mSwitchCamera = (ImageView)this.findViewById(R.id.image_switch);
        this.mFlashLamp = (ImageView)this.findViewById(R.id.image_flash);
        this.mCaptureLayout = (CaptureLayout)this.findViewById(R.id.capture_layout);
        this.tvCurrentTime = (TextView)this.findViewById(R.id.tv_current_time);
        this.mSwitchCamera.setImageResource(R.drawable.picture_ic_camera);
        this.displayManager = (DisplayManager)this.getContext().getSystemService("display");
        this.displayListener = new DisplayListener();
        this.displayManager.registerDisplayListener((DisplayManager.DisplayListener)this.displayListener, null);
        this.mainExecutor = ContextCompat.getMainExecutor((Context)this.getContext());
        this.mCameraPreviewView.post(new Runnable(){

            @Override
            public void run() {
                Display display;
                if (CustomCameraView.this.mCameraPreviewView != null && (display = CustomCameraView.this.mCameraPreviewView.getDisplay()) != null) {
                    CustomCameraView.this.displayId = display.getDisplayId();
                }
            }
        });
        this.mFlashLamp.setOnClickListener(v -> {
            ++this.typeFlash;
            if (this.typeFlash > 35) {
                this.typeFlash = 33;
            }
            this.setFlashMode();
        });
        this.mSwitchCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomCameraView.this.toggleCamera();
            }
        });
        this.mCaptureLayout.setCaptureListener(new CaptureListener(){

            @Override
            public void takePictures() {
                if (!CustomCameraView.this.mCameraProvider.isBound((UseCase)CustomCameraView.this.mImageCapture)) {
                    CustomCameraView.this.bindCameraImageUseCases();
                }
                CustomCameraView.this.useCameraCases = 1;
                CustomCameraView.this.mCaptureLayout.setButtonCaptureEnabled(false);
                CustomCameraView.this.mSwitchCamera.setVisibility(4);
                CustomCameraView.this.mFlashLamp.setVisibility(4);
                CustomCameraView.this.tvCurrentTime.setVisibility(8);
                ImageCapture.Metadata metadata = new ImageCapture.Metadata();
                metadata.setReversedHorizontal(CustomCameraView.this.isReversedHorizontal());
                File cameraFile = CustomCameraView.this.isSaveExternal() ? FileUtils.createTempFile(CustomCameraView.this.getContext(), false) : FileUtils.createCameraFile(CustomCameraView.this.getContext(), 1, CustomCameraView.this.outPutCameraFileName, CustomCameraView.this.imageFormat, CustomCameraView.this.outPutCameraDir);
                ImageCapture.OutputFileOptions fileOptions = new ImageCapture.OutputFileOptions.Builder(cameraFile).setMetadata(metadata).build();
                CustomCameraView.this.mImageCapture.takePicture(fileOptions, CustomCameraView.this.mainExecutor, (ImageCapture.OnImageSavedCallback)new MyImageResultCallback(CustomCameraView.this, CustomCameraView.this.mImagePreview, CustomCameraView.this.mImagePreviewBg, CustomCameraView.this.mCaptureLayout, CustomCameraView.this.mImageCallbackListener, CustomCameraView.this.mCameraListener));
            }

            @Override
            public void recordStart() {
                if (!CustomCameraView.this.mCameraProvider.isBound((UseCase)CustomCameraView.this.mVideoCapture)) {
                    CustomCameraView.this.bindCameraVideoUseCases();
                }
                CustomCameraView.this.useCameraCases = 4;
                CustomCameraView.this.mSwitchCamera.setVisibility(4);
                CustomCameraView.this.mFlashLamp.setVisibility(4);
                CustomCameraView.this.tvCurrentTime.setVisibility(CustomCameraView.this.isDisplayRecordTime ? 0 : 8);
                File cameraFile = CustomCameraView.this.isSaveExternal() ? FileUtils.createTempFile(CustomCameraView.this.getContext(), true) : FileUtils.createCameraFile(CustomCameraView.this.getContext(), 2, CustomCameraView.this.outPutCameraFileName, CustomCameraView.this.videoFormat, CustomCameraView.this.outPutCameraDir);
                VideoCapture.OutputFileOptions fileOptions = new VideoCapture.OutputFileOptions.Builder(cameraFile).build();
                CustomCameraView.this.mVideoCapture.startRecording(fileOptions, CustomCameraView.this.mainExecutor, new VideoCapture.OnVideoSavedCallback(){

                    public void onVideoSaved(@NonNull @NotNull VideoCapture.OutputFileResults outputFileResults) {
                        long minSecond;
                        long l = minSecond = CustomCameraView.this.recordVideoMinSecond <= 0 ? 1500L : (long)CustomCameraView.this.recordVideoMinSecond;
                        if (CustomCameraView.this.recordTime < minSecond || outputFileResults.getSavedUri() == null) {
                            return;
                        }
                        Uri savedUri = outputFileResults.getSavedUri();
                        SimpleCameraX.putOutputUri(CustomCameraView.this.activity.getIntent(), savedUri);
                        String outPutPath = FileUtils.isContent(savedUri.toString()) ? savedUri.toString() : savedUri.getPath();
                        CustomCameraView.this.mTextureView.setVisibility(0);
                        CustomCameraView.this.tvCurrentTime.setVisibility(8);
                        if (CustomCameraView.this.mTextureView.isAvailable()) {
                            CustomCameraView.this.startVideoPlay(outPutPath);
                        } else {
                            CustomCameraView.this.mTextureView.setSurfaceTextureListener(CustomCameraView.this.surfaceTextureListener);
                        }
                    }

                    public void onError(int videoCaptureError, @NonNull @NotNull String message, @Nullable @org.jetbrains.annotations.Nullable Throwable cause) {
                        if (CustomCameraView.this.mCameraListener != null) {
                            if (videoCaptureError == 6 || videoCaptureError == 2) {
                                this.recordShort(0L);
                            } else {
                                CustomCameraView.this.mCameraListener.onError(videoCaptureError, message, cause);
                            }
                        }
                    }
                });
            }

            @Override
            public void changeTime(long duration) {
                if (CustomCameraView.this.isDisplayRecordTime && CustomCameraView.this.tvCurrentTime.getVisibility() == 0) {
                    String format = String.format(Locale.getDefault(), "%02d:%02d", TimeUnit.MILLISECONDS.toMinutes(duration), TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration)));
                    if (!TextUtils.equals((CharSequence)format, (CharSequence)CustomCameraView.this.tvCurrentTime.getText())) {
                        CustomCameraView.this.tvCurrentTime.setText((CharSequence)format);
                    }
                    if (TextUtils.equals((CharSequence)"00:00", (CharSequence)CustomCameraView.this.tvCurrentTime.getText())) {
                        CustomCameraView.this.tvCurrentTime.setVisibility(8);
                    }
                }
            }

            @Override
            public void recordShort(long time) {
                CustomCameraView.this.recordTime = time;
                CustomCameraView.this.mSwitchCamera.setVisibility(0);
                CustomCameraView.this.mFlashLamp.setVisibility(0);
                CustomCameraView.this.tvCurrentTime.setVisibility(8);
                CustomCameraView.this.mCaptureLayout.resetCaptureLayout();
                CustomCameraView.this.mCaptureLayout.setTextWithAnimation(CustomCameraView.this.getContext().getString(R.string.picture_recording_time_is_short));
                try {
                    CustomCameraView.this.mVideoCapture.stopRecording();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void recordEnd(long time) {
                CustomCameraView.this.recordTime = time;
                try {
                    CustomCameraView.this.mVideoCapture.stopRecording();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void recordZoom(float zoom) {
            }

            @Override
            public void recordError() {
                if (CustomCameraView.this.mCameraListener != null) {
                    CustomCameraView.this.mCameraListener.onError(0, "An unknown error", null);
                }
            }
        });
        this.mCaptureLayout.setTypeListener(new TypeListener(){

            @Override
            public void cancel() {
                CustomCameraView.this.onCancelMedia();
            }

            @Override
            public void confirm() {
                String outputPath = SimpleCameraX.getOutputPath(CustomCameraView.this.activity.getIntent());
                if (CustomCameraView.this.isSaveExternal()) {
                    outputPath = CustomCameraView.this.isMergeExternalStorageState(CustomCameraView.this.activity, outputPath);
                } else if (CustomCameraView.this.isImageCaptureEnabled() && CustomCameraView.this.isReversedHorizontal()) {
                    File cameraFile = FileUtils.createCameraFile(CustomCameraView.this.getContext(), 1, CustomCameraView.this.outPutCameraFileName, CustomCameraView.this.imageFormat, CustomCameraView.this.outPutCameraDir);
                    if (FileUtils.copyPath((Context)CustomCameraView.this.activity, outputPath, cameraFile.getAbsolutePath())) {
                        outputPath = cameraFile.getAbsolutePath();
                        SimpleCameraX.putOutputUri(CustomCameraView.this.activity.getIntent(), Uri.fromFile((File)cameraFile));
                    }
                }
                if (CustomCameraView.this.isImageCaptureEnabled()) {
                    CustomCameraView.this.mImagePreview.setVisibility(4);
                    CustomCameraView.this.mImagePreviewBg.setAlpha(0.0f);
                    if (CustomCameraView.this.mCameraListener != null) {
                        CustomCameraView.this.mCameraListener.onPictureSuccess(outputPath);
                    }
                } else {
                    CustomCameraView.this.stopVideoPlay();
                    if (CustomCameraView.this.mCameraListener != null) {
                        CustomCameraView.this.mCameraListener.onRecordSuccess(outputPath);
                    }
                }
            }
        });
        this.mCaptureLayout.setLeftClickListener(new ClickListener(){

            @Override
            public void onClick() {
                if (CustomCameraView.this.mOnClickListener != null) {
                    CustomCameraView.this.mOnClickListener.onClick();
                }
            }
        });
    }

    private String isMergeExternalStorageState(Activity activity, String outputPath) {
        try {
            Uri externalSavedUri;
            ContentValues contentValues;
            File tempFile;
            if (this.isImageCaptureEnabled() && this.isReversedHorizontal() && FileUtils.copyPath((Context)activity, outputPath, (tempFile = FileUtils.createTempFile((Context)activity, false)).getAbsolutePath())) {
                outputPath = tempFile.getAbsolutePath();
            }
            if (this.isImageCaptureEnabled()) {
                contentValues = CameraUtils.buildImageContentValues(this.outPutCameraFileName, this.imageFormatForQ);
                externalSavedUri = this.getContext().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
            } else {
                contentValues = CameraUtils.buildVideoContentValues(this.outPutCameraFileName, this.videoFormatForQ);
                externalSavedUri = this.getContext().getContentResolver().insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, contentValues);
            }
            if (externalSavedUri == null) {
                return outputPath;
            }
            OutputStream outputStream = this.getContext().getContentResolver().openOutputStream(externalSavedUri);
            boolean isWriteFileSuccess = FileUtils.writeFileFromIS(new FileInputStream(outputPath), outputStream);
            if (isWriteFileSuccess) {
                FileUtils.deleteFile(this.getContext(), outputPath);
                SimpleCameraX.putOutputUri(activity.getIntent(), externalSavedUri);
                return externalSavedUri.toString();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return outputPath;
    }

    private boolean isSaveExternal() {
        return Build.VERSION.SDK_INT >= 29 && TextUtils.isEmpty((CharSequence)this.outPutCameraDir);
    }

    private boolean isReversedHorizontal() {
        return this.lensFacing == 0;
    }

    public void setCameraConfig(Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras == null) {
            return;
        }
        boolean isCameraAroundState = extras.getBoolean("com.luck.lib.camerax.CameraAroundState", false);
        this.buttonFeatures = extras.getInt("com.luck.lib.camerax.CameraMode", 0);
        this.lensFacing = isCameraAroundState ? 0 : 1;
        this.outPutCameraDir = extras.getString("com.luck.lib.camerax.OutputPathDir");
        this.outPutCameraFileName = extras.getString("com.luck.lib.camerax.CameraFileName");
        this.videoFrameRate = extras.getInt("com.luck.lib.camerax.VideoFrameRate");
        this.videoBitRate = extras.getInt("com.luck.lib.camerax.VideoBitRate");
        this.isManualFocus = extras.getBoolean("com.luck.lib.camerax.isManualFocus");
        this.isZoomPreview = extras.getBoolean("com.luck.lib.camerax.isZoomPreview");
        this.isAutoRotation = extras.getBoolean("com.luck.lib.camerax.isAutoRotation");
        int recordVideoMaxSecond = extras.getInt("com.luck.lib.camerax.RecordVideoMaxSecond", 60500);
        this.recordVideoMinSecond = extras.getInt("com.luck.lib.camerax.RecordVideoMinSecond", 1500);
        this.imageFormat = extras.getString("com.luck.lib.camerax.CameraImageFormat", ".jpeg");
        this.imageFormatForQ = extras.getString("com.luck.lib.camerax.CameraImageFormatForQ", "image/jpeg");
        this.videoFormat = extras.getString("com.luck.lib.camerax.CameraVideoFormat", ".mp4");
        this.videoFormatForQ = extras.getString("com.luck.lib.camerax.CameraVideoFormatForQ", "video/mp4");
        int captureLoadingColor = extras.getInt("com.luck.lib.camerax.CaptureLoadingColor", -8552961);
        this.isDisplayRecordTime = extras.getBoolean("com.luck.lib.camerax.DisplayRecordChangeTime", false);
        this.mCaptureLayout.setButtonFeatures(this.buttonFeatures);
        if (recordVideoMaxSecond > 0) {
            this.setRecordVideoMaxTime(recordVideoMaxSecond);
        }
        if (this.recordVideoMinSecond > 0) {
            this.setRecordVideoMinTime(this.recordVideoMinSecond);
        }
        String format = String.format(Locale.getDefault(), "%02d:%02d", TimeUnit.MILLISECONDS.toMinutes(recordVideoMaxSecond), TimeUnit.MILLISECONDS.toSeconds(recordVideoMaxSecond) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(recordVideoMaxSecond)));
        this.tvCurrentTime.setText((CharSequence)format);
        if (this.isAutoRotation && this.buttonFeatures != 2) {
            this.orientationEventListener = new CameraXOrientationEventListener(this.getContext(), this);
            this.startCheckOrientation();
        }
        this.setCaptureLoadingColor(captureLoadingColor);
        this.setProgressColor(captureLoadingColor);
        boolean isCheckSelfPermission = PermissionChecker.checkSelfPermission(this.getContext(), new String[]{"android.permission.CAMERA"});
        if (isCheckSelfPermission) {
            this.buildUseCameraCases();
        } else {
            if (CustomCameraConfig.explainListener != null && !SimpleXSpUtils.getBoolean(this.getContext(), "android.permission.CAMERA", false)) {
                CustomCameraConfig.explainListener.onPermissionDescription(this.getContext(), (ViewGroup)this, "android.permission.CAMERA");
            }
            PermissionChecker.getInstance().requestPermissions(this.activity, new String[]{"android.permission.CAMERA"}, new PermissionResultCallback(){

                @Override
                public void onGranted() {
                    CustomCameraView.this.buildUseCameraCases();
                    if (CustomCameraConfig.explainListener != null) {
                        CustomCameraConfig.explainListener.onDismiss((ViewGroup)CustomCameraView.this);
                    }
                }

                @Override
                public void onDenied() {
                    if (CustomCameraConfig.deniedListener != null) {
                        SimpleXSpUtils.putBoolean(CustomCameraView.this.getContext(), "android.permission.CAMERA", true);
                        CustomCameraConfig.deniedListener.onDenied(CustomCameraView.this.getContext(), "android.permission.CAMERA", 1102);
                        if (CustomCameraConfig.explainListener != null) {
                            CustomCameraConfig.explainListener.onDismiss((ViewGroup)CustomCameraView.this);
                        }
                    } else {
                        SimpleXPermissionUtil.goIntentSetting(CustomCameraView.this.activity, 1102);
                    }
                }
            });
        }
    }

    private void startCheckOrientation() {
        if (this.orientationEventListener != null) {
            this.orientationEventListener.star();
        }
    }

    public void stopCheckOrientation() {
        if (this.orientationEventListener != null) {
            this.orientationEventListener.stop();
        }
    }

    private int getTargetRotation() {
        return this.mImageCapture.getTargetRotation();
    }

    @Override
    public void onOrientationChanged(int orientation) {
        if (this.mImageCapture != null) {
            this.mImageCapture.setTargetRotation(orientation);
        }
        if (this.mImageAnalyzer != null) {
            this.mImageAnalyzer.setTargetRotation(orientation);
        }
    }

    public void buildUseCameraCases() {
        final ListenableFuture cameraProviderFuture = ProcessCameraProvider.getInstance((Context)this.getContext());
        cameraProviderFuture.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    CustomCameraView.this.mCameraProvider = (ProcessCameraProvider)cameraProviderFuture.get();
                    CustomCameraView.this.bindCameraUseCases();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, this.mainExecutor);
    }

    private void bindCameraUseCases() {
        if (null != this.mCameraProvider && this.isBackCameraLevel3Device(this.mCameraProvider)) {
            if (2 == this.buttonFeatures) {
                this.bindCameraVideoUseCases();
            } else {
                this.bindCameraImageUseCases();
            }
        } else {
            switch (this.buttonFeatures) {
                case 1: {
                    this.bindCameraImageUseCases();
                    break;
                }
                case 2: {
                    this.bindCameraVideoUseCases();
                    break;
                }
                default: {
                    this.bindCameraWithUserCases();
                }
            }
        }
    }

    @SuppressLint(value={"UnsafeOptInUsageError"})
    private boolean isBackCameraLevel3Device(ProcessCameraProvider cameraProvider) {
        List cameraInfos;
        if (Build.VERSION.SDK_INT >= 24 && !(cameraInfos = CameraSelector.DEFAULT_BACK_CAMERA.filter(cameraProvider.getAvailableCameraInfos())).isEmpty()) {
            return Objects.equals(Camera2CameraInfo.from((CameraInfo)((CameraInfo)cameraInfos.get(0))).getCameraCharacteristic(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL), 2);
        }
        return false;
    }

    private void bindCameraWithUserCases() {
        try {
            CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(this.lensFacing).build();
            Preview preview = new Preview.Builder().setTargetRotation(this.mCameraPreviewView.getDisplay().getRotation()).build();
            this.buildImageCapture();
            this.buildVideoCapture();
            UseCaseGroup.Builder useCase = new UseCaseGroup.Builder();
            useCase.addUseCase((UseCase)preview);
            useCase.addUseCase((UseCase)this.mImageCapture);
            useCase.addUseCase((UseCase)this.mVideoCapture);
            UseCaseGroup useCaseGroup = useCase.build();
            this.mCameraProvider.unbindAll();
            preview.setSurfaceProvider(this.mCameraPreviewView.getSurfaceProvider());
            Camera camera = this.mCameraProvider.bindToLifecycle((LifecycleOwner)this.getContext(), cameraSelector, useCaseGroup);
            this.setFlashMode();
            this.mCameraInfo = camera.getCameraInfo();
            this.mCameraControl = camera.getCameraControl();
            this.initCameraPreviewListener();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void bindCameraImageUseCases() {
        try {
            int screenAspectRatio = this.aspectRatio(DensityUtil.getScreenWidth(this.getContext()), DensityUtil.getScreenHeight(this.getContext()));
            int rotation = this.mCameraPreviewView.getDisplay().getRotation();
            CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(this.lensFacing).build();
            Preview preview = new Preview.Builder().setTargetAspectRatio(screenAspectRatio).setTargetRotation(rotation).build();
            this.buildImageCapture();
            this.mImageAnalyzer = new ImageAnalysis.Builder().setTargetAspectRatio(screenAspectRatio).setTargetRotation(rotation).build();
            this.mCameraProvider.unbindAll();
            preview.setSurfaceProvider(this.mCameraPreviewView.getSurfaceProvider());
            Camera camera = this.mCameraProvider.bindToLifecycle((LifecycleOwner)this.getContext(), cameraSelector, new UseCase[]{preview, this.mImageCapture, this.mImageAnalyzer});
            this.setFlashMode();
            this.mCameraInfo = camera.getCameraInfo();
            this.mCameraControl = camera.getCameraControl();
            this.initCameraPreviewListener();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void bindCameraVideoUseCases() {
        try {
            CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(this.lensFacing).build();
            Preview preview = new Preview.Builder().setTargetRotation(this.mCameraPreviewView.getDisplay().getRotation()).build();
            this.buildVideoCapture();
            this.mCameraProvider.unbindAll();
            preview.setSurfaceProvider(this.mCameraPreviewView.getSurfaceProvider());
            Camera camera = this.mCameraProvider.bindToLifecycle((LifecycleOwner)this.getContext(), cameraSelector, new UseCase[]{preview, this.mVideoCapture});
            this.mCameraInfo = camera.getCameraInfo();
            this.mCameraControl = camera.getCameraControl();
            this.initCameraPreviewListener();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildImageCapture() {
        int screenAspectRatio = this.aspectRatio(DensityUtil.getScreenWidth(this.getContext()), DensityUtil.getScreenHeight(this.getContext()));
        this.mImageCapture = new ImageCapture.Builder().setCaptureMode(1).setTargetAspectRatio(screenAspectRatio).setTargetRotation(this.mCameraPreviewView.getDisplay().getRotation()).build();
    }

    @SuppressLint(value={"RestrictedApi"})
    private void buildVideoCapture() {
        VideoCapture.Builder videoBuilder = new VideoCapture.Builder();
        videoBuilder.setTargetRotation(this.mCameraPreviewView.getDisplay().getRotation());
        if (this.videoFrameRate > 0) {
            videoBuilder.setVideoFrameRate(this.videoFrameRate);
        }
        if (this.videoBitRate > 0) {
            videoBuilder.setBitRate(this.videoBitRate);
        }
        this.mVideoCapture = videoBuilder.build();
    }

    private void initCameraPreviewListener() {
        final LiveData zoomState = this.mCameraInfo.getZoomState();
        CameraXPreviewViewTouchListener cameraXPreviewViewTouchListener = new CameraXPreviewViewTouchListener(this.getContext());
        cameraXPreviewViewTouchListener.setCustomTouchListener(new CameraXPreviewViewTouchListener.CustomTouchListener(){

            @Override
            public void zoom(float delta) {
                if (CustomCameraView.this.isZoomPreview && zoomState.getValue() != null) {
                    float currentZoomRatio = ((ZoomState)zoomState.getValue()).getZoomRatio();
                    CustomCameraView.this.mCameraControl.setZoomRatio(currentZoomRatio * delta);
                }
            }

            @Override
            public void click(float x, float y) {
                if (CustomCameraView.this.isManualFocus) {
                    MeteringPointFactory factory = CustomCameraView.this.mCameraPreviewView.getMeteringPointFactory();
                    MeteringPoint point = factory.createPoint(x, y);
                    FocusMeteringAction action = new FocusMeteringAction.Builder(point, 1).setAutoCancelDuration(3L, TimeUnit.SECONDS).build();
                    if (CustomCameraView.this.mCameraInfo.isFocusMeteringSupported(action)) {
                        CustomCameraView.this.mCameraControl.cancelFocusAndMetering();
                        CustomCameraView.this.focusImageView.setDisappear(false);
                        CustomCameraView.this.focusImageView.startFocus(new Point((int)x, (int)y));
                        final ListenableFuture future = CustomCameraView.this.mCameraControl.startFocusAndMetering(action);
                        future.addListener(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    FocusMeteringResult result = (FocusMeteringResult)future.get();
                                    CustomCameraView.this.focusImageView.setDisappear(true);
                                    if (result.isFocusSuccessful()) {
                                        CustomCameraView.this.focusImageView.onFocusSuccess();
                                    } else {
                                        CustomCameraView.this.focusImageView.onFocusFailed();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }, CustomCameraView.this.mainExecutor);
                    }
                }
            }

            @Override
            public void doubleClick(float x, float y) {
                if (CustomCameraView.this.isZoomPreview && zoomState.getValue() != null) {
                    float minZoomRatio;
                    float currentZoomRatio = ((ZoomState)zoomState.getValue()).getZoomRatio();
                    if (currentZoomRatio > (minZoomRatio = ((ZoomState)zoomState.getValue()).getMinZoomRatio())) {
                        CustomCameraView.this.mCameraControl.setLinearZoom(0.0f);
                    } else {
                        CustomCameraView.this.mCameraControl.setLinearZoom(0.5f);
                    }
                }
            }
        });
        this.mCameraPreviewView.setOnTouchListener((View.OnTouchListener)cameraXPreviewViewTouchListener);
    }

    private int aspectRatio(int width, int height) {
        double aspect = Math.max(width, height);
        double previewRatio = aspect / (double)Math.min(width, height);
        if (Math.abs(previewRatio - 1.3333333333333333) <= Math.abs(previewRatio - 1.7777777777777777)) {
            return 0;
        }
        return 1;
    }

    public void setCameraListener(CameraListener cameraListener) {
        this.mCameraListener = cameraListener;
    }

    public void setRecordVideoMaxTime(int maxDurationTime) {
        this.mCaptureLayout.setDuration(maxDurationTime);
    }

    public void setRecordVideoMinTime(int minDurationTime) {
        this.mCaptureLayout.setMinDuration(minDurationTime);
    }

    public void setCaptureLoadingColor(int color2) {
        this.mCaptureLayout.setCaptureLoadingColor(color2);
    }

    public void setProgressColor(int color2) {
        this.mCaptureLayout.setProgressColor(color2);
    }

    public void toggleCamera() {
        this.lensFacing = 0 == this.lensFacing ? 1 : 0;
        this.bindCameraUseCases();
    }

    private void setFlashMode() {
        if (this.mImageCapture == null) {
            return;
        }
        switch (this.typeFlash) {
            case 33: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_auto);
                this.mImageCapture.setFlashMode(0);
                break;
            }
            case 34: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_on);
                this.mImageCapture.setFlashMode(1);
                break;
            }
            case 35: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_off);
                this.mImageCapture.setFlashMode(2);
            }
        }
    }

    public void setOnCancelClickListener(ClickListener clickListener) {
        this.mOnClickListener = clickListener;
    }

    public void setImageCallbackListener(ImageCallbackListener mImageCallbackListener) {
        this.mImageCallbackListener = mImageCallbackListener;
    }

    private void resetState() {
        if (this.isImageCaptureEnabled()) {
            this.mImagePreview.setVisibility(4);
            this.mImagePreviewBg.setAlpha(0.0f);
        } else {
            try {
                this.mVideoCapture.stopRecording();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mSwitchCamera.setVisibility(0);
        this.mFlashLamp.setVisibility(0);
        this.mCaptureLayout.resetCaptureLayout();
    }

    private void startVideoPlay(String url) {
        try {
            if (this.mMediaPlayer == null) {
                this.mMediaPlayer = new MediaPlayer();
            } else {
                this.mMediaPlayer.reset();
            }
            if (FileUtils.isContent(url)) {
                this.mMediaPlayer.setDataSource(this.getContext(), Uri.parse((String)url));
            } else {
                this.mMediaPlayer.setDataSource(url);
            }
            this.mMediaPlayer.setSurface(new Surface(this.mTextureView.getSurfaceTexture()));
            this.mMediaPlayer.setVideoScalingMode(1);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setOnVideoSizeChangedListener(new MediaPlayer.OnVideoSizeChangedListener(){

                public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
                    CustomCameraView.this.updateVideoViewSize(CustomCameraView.this.mMediaPlayer.getVideoWidth(), CustomCameraView.this.mMediaPlayer.getVideoHeight());
                }
            });
            this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    CustomCameraView.this.mMediaPlayer.start();
                }
            });
            this.mMediaPlayer.setLooping(true);
            this.mMediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateVideoViewSize(float videoWidth, float videoHeight) {
        if (videoWidth > videoHeight) {
            int height = (int)(videoHeight / videoWidth * (float)this.getWidth());
            RelativeLayout.LayoutParams videoViewParam = new RelativeLayout.LayoutParams(-1, height);
            videoViewParam.addRule(13, -1);
            this.mTextureView.setLayoutParams((ViewGroup.LayoutParams)videoViewParam);
        }
    }

    public void onCancelMedia() {
        String outputPath = SimpleCameraX.getOutputPath(this.activity.getIntent());
        FileUtils.deleteFile(this.getContext(), outputPath);
        this.stopVideoPlay();
        this.resetState();
        this.startCheckOrientation();
    }

    private void stopVideoPlay() {
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        this.mTextureView.setVisibility(8);
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        this.buildUseCameraCases();
    }

    public void onDestroy() {
        this.displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this.displayListener);
        this.stopCheckOrientation();
        this.focusImageView.destroy();
    }

    private class DisplayListener
    implements DisplayManager.DisplayListener {
        private DisplayListener() {
        }

        public void onDisplayAdded(int displayId) {
        }

        public void onDisplayRemoved(int displayId) {
        }

        public void onDisplayChanged(int displayId) {
            if (displayId == CustomCameraView.this.displayId) {
                if (CustomCameraView.this.mImageCapture != null) {
                    CustomCameraView.this.mImageCapture.setTargetRotation(CustomCameraView.this.mCameraPreviewView.getDisplay().getRotation());
                }
                if (CustomCameraView.this.mImageAnalyzer != null) {
                    CustomCameraView.this.mImageAnalyzer.setTargetRotation(CustomCameraView.this.mCameraPreviewView.getDisplay().getRotation());
                }
            }
        }
    }

    private static class MyImageResultCallback
    implements ImageCapture.OnImageSavedCallback {
        private final WeakReference<ImageView> mImagePreviewReference;
        private final WeakReference<View> mImagePreviewBgReference;
        private final WeakReference<CaptureLayout> mCaptureLayoutReference;
        private final WeakReference<ImageCallbackListener> mImageCallbackListenerReference;
        private final WeakReference<CameraListener> mCameraListenerReference;
        private final WeakReference<CustomCameraView> mCameraViewLayoutReference;

        public MyImageResultCallback(CustomCameraView cameraView, ImageView imagePreview, View imagePreviewBg, CaptureLayout captureLayout, ImageCallbackListener imageCallbackListener, CameraListener cameraListener) {
            this.mCameraViewLayoutReference = new WeakReference<CustomCameraView>(cameraView);
            this.mImagePreviewReference = new WeakReference<ImageView>(imagePreview);
            this.mImagePreviewBgReference = new WeakReference<View>(imagePreviewBg);
            this.mCaptureLayoutReference = new WeakReference<CaptureLayout>(captureLayout);
            this.mImageCallbackListenerReference = new WeakReference<ImageCallbackListener>(imageCallbackListener);
            this.mCameraListenerReference = new WeakReference<CameraListener>(cameraListener);
        }

        public void onImageSaved(@NonNull ImageCapture.OutputFileResults outputFileResults) {
            Uri savedUri = outputFileResults.getSavedUri();
            if (savedUri != null) {
                CaptureLayout captureLayout;
                ImageView mImagePreview;
                CustomCameraView customCameraView = (CustomCameraView)this.mCameraViewLayoutReference.get();
                if (customCameraView != null) {
                    customCameraView.stopCheckOrientation();
                }
                if ((mImagePreview = (ImageView)this.mImagePreviewReference.get()) != null) {
                    ImageCallbackListener imageCallbackListener;
                    Context context = mImagePreview.getContext();
                    SimpleCameraX.putOutputUri(((Activity)context).getIntent(), savedUri);
                    mImagePreview.setVisibility(0);
                    if (customCameraView != null && customCameraView.isAutoRotation) {
                        int targetRotation = customCameraView.getTargetRotation();
                        if (targetRotation == 1 || targetRotation == 3) {
                            mImagePreview.setAdjustViewBounds(true);
                        } else {
                            mImagePreview.setAdjustViewBounds(false);
                            mImagePreview.setScaleType(ImageView.ScaleType.FIT_CENTER);
                        }
                        View mImagePreviewBackground = (View)this.mImagePreviewBgReference.get();
                        if (mImagePreviewBackground != null) {
                            mImagePreviewBackground.animate().alpha(1.0f).setDuration(220L).start();
                        }
                    }
                    if ((imageCallbackListener = (ImageCallbackListener)this.mImageCallbackListenerReference.get()) != null) {
                        String outPutCameraPath = FileUtils.isContent(savedUri.toString()) ? savedUri.toString() : savedUri.getPath();
                        imageCallbackListener.onLoadImage(outPutCameraPath, mImagePreview);
                    }
                }
                if ((captureLayout = (CaptureLayout)((Object)this.mCaptureLayoutReference.get())) != null) {
                    captureLayout.setButtonCaptureEnabled(true);
                    captureLayout.startTypeBtnAnimator();
                }
            }
        }

        public void onError(@NonNull ImageCaptureException exception) {
            if (this.mCaptureLayoutReference.get() != null) {
                ((CaptureLayout)((Object)this.mCaptureLayoutReference.get())).setButtonCaptureEnabled(true);
            }
            if (this.mCameraListenerReference.get() != null) {
                ((CameraListener)this.mCameraListenerReference.get()).onError(exception.getImageCaptureError(), exception.getMessage(), exception.getCause());
            }
        }
    }
}

