/*
 * Decompiled with CFR 0.152.
 */
package com.luck.lib.camerax;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.luck.lib.camerax.CustomCameraConfig;
import com.luck.lib.camerax.CustomCameraView;
import com.luck.lib.camerax.listener.CameraListener;
import com.luck.lib.camerax.listener.ClickListener;
import com.luck.lib.camerax.listener.IObtainCameraView;
import com.luck.lib.camerax.listener.ImageCallbackListener;
import com.luck.lib.camerax.permissions.PermissionChecker;
import com.luck.lib.camerax.permissions.PermissionResultCallback;
import com.luck.lib.camerax.utils.SimpleXSpUtils;

public class PictureCameraActivity
extends AppCompatActivity
implements IObtainCameraView {
    private PermissionResultCallback mPermissionResultCallback;
    private CustomCameraView mCameraView;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.getWindow().setFlags(1024, 1024);
        this.getWindow().setFlags(0x4000000, 0x4000000);
        this.getWindow().setFlags(0x8000000, 0x8000000);
        if (Build.VERSION.SDK_INT >= 28) {
            WindowManager.LayoutParams lp = this.getWindow().getAttributes();
            lp.layoutInDisplayCutoutMode = 1;
            this.getWindow().setAttributes(lp);
        }
        this.getWindow().addFlags(128);
        super.onCreate(savedInstanceState);
        this.mCameraView = new CustomCameraView((Context)this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        this.mCameraView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.setContentView((View)this.mCameraView);
        this.mCameraView.post(new Runnable(){

            @Override
            public void run() {
                PictureCameraActivity.this.mCameraView.setCameraConfig(PictureCameraActivity.this.getIntent());
            }
        });
        this.mCameraView.setImageCallbackListener(new ImageCallbackListener(){

            @Override
            public void onLoadImage(String url, ImageView imageView) {
                if (CustomCameraConfig.imageEngine != null) {
                    CustomCameraConfig.imageEngine.loadImage(imageView.getContext(), url, imageView);
                }
            }
        });
        this.mCameraView.setCameraListener(new CameraListener(){

            @Override
            public void onPictureSuccess(@NonNull String url) {
                PictureCameraActivity.this.handleCameraSuccess();
            }

            @Override
            public void onRecordSuccess(@NonNull String url) {
                PictureCameraActivity.this.handleCameraSuccess();
            }

            @Override
            public void onError(int videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
                Toast.makeText((Context)PictureCameraActivity.this.getApplicationContext(), (CharSequence)message, (int)1).show();
            }
        });
        this.mCameraView.setOnCancelClickListener(new ClickListener(){

            @Override
            public void onClick() {
                PictureCameraActivity.this.handleCameraCancel();
            }
        });
    }

    private void handleCameraSuccess() {
        Uri uri = (Uri)this.getIntent().getParcelableExtra("output");
        Intent intent = new Intent();
        intent.putExtra("output", (Parcelable)uri);
        this.setResult(-1, this.getIntent());
        this.onBackPressed();
    }

    private void handleCameraCancel() {
        this.setResult(0);
        this.onBackPressed();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.mCameraView.onCancelMedia();
        }
        return super.onKeyDown(keyCode, event);
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mCameraView.onConfigurationChanged(newConfig);
    }

    public void onBackPressed() {
        CustomCameraConfig.destroy();
        if (Build.VERSION.SDK_INT == 29) {
            this.finishAfterTransition();
        } else {
            super.onBackPressed();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (CustomCameraConfig.explainListener != null) {
            CustomCameraConfig.explainListener.onDismiss((ViewGroup)this.mCameraView);
        }
        if (requestCode == 1102) {
            if (PermissionChecker.checkSelfPermission((Context)this, new String[]{"android.permission.CAMERA"})) {
                this.mCameraView.buildUseCameraCases();
            } else {
                SimpleXSpUtils.putBoolean((Context)this, "android.permission.CAMERA", true);
                this.handleCameraCancel();
            }
        } else if (requestCode == 1103 && !PermissionChecker.checkSelfPermission((Context)this, new String[]{"android.permission.RECORD_AUDIO"})) {
            SimpleXSpUtils.putBoolean((Context)this, "android.permission.RECORD_AUDIO", true);
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Missing recording permission", (int)1).show();
        }
    }

    public void setPermissionsResultAction(PermissionResultCallback callback) {
        this.mPermissionResultCallback = callback;
    }

    protected void onDestroy() {
        this.mCameraView.onDestroy();
        super.onDestroy();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (this.mPermissionResultCallback != null) {
            PermissionChecker.getInstance().onRequestPermissionsResult(grantResults, this.mPermissionResultCallback);
            this.mPermissionResultCallback = null;
        }
    }

    @Override
    public ViewGroup getCustomCameraView() {
        return this.mCameraView;
    }
}

