/*
 * Decompiled with CFR 0.152.
 */
package com.luck.lib.camerax.listener;

import android.content.Context;
import android.view.OrientationEventListener;

public class CameraXOrientationEventListener
extends OrientationEventListener {
    private int mRotation = 0;
    private OnOrientationChangedListener changedListener;

    public CameraXOrientationEventListener(Context context, OnOrientationChangedListener listener) {
        super(context);
        this.changedListener = listener;
    }

    public void onOrientationChanged(int orientation) {
        if (orientation == -1) {
            return;
        }
        int currentRotation = orientation > 80 && orientation < 100 ? 3 : (orientation > 170 && orientation < 190 ? 2 : (orientation > 260 && orientation < 280 ? 1 : 0));
        if (this.mRotation != currentRotation) {
            this.mRotation = currentRotation;
            if (this.changedListener != null) {
                this.changedListener.onOrientationChanged(this.mRotation);
            }
        }
    }

    public void star() {
        this.enable();
    }

    public void stop() {
        this.disable();
    }

    public static interface OnOrientationChangedListener {
        public void onOrientationChanged(int var1);
    }
}

