/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import androidx.fragment.app.Fragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.base.BaseSelectorFragment;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnPermissionApplyListener;
import com.luck.picture.lib.interfaces.OnRequestPermissionListener;
import com.luck.picture.lib.permissions.OnPermissionResultListener;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.provider.TempDataProvider;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.SelectorLogUtils;
import com.luck.picture.lib.utils.ToastUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u001b\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u001a\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001b\u0010\u0017\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/luck/picture/lib/SelectorCameraFragment;", "Lcom/luck/picture/lib/base/BaseSelectorFragment;", "()V", "getFragmentTag", "", "getResourceId", "", "handlePermissionSettingResult", "", "permission", "", "([Ljava/lang/String;)V", "onMergeCameraResult", "media", "Lcom/luck/picture/lib/entity/LocalMedia;", "onResultCanceled", "requestCode", "resultCode", "onViewCreated", "view", "Landroid/view/View;", "savedInstanceState", "Landroid/os/Bundle;", "showCustomPermissionApply", "selector_release"})
public class SelectorCameraFragment
extends BaseSelectorFragment {
    @Override
    @NotNull
    public String getFragmentTag() {
        String string2 = SelectorCameraFragment.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SelectorCameraFragment::class.java.simpleName");
        return string2;
    }

    @Override
    public int getResourceId() {
        return R.layout.ps_empty;
    }

    @Override
    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState == null) {
            if (SdkVersionUtils.INSTANCE.isQ()) {
                this.openSelectedCamera();
            } else {
                String[] stringArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
                String[] permission = stringArray;
                PermissionChecker.INSTANCE.requestPermissions((Fragment)this, permission, new OnPermissionResultListener(this, permission){
                    final /* synthetic */ SelectorCameraFragment this$0;
                    final /* synthetic */ String[] $permission;
                    {
                        this.this$0 = $receiver;
                        this.$permission = $permission;
                    }

                    public void onGranted() {
                        this.this$0.showPermissionDescription(false, this.$permission);
                        this.this$0.openSelectedCamera();
                    }

                    public void onDenied() {
                        String[] stringArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
                        this.this$0.handlePermissionDenied(stringArray);
                    }
                });
            }
        }
    }

    @Override
    public void showCustomPermissionApply(@NotNull String[] permission) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            OnPermissionApplyListener onPermissionApplyListener = this.getConfig().getMListenerInfo().getOnPermissionApplyListener();
            if (onPermissionApplyListener == null) break block0;
            onPermissionApplyListener.requestPermission(this, permission, new OnRequestPermissionListener(this){
                final /* synthetic */ SelectorCameraFragment this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onCall(@NotNull String[] permission, boolean isResult) {
                    Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
                    if (isResult) {
                        this.this$0.showPermissionDescription(false, permission);
                        this.this$0.openSelectedCamera();
                    } else {
                        this.this$0.handlePermissionDenied(permission);
                    }
                }
            });
        }
    }

    @Override
    public void onResultCanceled(int requestCode, int resultCode) {
        if (resultCode == 0) {
            if (requestCode == 10003) {
                this.handlePermissionSettingResult(TempDataProvider.Companion.getInstance().getCurrentRequestPermission());
            } else {
                this.onBackPressed();
            }
        }
    }

    @Override
    public void onMergeCameraResult(@Nullable LocalMedia media) {
        if (media != null && this.confirmSelect(media, false) == 0) {
            this.handleSelectResult();
        } else {
            this.onBackPressed();
            SelectorLogUtils.INSTANCE.info("only camera analysisCameraData: Parsing LocalMedia object as empty");
        }
    }

    @Override
    public void handlePermissionSettingResult(@NotNull String[] permission) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        if (permission.length == 0) {
            return;
        }
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        Context context2 = context;
        this.showPermissionDescription(false, permission);
        boolean isHasPermissions = false;
        OnPermissionApplyListener onPermissionApplyListener = this.getConfig().getMListenerInfo().getOnPermissionApplyListener();
        if (onPermissionApplyListener != null) {
            isHasPermissions = onPermissionApplyListener.hasPermissions(this, permission);
        } else {
            stringArray = new String[]{"android.permission.CAMERA"};
            isHasPermissions = PermissionChecker.INSTANCE.checkSelfPermission(context2, stringArray);
            if (!SdkVersionUtils.INSTANCE.isQ()) {
                stringArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
                isHasPermissions = PermissionChecker.INSTANCE.checkSelfPermission(context2, stringArray);
            }
        }
        if (isHasPermissions) {
            this.openSelectedCamera();
        } else {
            stringArray = new String[]{"android.permission.CAMERA"};
            if (!PermissionChecker.INSTANCE.checkSelfPermission(context2, stringArray)) {
                String string2 = this.getString(R.string.ps_camera);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.ps_camera)");
                ToastUtils.INSTANCE.showMsg(context2, string2);
            } else {
                stringArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
                if (!PermissionChecker.INSTANCE.checkSelfPermission(context2, stringArray)) {
                    Context context3 = this.requireContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"requireContext()");
                    String string3 = this.getString(R.string.ps_jurisdiction);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(R.string.ps_jurisdiction)");
                    ToastUtils.INSTANCE.showMsg(context3, string3);
                }
            }
            this.onBackPressed();
        }
        TempDataProvider.Companion.getInstance().setCurrentRequestPermission(new String[0]);
    }
}

