/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.SystemClock;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.luck.picture.lib.R;
import com.luck.picture.lib.SelectorPreviewFragment;
import com.luck.picture.lib.adapter.MediaListAdapter;
import com.luck.picture.lib.adapter.base.BaseMediaListAdapter;
import com.luck.picture.lib.base.BaseSelectorFragment;
import com.luck.picture.lib.config.LayoutSource;
import com.luck.picture.lib.config.MediaType;
import com.luck.picture.lib.config.SelectionMode;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.dialog.AlbumListPopWindow;
import com.luck.picture.lib.engine.ImageEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaAlbum;
import com.luck.picture.lib.entity.PreviewDataWrap;
import com.luck.picture.lib.factory.ClassFactory;
import com.luck.picture.lib.helper.FragmentInjectManager;
import com.luck.picture.lib.interfaces.OnItemClickListener;
import com.luck.picture.lib.interfaces.OnMediaItemClickListener;
import com.luck.picture.lib.interfaces.OnPermissionApplyListener;
import com.luck.picture.lib.interfaces.OnRecyclerViewPreloadMoreListener;
import com.luck.picture.lib.interfaces.OnRecyclerViewScrollListener;
import com.luck.picture.lib.interfaces.OnRecyclerViewScrollStateListener;
import com.luck.picture.lib.interfaces.OnRequestPermissionListener;
import com.luck.picture.lib.magical.RecycleItemViewParams;
import com.luck.picture.lib.permissions.OnPermissionResultListener;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.provider.TempDataProvider;
import com.luck.picture.lib.registry.Registry;
import com.luck.picture.lib.utils.AnimUtils;
import com.luck.picture.lib.utils.DateUtils;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.DoubleUtils;
import com.luck.picture.lib.utils.FileUtils;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.SelectorLogUtils;
import com.luck.picture.lib.utils.ToastUtils;
import com.luck.picture.lib.viewmodel.SelectorViewModel;
import com.luck.picture.lib.widget.GridSpacingItemDecoration;
import com.luck.picture.lib.widget.RecyclerPreloadView;
import com.luck.picture.lib.widget.SlideSelectTouchListener;
import com.luck.picture.lib.widget.SlideSelectionHandler;
import com.luck.picture.lib.widget.StyleTextView;
import com.luck.picture.lib.widget.WrapContentGridLayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010S\u001a\u00020\b2\u0006\u0010T\u001a\u00020\bH\u0016J\b\u0010U\u001a\u00020VH\u0016J\b\u0010W\u001a\u00020\u0010H\u0016J\b\u0010X\u001a\u00020\nH\u0016J\u0016\u0010Y\u001a\u00020V2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\\0[H\u0016J\b\u0010]\u001a\u00020^H\u0016J\b\u0010_\u001a\u00020`H\u0016J\b\u0010a\u001a\u00020bH\u0016J\u001b\u0010c\u001a\u00020V2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020`0eH\u0016\u00a2\u0006\u0002\u0010fJ\b\u0010g\u001a\u00020VH\u0016J\b\u0010h\u001a\u00020VH\u0016J\b\u0010i\u001a\u00020VH\u0016J\b\u0010j\u001a\u00020VH\u0016J\u0010\u0010k\u001a\u00020V2\u0006\u0010l\u001a\u00020'H\u0016J\b\u0010m\u001a\u00020VH\u0016J\u0010\u0010n\u001a\u00020V2\u0006\u0010o\u001a\u00020-H\u0016J\b\u0010p\u001a\u00020VH\u0016J\b\u0010q\u001a\u00020\bH\u0016J\b\u0010r\u001a\u00020\bH\u0016J\b\u0010s\u001a\u00020\bH\u0016J\u0018\u0010t\u001a\b\u0012\u0004\u0012\u0002Hv0u\"\b\b\u0000\u0010v*\u00020wH\u0016J\u0018\u0010x\u001a\u00020V2\u0006\u0010y\u001a\u00020b2\u0006\u0010z\u001a\u00020^H\u0016J\u0016\u0010{\u001a\u00020V2\f\u0010|\u001a\b\u0012\u0004\u0012\u00020^0[H\u0016J\u0010\u0010}\u001a\u00020V2\u0006\u0010~\u001a\u00020-H\u0016J\u0011\u0010\u007f\u001a\u00020V2\u0007\u0010\u0080\u0001\u001a\u00020\\H\u0016J\u0011\u0010\u0081\u0001\u001a\u00020V2\u0006\u0010~\u001a\u00020-H\u0016J\t\u0010\u0082\u0001\u001a\u00020VH\u0016J\u0017\u0010\u0083\u0001\u001a\u00020V2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\\0[H\u0016J\u0012\u0010\u0084\u0001\u001a\u00020V2\u0007\u0010\u0080\u0001\u001a\u00020\\H\u0016J\u0012\u0010\u0085\u0001\u001a\u00020V2\u0007\u0010\u0080\u0001\u001a\u00020\\H\u0016J\u0014\u0010\u0086\u0001\u001a\u00020V2\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010\\H\u0016J\t\u0010\u0087\u0001\u001a\u00020VH\u0016J\u0012\u0010\u0088\u0001\u001a\u00020V2\u0007\u0010\u0089\u0001\u001a\u00020\bH\u0016J\u0011\u0010\u008a\u0001\u001a\u00020V2\u0006\u0010~\u001a\u00020-H\u0016J\t\u0010\u008b\u0001\u001a\u00020VH\u0016J\u0012\u0010\u008c\u0001\u001a\u00020V2\u0007\u0010\u008d\u0001\u001a\u00020\bH\u0016J\u0013\u0010\u008e\u0001\u001a\u00020V2\b\u0010\u008f\u0001\u001a\u00030\u0090\u0001H\u0016J\u0014\u0010\u0091\u0001\u001a\u00020V2\t\u0010\u0092\u0001\u001a\u0004\u0018\u00010\\H\u0016J\t\u0010\u0093\u0001\u001a\u00020VH\u0016J)\u0010\u0094\u0001\u001a\u00020V2\u0006\u0010y\u001a\u00020b2\u0007\u0010\u0095\u0001\u001a\u00020\b2\r\u0010\u0096\u0001\u001a\b\u0012\u0004\u0012\u00020\\0[H\u0016J\u0011\u0010\u0097\u0001\u001a\u00020V2\u0006\u0010~\u001a\u00020-H\u0016J\u001d\u0010\u0098\u0001\u001a\u00020V2\u0006\u0010o\u001a\u00020-2\n\u0010\u0099\u0001\u001a\u0005\u0018\u00010\u0090\u0001H\u0016J3\u0010\u009a\u0001\u001a\u00030\u009b\u00012\u0007\u0010\u009c\u0001\u001a\u00020b2\u0006\u0010y\u001a\u00020b2\u0007\u0010\u0095\u0001\u001a\u00020\b2\r\u0010\u0096\u0001\u001a\b\u0012\u0004\u0012\u00020\\0[H\u0016J\t\u0010\u009d\u0001\u001a\u00020VH\u0003J\t\u0010\u009e\u0001\u001a\u00020VH\u0016J\t\u0010\u009f\u0001\u001a\u00020VH\u0016J\u0012\u0010\u00a0\u0001\u001a\u00020V2\u0007\u0010\u00a1\u0001\u001a\u00020^H\u0002J\t\u0010\u00a2\u0001\u001a\u00020VH\u0016J\t\u0010\u00a3\u0001\u001a\u00020VH\u0016J\u0014\u0010\u00a4\u0001\u001a\u00020V2\t\u0010\u00a5\u0001\u001a\u0004\u0018\u00010`H\u0016J\t\u0010\u00a6\u0001\u001a\u00020VH\u0016J\u0014\u0010\u00a7\u0001\u001a\u00020V2\t\u0010\u00a8\u0001\u001a\u0004\u0018\u00010-H\u0016J\t\u0010\u00a9\u0001\u001a\u00020VH\u0016J\u001c\u0010\u00aa\u0001\u001a\u00020V2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020`0eH\u0016\u00a2\u0006\u0002\u0010fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R\u001a\u0010&\u001a\u00020'X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001c\u00102\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0018\"\u0004\b4\u0010\u001aR\u001c\u00105\u001a\u0004\u0018\u000106X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001c\u0010;\u001a\u0004\u0018\u00010<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001c\u0010A\u001a\u0004\u0018\u000106X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u00108\"\u0004\bC\u0010:R\u001c\u0010D\u001a\u0004\u0018\u000106X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u00108\"\u0004\bF\u0010:R\u001c\u0010G\u001a\u0004\u0018\u000106X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u00108\"\u0004\bI\u0010:R\u001c\u0010J\u001a\u0004\u0018\u00010<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010>\"\u0004\bL\u0010@R\u001c\u0010M\u001a\u0004\u0018\u000106X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u00108\"\u0004\bO\u0010:R\u001c\u0010P\u001a\u0004\u0018\u000106X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u00108\"\u0004\bR\u0010:\u00a8\u0006\u00ab\u0001"}, d2={"Lcom/luck/picture/lib/SelectorMainFragment;", "Lcom/luck/picture/lib/base/BaseSelectorFragment;", "()V", "anyLock", "", "intervalClickTime", "", "isCameraCallback", "", "mAdapter", "Lcom/luck/picture/lib/adapter/base/BaseMediaListAdapter;", "getMAdapter", "()Lcom/luck/picture/lib/adapter/base/BaseMediaListAdapter;", "setMAdapter", "(Lcom/luck/picture/lib/adapter/base/BaseMediaListAdapter;)V", "mAlbumWindow", "Lcom/luck/picture/lib/dialog/AlbumListPopWindow;", "getMAlbumWindow", "()Lcom/luck/picture/lib/dialog/AlbumListPopWindow;", "setMAlbumWindow", "(Lcom/luck/picture/lib/dialog/AlbumListPopWindow;)V", "mBottomNarBar", "Landroid/view/ViewGroup;", "getMBottomNarBar", "()Landroid/view/ViewGroup;", "setMBottomNarBar", "(Landroid/view/ViewGroup;)V", "mDragSelectTouchListener", "Lcom/luck/picture/lib/widget/SlideSelectTouchListener;", "mIvLeftBack", "Landroid/widget/ImageView;", "getMIvLeftBack", "()Landroid/widget/ImageView;", "setMIvLeftBack", "(Landroid/widget/ImageView;)V", "mIvTitleArrow", "getMIvTitleArrow", "setMIvTitleArrow", "mRecycler", "Lcom/luck/picture/lib/widget/RecyclerPreloadView;", "getMRecycler", "()Lcom/luck/picture/lib/widget/RecyclerPreloadView;", "setMRecycler", "(Lcom/luck/picture/lib/widget/RecyclerPreloadView;)V", "mStatusBar", "Landroid/view/View;", "getMStatusBar", "()Landroid/view/View;", "setMStatusBar", "(Landroid/view/View;)V", "mTitleBar", "getMTitleBar", "setMTitleBar", "mTvCancel", "Landroid/widget/TextView;", "getMTvCancel", "()Landroid/widget/TextView;", "setMTvCancel", "(Landroid/widget/TextView;)V", "mTvComplete", "Lcom/luck/picture/lib/widget/StyleTextView;", "getMTvComplete", "()Lcom/luck/picture/lib/widget/StyleTextView;", "setMTvComplete", "(Lcom/luck/picture/lib/widget/StyleTextView;)V", "mTvCurrentDataTime", "getMTvCurrentDataTime", "setMTvCurrentDataTime", "mTvDataEmpty", "getMTvDataEmpty", "setMTvDataEmpty", "mTvOriginal", "getMTvOriginal", "setMTvOriginal", "mTvPreview", "getMTvPreview", "setMTvPreview", "mTvSelectNum", "getMTvSelectNum", "setMTvSelectNum", "mTvTitle", "getMTvTitle", "setMTvTitle", "checkNotifyStrategy", "isAddRemove", "checkPermissions", "", "createAlbumWindow", "createMediaAdapter", "duplicateMediaSource", "result", "", "Lcom/luck/picture/lib/entity/LocalMedia;", "getCurrentAlbum", "Lcom/luck/picture/lib/entity/LocalMediaAlbum;", "getFragmentTag", "", "getResourceId", "", "handlePermissionSettingResult", "permission", "", "([Ljava/lang/String;)V", "hideCurrentMediaCreateTimeUI", "initAlbumWindow", "initMediaAdapter", "initNavbarBar", "initRecyclerConfig", "recycler", "initTitleBar", "initViews", "view", "initWidgets", "isDisplayCamera", "isLoadMoreThreshold", "isNeedRestore", "newPreviewInstance", "Ljava/lang/Class;", "F", "Lcom/luck/picture/lib/SelectorPreviewFragment;", "onAlbumItemClick", "position", "data", "onAlbumSourceChange", "albumList", "onBackClick", "v", "onCheckDuplicateMedia", "media", "onCompleteClick", "onDestroy", "onMediaSourceChange", "onMergeCameraAlbum", "onMergeCameraMedia", "onMergeCameraResult", "onMergeSelectedSource", "onOriginalChange", "isOriginal", "onOriginalClick", "onPreloadFakeData", "onRotateArrowAnim", "showing", "onSaveInstanceState", "outState", "Landroid/os/Bundle;", "onSelectionResultChange", "change", "onShowAlbumWindowAsDropDown", "onStartPreview", "isBottomPreview", "source", "onTitleBarClick", "onViewCreated", "savedInstanceState", "onWrapPreviewData", "Lcom/luck/picture/lib/entity/PreviewDataWrap;", "page", "registerLiveData", "requestData", "restoreMemoryData", "setCurrentAlbum", "album", "setCurrentMediaCreateTimeText", "setDataEmpty", "setDefaultAlbumTitle", "title", "setFastSlidingSelect", "setStatusBarRectSize", "statusBarRectView", "showCurrentMediaCreateTimeUI", "showCustomPermissionApply", "selector_release"})
public class SelectorMainFragment
extends BaseSelectorFragment {
    public RecyclerPreloadView mRecycler;
    @Nullable
    private TextView mTvDataEmpty;
    @Nullable
    private View mStatusBar;
    @Nullable
    private ViewGroup mTitleBar;
    @Nullable
    private ImageView mIvLeftBack;
    @Nullable
    private TextView mTvTitle;
    @Nullable
    private ImageView mIvTitleArrow;
    @Nullable
    private TextView mTvCancel;
    @Nullable
    private TextView mTvCurrentDataTime;
    @Nullable
    private ViewGroup mBottomNarBar;
    @Nullable
    private StyleTextView mTvPreview;
    @Nullable
    private TextView mTvOriginal;
    @Nullable
    private StyleTextView mTvComplete;
    @Nullable
    private TextView mTvSelectNum;
    @NotNull
    private final Object anyLock = new Object();
    private boolean isCameraCallback;
    public AlbumListPopWindow mAlbumWindow;
    public BaseMediaListAdapter mAdapter;
    private long intervalClickTime;
    @Nullable
    private SlideSelectTouchListener mDragSelectTouchListener;

    @Override
    @NotNull
    public String getFragmentTag() {
        String string2 = SelectorMainFragment.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SelectorMainFragment::class.java.simpleName");
        return string2;
    }

    @Override
    public int getResourceId() {
        Integer n = this.getConfig().getLayoutSource().get((Object)LayoutSource.SELECTOR_MAIN);
        return n == null ? R.layout.ps_fragment_selector : n;
    }

    @NotNull
    public final RecyclerPreloadView getMRecycler() {
        RecyclerPreloadView recyclerPreloadView = this.mRecycler;
        if (recyclerPreloadView != null) {
            return recyclerPreloadView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mRecycler");
        return null;
    }

    public final void setMRecycler(@NotNull RecyclerPreloadView recyclerPreloadView) {
        Intrinsics.checkNotNullParameter((Object)((Object)recyclerPreloadView), (String)"<set-?>");
        this.mRecycler = recyclerPreloadView;
    }

    @Nullable
    public final TextView getMTvDataEmpty() {
        return this.mTvDataEmpty;
    }

    public final void setMTvDataEmpty(@Nullable TextView textView) {
        this.mTvDataEmpty = textView;
    }

    @Nullable
    public final View getMStatusBar() {
        return this.mStatusBar;
    }

    public final void setMStatusBar(@Nullable View view) {
        this.mStatusBar = view;
    }

    @Nullable
    public final ViewGroup getMTitleBar() {
        return this.mTitleBar;
    }

    public final void setMTitleBar(@Nullable ViewGroup viewGroup) {
        this.mTitleBar = viewGroup;
    }

    @Nullable
    public final ImageView getMIvLeftBack() {
        return this.mIvLeftBack;
    }

    public final void setMIvLeftBack(@Nullable ImageView imageView) {
        this.mIvLeftBack = imageView;
    }

    @Nullable
    public final TextView getMTvTitle() {
        return this.mTvTitle;
    }

    public final void setMTvTitle(@Nullable TextView textView) {
        this.mTvTitle = textView;
    }

    @Nullable
    public final ImageView getMIvTitleArrow() {
        return this.mIvTitleArrow;
    }

    public final void setMIvTitleArrow(@Nullable ImageView imageView) {
        this.mIvTitleArrow = imageView;
    }

    @Nullable
    public final TextView getMTvCancel() {
        return this.mTvCancel;
    }

    public final void setMTvCancel(@Nullable TextView textView) {
        this.mTvCancel = textView;
    }

    @Nullable
    public final TextView getMTvCurrentDataTime() {
        return this.mTvCurrentDataTime;
    }

    public final void setMTvCurrentDataTime(@Nullable TextView textView) {
        this.mTvCurrentDataTime = textView;
    }

    @Nullable
    public final ViewGroup getMBottomNarBar() {
        return this.mBottomNarBar;
    }

    public final void setMBottomNarBar(@Nullable ViewGroup viewGroup) {
        this.mBottomNarBar = viewGroup;
    }

    @Nullable
    public final StyleTextView getMTvPreview() {
        return this.mTvPreview;
    }

    public final void setMTvPreview(@Nullable StyleTextView styleTextView) {
        this.mTvPreview = styleTextView;
    }

    @Nullable
    public final TextView getMTvOriginal() {
        return this.mTvOriginal;
    }

    public final void setMTvOriginal(@Nullable TextView textView) {
        this.mTvOriginal = textView;
    }

    @Nullable
    public final StyleTextView getMTvComplete() {
        return this.mTvComplete;
    }

    public final void setMTvComplete(@Nullable StyleTextView styleTextView) {
        this.mTvComplete = styleTextView;
    }

    @Nullable
    public final TextView getMTvSelectNum() {
        return this.mTvSelectNum;
    }

    public final void setMTvSelectNum(@Nullable TextView textView) {
        this.mTvSelectNum = textView;
    }

    @NotNull
    public final AlbumListPopWindow getMAlbumWindow() {
        AlbumListPopWindow albumListPopWindow = this.mAlbumWindow;
        if (albumListPopWindow != null) {
            return albumListPopWindow;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mAlbumWindow");
        return null;
    }

    public final void setMAlbumWindow(@NotNull AlbumListPopWindow albumListPopWindow) {
        Intrinsics.checkNotNullParameter((Object)((Object)albumListPopWindow), (String)"<set-?>");
        this.mAlbumWindow = albumListPopWindow;
    }

    @NotNull
    public final BaseMediaListAdapter getMAdapter() {
        BaseMediaListAdapter baseMediaListAdapter = this.mAdapter;
        if (baseMediaListAdapter != null) {
            return baseMediaListAdapter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mAdapter");
        return null;
    }

    public final void setMAdapter(@NotNull BaseMediaListAdapter baseMediaListAdapter) {
        Intrinsics.checkNotNullParameter((Object)((Object)baseMediaListAdapter), (String)"<set-?>");
        this.mAdapter = baseMediaListAdapter;
    }

    @NotNull
    public LocalMediaAlbum getCurrentAlbum() {
        return TempDataProvider.Companion.getInstance().getCurrentMediaAlbum();
    }

    private final void setCurrentAlbum(LocalMediaAlbum album) {
        TempDataProvider.Companion.getInstance().setCurrentMediaAlbum(album);
    }

    @Override
    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.initViews(view);
        this.onMergeSelectedSource();
        this.initAlbumWindow();
        this.initTitleBar();
        this.initNavbarBar();
        this.initMediaAdapter();
        this.checkPermissions();
        this.registerLiveData();
        this.initWidgets();
    }

    public void initViews(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        View view2 = view.findViewById(R.id.ps_recycler);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view.findViewById(R.id.ps_recycler)");
        this.setMRecycler((RecyclerPreloadView)view2);
        this.mTvDataEmpty = (TextView)view.findViewById(R.id.ps_tv_data_empty);
        this.mTvCurrentDataTime = (TextView)view.findViewById(R.id.ps_tv_current_data_time);
        this.setDataEmpty();
        this.mStatusBar = view.findViewById(R.id.ps_status_bar);
        this.mTitleBar = (ViewGroup)view.findViewById(R.id.ps_title_bar);
        this.mIvLeftBack = (ImageView)view.findViewById(R.id.ps_iv_left_back);
        this.mTvTitle = (TextView)view.findViewById(R.id.ps_tv_title);
        this.mIvTitleArrow = (ImageView)view.findViewById(R.id.ps_iv_arrow);
        this.mTvCancel = (TextView)view.findViewById(R.id.ps_tv_cancel);
        this.setStatusBarRectSize(this.mStatusBar);
        this.mBottomNarBar = (ViewGroup)view.findViewById(R.id.ps_bottom_nar_bar);
        this.mTvPreview = (StyleTextView)view.findViewById(R.id.ps_tv_preview);
        this.mTvOriginal = (TextView)view.findViewById(R.id.ps_tv_original);
        this.mTvComplete = (StyleTextView)view.findViewById(R.id.ps_tv_complete);
        this.mTvSelectNum = (TextView)view.findViewById(R.id.ps_tv_select_num);
    }

    public void initWidgets() {
    }

    @Override
    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        TempDataProvider.Companion.getInstance().setAlbumSource(this.getMAlbumWindow().getAlbumList());
        TempDataProvider.Companion.getInstance().setMediaSource(CollectionsKt.toMutableList((Collection)this.getMAdapter().getData()));
    }

    public void setDataEmpty() {
        TextView textView = this.mTvDataEmpty;
        if (textView != null) {
            textView.setText(this.getConfig().getMediaType() == MediaType.AUDIO ? (CharSequence)this.getString(R.string.ps_audio_empty) : (CharSequence)this.getString(R.string.ps_empty));
        }
    }

    public void onMergeSelectedSource() {
        if (!((Collection)this.getConfig().getSelectedSource()).isEmpty()) {
            this.getSelectResult().addAll(CollectionsKt.toMutableList((Collection)this.getConfig().getSelectedSource()));
            this.getConfig().getSelectedSource().clear();
        }
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    private final void registerLiveData() {
        this.getGlobalViewMode().getEditorLiveData().observe(this.getViewLifecycleOwner(), arg_0 -> SelectorMainFragment.registerLiveData$lambda-0(this, arg_0));
        this.getGlobalViewMode().getOriginalLiveData().observe(this.getViewLifecycleOwner(), arg_0 -> SelectorMainFragment.registerLiveData$lambda-1(this, arg_0));
        this.getGlobalViewMode().getSelectResultLiveData().observe(this.getViewLifecycleOwner(), arg_0 -> SelectorMainFragment.registerLiveData$lambda-3(this, arg_0));
        this.getViewModel().getAlbumLiveData().observe(this.getViewLifecycleOwner(), arg_0 -> SelectorMainFragment.registerLiveData$lambda-4(this, arg_0));
        this.getViewModel().getMediaLiveData().observe(this.getViewLifecycleOwner(), arg_0 -> SelectorMainFragment.registerLiveData$lambda-5(this, arg_0));
    }

    public void initTitleBar() {
        block4: {
            this.setDefaultAlbumTitle(this.getCurrentAlbum().getBucketDisplayName());
            ImageView imageView = this.mIvLeftBack;
            if (imageView != null) {
                imageView.setOnClickListener(arg_0 -> SelectorMainFragment.initTitleBar$lambda-6(this, arg_0));
            }
            TextView textView = this.mTvCancel;
            if (textView != null) {
                textView.setOnClickListener(arg_0 -> SelectorMainFragment.initTitleBar$lambda-7(this, arg_0));
            }
            TextView textView2 = this.mTvTitle;
            if (textView2 != null) {
                textView2.setOnClickListener(arg_0 -> SelectorMainFragment.initTitleBar$lambda-8(this, arg_0));
            }
            ImageView imageView2 = this.mIvTitleArrow;
            if (imageView2 != null) {
                imageView2.setOnClickListener(arg_0 -> SelectorMainFragment.initTitleBar$lambda-9(this, arg_0));
            }
            ViewGroup viewGroup = this.mTitleBar;
            if (viewGroup == null) break block4;
            viewGroup.setOnClickListener(arg_0 -> SelectorMainFragment.initTitleBar$lambda-10(this, arg_0));
        }
    }

    public void onBackClick(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.onBackPressed();
    }

    public void onShowAlbumWindowAsDropDown() {
        block1: {
            if (!(!((Collection)this.getMAlbumWindow().getAlbumList()).isEmpty()) || this.getConfig().isOnlySandboxDir()) break block1;
            ViewGroup viewGroup = this.mTitleBar;
            if (viewGroup != null) {
                ViewGroup it = viewGroup;
                boolean bl = false;
                this.getMAlbumWindow().showAsDropDown((View)it);
            }
        }
    }

    public void onTitleBarClick(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (SystemClock.uptimeMillis() - this.intervalClickTime < 500L && !((Collection)this.getMAdapter().getData()).isEmpty()) {
            if (this.getMAdapter().getData().size() > 2 * this.getConfig().getPageSize()) {
                this.getMRecycler().scrollToPosition(this.getConfig().getPageSize());
                this.getMRecycler().post(() -> SelectorMainFragment.onTitleBarClick$lambda-12(this));
            } else {
                this.getMRecycler().smoothScrollToPosition(0);
            }
        } else {
            this.intervalClickTime = SystemClock.uptimeMillis();
        }
    }

    public void onOriginalClick(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.getGlobalViewMode().setOriginalLiveData(!v.isSelected());
    }

    public void onOriginalChange(boolean isOriginal) {
        TextView textView = this.mTvOriginal;
        if (textView != null) {
            textView.setSelected(isOriginal);
        }
    }

    public void onCompleteClick(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.handleSelectResult();
    }

    public void setStatusBarRectSize(@Nullable View statusBarRectView) {
        if (this.getConfig().isPreviewFullScreenMode()) {
            View view = statusBarRectView;
            if ((view != null ? view.getLayoutParams() : null) != null) {
                Context context = this.requireContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                ((ViewGroup.LayoutParams)(view != null ? view.getLayoutParams() : null)).height = DensityUtil.INSTANCE.getStatusBarHeight(context);
            }
            View view2 = statusBarRectView;
            if (view2 != null) {
                view2.setVisibility(0);
            }
        } else {
            View view = statusBarRectView;
            if ((view != null ? view.getLayoutParams() : null) != null) {
                ((ViewGroup.LayoutParams)(view != null ? view.getLayoutParams() : null)).height = 0;
            }
            View view3 = statusBarRectView;
            if (view3 != null) {
                view3.setVisibility(8);
            }
        }
    }

    public void setCurrentMediaCreateTimeText() {
        List<LocalMedia> data;
        int position;
        if (this.getConfig().isDisplayTimeAxis() && (position = this.getMRecycler().getFirstVisiblePosition()) != -1 && (data = this.getMAdapter().getData()).size() > position && data.get(position).getDateAdded() > 0L) {
            TextView textView = this.mTvCurrentDataTime;
            if (textView != null) {
                Context context = this.requireContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                textView.setText((CharSequence)DateUtils.INSTANCE.getDataFormat(context, data.get(position).getDateAdded()));
            }
        }
    }

    public void showCurrentMediaCreateTimeUI() {
        block1: {
            TextView textView;
            if (!this.getConfig().isDisplayTimeAxis() || this.getMAdapter().getData().size() <= 0) break block1;
            TextView textView2 = this.mTvCurrentDataTime;
            if (Intrinsics.areEqual((Float)(textView2 != null ? Float.valueOf(textView2.getAlpha()) : null), (float)0.0f) && (textView = this.mTvCurrentDataTime) != null && (textView = textView.animate()) != null && (textView = textView.setDuration(150L)) != null && (textView = textView.alphaBy(1.0f)) != null) {
                textView.start();
            }
        }
    }

    public void hideCurrentMediaCreateTimeUI() {
        block0: {
            TextView textView;
            if (!this.getConfig().isDisplayTimeAxis() || this.getMAdapter().getData().size() <= 0 || (textView = this.mTvCurrentDataTime) == null || (textView = textView.animate()) == null || (textView = textView.setDuration(250L)) == null || (textView = textView.alpha(0.0f)) == null) break block0;
            textView.start();
        }
    }

    @NotNull
    public AlbumListPopWindow createAlbumWindow() {
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        return new AlbumListPopWindow(context);
    }

    public void initAlbumWindow() {
        this.setMAlbumWindow(this.createAlbumWindow());
        this.getMAlbumWindow().setOnItemClickListener(new OnItemClickListener<LocalMediaAlbum>(this){
            final /* synthetic */ SelectorMainFragment this$0;
            {
                this.this$0 = $receiver;
            }

            public void onItemClick(int position, @NotNull LocalMediaAlbum data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.this$0.onAlbumItemClick(position, data);
            }
        });
        this.getMAlbumWindow().setOnWindowStatusListener(new AlbumListPopWindow.OnWindowStatusListener(this){
            final /* synthetic */ SelectorMainFragment this$0;
            {
                this.this$0 = $receiver;
            }

            public void onShowing(boolean isShowing) {
                this.this$0.onRotateArrowAnim(isShowing);
            }
        });
    }

    public void onAlbumItemClick(int position, @NotNull LocalMediaAlbum data) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.getMAlbumWindow().dismiss();
            LocalMediaAlbum oldCurrentAlbum = this.getCurrentAlbum();
            if (data.isEqualAlbum(oldCurrentAlbum.getBucketId())) {
                return;
            }
            LocalMediaAlbum localMediaAlbum = this.getMAlbumWindow().getAlbum(oldCurrentAlbum.getBucketId());
            if (localMediaAlbum != null) {
                LocalMediaAlbum it = localMediaAlbum;
                boolean bl = false;
                List source = CollectionsKt.toMutableList((Collection)this.getMAdapter().getData());
                if (!(!((Collection)source).isEmpty()) || ((LocalMedia)CollectionsKt.first((List)source)).getId() != -10000L) {
                    it.setSource(source);
                    it.setCachePage(this.getViewModel().getPage());
                }
            }
            this.setCurrentAlbum(data);
            this.getMAdapter().setDisplayCamera(this.isDisplayCamera());
            this.setDefaultAlbumTitle(data.getBucketDisplayName());
            if (data.getCachePage() > 0 && !((Collection)data.getSource()).isEmpty()) {
                this.getViewModel().setPage(data.getCachePage());
                this.getMAdapter().setDataNotifyChanged(data.getSource());
                this.getMRecycler().scrollToPosition(0);
                this.getMRecycler().setEnabledLoadMore(!data.isSandboxAlbum() && !this.getConfig().isOnlySandboxDir() && !((Collection)data.getSource()).isEmpty());
            } else {
                this.getViewModel().loadMedia(data.getBucketId());
            }
            if (!this.getConfig().isFastSlidingSelect()) break block6;
            SlideSelectTouchListener slideSelectTouchListener = this.mDragSelectTouchListener;
            if (slideSelectTouchListener != null) {
                slideSelectTouchListener.setRecyclerViewHeaderCount(this.getMAdapter().isDisplayCamera() ? 1 : 0);
            }
        }
    }

    public void onRotateArrowAnim(boolean showing) {
        if (!this.getConfig().isOnlySandboxDir()) {
            AnimUtils.INSTANCE.rotateArrow(this.mIvTitleArrow, showing);
        }
    }

    public void initNavbarBar() {
        block6: {
            block5: {
                if (this.getConfig().getSelectionMode() != SelectionMode.ONLY_SINGLE) break block5;
                ViewGroup viewGroup = this.mBottomNarBar;
                if (viewGroup == null) break block6;
                viewGroup.setVisibility(8);
                break block6;
            }
            if (!this.getConfig().isOnlyCamera() && !this.getConfig().getSystemGallery()) {
                TextView textView = this.mTvOriginal;
                if (textView != null) {
                    textView.setVisibility(this.getConfig().isOriginalControl() ? 0 : 8);
                }
                TextView textView2 = this.mTvOriginal;
                if (textView2 != null) {
                    textView2.setOnClickListener(arg_0 -> SelectorMainFragment.initNavbarBar$lambda-14(this, arg_0));
                }
            }
            StyleTextView styleTextView = this.mTvPreview;
            if (styleTextView != null) {
                styleTextView.setOnClickListener(arg_0 -> SelectorMainFragment.initNavbarBar$lambda-15(this, arg_0));
            }
            TextView textView = this.mTvSelectNum;
            if (textView != null) {
                textView.setOnClickListener(arg_0 -> SelectorMainFragment.initNavbarBar$lambda-16(this, arg_0));
            }
            StyleTextView styleTextView2 = this.mTvComplete;
            if (styleTextView2 == null) break block6;
            styleTextView2.setOnClickListener(arg_0 -> SelectorMainFragment.initNavbarBar$lambda-17(this, arg_0));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkNotifyStrategy(boolean isAddRemove) {
        boolean bl;
        boolean isNotifyAll = false;
        if (!this.getConfig().isMaxSelectEnabledMask()) return isNotifyAll;
        List<LocalMedia> selectResult = this.getSelectResult();
        int selectCount = selectResult.size();
        if (this.getConfig().isAllWithImageVideo()) {
            int maxSelectCount = this.getConfig().getSelectCount();
            if (this.getConfig().getSelectionMode() != SelectionMode.MULTIPLE) return isNotifyAll;
            if (selectCount == maxSelectCount) return true;
            if (isAddRemove) return false;
            if (selectCount != maxSelectCount - 1) return false;
            return true;
        }
        if (selectCount == 0) return true;
        if (isAddRemove) {
            if (this.getConfig().getMediaType() == MediaType.ALL && selectCount == 1) {
                return true;
            }
            bl = false;
        } else {
            if (selectCount == this.getConfig().getTotalCount() - 1) {
                return true;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        if (MediaUtils.INSTANCE.hasMimeTypeOfVideo(((LocalMedia)CollectionsKt.first(selectResult)).getMimeType())) {
            if (selectResult.size() != this.getConfig().getMaxVideoSelectNum()) return false;
            return true;
        }
        if (selectResult.size() != this.getConfig().getTotalCount()) return false;
        return true;
    }

    @Override
    public void onSelectionResultChange(@Nullable LocalMedia change) {
        List<LocalMedia> selectResult = this.getSelectResult();
        StyleTextView styleTextView = this.mTvPreview;
        if (styleTextView != null) {
            styleTextView.setDataStyle(this.getConfig(), selectResult);
        }
        StyleTextView styleTextView2 = this.mTvComplete;
        if (styleTextView2 != null) {
            styleTextView2.setDataStyle(this.getConfig(), selectResult);
        }
        TextView textView = this.mTvSelectNum;
        if (textView != null) {
            textView.setVisibility(!((Collection)selectResult).isEmpty() ? 0 : 8);
        }
        TextView textView2 = this.mTvSelectNum;
        if (textView2 != null) {
            textView2.setText((CharSequence)String.valueOf(selectResult.size()));
        }
        long totalSize = 0L;
        Iterable $this$forEach$iv = selectResult;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalMedia media = (LocalMedia)element$iv;
            boolean bl = false;
            totalSize += media.getSize();
        }
        if (totalSize > 0L) {
            TextView textView3 = this.mTvOriginal;
            if (textView3 != null) {
                Object[] objectArray = new Object[]{FileUtils.INSTANCE.formatAccurateUnitFileSize(totalSize)};
                textView3.setText((CharSequence)this.getString(R.string.ps_original_image, objectArray));
            }
        } else {
            TextView textView4 = this.mTvOriginal;
            if (textView4 != null) {
                textView4.setText((CharSequence)this.getString(R.string.ps_default_original_image));
            }
        }
    }

    public void initRecyclerConfig(@NotNull RecyclerPreloadView recycler) {
        RecyclerPreloadView recyclerPreloadView;
        Intrinsics.checkNotNullParameter((Object)((Object)recycler), (String)"recycler");
        RecyclerPreloadView view = recyclerPreloadView = recycler;
        boolean bl = false;
        if (view.getItemDecorationCount() == 0) {
            int n = this.getConfig().getImageSpanCount();
            Context context = this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
            view.addItemDecoration(new GridSpacingItemDecoration(n, DensityUtil.INSTANCE.dip2px(context, 1.0f), false));
        }
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        view.setLayoutManager((RecyclerView.LayoutManager)new WrapContentGridLayoutManager(context, this.getConfig().getImageSpanCount()));
        RecyclerView.ItemAnimator itemAnimator = view.getItemAnimator();
        if (itemAnimator == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.SimpleItemAnimator");
        }
        ((SimpleItemAnimator)itemAnimator).setSupportsChangeAnimations(false);
    }

    @NotNull
    public BaseMediaListAdapter createMediaAdapter() {
        Class<MediaListAdapter> adapterClass = this.getConfig().getRegistry().get(MediaListAdapter.class);
        return this.getFactory().create(adapterClass);
    }

    public void initMediaAdapter() {
        Object object;
        this.initRecyclerConfig(this.getMRecycler());
        this.setMAdapter(this.createMediaAdapter());
        this.getMAdapter().setDisplayCamera(this.isDisplayCamera());
        this.getMRecycler().setAdapter((object = this.getConfig().getMListenerInfo().getOnAnimationAdapterWrapListener()) != null && (object = object.wrap((RecyclerView.Adapter<RecyclerView.ViewHolder>)((RecyclerView.Adapter)this.getMAdapter()))) != null ? (RecyclerView.Adapter)object : (RecyclerView.Adapter)this.getMAdapter());
        this.setFastSlidingSelect();
        this.onSelectionResultChange(null);
        this.getMRecycler().setReachBottomRow(2);
        this.getMRecycler().setOnRecyclerViewPreloadListener(new OnRecyclerViewPreloadMoreListener(this){
            final /* synthetic */ SelectorMainFragment this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPreloadMore() {
                if (this.this$0.getMRecycler().isEnabledLoadMore() && this.this$0.isLoadMoreThreshold()) {
                    SelectorMainFragment.access$getViewModel(this.this$0).loadMediaMore(this.this$0.getCurrentAlbum().getBucketId());
                    SelectorLogUtils.INSTANCE.info("\u52a0\u8f7d\u7b2c" + SelectorMainFragment.access$getViewModel(this.this$0).getPage() + '\u9875');
                }
            }
        });
        this.getMRecycler().setOnRecyclerViewScrollStateListener(new OnRecyclerViewScrollStateListener(this){
            final /* synthetic */ SelectorMainFragment this$0;
            {
                this.this$0 = $receiver;
            }

            public void onScrollFast() {
                block0: {
                    ImageEngine imageEngine = SelectorMainFragment.access$getConfig(this.this$0).getImageEngine();
                    if (imageEngine == null) break block0;
                    Context context = this.this$0.requireContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                    imageEngine.pauseRequests(context);
                }
            }

            public void onScrollSlow() {
                block0: {
                    ImageEngine imageEngine = SelectorMainFragment.access$getConfig(this.this$0).getImageEngine();
                    if (imageEngine == null) break block0;
                    Context context = this.this$0.requireContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                    imageEngine.resumeRequests(context);
                }
            }
        });
        this.getMRecycler().setOnRecyclerViewScrollListener(new OnRecyclerViewScrollListener(this){
            final /* synthetic */ SelectorMainFragment this$0;
            {
                this.this$0 = $receiver;
            }

            public void onScrolled(int dx, int dy) {
                this.this$0.setCurrentMediaCreateTimeText();
            }

            public void onScrollStateChanged(int state) {
                switch (state) {
                    case 1: {
                        this.this$0.showCurrentMediaCreateTimeUI();
                        break;
                    }
                    case 0: {
                        this.this$0.hideCurrentMediaCreateTimeUI();
                    }
                }
            }
        });
        this.getMAdapter().setOnGetSelectResultListener(new BaseMediaListAdapter.OnGetSelectResultListener(this){
            final /* synthetic */ SelectorMainFragment this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public List<LocalMedia> onSelectResult() {
                return this.this$0.getSelectResult();
            }
        });
        this.getMAdapter().setOnItemClickListener(new OnMediaItemClickListener(this){
            final /* synthetic */ SelectorMainFragment this$0;
            {
                this.this$0 = $receiver;
            }

            public void openCamera() {
                if (DoubleUtils.INSTANCE.isFastDoubleClick()) {
                    return;
                }
                this.this$0.openSelectedCamera();
            }

            public void onItemClick(@NotNull View selectedView, int position, @NotNull LocalMedia media) {
                Intrinsics.checkNotNullParameter((Object)selectedView, (String)"selectedView");
                Intrinsics.checkNotNullParameter((Object)media, (String)"media");
                if (DoubleUtils.INSTANCE.isFastDoubleClick()) {
                    return;
                }
                if (SelectorMainFragment.access$getConfig(this.this$0).isPreviewZoomEffect()) {
                    boolean isFullScreen = SelectorMainFragment.access$getConfig(this.this$0).isPreviewFullScreenMode();
                    Context context = this.this$0.requireContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                    int statusBarHeight = DensityUtil.INSTANCE.getStatusBarHeight(context);
                    RecycleItemViewParams.INSTANCE.build((ViewGroup)this.this$0.getMRecycler(), isFullScreen ? 0 : statusBarHeight);
                }
                this.this$0.onStartPreview(position, false, this.this$0.getMAdapter().getData());
            }

            public void onComplete(boolean isSelected, int position, @NotNull LocalMedia media) {
                Intrinsics.checkNotNullParameter((Object)media, (String)"media");
                if (this.this$0.confirmSelect(media, isSelected) == 0) {
                    this.this$0.handleSelectResult();
                }
            }

            public void onItemLongClick(@NotNull View itemView, int position, @NotNull LocalMedia media) {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
                    Intrinsics.checkNotNullParameter((Object)media, (String)"media");
                    if (!SelectorMainFragment.access$getConfig(this.this$0).isFastSlidingSelect()) break block4;
                    SlideSelectTouchListener slideSelectTouchListener = SelectorMainFragment.access$getMDragSelectTouchListener$p(this.this$0);
                    if (slideSelectTouchListener != null) {
                        SlideSelectTouchListener slideSelectTouchListener2 = slideSelectTouchListener;
                        SelectorMainFragment selectorMainFragment = this.this$0;
                        SlideSelectTouchListener it = slideSelectTouchListener2;
                        boolean bl = false;
                        FragmentActivity fragmentActivity = selectorMainFragment.requireActivity();
                        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
                        FragmentActivity activity = fragmentActivity;
                        Object object = activity.getSystemService("vibrator");
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type android.os.Vibrator");
                        }
                        Vibrator vibrator = (Vibrator)object;
                        if (SdkVersionUtils.INSTANCE.isO()) {
                            vibrator.vibrate(VibrationEffect.createOneShot((long)50L, (int)-1));
                        } else {
                            vibrator.vibrate(50L);
                        }
                        it.startSlideSelection(position);
                    }
                }
            }

            public int onSelected(boolean isSelected, int position, @NotNull LocalMedia media) {
                Intrinsics.checkNotNullParameter((Object)media, (String)"media");
                return this.this$0.confirmSelect(media, isSelected);
            }
        });
    }

    public boolean isDisplayCamera() {
        return this.getConfig().isDisplayCamera() && this.getCurrentAlbum().isAllAlbum() || this.getConfig().isOnlySandboxDir() && this.getCurrentAlbum().isSandboxAlbum();
    }

    public boolean isLoadMoreThreshold() {
        return this.getCurrentAlbum().getTotalCount() != this.getMAdapter().getData().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void duplicateMediaSource(@NotNull List<LocalMedia> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        if (this.isCameraCallback && this.getCurrentAlbum().isAllAlbum()) {
            this.isCameraCallback = false;
            Object object = this.anyLock;
            synchronized (object) {
                boolean bl = false;
                List<LocalMedia> data = this.getMAdapter().getData();
                Iterator<LocalMedia> iterator = result.iterator();
                while (iterator.hasNext()) {
                    LocalMedia media = iterator.next();
                    if (!data.contains(media)) continue;
                    iterator.remove();
                    SelectorLogUtils.INSTANCE.info("\u6709\u91cd\u590d\u7684:" + media.getAvailablePath());
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public void setFastSlidingSelect() {
        block1: {
            if (!this.getConfig().isFastSlidingSelect()) break block1;
            HashSet<Integer> selectedPosition = new HashSet<Integer>();
            SlideSelectionHandler slideSelectionHandler2 = new SlideSelectionHandler(new SlideSelectionHandler.ISelectionHandler(this, selectedPosition){
                final /* synthetic */ SelectorMainFragment this$0;
                final /* synthetic */ HashSet<Integer> $selectedPosition;
                {
                    this.this$0 = $receiver;
                    this.$selectedPosition = $selectedPosition;
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public Set<Integer> getSelection() {
                    void $this$forEach$iv;
                    Iterable iterable = this.this$0.getSelectResult();
                    HashSet<Integer> hashSet = this.$selectedPosition;
                    SelectorMainFragment selectorMainFragment = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        LocalMedia media = (LocalMedia)element$iv;
                        boolean bl = false;
                        hashSet.add(selectorMainFragment.getMAdapter().getData().indexOf(media));
                    }
                    return this.$selectedPosition;
                }

                public void changeSelection(int start, int end, boolean isSelected, boolean calledFromOnStart) {
                    block1: {
                        List<LocalMedia> adapterData = this.this$0.getMAdapter().getData();
                        if (adapterData.size() == 0 || start > adapterData.size()) {
                            return;
                        }
                        LocalMedia media = adapterData.get(start);
                        SlideSelectTouchListener slideSelectTouchListener = SelectorMainFragment.access$getMDragSelectTouchListener$p(this.this$0);
                        if (slideSelectTouchListener == null) break block1;
                        slideSelectTouchListener.setActive(this.this$0.confirmSelect(media, this.this$0.getSelectResult().contains(media)) != -1);
                    }
                }
            });
            SlideSelectTouchListener slideSelectTouchListener = this.mDragSelectTouchListener = new SlideSelectTouchListener().setRecyclerViewHeaderCount(this.getMAdapter().isDisplayCamera() ? 1 : 0).withSelectListener(slideSelectionHandler2);
            if (slideSelectTouchListener != null) {
                SlideSelectTouchListener it = slideSelectTouchListener;
                boolean bl = false;
                this.getMRecycler().addOnItemTouchListener(it);
            }
        }
    }

    public void checkPermissions() {
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        if (PermissionChecker.INSTANCE.isCheckReadStorage(context, this.getConfig().getMediaType())) {
            if (this.isNeedRestore()) {
                this.restoreMemoryData();
            } else {
                this.requestData();
            }
        } else {
            Context context2 = this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"requireContext()");
            String[] permissionArray = PermissionChecker.INSTANCE.getReadPermissionArray(context2, this.getConfig().getMediaType());
            this.showPermissionDescription(true, permissionArray);
            OnPermissionApplyListener onPermissionApplyListener = this.getConfig().getMListenerInfo().getOnPermissionApplyListener();
            if (onPermissionApplyListener != null) {
                this.showCustomPermissionApply(permissionArray);
            } else {
                PermissionChecker.INSTANCE.requestPermissions((Fragment)this, permissionArray, new OnPermissionResultListener(this, permissionArray){
                    final /* synthetic */ SelectorMainFragment this$0;
                    final /* synthetic */ String[] $permissionArray;
                    {
                        this.this$0 = $receiver;
                        this.$permissionArray = $permissionArray;
                    }

                    public void onGranted() {
                        this.this$0.showPermissionDescription(false, this.$permissionArray);
                        this.this$0.requestData();
                    }

                    public void onDenied() {
                        this.this$0.handlePermissionDenied(this.$permissionArray);
                    }
                });
            }
        }
    }

    @Override
    public void showCustomPermissionApply(@NotNull String[] permission) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            OnPermissionApplyListener onPermissionApplyListener = this.getConfig().getMListenerInfo().getOnPermissionApplyListener();
            if (onPermissionApplyListener == null) break block0;
            onPermissionApplyListener.requestPermission(this, permission, new OnRequestPermissionListener(this){
                final /* synthetic */ SelectorMainFragment this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onCall(@NotNull String[] permission, boolean isResult) {
                    Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
                    if (isResult) {
                        this.this$0.showPermissionDescription(false, permission);
                        if (Intrinsics.areEqual((Object)ArraysKt.first((Object[])permission), (Object)"android.permission.CAMERA")) {
                            this.this$0.openSelectedCamera();
                        } else {
                            this.this$0.requestData();
                        }
                    } else {
                        this.this$0.handlePermissionDenied(permission);
                    }
                }
            });
        }
    }

    @Override
    public void handlePermissionSettingResult(@NotNull String[] permission) {
        boolean isHasPermissions;
        boolean bl;
        OnPermissionApplyListener onPermissionApplyListener;
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        if (permission.length == 0) {
            return;
        }
        this.showPermissionDescription(false, permission);
        boolean isHasCamera = TextUtils.equals((CharSequence)permission[0], (CharSequence)"android.permission.CAMERA");
        OnPermissionApplyListener onPermissionApplyListener2 = onPermissionApplyListener = this.getConfig().getMListenerInfo().getOnPermissionApplyListener();
        if (onPermissionApplyListener2 != null) {
            bl = onPermissionApplyListener2.hasPermissions(this, permission);
        } else {
            Context context = this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
            bl = isHasPermissions = PermissionChecker.INSTANCE.checkSelfPermission(context, permission);
        }
        if (isHasPermissions) {
            if (isHasCamera) {
                this.openSelectedCamera();
            } else {
                this.requestData();
            }
        } else if (isHasCamera) {
            Context context = this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
            String string2 = this.getString(R.string.ps_camera);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.ps_camera)");
            ToastUtils.INSTANCE.showMsg(context, string2);
        } else {
            Context context = this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
            String string3 = this.getString(R.string.ps_jurisdiction);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(R.string.ps_jurisdiction)");
            ToastUtils.INSTANCE.showMsg(context, string3);
            this.onBackPressed();
        }
        TempDataProvider.Companion.getInstance().setCurrentRequestPermission(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void requestData() {
        if (this.getConfig().isOnlySandboxDir()) {
            void $this$requestData_u24lambda_u2d22;
            LocalMediaAlbum localMediaAlbum;
            String string2 = this.getConfig().getSandboxDir();
            if (string2 == null) {
                throw new NullPointerException("config.sandboxDir cannot be empty");
            }
            String sandboxDir = string2;
            File dir = new File(sandboxDir);
            this.setDefaultAlbumTitle(dir.getName());
            LocalMediaAlbum localMediaAlbum2 = localMediaAlbum = new LocalMediaAlbum();
            SelectorMainFragment selectorMainFragment = this;
            boolean bl = false;
            $this$requestData_u24lambda_u2d22.setBucketId(-2L);
            $this$requestData_u24lambda_u2d22.setBucketDisplayName(dir.getName());
            selectorMainFragment.setCurrentAlbum(localMediaAlbum);
            ImageView imageView = this.mIvTitleArrow;
            if (imageView != null) {
                imageView.setVisibility(8);
            }
            this.getMRecycler().setEnabledLoadMore(false);
            this.getViewModel().loadAppInternalDir(sandboxDir);
        } else {
            this.onPreloadFakeData();
            Looper.myQueue().addIdleHandler(() -> SelectorMainFragment.requestData$lambda-23(this));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onPreloadFakeData() {
        if (this.isSavedInstanceState()) {
            return;
        }
        List pre = new ArrayList();
        for (int i = 0; i < 60; ++i) {
            void $this$onPreloadFakeData_u24lambda_u2d24;
            LocalMedia localMedia;
            LocalMedia localMedia2 = localMedia = new LocalMedia();
            List list = pre;
            boolean bl = false;
            $this$onPreloadFakeData_u24lambda_u2d24.setId(-10000L);
            list.add(localMedia);
        }
        this.getMAdapter().setDataNotifyChanged(pre);
    }

    public void setDefaultAlbumTitle(@Nullable String title) {
        TextView textView = this.mTvTitle;
        if (textView != null) {
            CharSequence charSequence;
            String string2 = this.getConfig().getDefaultAlbumName();
            if (string2 != null) {
                charSequence = string2;
            } else {
                String string3 = title;
                charSequence = string3 != null ? (CharSequence)string3 : (CharSequence)(this.getConfig().getMediaType() == MediaType.AUDIO ? this.getString(R.string.ps_all_audio) : this.getString(R.string.ps_camera_roll));
            }
            textView.setText(charSequence);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void restoreMemoryData() {
        List albumSource = CollectionsKt.toMutableList((Collection)TempDataProvider.Companion.getInstance().getAlbumSource());
        this.onAlbumSourceChange(albumSource);
        List mediaSource = CollectionsKt.toMutableList((Collection)TempDataProvider.Companion.getInstance().getMediaSource());
        this.onMediaSourceChange(mediaSource);
        TempDataProvider.Companion.getInstance().getAlbumSource().clear();
        TempDataProvider.Companion.getInstance().getMediaSource().clear();
        if (this.getConfig().isOnlySandboxDir()) {
            void $this$restoreMemoryData_u24lambda_u2d25;
            LocalMediaAlbum localMediaAlbum;
            String string2 = this.getConfig().getSandboxDir();
            if (string2 == null) {
                throw new NullPointerException("config.sandboxDir cannot be empty");
            }
            String sandboxDir = string2;
            File dir = new File(sandboxDir);
            this.setDefaultAlbumTitle(dir.getName());
            LocalMediaAlbum localMediaAlbum2 = localMediaAlbum = new LocalMediaAlbum();
            SelectorMainFragment selectorMainFragment = this;
            boolean bl = false;
            $this$restoreMemoryData_u24lambda_u2d25.setBucketId(-2L);
            $this$restoreMemoryData_u24lambda_u2d25.setBucketDisplayName(dir.getName());
            selectorMainFragment.setCurrentAlbum(localMediaAlbum);
            ImageView imageView = this.mIvTitleArrow;
            if (imageView != null) {
                imageView.setVisibility(8);
            }
            this.getMRecycler().setEnabledLoadMore(false);
        }
    }

    public boolean isNeedRestore() {
        return this.isSavedInstanceState();
    }

    public void onAlbumSourceChange(@NotNull List<LocalMediaAlbum> albumList) {
        Intrinsics.checkNotNullParameter(albumList, (String)"albumList");
        if (!((Collection)albumList).isEmpty()) {
            this.setCurrentAlbum((LocalMediaAlbum)CollectionsKt.first(albumList));
            Iterable $this$forEach$iv = albumList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LocalMediaAlbum album = (LocalMediaAlbum)element$iv;
                boolean bl = false;
                if (album.getBucketId() != this.getCurrentAlbum().getBucketId()) continue;
                album.setSelected(true);
            }
            this.getMAlbumWindow().setAlbumList(albumList);
            this.getMAlbumWindow().notifyChangedSelectTag(this.getSelectResult());
        }
    }

    public void onMediaSourceChange(@NotNull List<LocalMedia> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        this.duplicateMediaSource(result);
        this.getMRecycler().setEnabledLoadMore(!this.getConfig().isOnlySandboxDir() && !((Collection)result).isEmpty());
        if (this.getViewModel().getPage() == 1) {
            this.getMAdapter().setDataNotifyChanged(CollectionsKt.toMutableList((Collection)result));
            this.getMRecycler().scrollToPosition(0);
            if (this.getMAdapter().getData().isEmpty() && (this.getCurrentAlbum().isAllAlbum() || this.getConfig().isOnlySandboxDir() && this.getCurrentAlbum().isSandboxAlbum())) {
                TextView textView = this.mTvDataEmpty;
                if (textView != null) {
                    textView.setVisibility(0);
                }
            } else {
                TextView textView = this.mTvDataEmpty;
                if (textView != null) {
                    textView.setVisibility(8);
                }
            }
        } else {
            this.getMAdapter().addAllDataNotifyChanged(result);
        }
    }

    public void onStartPreview(int position, boolean isBottomPreview, @NotNull List<LocalMedia> source) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        this.getConfig().setPreviewWrap(this.onWrapPreviewData(this.getViewModel().getPage(), position, isBottomPreview, source));
        ClassFactory.NewInstance factory = new ClassFactory.NewInstance();
        Registry registry = this.getConfig().getRegistry();
        SelectorPreviewFragment instance = (SelectorPreviewFragment)((Object)factory.create(registry.get(this.newPreviewInstance())));
        String fragmentTag = instance.getFragmentTag();
        FragmentActivity fragmentActivity = this.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
        FragmentInjectManager.INSTANCE.injectSystemRoomFragment(fragmentActivity, fragmentTag, instance);
    }

    @NotNull
    public <F extends SelectorPreviewFragment> Class<F> newPreviewInstance() {
        return SelectorPreviewFragment.class;
    }

    @NotNull
    public PreviewDataWrap onWrapPreviewData(int page, int position, boolean isBottomPreview, @NotNull List<LocalMedia> source) {
        PreviewDataWrap previewDataWrap;
        Intrinsics.checkNotNullParameter(source, (String)"source");
        PreviewDataWrap $this$onWrapPreviewData_u24lambda_u2d27 = previewDataWrap = new PreviewDataWrap();
        boolean bl = false;
        $this$onWrapPreviewData_u24lambda_u2d27.setPage(page);
        $this$onWrapPreviewData_u24lambda_u2d27.setPosition(position);
        $this$onWrapPreviewData_u24lambda_u2d27.setBucketId(this.getCurrentAlbum().getBucketId());
        $this$onWrapPreviewData_u24lambda_u2d27.setBottomPreview(isBottomPreview);
        $this$onWrapPreviewData_u24lambda_u2d27.setDisplayCamera(this.getMAdapter().isDisplayCamera());
        if (this.getConfig().isOnlySandboxDir()) {
            $this$onWrapPreviewData_u24lambda_u2d27.setTotalCount(source.size());
        } else {
            $this$onWrapPreviewData_u24lambda_u2d27.setTotalCount(isBottomPreview ? source.size() : this.getCurrentAlbum().getTotalCount());
        }
        $this$onWrapPreviewData_u24lambda_u2d27.setSource(CollectionsKt.toMutableList((Collection)source));
        return previewDataWrap;
    }

    @Override
    public void onMergeCameraResult(@Nullable LocalMedia media) {
        if (media != null) {
            this.isCameraCallback = true;
            this.onCheckDuplicateMedia(media);
            this.onMergeCameraAlbum(media);
            this.onMergeCameraMedia(media);
        } else {
            SelectorLogUtils.INSTANCE.info("analysisCameraData: Parsing LocalMedia object as empty");
        }
    }

    public void onCheckDuplicateMedia(@NotNull LocalMedia media) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        if (!SdkVersionUtils.INSTANCE.isQ() && MediaUtils.INSTANCE.hasMimeTypeOfImage(media.getMimeType())) {
            BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)((ViewModel)this.getViewModel())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(media, this, null){
                Object L$0;
                int label;
                final /* synthetic */ LocalMedia $media;
                final /* synthetic */ SelectorMainFragment this$0;
                {
                    this.$media = $media;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = this.$media.getAbsolutePath();
                            if (v0 == null) break;
                            var2_3 = v0;
                            var3_4 = this.this$0;
                            it = var2_3;
                            $i$a$-let-SelectorMainFragment$onCheckDuplicateMedia$1$1 = false;
                            v1 = new File(it).getParent();
                            if (v1 == null) break;
                            parent = v1;
                            $i$a$-let-SelectorMainFragment$onCheckDuplicateMedia$1$1$1 = false;
                            v2 = var3_4.requireContext();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"requireContext()");
                            context = v2;
                            this.L$0 = context;
                            this.label = 1;
                            v3 = MediaUtils.INSTANCE.getDCIMLastId(context, parent, (Continuation<? super Long>)this);
                            if (v3 == var11_2) {
                                return var11_2;
                            }
                            ** GOTO lbl30
                        }
                        case 1: {
                            $i$a$-let-SelectorMainFragment$onCheckDuplicateMedia$1$1 = false;
                            $i$a$-let-SelectorMainFragment$onCheckDuplicateMedia$1$1$1 = false;
                            context = (Context)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl30:
                            // 2 sources

                            if ((id = ((Number)v3).longValue()) != -1L) {
                                MediaUtils.INSTANCE.remove(context, id);
                            }
                            break;
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public void onMergeCameraAlbum(@NotNull LocalMedia media) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        LocalMediaAlbum localMediaAlbum = this.getMAlbumWindow().getAlbum(-1L);
        if (localMediaAlbum == null) {
            localMediaAlbum = new LocalMediaAlbum();
        }
        LocalMediaAlbum allMediaAlbum = localMediaAlbum;
        allMediaAlbum.setBucketId(-1L);
        String string2 = this.getConfig().getDefaultAlbumName();
        if (string2 == null) {
            String string3 = MediaUtils.INSTANCE.hasMimeTypeOfAudio(media.getMimeType()) ? this.getString(R.string.ps_all_audio) : this.getString(R.string.ps_camera_roll);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"if (MediaUtils.hasMimeTy\u2026camera_roll\n            )");
        }
        String bucketDisplayName = string2;
        allMediaAlbum.setBucketDisplayName(bucketDisplayName);
        allMediaAlbum.setBucketDisplayCover(media.getPath());
        allMediaAlbum.setBucketDisplayMimeType(media.getMimeType());
        allMediaAlbum.getSource().add(0, media);
        allMediaAlbum.setTotalCount(allMediaAlbum.getTotalCount() + 1);
        LocalMediaAlbum localMediaAlbum2 = this.getMAlbumWindow().getAlbum(media.getBucketId());
        if (localMediaAlbum2 == null) {
            localMediaAlbum2 = new LocalMediaAlbum();
        }
        LocalMediaAlbum cameraMediaAlbum = localMediaAlbum2;
        cameraMediaAlbum.setBucketId(media.getBucketId());
        cameraMediaAlbum.setBucketDisplayName(media.getBucketDisplayName());
        cameraMediaAlbum.setBucketDisplayCover(media.getPath());
        cameraMediaAlbum.setBucketDisplayMimeType(media.getMimeType());
        cameraMediaAlbum.getSource().add(0, media);
        cameraMediaAlbum.setTotalCount(cameraMediaAlbum.getTotalCount() + 1);
        if (this.getMAlbumWindow().getAlbumList().isEmpty()) {
            List albumList = new ArrayList();
            albumList.add(0, allMediaAlbum);
            albumList.add(cameraMediaAlbum);
            ((LocalMediaAlbum)CollectionsKt.first((List)albumList)).setSelected(true);
            this.setCurrentAlbum((LocalMediaAlbum)CollectionsKt.first((List)albumList));
            this.getMAlbumWindow().setAlbumList(albumList);
            TextView textView = this.mTvDataEmpty;
            if (textView != null) {
                textView.setVisibility(8);
            }
        } else {
            LocalMediaAlbum cameraAlbum = this.getMAlbumWindow().getAlbum(cameraMediaAlbum.getBucketId());
            if (cameraAlbum == null) {
                this.getMAlbumWindow().getAlbumList().add(cameraMediaAlbum);
            }
        }
        this.getMAlbumWindow().notifyItemRangeChanged();
    }

    public void onMergeCameraMedia(@NotNull LocalMedia media) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        this.requireActivity().runOnUiThread(() -> SelectorMainFragment.onMergeCameraMedia$lambda-28(this, media));
    }

    public void onDestroy() {
        SlideSelectTouchListener slideSelectTouchListener = this.mDragSelectTouchListener;
        if (slideSelectTouchListener != null) {
            slideSelectTouchListener.stopAutoScroll();
        }
        super.onDestroy();
    }

    private static final void registerLiveData$lambda-0(SelectorMainFragment this$0, LocalMedia media) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        int position = this$0.getMAdapter().getData().indexOf(media);
        if (position >= 0) {
            this$0.getMAdapter().notifyItemChanged(this$0.getMAdapter().isDisplayCamera() ? position + 1 : position);
        }
    }

    private static final void registerLiveData$lambda-1(SelectorMainFragment this$0, Boolean isOriginal) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)isOriginal, (String)"isOriginal");
        this$0.onOriginalChange(isOriginal);
    }

    private static final boolean registerLiveData$lambda-3$lambda-2(SelectorMainFragment this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getMAdapter().notifyDataSetChanged();
        return false;
    }

    private static final void registerLiveData$lambda-3(SelectorMainFragment this$0, LocalMedia media) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        int position = this$0.getMAdapter().getData().indexOf(media);
        if (this$0.checkNotifyStrategy(this$0.getSelectResult().indexOf(media) != -1)) {
            this$0.getMAdapter().notifyItemChanged(this$0.getMAdapter().isDisplayCamera() ? position + 1 : position);
            Looper.myQueue().addIdleHandler(() -> SelectorMainFragment.registerLiveData$lambda-3$lambda-2(this$0));
        } else {
            this$0.getMAdapter().notifyItemChanged(this$0.getMAdapter().isDisplayCamera() ? position + 1 : position);
        }
        this$0.getMAlbumWindow().notifyChangedSelectTag(this$0.getSelectResult());
        this$0.onSelectionResultChange(media);
    }

    private static final void registerLiveData$lambda-4(SelectorMainFragment this$0, List albumList) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)albumList, (String)"albumList");
        this$0.onAlbumSourceChange(albumList);
    }

    private static final void registerLiveData$lambda-5(SelectorMainFragment this$0, List mediaList) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)mediaList, (String)"mediaList");
        this$0.onMediaSourceChange(mediaList);
        SelectorLogUtils.INSTANCE.info("\u5f53\u524d\u6570\u91cf->" + this$0.getMAdapter().getData().size());
    }

    private static final void initTitleBar$lambda-6(SelectorMainFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.onBackClick(it);
    }

    private static final void initTitleBar$lambda-7(SelectorMainFragment this$0, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            ImageView imageView = this$0.mIvLeftBack;
            if (imageView == null) break block0;
            imageView.performClick();
        }
    }

    private static final void initTitleBar$lambda-8(SelectorMainFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onShowAlbumWindowAsDropDown();
    }

    private static final void initTitleBar$lambda-9(SelectorMainFragment this$0, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            TextView textView = this$0.mTvTitle;
            if (textView == null) break block0;
            textView.performClick();
        }
    }

    private static final void initTitleBar$lambda-10(SelectorMainFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.onTitleBarClick(it);
    }

    private static final void onTitleBarClick$lambda-12(SelectorMainFragment this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getMRecycler().smoothScrollToPosition(0);
    }

    private static final void initNavbarBar$lambda-14(SelectorMainFragment this$0, View tvOriginal) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)tvOriginal, (String)"tvOriginal");
        this$0.onOriginalClick(tvOriginal);
    }

    private static final void initNavbarBar$lambda-15(SelectorMainFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (DoubleUtils.INSTANCE.isFastDoubleClick()) {
            return;
        }
        this$0.onStartPreview(0, true, this$0.getSelectResult());
    }

    private static final void initNavbarBar$lambda-16(SelectorMainFragment this$0, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            StyleTextView styleTextView = this$0.mTvComplete;
            if (styleTextView == null) break block0;
            styleTextView.performClick();
        }
    }

    private static final void initNavbarBar$lambda-17(SelectorMainFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.onCompleteClick(it);
    }

    private static final boolean requestData$lambda-23(SelectorMainFragment this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getViewModel().loadMediaAlbum();
        this$0.getViewModel().loadMedia(this$0.getCurrentAlbum().getBucketId());
        return false;
    }

    private static final void onMergeCameraMedia$lambda-28(SelectorMainFragment this$0, LocalMedia $media) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$media, (String)"$media");
        this$0.getMAdapter().getData().add(0, $media);
        this$0.confirmSelect($media, false);
        int position = this$0.getMAdapter().isDisplayCamera() ? 1 : 0;
        this$0.getMAdapter().notifyItemInserted(position);
        this$0.getMAdapter().notifyItemRangeChanged(position, this$0.getMAdapter().getData().size());
    }

    public static final /* synthetic */ SelectorViewModel access$getViewModel(SelectorMainFragment $this) {
        return $this.getViewModel();
    }

    public static final /* synthetic */ SelectorConfig access$getConfig(SelectorMainFragment $this) {
        return $this.getConfig();
    }

    public static final /* synthetic */ SlideSelectTouchListener access$getMDragSelectTouchListener$p(SelectorMainFragment $this) {
        return $this.mDragSelectTouchListener;
    }
}

