/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.os.Bundle;
import android.view.WindowManager;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.SelectorCameraFragment;
import com.luck.picture.lib.SelectorExternalPreviewFragment;
import com.luck.picture.lib.SelectorPreviewFragment;
import com.luck.picture.lib.SelectorSystemFragment;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.factory.ClassFactory;
import com.luck.picture.lib.helper.FragmentInjectManager;
import com.luck.picture.lib.immersive.ImmersiveManager;
import com.luck.picture.lib.provider.SelectorProviders;
import com.luck.picture.lib.registry.Registry;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\u0012\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\b\u0010\u000b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/luck/picture/lib/SelectorTransparentActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "config", "Lcom/luck/picture/lib/config/SelectorConfig;", "finish", "", "immersive", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "setActivitySize", "selector_release"})
public final class SelectorTransparentActivity
extends AppCompatActivity {
    @NotNull
    private final SelectorConfig config = SelectorProviders.Companion.getInstance().getConfig();

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.immersive();
        this.setActivitySize();
        this.setContentView(R.layout.ps_empty);
        Registry registry = this.config.getRegistry();
        ClassFactory.NewInstance factory = new ClassFactory.NewInstance();
        if (this.config.getPreviewWrap().isExternalPreview()) {
            SelectorPreviewFragment instance = factory.create(SelectorPreviewFragment.class);
            if (((Object)((Object)instance)).getClass().isAssignableFrom(SelectorPreviewFragment.class)) {
                instance = factory.create(registry.get(SelectorExternalPreviewFragment.class));
            }
            FragmentInjectManager.INSTANCE.injectFragment((FragmentActivity)this, instance.getFragmentTag(), instance);
        } else if (this.config.getSystemGallery()) {
            SelectorSystemFragment instance = factory.create(SelectorSystemFragment.class);
            FragmentInjectManager.INSTANCE.injectFragment((FragmentActivity)this, instance.getFragmentTag(), instance);
        } else {
            SelectorCameraFragment instance = factory.create(registry.get(SelectorCameraFragment.class));
            FragmentInjectManager.INSTANCE.injectFragment((FragmentActivity)this, instance.getFragmentTag(), instance);
        }
    }

    private final void immersive() {
        ImmersiveManager.INSTANCE.immersiveAboveAPI23(this, this.config.getStatusBarStyle().getStatusBarColor(), this.config.getStatusBarStyle().getNavigationBarColor(), this.config.getStatusBarStyle().isDarkStatusBar());
    }

    private final void setActivitySize() {
        if (this.config.isOnlyCamera() || this.config.getSystemGallery()) {
            this.getWindow().setGravity(51);
            WindowManager.LayoutParams params = this.getWindow().getAttributes();
            params.x = 0;
            params.y = 0;
            params.height = 1;
            params.width = 1;
            this.getWindow().setAttributes(params);
        }
    }

    public void finish() {
        super.finish();
        if (this.config.getPreviewWrap().isExternalPreview() && !this.config.isPreviewZoomEffect()) {
            this.overridePendingTransition(R.anim.ps_anim_fade_in, this.config.getWindowAnimStyle().getExitAnimRes());
        } else if (!this.config.isOnlyCamera() && !this.config.getSystemGallery()) {
            this.overridePendingTransition(0, R.anim.ps_anim_fade_out);
        }
    }
}

