/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.ListMediaViewHolder;
import com.luck.picture.lib.adapter.base.BaseMediaListAdapter;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.utils.MediaUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u001c\u0010\u0017\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/luck/picture/lib/adapter/ImageViewHolder;", "Lcom/luck/picture/lib/adapter/ListMediaViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "ivEditor", "Landroid/widget/ImageView;", "tvMediaTag", "Landroid/widget/TextView;", "bindData", "", "media", "Lcom/luck/picture/lib/entity/LocalMedia;", "position", "", "isGif", "", "mimeType", "", "path", "isLongImage", "width", "height", "isWebp", "onMergeEditor", "selector_release"})
public class ImageViewHolder
extends ListMediaViewHolder {
    @NotNull
    private TextView tvMediaTag;
    @NotNull
    private ImageView ivEditor;

    public ImageViewHolder(@NotNull View itemView) {
        Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
        super(itemView);
        View view = itemView.findViewById(R.id.tv_media_tag);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.tv_media_tag)");
        this.tvMediaTag = (TextView)view;
        View view2 = itemView.findViewById(R.id.iv_editor);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView.findViewById(R.id.iv_editor)");
        this.ivEditor = (ImageView)view2;
    }

    @Override
    public void bindData(@NotNull LocalMedia media, int position) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        super.bindData(media, position);
        this.onMergeEditor(media);
        if (this.isLongImage(media.getWidth(), media.getHeight())) {
            this.tvMediaTag.setVisibility(0);
            String string2 = this.itemView.getContext().getString(R.string.ps_long_chart);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"itemView.context.getString(R.string.ps_long_chart)");
            String longChartTag = string2;
            if (this.isGif(media.getMimeType(), media.getAvailablePath())) {
                String string3 = longChartTag + ',' + this.itemView.getContext().getString(R.string.ps_gif_tag);
                Object[] objectArray = new Object[]{};
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
                this.tvMediaTag.setText((CharSequence)string4);
            } else if (this.isWebp(media.getMimeType(), media.getAvailablePath())) {
                String string5 = longChartTag + ',' + this.itemView.getContext().getString(R.string.ps_webp_tag);
                Object[] objectArray = new Object[]{};
                String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(format, *args)");
                this.tvMediaTag.setText((CharSequence)string6);
            } else {
                this.tvMediaTag.setText((CharSequence)longChartTag);
            }
        } else if (this.isGif(media.getMimeType(), media.getAvailablePath())) {
            this.tvMediaTag.setText((CharSequence)this.itemView.getContext().getString(R.string.ps_gif_tag));
            this.tvMediaTag.setVisibility(0);
        } else if (this.isWebp(media.getMimeType(), media.getAvailablePath())) {
            this.tvMediaTag.setText((CharSequence)this.itemView.getContext().getString(R.string.ps_webp_tag));
            this.tvMediaTag.setVisibility(0);
        } else {
            this.tvMediaTag.setVisibility(8);
        }
    }

    public boolean isWebp(@Nullable String mimeType, @Nullable String path) {
        return MediaUtils.INSTANCE.isHasWebp(mimeType) || MediaUtils.INSTANCE.isUrlHasWebp(path);
    }

    public boolean isGif(@Nullable String mimeType, @Nullable String path) {
        return MediaUtils.INSTANCE.isHasGif(mimeType) || MediaUtils.INSTANCE.isUrlHasGif(path);
    }

    public boolean isLongImage(int width, int height) {
        return MediaUtils.INSTANCE.isLongImage(width, height);
    }

    public void onMergeEditor(@NotNull LocalMedia media) {
        LocalMedia existsMedia;
        int position;
        List<LocalMedia> selectResult;
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        BaseMediaListAdapter.OnGetSelectResultListener onGetSelectResultListener = this.getMGetSelectResultListener();
        List<LocalMedia> list = selectResult = onGetSelectResultListener != null ? onGetSelectResultListener.onSelectResult() : null;
        if (selectResult != null && !((Collection)selectResult).isEmpty() && !media.isEditor() && (position = selectResult.indexOf(media)) >= 0 && (existsMedia = selectResult.get(position)).isEditor()) {
            media.setCropWidth(existsMedia.getCropWidth());
            media.setCropHeight(existsMedia.getCropHeight());
            media.setEditorPath(existsMedia.getEditorPath());
            media.setEditorData(existsMedia.getEditorData());
            media.setCropOffsetX(existsMedia.getCropOffsetX());
            media.setCropOffsetY(existsMedia.getCropOffsetY());
            media.setCropAspectRatio(existsMedia.getCropAspectRatio());
        }
        this.ivEditor.setVisibility(media.isEditor() ? 0 : 8);
    }
}

