/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.LayoutSource;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.engine.ImageEngine;
import com.luck.picture.lib.entity.LocalMediaAlbum;
import com.luck.picture.lib.interfaces.OnItemClickListener;
import com.luck.picture.lib.utils.MediaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u000bJ\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J\u0014\u0010\u001f\u001a\u00020\u00182\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0016\u0010 \u001a\u00020\u00182\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0012R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0005R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/luck/picture/lib/adapter/MediaAlbumAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/luck/picture/lib/adapter/MediaAlbumAdapter$ViewHolder;", "config", "Lcom/luck/picture/lib/config/SelectorConfig;", "(Lcom/luck/picture/lib/config/SelectorConfig;)V", "albumList", "", "Lcom/luck/picture/lib/entity/LocalMediaAlbum;", "albumMap", "", "", "getConfig", "()Lcom/luck/picture/lib/config/SelectorConfig;", "setConfig", "lastSelectPosition", "", "mItemClickListener", "Lcom/luck/picture/lib/interfaces/OnItemClickListener;", "getAlbum", "bucketId", "getAlbumList", "getItemCount", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setAlbumList", "setOnItemClickListener", "listener", "ViewHolder", "selector_release"})
public class MediaAlbumAdapter
extends RecyclerView.Adapter<ViewHolder> {
    @NotNull
    private SelectorConfig config;
    @NotNull
    private List<LocalMediaAlbum> albumList;
    @NotNull
    private Map<Long, LocalMediaAlbum> albumMap;
    private int lastSelectPosition;
    @Nullable
    private OnItemClickListener<LocalMediaAlbum> mItemClickListener;

    public MediaAlbumAdapter(@NotNull SelectorConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.albumList = new ArrayList();
        this.albumMap = new LinkedHashMap();
    }

    @NotNull
    public final SelectorConfig getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull SelectorConfig selectorConfig) {
        Intrinsics.checkNotNullParameter((Object)selectorConfig, (String)"<set-?>");
        this.config = selectorConfig;
    }

    public final void setAlbumList(@NotNull List<LocalMediaAlbum> albumList) {
        Intrinsics.checkNotNullParameter(albumList, (String)"albumList");
        this.albumList.addAll((Collection<LocalMediaAlbum>)albumList);
        Iterable $this$forEach$iv = this.albumList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalMediaAlbum mediaAlbum = (LocalMediaAlbum)element$iv;
            boolean bl = false;
            this.albumMap.put(mediaAlbum.getBucketId(), mediaAlbum);
        }
        this.notifyItemRangeChanged(0, this.albumList.size());
    }

    @NotNull
    public final List<LocalMediaAlbum> getAlbumList() {
        return this.albumList;
    }

    @Nullable
    public final LocalMediaAlbum getAlbum(long bucketId) {
        return this.albumMap.get(bucketId);
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Integer n = this.config.getLayoutSource().get((Object)LayoutSource.ALBUM_WINDOW_ITEM);
        if (n == null) {
            n = R.layout.ps_album_item;
        }
        int resource = ((Number)n).intValue();
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(resource, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)itemView, (String)"itemView");
        return new ViewHolder(itemView);
    }

    public void onBindViewHolder(@NotNull ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        LocalMediaAlbum mediaAlbum = this.albumList.get(position);
        holder.itemView.setSelected(mediaAlbum.isSelected());
        Object[] objectArray = new Object[]{mediaAlbum.getBucketDisplayName(), mediaAlbum.getTotalCount()};
        holder.getTvAlbumName().setText((CharSequence)holder.itemView.getContext().getString(R.string.ps_camera_roll_num, objectArray));
        if (MediaUtils.INSTANCE.hasMimeTypeOfAudio(mediaAlbum.getBucketDisplayMimeType())) {
            holder.getIvFirstCover().setImageResource(R.drawable.ps_audio_placeholder);
        } else {
            ImageEngine imageEngine = this.config.getImageEngine();
            if (imageEngine != null) {
                Context context = holder.itemView.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"holder.itemView.context");
                imageEngine.loadAlbumCover(context, mediaAlbum.getBucketDisplayCover(), holder.getIvFirstCover());
            }
        }
        holder.getTvSelectTag().setVisibility(mediaAlbum.isSelectedTag() ? 0 : 8);
        holder.itemView.setOnClickListener(arg_0 -> MediaAlbumAdapter.onBindViewHolder$lambda-1(this, mediaAlbum, position, arg_0));
    }

    public int getItemCount() {
        return this.albumList.size();
    }

    public final void setOnItemClickListener(@Nullable OnItemClickListener<LocalMediaAlbum> listener) {
        this.mItemClickListener = listener;
    }

    private static final void onBindViewHolder$lambda-1(MediaAlbumAdapter this$0, LocalMediaAlbum $mediaAlbum, int $position, View it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$mediaAlbum, (String)"$mediaAlbum");
            if (this$0.getItemCount() > this$0.lastSelectPosition) {
                this$0.albumList.get(this$0.lastSelectPosition).setSelected(false);
            }
            this$0.notifyItemChanged(this$0.lastSelectPosition);
            $mediaAlbum.setSelected(true);
            this$0.lastSelectPosition = $position;
            this$0.notifyItemChanged(this$0.lastSelectPosition);
            OnItemClickListener<LocalMediaAlbum> onItemClickListener = this$0.mItemClickListener;
            if (onItemClickListener == null) break block1;
            onItemClickListener.onItemClick($position, $mediaAlbum);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/luck/picture/lib/adapter/MediaAlbumAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "ivFirstCover", "Landroid/widget/ImageView;", "getIvFirstCover", "()Landroid/widget/ImageView;", "setIvFirstCover", "(Landroid/widget/ImageView;)V", "tvAlbumName", "Landroid/widget/TextView;", "getTvAlbumName", "()Landroid/widget/TextView;", "setTvAlbumName", "(Landroid/widget/TextView;)V", "tvSelectTag", "getTvSelectTag", "setTvSelectTag", "selector_release"})
    public static final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private ImageView ivFirstCover;
        @NotNull
        private TextView tvSelectTag;
        @NotNull
        private TextView tvAlbumName;

        public ViewHolder(@NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.ps_iv_first_cover);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.ps_iv_first_cover)");
            this.ivFirstCover = (ImageView)view;
            View view2 = itemView.findViewById(R.id.ps_tv_select_tag);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView.findViewById(R.id.ps_tv_select_tag)");
            this.tvSelectTag = (TextView)view2;
            View view3 = itemView.findViewById(R.id.ps_tv_album_name);
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"itemView.findViewById(R.id.ps_tv_album_name)");
            this.tvAlbumName = (TextView)view3;
        }

        @NotNull
        public final ImageView getIvFirstCover() {
            return this.ivFirstCover;
        }

        public final void setIvFirstCover(@NotNull ImageView imageView) {
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"<set-?>");
            this.ivFirstCover = imageView;
        }

        @NotNull
        public final TextView getTvSelectTag() {
            return this.tvSelectTag;
        }

        public final void setTvSelectTag(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.tvSelectTag = textView;
        }

        @NotNull
        public final TextView getTvAlbumName() {
            return this.tvAlbumName;
        }

        public final void setTvAlbumName(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.tvAlbumName = textView;
        }
    }
}

