/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PreviewAudioHolder;
import com.luck.picture.lib.adapter.PreviewImageHolder;
import com.luck.picture.lib.adapter.PreviewVideoHolder;
import com.luck.picture.lib.adapter.base.BasePreviewMediaHolder;
import com.luck.picture.lib.config.LayoutSource;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.factory.ClassFactory;
import com.luck.picture.lib.interfaces.OnLongClickListener;
import com.luck.picture.lib.provider.SelectorProviders;
import com.luck.picture.lib.utils.MediaUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003456B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\b\u0010\u001e\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\u0006\u0010*\u001a\u00020\u0015H\u0016J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0002H\u0016J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0002H\u0016J\u0014\u0010-\u001a\u00020\u001a2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0010\u0010/\u001a\u00020\u001a2\b\u00100\u001a\u0004\u0018\u00010\u000bJ\u000e\u00101\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u0018J\u0016\u00102\u001a\u00020\u001a2\u000e\u00100\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0010J\u0010\u00103\u001a\u00020\u001a2\b\u00100\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00020\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0002`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/luck/picture/lib/adapter/MediaPreviewAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/luck/picture/lib/adapter/base/BasePreviewMediaHolder;", "()V", "config", "Lcom/luck/picture/lib/config/SelectorConfig;", "holderFactory", "Lcom/luck/picture/lib/factory/ClassFactory$NewConstructorInstance;", "isFirstAttachedToWindow", "", "mClickListener", "Lcom/luck/picture/lib/adapter/MediaPreviewAdapter$OnClickListener;", "mData", "", "Lcom/luck/picture/lib/entity/LocalMedia;", "mLongClickListener", "Lcom/luck/picture/lib/interfaces/OnLongClickListener;", "mTitleChangeListener", "Lcom/luck/picture/lib/adapter/MediaPreviewAdapter$OnTitleChangeListener;", "mViewHolderCache", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "onAttachedToWindowListener", "Lcom/luck/picture/lib/adapter/MediaPreviewAdapter$OnAttachedToWindowListener;", "destroy", "", "getCurrentViewHolder", "position", "getData", "getItemCount", "getItemViewType", "onBindViewHolder", "holder", "onCreateAudioViewHolder", "inflater", "Landroid/view/LayoutInflater;", "parent", "Landroid/view/ViewGroup;", "onCreateImageViewHolder", "onCreateVideoViewHolder", "onCreateViewHolder", "viewType", "onViewAttachedToWindow", "onViewDetachedFromWindow", "setDataNotifyChanged", "data", "setOnClickListener", "l", "setOnFirstAttachedToWindowListener", "setOnLongClickListener", "setOnTitleChangeListener", "OnAttachedToWindowListener", "OnClickListener", "OnTitleChangeListener", "selector_release"})
public class MediaPreviewAdapter
extends RecyclerView.Adapter<BasePreviewMediaHolder> {
    private List<LocalMedia> mData;
    @NotNull
    private final SelectorConfig config = SelectorProviders.Companion.getInstance().getConfig();
    @NotNull
    private final ClassFactory.NewConstructorInstance holderFactory = new ClassFactory.NewConstructorInstance();
    @NotNull
    private final LinkedHashMap<Integer, BasePreviewMediaHolder> mViewHolderCache = new LinkedHashMap();
    private boolean isFirstAttachedToWindow;
    @Nullable
    private OnAttachedToWindowListener onAttachedToWindowListener;
    @Nullable
    private OnClickListener mClickListener;
    @Nullable
    private OnLongClickListener<LocalMedia> mLongClickListener;
    @Nullable
    private OnTitleChangeListener mTitleChangeListener;

    @Nullable
    public BasePreviewMediaHolder getCurrentViewHolder(int position) {
        return this.mViewHolderCache.get(position);
    }

    @NotNull
    public final List<LocalMedia> getData() {
        List<LocalMedia> list = this.mData;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mData");
            list = null;
        }
        return list;
    }

    public final void setDataNotifyChanged(@NotNull List<LocalMedia> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.mData = data;
        List<LocalMedia> list = this.mData;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mData");
            list = null;
        }
        this.notifyItemRangeChanged(0, list.size());
    }

    @NotNull
    public BasePreviewMediaHolder onCreateImageViewHolder(@NotNull LayoutInflater inflater, @NotNull ViewGroup parent) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Integer n = this.config.getLayoutSource().get((Object)LayoutSource.PREVIEW_ITEM_IMAGE);
        if (n == null) {
            n = R.layout.ps_preview_image;
        }
        int resource = ((Number)n).intValue();
        View itemView = inflater.inflate(resource, parent, false);
        Class<PreviewImageHolder> clz = this.config.getRegistry().get(PreviewImageHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)itemView, (String)"itemView");
        return this.holderFactory.create(clz, itemView);
    }

    @NotNull
    public BasePreviewMediaHolder onCreateVideoViewHolder(@NotNull LayoutInflater inflater, @NotNull ViewGroup parent) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Integer n = this.config.getLayoutSource().get((Object)LayoutSource.PREVIEW_ITEM_VIDEO);
        if (n == null) {
            n = R.layout.ps_preview_video;
        }
        int resource = ((Number)n).intValue();
        View itemView = inflater.inflate(resource, parent, false);
        Class<PreviewVideoHolder> clz = this.config.getRegistry().get(PreviewVideoHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)itemView, (String)"itemView");
        return this.holderFactory.create(clz, itemView);
    }

    @NotNull
    public BasePreviewMediaHolder onCreateAudioViewHolder(@NotNull LayoutInflater inflater, @NotNull ViewGroup parent) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Integer n = this.config.getLayoutSource().get((Object)LayoutSource.PREVIEW_ITEM_AUDIO);
        if (n == null) {
            n = R.layout.ps_preview_audio;
        }
        int resource = ((Number)n).intValue();
        View itemView = inflater.inflate(resource, parent, false);
        Class<PreviewAudioHolder> clz = this.config.getRegistry().get(PreviewAudioHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)itemView, (String)"itemView");
        return this.holderFactory.create(clz, itemView);
    }

    @NotNull
    public BasePreviewMediaHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        BasePreviewMediaHolder basePreviewMediaHolder;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        switch (viewType) {
            case 2: {
                Intrinsics.checkNotNullExpressionValue((Object)inflater, (String)"inflater");
                basePreviewMediaHolder = this.onCreateVideoViewHolder(inflater, parent);
                break;
            }
            case 3: {
                Intrinsics.checkNotNullExpressionValue((Object)inflater, (String)"inflater");
                basePreviewMediaHolder = this.onCreateAudioViewHolder(inflater, parent);
                break;
            }
            default: {
                Intrinsics.checkNotNullExpressionValue((Object)inflater, (String)"inflater");
                basePreviewMediaHolder = this.onCreateImageViewHolder(inflater, parent);
            }
        }
        BasePreviewMediaHolder holder = basePreviewMediaHolder;
        return holder;
    }

    public void onBindViewHolder(@NotNull BasePreviewMediaHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Integer n = position;
        ((Map)this.mViewHolderCache).put(n, holder);
        holder.setOnClickListener(this.mClickListener);
        holder.setOnTitleChangeListener(this.mTitleChangeListener);
        holder.setOnLongClickListener(this.mLongClickListener);
        List<LocalMedia> list = this.mData;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mData");
            list = null;
        }
        holder.bindData(list.get(position), position);
    }

    public int getItemCount() {
        List<LocalMedia> list = this.mData;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mData");
            list = null;
        }
        return list.size();
    }

    public int getItemViewType(int position) {
        String mimeType;
        List<LocalMedia> list = this.mData;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mData");
            list = null;
        }
        if (MediaUtils.INSTANCE.hasMimeTypeOfVideo(mimeType = list.get(position).getMimeType())) {
            return 2;
        }
        if (MediaUtils.INSTANCE.hasMimeTypeOfAudio(mimeType)) {
            return 3;
        }
        return 1;
    }

    public void onViewAttachedToWindow(@NotNull BasePreviewMediaHolder holder) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        holder.onViewAttachedToWindow();
        if (!this.isFirstAttachedToWindow) {
            OnAttachedToWindowListener onAttachedToWindowListener = this.onAttachedToWindowListener;
            if (onAttachedToWindowListener != null) {
                onAttachedToWindowListener.onViewAttachedToWindow(holder);
            }
            this.isFirstAttachedToWindow = true;
        }
    }

    public void onViewDetachedFromWindow(@NotNull BasePreviewMediaHolder holder) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        holder.onViewDetachedFromWindow();
    }

    public final void setOnFirstAttachedToWindowListener(@NotNull OnAttachedToWindowListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.onAttachedToWindowListener = l;
    }

    public final void setOnClickListener(@Nullable OnClickListener l) {
        this.mClickListener = l;
    }

    public final void setOnLongClickListener(@Nullable OnLongClickListener<LocalMedia> l) {
        this.mLongClickListener = l;
    }

    public final void setOnTitleChangeListener(@Nullable OnTitleChangeListener l) {
        this.mTitleChangeListener = l;
    }

    public void destroy() {
        for (Integer key : this.mViewHolderCache.keySet()) {
            BasePreviewMediaHolder basePreviewMediaHolder = this.mViewHolderCache.get(key);
            if (basePreviewMediaHolder == null) continue;
            basePreviewMediaHolder.release();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/luck/picture/lib/adapter/MediaPreviewAdapter$OnAttachedToWindowListener;", "", "onViewAttachedToWindow", "", "holder", "Lcom/luck/picture/lib/adapter/base/BasePreviewMediaHolder;", "selector_release"})
    public static interface OnAttachedToWindowListener {
        public void onViewAttachedToWindow(@NotNull BasePreviewMediaHolder var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/luck/picture/lib/adapter/MediaPreviewAdapter$OnClickListener;", "", "onClick", "", "media", "Lcom/luck/picture/lib/entity/LocalMedia;", "selector_release"})
    public static interface OnClickListener {
        public void onClick(@NotNull LocalMedia var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/luck/picture/lib/adapter/MediaPreviewAdapter$OnTitleChangeListener;", "", "onTitle", "", "title", "", "selector_release"})
    public static interface OnTitleChangeListener {
        public void onTitle(@Nullable String var1);
    }
}

