/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PreviewAudioHolder;
import com.luck.picture.lib.adapter.base.BasePreviewMediaHolder;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.player.AbsController;
import com.luck.picture.lib.player.AudioController;
import com.luck.picture.lib.player.AudioMediaPlayer;
import com.luck.picture.lib.player.IMediaPlayer;
import com.luck.picture.lib.utils.DateUtils;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.FileUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n*\u0002\u0012\u0015\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010%\u001a\u00020\u0006H\u0016J\b\u0010&\u001a\u00020\u001aH\u0016J\b\u0010'\u001a\u00020\u001aH\u0016J\b\u0010(\u001a\u00020\u001aH\u0016J\b\u0010)\u001a\u00020\u001aH\u0016J\b\u0010*\u001a\u00020\u001aH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/luck/picture/lib/adapter/PreviewAudioHolder;", "Lcom/luck/picture/lib/adapter/base/BasePreviewMediaHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "controller", "Lcom/luck/picture/lib/player/AbsController;", "getController", "()Lcom/luck/picture/lib/player/AbsController;", "setController", "(Lcom/luck/picture/lib/player/AbsController;)V", "mediaPlayer", "Lcom/luck/picture/lib/player/AudioMediaPlayer;", "getMediaPlayer", "()Lcom/luck/picture/lib/player/AudioMediaPlayer;", "setMediaPlayer", "(Lcom/luck/picture/lib/player/AudioMediaPlayer;)V", "playStateListener", "com/luck/picture/lib/adapter/PreviewAudioHolder$playStateListener$1", "Lcom/luck/picture/lib/adapter/PreviewAudioHolder$playStateListener$1;", "seekBarChangeListener", "com/luck/picture/lib/adapter/PreviewAudioHolder$seekBarChangeListener$1", "Lcom/luck/picture/lib/adapter/PreviewAudioHolder$seekBarChangeListener$1;", "tvAudioName", "Landroid/widget/TextView;", "attachComponent", "", "group", "Landroid/view/ViewGroup;", "bindData", "media", "Lcom/luck/picture/lib/entity/LocalMedia;", "position", "", "coverLayoutParams", "coverScaleType", "loadCover", "onCreateAudioController", "onDefaultAudioState", "onPlayingAudioState", "onViewAttachedToWindow", "onViewDetachedFromWindow", "release", "selector_release"})
public class PreviewAudioHolder
extends BasePreviewMediaHolder {
    @NotNull
    private TextView tvAudioName;
    @NotNull
    private AudioMediaPlayer mediaPlayer;
    @NotNull
    private AbsController controller;
    @NotNull
    private final playStateListener.1 playStateListener;
    @NotNull
    private final seekBarChangeListener.1 seekBarChangeListener;

    public PreviewAudioHolder(@NotNull View itemView) {
        Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
        super(itemView);
        View view = itemView.findViewById(R.id.tv_audio_name);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.tv_audio_name)");
        this.tvAudioName = (TextView)view;
        this.mediaPlayer = new AudioMediaPlayer();
        this.controller = this.onCreateAudioController();
        this.attachComponent((ViewGroup)itemView);
        this.playStateListener = new AbsController.OnPlayStateListener(){

            public void onPlayState(boolean isPlaying) {
            }
        };
        this.seekBarChangeListener = new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(@Nullable SeekBar seekBar, int progress, boolean fromUser) {
            }

            public void onStartTrackingTouch(@Nullable SeekBar seekBar) {
            }

            public void onStopTrackingTouch(@Nullable SeekBar seekBar) {
            }
        };
    }

    @NotNull
    public final AudioMediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public final void setMediaPlayer(@NotNull AudioMediaPlayer audioMediaPlayer) {
        Intrinsics.checkNotNullParameter((Object)audioMediaPlayer, (String)"<set-?>");
        this.mediaPlayer = audioMediaPlayer;
    }

    @NotNull
    public final AbsController getController() {
        return this.controller;
    }

    public final void setController(@NotNull AbsController absController) {
        Intrinsics.checkNotNullParameter((Object)absController, (String)"<set-?>");
        this.controller = absController;
    }

    public void attachComponent(@NotNull ViewGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        group.addView((View)this.controller);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AbsController onCreateAudioController() {
        void $this$onCreateAudioController_u24lambda_u2d1_u24lambda_u2d0;
        RelativeLayout.LayoutParams layoutParams;
        AudioController audioController;
        Context context = this.itemView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
        AudioController $this$onCreateAudioController_u24lambda_u2d1 = audioController = new AudioController(context);
        boolean bl = false;
        RelativeLayout.LayoutParams layoutParams2 = layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        AudioController audioController2 = $this$onCreateAudioController_u24lambda_u2d1;
        boolean bl2 = false;
        $this$onCreateAudioController_u24lambda_u2d1_u24lambda_u2d0.addRule(3, R.id.tv_audio_name);
        audioController2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return audioController;
    }

    @Override
    public void bindData(@NotNull LocalMedia media, int position) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        this.loadCover(media);
        String dataFormat = DateUtils.INSTANCE.getYearDataFormat(media.getDateAdded());
        String fileSize = FileUtils.INSTANCE.formatAccurateUnitFileSize(media.getSize());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(media.getDisplayName()).append("\n").append(dataFormat).append(" - ").append(fileSize);
        SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)stringBuilder.toString());
        String indexOfStr = dataFormat + " - " + fileSize;
        int startIndex = stringBuilder.indexOf(indexOfStr);
        int endOf = startIndex + indexOfStr.length();
        Context context = this.itemView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
        builder.setSpan((Object)new AbsoluteSizeSpan(DensityUtil.INSTANCE.dip2px(context, 12.0f)), startIndex, endOf, 17);
        builder.setSpan((Object)new ForegroundColorSpan(-10132123), startIndex, endOf, 17);
        this.tvAudioName.setText((CharSequence)builder);
        this.controller.setDataSource(media);
        this.controller.setIMediaPlayer(this.mediaPlayer);
        this.controller.setOnPlayStateListener(this.playStateListener);
        this.controller.setOnSeekBarChangeListener(this.seekBarChangeListener);
        this.itemView.setOnClickListener(arg_0 -> PreviewAudioHolder.bindData$lambda-2(this, media, arg_0));
        this.itemView.setOnLongClickListener(arg_0 -> PreviewAudioHolder.bindData$lambda-3(this, position, media, arg_0));
    }

    public void onPlayingAudioState() {
        this.controller.start();
    }

    public void onDefaultAudioState() {
        this.controller.stop(true);
    }

    @Override
    public void loadCover(@NotNull LocalMedia media) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        this.getImageCover().setImageResource(R.drawable.ps_ic_audio_play_cover);
    }

    @Override
    public void coverScaleType(@NotNull LocalMedia media) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
    }

    @Override
    public void coverLayoutParams(@NotNull LocalMedia media) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
    }

    @Override
    public void onViewAttachedToWindow() {
        this.mediaPlayer.initMediaPlayer();
        this.mediaPlayer.setOnPreparedListener(new IMediaPlayer.OnPreparedListener(this){
            final /* synthetic */ PreviewAudioHolder this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPrepared(@Nullable IMediaPlayer mp) {
                this.this$0.getMediaPlayer().start();
                this.this$0.onPlayingAudioState();
            }
        });
        this.mediaPlayer.setOnCompletionListener(new IMediaPlayer.OnCompletionListener(this){
            final /* synthetic */ PreviewAudioHolder this$0;
            {
                this.this$0 = $receiver;
            }

            public void onCompletion(@Nullable IMediaPlayer mp) {
                this.this$0.getMediaPlayer().stop();
                this.this$0.getMediaPlayer().reset();
                this.this$0.onDefaultAudioState();
            }
        });
        this.mediaPlayer.setOnErrorListener(new IMediaPlayer.OnErrorListener(this){
            final /* synthetic */ PreviewAudioHolder this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onError(@Nullable IMediaPlayer mp, int what, int extra) {
                this.this$0.onDefaultAudioState();
                return false;
            }
        });
    }

    @Override
    public void onViewDetachedFromWindow() {
        this.release();
    }

    @Override
    public void release() {
        this.mediaPlayer.release();
        this.mediaPlayer.setOnErrorListener(null);
        this.mediaPlayer.setOnCompletionListener(null);
        this.mediaPlayer.setOnPreparedListener(null);
        this.controller.setOnPlayStateListener(null);
        this.controller.setOnSeekBarChangeListener(null);
        this.onDefaultAudioState();
    }

    private static final void bindData$lambda-2(PreviewAudioHolder this$0, LocalMedia $media, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$media, (String)"$media");
        this$0.setClickEvent($media);
    }

    private static final boolean bindData$lambda-3(PreviewAudioHolder this$0, int $position, LocalMedia $media, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$media, (String)"$media");
        this$0.setLongClickEvent(this$0, $position, $media);
        return false;
    }
}

