/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.luck.picture.lib.adapter.base.BasePreviewMediaHolder;
import com.luck.picture.lib.engine.ImageEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.utils.BitmapUtils;
import com.luck.picture.lib.utils.MediaUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/luck/picture/lib/adapter/PreviewImageHolder;", "Lcom/luck/picture/lib/adapter/base/BasePreviewMediaHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "coverLayoutParams", "", "media", "Lcom/luck/picture/lib/entity/LocalMedia;", "coverScaleType", "loadCover", "onViewAttachedToWindow", "onViewDetachedFromWindow", "release", "selector_release"})
public class PreviewImageHolder
extends BasePreviewMediaHolder {
    public PreviewImageHolder(@NotNull View itemView) {
        Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
        super(itemView);
    }

    @Override
    public void onViewAttachedToWindow() {
    }

    @Override
    public void onViewDetachedFromWindow() {
    }

    @Override
    public void release() {
    }

    @Override
    public void coverLayoutParams(@NotNull LocalMedia media) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        if (!this.getConfig().isPreviewZoomEffect() && this.getScreenWidth() < this.getScreenHeight() && media.getWidth() > 0 && media.getHeight() > 0) {
            FrameLayout.LayoutParams layoutParams;
            ViewGroup.LayoutParams layoutParams2 = this.getImageCover().getLayoutParams();
            if (layoutParams2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
            }
            FrameLayout.LayoutParams $this$coverLayoutParams_u24lambda_u2d0 = layoutParams = (FrameLayout.LayoutParams)layoutParams2;
            boolean bl = false;
            $this$coverLayoutParams_u24lambda_u2d0.width = this.getScreenWidth();
            $this$coverLayoutParams_u24lambda_u2d0.height = this.getScreenAppInHeight();
            $this$coverLayoutParams_u24lambda_u2d0.gravity = 17;
        }
    }

    @Override
    public void loadCover(@NotNull LocalMedia media) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)media, (String)"media");
                int[] size = this.getRealSizeFromMedia(media);
                int[] mediaComputeSize = BitmapUtils.INSTANCE.getComputeImageSize(size[0], size[1]);
                int width = mediaComputeSize[0];
                int height = mediaComputeSize[1];
                if (width <= 0 || height <= 0) break block0;
                ImageEngine imageEngine = this.getConfig().getImageEngine();
                if (imageEngine == null) break block1;
                Context context = this.itemView.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
                imageEngine.loadImage(context, media.getAvailablePath(), width, height, this.getImageCover());
                break block1;
            }
            ImageEngine imageEngine = this.getConfig().getImageEngine();
            if (imageEngine == null) break block1;
            Context context = this.itemView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
            imageEngine.loadImage(context, media.getAvailablePath(), this.getImageCover());
        }
    }

    @Override
    public void coverScaleType(@NotNull LocalMedia media) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        if (MediaUtils.INSTANCE.isLongImage(media.getWidth(), media.getHeight())) {
            this.getImageCover().setScaleType(ImageView.ScaleType.CENTER_CROP);
        } else {
            this.getImageCover().setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
    }
}

