/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.adapter.CameraViewHolder;
import com.luck.picture.lib.adapter.ListMediaViewHolder;
import com.luck.picture.lib.adapter.base.BaseListViewHolder;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.factory.ClassFactory;
import com.luck.picture.lib.interfaces.OnMediaItemClickListener;
import com.luck.picture.lib.provider.SelectorProviders;
import com.luck.picture.lib.utils.MediaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001:B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u001d\u001a\u00020\u001e2\u000e\b\u0001\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ \u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%H\u0016J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\b\u0010'\u001a\u00020%H\u0016J\u0010\u0010(\u001a\u00020%2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H$J\u0018\u0010/\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H$J\u0018\u00100\u001a\u00020\"2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H$J\u0018\u00101\u001a\u00020\"2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H$J\u0018\u00102\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u00103\u001a\u00020%H\u0016J\u0018\u00104\u001a\u00020\u001e2\u000e\b\u0001\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J\u000e\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\rJ\u0010\u00107\u001a\u00020\u001e2\b\u00108\u001a\u0004\u0018\u00010\u0012J\u0010\u00109\u001a\u00020\u001e2\b\u00108\u001a\u0004\u0018\u00010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006;"}, d2={"Lcom/luck/picture/lib/adapter/base/BaseMediaListAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/luck/picture/lib/adapter/base/BaseListViewHolder;", "()V", "config", "Lcom/luck/picture/lib/config/SelectorConfig;", "getConfig", "()Lcom/luck/picture/lib/config/SelectorConfig;", "holderFactory", "Lcom/luck/picture/lib/factory/ClassFactory$NewConstructorInstance;", "getHolderFactory", "()Lcom/luck/picture/lib/factory/ClassFactory$NewConstructorInstance;", "isDisplayCamera", "", "mData", "", "Lcom/luck/picture/lib/entity/LocalMedia;", "mGetSelectResultListener", "Lcom/luck/picture/lib/adapter/base/BaseMediaListAdapter$OnGetSelectResultListener;", "getMGetSelectResultListener", "()Lcom/luck/picture/lib/adapter/base/BaseMediaListAdapter$OnGetSelectResultListener;", "setMGetSelectResultListener", "(Lcom/luck/picture/lib/adapter/base/BaseMediaListAdapter$OnGetSelectResultListener;)V", "mItemClickListener", "Lcom/luck/picture/lib/interfaces/OnMediaItemClickListener;", "getMItemClickListener", "()Lcom/luck/picture/lib/interfaces/OnMediaItemClickListener;", "setMItemClickListener", "(Lcom/luck/picture/lib/interfaces/OnMediaItemClickListener;)V", "addAllDataNotifyChanged", "", "data", "bindData", "holder", "Lcom/luck/picture/lib/adapter/ListMediaViewHolder;", "media", "position", "", "getData", "getItemCount", "getItemViewType", "onBindViewHolder", "onCreateAudioViewHolder", "inflater", "Landroid/view/LayoutInflater;", "parent", "Landroid/view/ViewGroup;", "onCreateCameraViewHolder", "onCreateImageViewHolder", "onCreateVideoViewHolder", "onCreateViewHolder", "viewType", "setDataNotifyChanged", "setDisplayCamera", "displayCamera", "setOnGetSelectResultListener", "listener", "setOnItemClickListener", "OnGetSelectResultListener", "selector_release"})
public abstract class BaseMediaListAdapter
extends RecyclerView.Adapter<BaseListViewHolder> {
    @NotNull
    private final SelectorConfig config = SelectorProviders.Companion.getInstance().getConfig();
    @NotNull
    private final ClassFactory.NewConstructorInstance holderFactory = new ClassFactory.NewConstructorInstance();
    @NotNull
    private List<LocalMedia> mData = new ArrayList();
    private boolean isDisplayCamera;
    @Nullable
    private OnMediaItemClickListener mItemClickListener;
    @Nullable
    private OnGetSelectResultListener mGetSelectResultListener;

    @NotNull
    public final SelectorConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final ClassFactory.NewConstructorInstance getHolderFactory() {
        return this.holderFactory;
    }

    @NotNull
    public final List<LocalMedia> getData() {
        return this.mData;
    }

    public boolean isDisplayCamera() {
        return this.isDisplayCamera;
    }

    public final void setDisplayCamera(boolean displayCamera) {
        this.isDisplayCamera = displayCamera;
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public final void setDataNotifyChanged(@NotNull List<LocalMedia> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.mData.clear();
        this.mData.addAll((Collection<LocalMedia>)data);
        this.notifyDataSetChanged();
    }

    public final void addAllDataNotifyChanged(@NotNull List<LocalMedia> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        int positionStart = this.mData.size();
        this.mData.addAll((Collection<LocalMedia>)data);
        int itemCount = this.mData.size();
        this.notifyItemRangeChanged(positionStart, itemCount);
    }

    @NotNull
    public BaseListViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        BaseListViewHolder baseListViewHolder;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        switch (viewType) {
            case -1: {
                Intrinsics.checkNotNullExpressionValue((Object)inflater, (String)"inflater");
                baseListViewHolder = this.onCreateCameraViewHolder(inflater, parent);
                break;
            }
            case 2: {
                Intrinsics.checkNotNullExpressionValue((Object)inflater, (String)"inflater");
                baseListViewHolder = this.onCreateVideoViewHolder(inflater, parent);
                break;
            }
            case 3: {
                Intrinsics.checkNotNullExpressionValue((Object)inflater, (String)"inflater");
                baseListViewHolder = this.onCreateAudioViewHolder(inflater, parent);
                break;
            }
            default: {
                Intrinsics.checkNotNullExpressionValue((Object)inflater, (String)"inflater");
                baseListViewHolder = this.onCreateImageViewHolder(inflater, parent);
            }
        }
        BaseListViewHolder holder = baseListViewHolder;
        return holder;
    }

    public void onBindViewHolder(@NotNull BaseListViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.setOnItemClickListener(this.mItemClickListener);
        holder.setOnGetSelectResultListener(this.mGetSelectResultListener);
        if (this.getItemViewType(position) == -1) {
            ((CameraViewHolder)holder).bindData(position);
        } else {
            int adapterPosition = this.isDisplayCamera ? position - 1 : position;
            this.bindData((ListMediaViewHolder)holder, this.mData.get(adapterPosition), adapterPosition);
        }
    }

    public void bindData(@NotNull ListMediaViewHolder holder, @NotNull LocalMedia media, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        holder.bindData(this.mData.get(position), position);
    }

    @NotNull
    protected abstract BaseListViewHolder onCreateCameraViewHolder(@NotNull LayoutInflater var1, @NotNull ViewGroup var2);

    @NotNull
    protected abstract ListMediaViewHolder onCreateImageViewHolder(@NotNull LayoutInflater var1, @NotNull ViewGroup var2);

    @NotNull
    protected abstract ListMediaViewHolder onCreateVideoViewHolder(@NotNull LayoutInflater var1, @NotNull ViewGroup var2);

    @NotNull
    protected abstract ListMediaViewHolder onCreateAudioViewHolder(@NotNull LayoutInflater var1, @NotNull ViewGroup var2);

    public int getItemViewType(int position) {
        int n;
        if (this.isDisplayCamera && position == 0) {
            n = -1;
        } else {
            int adapterPosition = this.isDisplayCamera ? position - 1 : position;
            String mimeType = this.mData.get(adapterPosition).getMimeType();
            if (MediaUtils.INSTANCE.hasMimeTypeOfVideo(mimeType)) {
                return 2;
            }
            if (MediaUtils.INSTANCE.hasMimeTypeOfAudio(mimeType)) {
                return 3;
            }
            n = 1;
        }
        return n;
    }

    public int getItemCount() {
        return this.isDisplayCamera ? this.mData.size() + 1 : this.mData.size();
    }

    @Nullable
    public final OnMediaItemClickListener getMItemClickListener() {
        return this.mItemClickListener;
    }

    public final void setMItemClickListener(@Nullable OnMediaItemClickListener onMediaItemClickListener) {
        this.mItemClickListener = onMediaItemClickListener;
    }

    public final void setOnItemClickListener(@Nullable OnMediaItemClickListener listener) {
        this.mItemClickListener = listener;
    }

    @Nullable
    public final OnGetSelectResultListener getMGetSelectResultListener() {
        return this.mGetSelectResultListener;
    }

    public final void setMGetSelectResultListener(@Nullable OnGetSelectResultListener onGetSelectResultListener) {
        this.mGetSelectResultListener = onGetSelectResultListener;
    }

    public final void setOnGetSelectResultListener(@Nullable OnGetSelectResultListener listener) {
        this.mGetSelectResultListener = listener;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&\u00a8\u0006\u0005"}, d2={"Lcom/luck/picture/lib/adapter/base/BaseMediaListAdapter$OnGetSelectResultListener;", "", "onSelectResult", "", "Lcom/luck/picture/lib/entity/LocalMedia;", "selector_release"})
    public static interface OnGetSelectResultListener {
        @NotNull
        public List<LocalMedia> onSelectResult();
    }
}

