/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.base;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.MediaPreviewAdapter;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnLongClickListener;
import com.luck.picture.lib.provider.SelectorProviders;
import com.luck.picture.lib.utils.DensityUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0015H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011H&J\u0010\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011H&J\u0010\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u0011H\u0016J\u0010\u0010(\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011H&J\b\u0010)\u001a\u00020!H&J\b\u0010*\u001a\u00020!H&J\b\u0010+\u001a\u00020!H&J\u0010\u0010,\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011H\u0016J \u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0011H\u0016J\u0010\u0010/\u001a\u00020!2\b\u00100\u001a\u0004\u0018\u00010\u000eJ\u0016\u00101\u001a\u00020!2\u000e\u00100\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010J\u0010\u00102\u001a\u00020!2\b\u00100\u001a\u0004\u0018\u00010\u0013J\u0012\u00103\u001a\u00020!2\b\u00104\u001a\u0004\u0018\u000105H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019\u00a8\u00066"}, d2={"Lcom/luck/picture/lib/adapter/base/BasePreviewMediaHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "config", "Lcom/luck/picture/lib/config/SelectorConfig;", "getConfig", "()Lcom/luck/picture/lib/config/SelectorConfig;", "imageCover", "Landroid/widget/ImageView;", "getImageCover", "()Landroid/widget/ImageView;", "onClickListener", "Lcom/luck/picture/lib/adapter/MediaPreviewAdapter$OnClickListener;", "onLongClickListener", "Lcom/luck/picture/lib/interfaces/OnLongClickListener;", "Lcom/luck/picture/lib/entity/LocalMedia;", "onTitleChangeListener", "Lcom/luck/picture/lib/adapter/MediaPreviewAdapter$OnTitleChangeListener;", "screenAppInHeight", "", "getScreenAppInHeight", "()I", "setScreenAppInHeight", "(I)V", "screenHeight", "getScreenHeight", "setScreenHeight", "screenWidth", "getScreenWidth", "setScreenWidth", "bindData", "", "media", "position", "coverLayoutParams", "coverScaleType", "getRealSizeFromMedia", "", "loadCover", "onViewAttachedToWindow", "onViewDetachedFromWindow", "release", "setClickEvent", "setLongClickEvent", "holder", "setOnClickListener", "l", "setOnLongClickListener", "setOnTitleChangeListener", "setPreviewVideoTitle", "title", "", "selector_release"})
public abstract class BasePreviewMediaHolder
extends RecyclerView.ViewHolder {
    @NotNull
    private final SelectorConfig config;
    private int screenWidth;
    private int screenHeight;
    private int screenAppInHeight;
    @NotNull
    private final ImageView imageCover;
    @Nullable
    private MediaPreviewAdapter.OnClickListener onClickListener;
    @Nullable
    private OnLongClickListener<LocalMedia> onLongClickListener;
    @Nullable
    private MediaPreviewAdapter.OnTitleChangeListener onTitleChangeListener;

    public BasePreviewMediaHolder(@NotNull View itemView) {
        Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
        super(itemView);
        this.config = SelectorProviders.Companion.getInstance().getConfig();
        Context context = itemView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
        this.screenWidth = DensityUtil.INSTANCE.getRealScreenWidth(context);
        Context context2 = itemView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"itemView.context");
        this.screenHeight = DensityUtil.INSTANCE.getScreenHeight(context2);
        Context context3 = itemView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"itemView.context");
        this.screenAppInHeight = DensityUtil.INSTANCE.getRealScreenHeight(context3);
        View view = itemView.findViewById(R.id.iv_preview_cover);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.iv_preview_cover)");
        this.imageCover = (ImageView)view;
    }

    @NotNull
    public final SelectorConfig getConfig() {
        return this.config;
    }

    public final int getScreenWidth() {
        return this.screenWidth;
    }

    public final void setScreenWidth(int n) {
        this.screenWidth = n;
    }

    public final int getScreenHeight() {
        return this.screenHeight;
    }

    public final void setScreenHeight(int n) {
        this.screenHeight = n;
    }

    public final int getScreenAppInHeight() {
        return this.screenAppInHeight;
    }

    public final void setScreenAppInHeight(int n) {
        this.screenAppInHeight = n;
    }

    @NotNull
    public final ImageView getImageCover() {
        return this.imageCover;
    }

    @NotNull
    public int[] getRealSizeFromMedia(@NotNull LocalMedia media) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        if ((media.isCrop() || media.isEditor()) && media.getCropWidth() > 0 && media.getCropHeight() > 0) {
            int[] nArray2 = new int[]{media.getCropWidth(), media.getCropHeight()};
            nArray = nArray2;
        } else {
            int[] nArray3 = new int[]{media.getWidth(), media.getHeight()};
            nArray = nArray3;
        }
        return nArray;
    }

    public abstract void loadCover(@NotNull LocalMedia var1);

    public abstract void coverScaleType(@NotNull LocalMedia var1);

    public abstract void coverLayoutParams(@NotNull LocalMedia var1);

    public abstract void onViewAttachedToWindow();

    public abstract void onViewDetachedFromWindow();

    public void bindData(@NotNull LocalMedia media, int position) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        this.loadCover(media);
        this.coverScaleType(media);
        this.coverLayoutParams(media);
        this.imageCover.setOnClickListener(arg_0 -> BasePreviewMediaHolder.bindData$lambda-0(this, media, arg_0));
        this.imageCover.setOnLongClickListener(arg_0 -> BasePreviewMediaHolder.bindData$lambda-1(this, position, media, arg_0));
    }

    public abstract void release();

    public final void setOnClickListener(@Nullable MediaPreviewAdapter.OnClickListener l) {
        this.onClickListener = l;
    }

    public void setClickEvent(@NotNull LocalMedia media) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)media, (String)"media");
            MediaPreviewAdapter.OnClickListener onClickListener = this.onClickListener;
            if (onClickListener == null) break block0;
            onClickListener.onClick(media);
        }
    }

    public final void setOnLongClickListener(@Nullable OnLongClickListener<LocalMedia> l) {
        this.onLongClickListener = l;
    }

    public void setLongClickEvent(@NotNull RecyclerView.ViewHolder holder, int position, @NotNull LocalMedia media) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)media, (String)"media");
            OnLongClickListener<LocalMedia> onLongClickListener = this.onLongClickListener;
            if (onLongClickListener == null) break block0;
            onLongClickListener.onLongClick(holder, position, media);
        }
    }

    public final void setOnTitleChangeListener(@Nullable MediaPreviewAdapter.OnTitleChangeListener l) {
        this.onTitleChangeListener = l;
    }

    public void setPreviewVideoTitle(@Nullable String title) {
        block0: {
            MediaPreviewAdapter.OnTitleChangeListener onTitleChangeListener = this.onTitleChangeListener;
            if (onTitleChangeListener == null) break block0;
            onTitleChangeListener.onTitle(title);
        }
    }

    private static final void bindData$lambda-0(BasePreviewMediaHolder this$0, LocalMedia $media, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$media, (String)"$media");
        this$0.setClickEvent($media);
    }

    private static final boolean bindData$lambda-1(BasePreviewMediaHolder this$0, int $position, LocalMedia $media, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$media, (String)"$media");
        this$0.setLongClickEvent(this$0, $position, $media);
        return false;
    }
}

