/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.animators;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.animators.ViewHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H$\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bH\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0016J\u000e\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\bJ\u000e\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u0006J\u000e\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\nJ\u000e\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\bJ\u0010\u00100\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/luck/picture/lib/animators/BaseAnimationAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "wrapAdapter", "(Landroidx/recyclerview/widget/RecyclerView$Adapter;)V", "isFirstOnly", "", "mDuration", "", "mInterpolator", "Landroid/view/animation/Interpolator;", "mLastPosition", "getAnimators", "", "Landroid/animation/Animator;", "view", "Landroid/view/View;", "(Landroid/view/View;)[Landroid/animation/Animator;", "getItemCount", "getItemId", "", "position", "getItemViewType", "onAttachedToRecyclerView", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onDetachedFromRecyclerView", "onViewAttachedToWindow", "onViewDetachedFromWindow", "onViewRecycled", "registerAdapterDataObserver", "observer", "Landroidx/recyclerview/widget/RecyclerView$AdapterDataObserver;", "setDuration", "duration", "setFirstOnly", "firstOnly", "setInterpolator", "interpolator", "setStartPosition", "start", "unregisterAdapterDataObserver", "selector_release"})
public abstract class BaseAnimationAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private final RecyclerView.Adapter<RecyclerView.ViewHolder> wrapAdapter;
    private int mDuration;
    @NotNull
    private Interpolator mInterpolator;
    private int mLastPosition;
    private boolean isFirstOnly;

    public BaseAnimationAdapter(@NotNull RecyclerView.Adapter<RecyclerView.ViewHolder> wrapAdapter) {
        Intrinsics.checkNotNullParameter(wrapAdapter, (String)"wrapAdapter");
        this.wrapAdapter = wrapAdapter;
        this.mDuration = 250;
        this.mInterpolator = (Interpolator)new LinearInterpolator();
        this.mLastPosition = -1;
        this.isFirstOnly = true;
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        RecyclerView.ViewHolder viewHolder = this.wrapAdapter.onCreateViewHolder(parent, viewType);
        Intrinsics.checkNotNullExpressionValue((Object)viewHolder, (String)"wrapAdapter.onCreateViewHolder(parent, viewType)");
        return viewHolder;
    }

    public void registerAdapterDataObserver(@NotNull RecyclerView.AdapterDataObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        super.registerAdapterDataObserver(observer);
        this.wrapAdapter.registerAdapterDataObserver(observer);
    }

    public void unregisterAdapterDataObserver(@NotNull RecyclerView.AdapterDataObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        super.unregisterAdapterDataObserver(observer);
        this.wrapAdapter.unregisterAdapterDataObserver(observer);
    }

    public void onAttachedToRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        super.onAttachedToRecyclerView(recyclerView);
        this.wrapAdapter.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        super.onDetachedFromRecyclerView(recyclerView);
        this.wrapAdapter.onDetachedFromRecyclerView(recyclerView);
    }

    public void onViewAttachedToWindow(@NotNull RecyclerView.ViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super.onViewAttachedToWindow(holder);
        this.wrapAdapter.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(@NotNull RecyclerView.ViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super.onViewDetachedFromWindow(holder);
        this.wrapAdapter.onViewDetachedFromWindow(holder);
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.wrapAdapter.onBindViewHolder(holder, position);
        int adapterPosition = holder.getAdapterPosition();
        if (!this.isFirstOnly || adapterPosition > this.mLastPosition) {
            View view = holder.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"holder.itemView");
            for (Animator anim2 : this.getAnimators(view)) {
                anim2.setDuration((long)this.mDuration).start();
                anim2.setInterpolator((TimeInterpolator)this.mInterpolator);
            }
            this.mLastPosition = adapterPosition;
        } else {
            View view = holder.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"holder.itemView");
            ViewHelper.INSTANCE.clear(view);
        }
    }

    public void onViewRecycled(@NotNull RecyclerView.ViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.wrapAdapter.onViewRecycled(holder);
        super.onViewRecycled(holder);
    }

    public int getItemCount() {
        return this.wrapAdapter.getItemCount();
    }

    public final void setDuration(int duration) {
        this.mDuration = duration;
    }

    public final void setInterpolator(@NotNull Interpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        this.mInterpolator = interpolator;
    }

    public final void setStartPosition(int start) {
        this.mLastPosition = start;
    }

    @NotNull
    protected abstract Animator[] getAnimators(@NotNull View var1);

    public final void setFirstOnly(boolean firstOnly) {
        this.isFirstOnly = firstOnly;
    }

    public int getItemViewType(int position) {
        return this.wrapAdapter.getItemViewType(position);
    }

    public long getItemId(int position) {
        return this.wrapAdapter.getItemId(position);
    }
}

