/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.base;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.SavedStateViewModelFactory;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.savedstate.SavedStateRegistryOwner;
import com.luck.picture.lib.R;
import com.luck.picture.lib.SelectorCameraFragment;
import com.luck.picture.lib.SelectorExternalPreviewFragment;
import com.luck.picture.lib.SelectorMainFragment;
import com.luck.picture.lib.SelectorPreviewFragment;
import com.luck.picture.lib.SelectorSupporterActivity;
import com.luck.picture.lib.SelectorSystemFragment;
import com.luck.picture.lib.SelectorTransparentActivity;
import com.luck.picture.lib.app.SelectorAppMaster;
import com.luck.picture.lib.app.SelectorEngine;
import com.luck.picture.lib.config.MediaType;
import com.luck.picture.lib.config.SelectionMode;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.dialog.PhotoItemSelectedDialog;
import com.luck.picture.lib.dialog.PictureLoadingDialog;
import com.luck.picture.lib.dialog.ReminderDialog;
import com.luck.picture.lib.engine.CropEngine;
import com.luck.picture.lib.engine.MediaConverterEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.factory.ClassFactory;
import com.luck.picture.lib.helper.ActivityCompatHelper;
import com.luck.picture.lib.immersive.ImmersiveManager;
import com.luck.picture.lib.interfaces.OnCallbackListener;
import com.luck.picture.lib.interfaces.OnConfirmListener;
import com.luck.picture.lib.interfaces.OnCustomCameraListener;
import com.luck.picture.lib.interfaces.OnCustomLoadingListener;
import com.luck.picture.lib.interfaces.OnFragmentLifecycleListener;
import com.luck.picture.lib.interfaces.OnItemClickListener;
import com.luck.picture.lib.interfaces.OnPermissionApplyListener;
import com.luck.picture.lib.interfaces.OnPermissionDeniedListener;
import com.luck.picture.lib.interfaces.OnPermissionDescriptionListener;
import com.luck.picture.lib.interfaces.OnRecordAudioListener;
import com.luck.picture.lib.interfaces.OnReplaceFileNameListener;
import com.luck.picture.lib.interfaces.OnResultCallbackListener;
import com.luck.picture.lib.interfaces.OnSelectFilterListener;
import com.luck.picture.lib.language.Language;
import com.luck.picture.lib.language.PictureLanguageUtils;
import com.luck.picture.lib.media.ScanListener;
import com.luck.picture.lib.permissions.OnPermissionResultListener;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.permissions.PermissionUtil;
import com.luck.picture.lib.provider.SelectorProviders;
import com.luck.picture.lib.provider.TempDataProvider;
import com.luck.picture.lib.registry.ImageCaptureComponent;
import com.luck.picture.lib.registry.SoundCaptureComponent;
import com.luck.picture.lib.registry.VideoCaptureComponent;
import com.luck.picture.lib.service.ForegroundService;
import com.luck.picture.lib.utils.FileUtils;
import com.luck.picture.lib.utils.MediaStoreUtils;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.SpUtils;
import com.luck.picture.lib.viewmodel.GlobalViewModel;
import com.luck.picture.lib.viewmodel.SelectorViewModel;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0012H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0012H\u0016J\u0010\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020#H\u0016J\b\u0010,\u001a\u00020!H\u0016J\u0006\u0010-\u001a\u00020!J\b\u0010.\u001a\u00020/H&J\b\u00100\u001a\u00020&H&J\f\u00101\u001a\b\u0012\u0004\u0012\u00020(02J\u001b\u00103\u001a\u00020!2\f\u00104\u001a\b\u0012\u0004\u0012\u00020/05H\u0016\u00a2\u0006\u0002\u00106J\u001b\u00107\u001a\u00020!2\f\u00104\u001a\b\u0012\u0004\u0012\u00020/05H\u0016\u00a2\u0006\u0002\u00106J\b\u00108\u001a\u00020!H\u0016J\b\u00109\u001a\u00020!H\u0016J\b\u0010:\u001a\u00020\u0012H\u0016J\b\u0010;\u001a\u00020\u0012H\u0016J\b\u0010<\u001a\u00020\u0012H\u0016J \u0010=\u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u00010>2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020(02H\u0016J \u0010@\u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u00010>2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020(02H\u0016J\"\u0010A\u001a\u00020!2\u0006\u0010B\u001a\u00020&2\u0006\u0010C\u001a\u00020&2\b\u0010+\u001a\u0004\u0018\u00010>H\u0016J\u0010\u0010D\u001a\u00020!2\u0006\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020!H\u0016J\u0018\u0010H\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0012H\u0016J\u0010\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u00020KH\u0016J\b\u0010L\u001a\u00020!H\u0016J\"\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010O\u001a\u00020&2\u0006\u0010P\u001a\u00020\u00122\u0006\u0010Q\u001a\u00020&H\u0016J&\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010T\u001a\u00020U2\b\u0010V\u001a\u0004\u0018\u00010W2\b\u0010X\u001a\u0004\u0018\u00010YH\u0016J\b\u0010Z\u001a\u00020!H\u0016J\u0012\u0010[\u001a\u00020!2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J-\u0010\\\u001a\u00020!2\u0006\u0010B\u001a\u00020&2\u000e\u0010]\u001a\n\u0012\u0006\b\u0001\u0012\u00020/052\u0006\u0010^\u001a\u00020_H\u0016\u00a2\u0006\u0002\u0010`J\u0018\u0010a\u001a\u00020!2\u0006\u0010B\u001a\u00020&2\u0006\u0010C\u001a\u00020&H\u0016J\u0010\u0010b\u001a\u00020!2\u0006\u0010c\u001a\u00020YH\u0016J\b\u0010d\u001a\u00020!H\u0016J\u0012\u0010e\u001a\u00020!2\b\u0010f\u001a\u0004\u0018\u00010(H\u0016J\u001a\u0010g\u001a\u00020!2\u0006\u0010h\u001a\u00020S2\b\u0010X\u001a\u0004\u0018\u00010YH\u0016J\b\u0010i\u001a\u00020!H\u0016J\b\u0010j\u001a\u00020!H\u0016J\b\u0010k\u001a\u00020!H\u0016J\b\u0010l\u001a\u00020!H\u0002J\u0012\u0010m\u001a\u00020!2\b\u0010n\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010o\u001a\u00020!H\u0016J\b\u0010p\u001a\u00020!H\u0002J\u001b\u0010q\u001a\u00020!2\f\u00104\u001a\b\u0012\u0004\u0012\u00020/05H\u0016\u00a2\u0006\u0002\u00106J\u0006\u0010r\u001a\u00020!J#\u0010s\u001a\u00020!2\u0006\u0010t\u001a\u00020\u00122\f\u00104\u001a\b\u0012\u0004\u0012\u00020/05H\u0016\u00a2\u0006\u0002\u0010uJ\u0010\u0010v\u001a\u00020!2\u0006\u0010w\u001a\u00020/H\u0002J\b\u0010x\u001a\u00020!H\u0016J\u0010\u0010y\u001a\u00020!2\u0006\u0010z\u001a\u00020{H\u0016J\b\u0010|\u001a\u00020!H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u001c8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0010\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006}"}, d2={"Lcom/luck/picture/lib/base/BaseSelectorFragment;", "Landroidx/fragment/app/Fragment;", "()V", "config", "Lcom/luck/picture/lib/config/SelectorConfig;", "getConfig", "()Lcom/luck/picture/lib/config/SelectorConfig;", "factory", "Lcom/luck/picture/lib/factory/ClassFactory$NewInstance;", "getFactory", "()Lcom/luck/picture/lib/factory/ClassFactory$NewInstance;", "globalViewMode", "Lcom/luck/picture/lib/viewmodel/GlobalViewModel;", "getGlobalViewMode", "()Lcom/luck/picture/lib/viewmodel/GlobalViewModel;", "globalViewMode$delegate", "Lkotlin/Lazy;", "isSavedInstanceState", "", "()Z", "setSavedInstanceState", "(Z)V", "mLoadingDialog", "Landroid/app/Dialog;", "mPermissionResultListener", "Lcom/luck/picture/lib/permissions/OnPermissionResultListener;", "tipsDialog", "viewModel", "Lcom/luck/picture/lib/viewmodel/SelectorViewModel;", "getViewModel", "()Lcom/luck/picture/lib/viewmodel/SelectorViewModel;", "viewModel$delegate", "analysisCameraData", "", "uri", "Landroid/net/Uri;", "checkCompleteValidity", "confirmSelect", "", "media", "Lcom/luck/picture/lib/entity/LocalMedia;", "isSelected", "copyAudioUriToFile", "data", "createLoadingDialog", "dismissLoading", "getFragmentTag", "", "getResourceId", "getSelectResult", "", "handlePermissionDenied", "permission", "", "([Ljava/lang/String;)V", "handlePermissionSettingResult", "handleSelectResult", "initAppLanguage", "isCrop", "isNormalDefaultEnter", "isRootExit", "mergeMultipleCrop", "Landroid/content/Intent;", "selectResult", "mergeSingleCrop", "onActivityResult", "requestCode", "resultCode", "onAttach", "context", "Landroid/content/Context;", "onBackPressed", "onCheckSelectValidity", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onConfirmComplete", "onCreateAnimation", "Landroid/view/animation/Animation;", "transit", "enter", "nextAnim", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onKeyBackAction", "onMergeCameraResult", "onRequestPermissionsResult", "permissions", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onResultCanceled", "onSaveInstanceState", "outState", "onSelectedOnlyCameraDialog", "onSelectionResultChange", "change", "onViewCreated", "view", "openSelectedCamera", "recordVideo", "restoreEngine", "setFragmentKeyBackListener", "setOnPermissionResultListener", "listener", "setRequestedOrientation", "setTranslucentStatusBar", "showCustomPermissionApply", "showLoading", "showPermissionDescription", "isDisplay", "(Z[Ljava/lang/String;)V", "showTipsDialog", "tips", "soundRecording", "startCameraAction", "mode", "Lcom/luck/picture/lib/config/MediaType;", "takePictures", "selector_release"})
public abstract class BaseSelectorFragment
extends Fragment {
    @Nullable
    private Dialog mLoadingDialog;
    @Nullable
    private Dialog tipsDialog;
    @NotNull
    private final SelectorConfig config = SelectorProviders.Companion.getInstance().getConfig();
    @NotNull
    private final ClassFactory.NewInstance factory = new ClassFactory.NewInstance();
    private boolean isSavedInstanceState;
    @NotNull
    private final Lazy viewModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SelectorViewModel>(this){
        final /* synthetic */ BaseSelectorFragment this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final SelectorViewModel invoke() {
            FragmentActivity fragmentActivity = this.this$0.requireActivity();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
            FragmentActivity activity = fragmentActivity;
            SavedStateViewModelFactory savedStateViewModelFactory = new SavedStateViewModelFactory(activity.getApplication(), (SavedStateRegistryOwner)this.this$0);
            return (SelectorViewModel)new ViewModelProvider((ViewModelStoreOwner)this.this$0, (ViewModelProvider.Factory)savedStateViewModelFactory).get(SelectorViewModel.class);
        }
    }));
    @NotNull
    private final Lazy globalViewMode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GlobalViewModel>(this){
        final /* synthetic */ BaseSelectorFragment this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final GlobalViewModel invoke() {
            FragmentActivity fragmentActivity = this.this$0.requireActivity();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
            FragmentActivity activity = fragmentActivity;
            SavedStateViewModelFactory savedStateViewModelFactory = new SavedStateViewModelFactory(activity.getApplication(), (SavedStateRegistryOwner)activity);
            return (GlobalViewModel)new ViewModelProvider((ViewModelStoreOwner)activity, (ViewModelProvider.Factory)savedStateViewModelFactory).get(GlobalViewModel.class);
        }
    }));
    @Nullable
    private OnPermissionResultListener mPermissionResultListener;

    @NotNull
    public abstract String getFragmentTag();

    public abstract int getResourceId();

    public boolean isNormalDefaultEnter() {
        return this.requireActivity() instanceof SelectorSupporterActivity || this.requireActivity() instanceof SelectorTransparentActivity;
    }

    public void showCustomPermissionApply(@NotNull String[] permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
    }

    public void handlePermissionSettingResult(@NotNull String[] permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
    }

    public void onSelectionResultChange(@Nullable LocalMedia change) {
    }

    @NotNull
    protected final SelectorConfig getConfig() {
        return this.config;
    }

    @NotNull
    protected final ClassFactory.NewInstance getFactory() {
        return this.factory;
    }

    protected final boolean isSavedInstanceState() {
        return this.isSavedInstanceState;
    }

    protected final void setSavedInstanceState(boolean bl) {
        this.isSavedInstanceState = bl;
    }

    @NotNull
    protected final SelectorViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (SelectorViewModel)((Object)lazy.getValue());
    }

    @NotNull
    protected final GlobalViewModel getGlobalViewMode() {
        Lazy lazy = this.globalViewMode$delegate;
        return (GlobalViewModel)((Object)lazy.getValue());
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        return inflater.inflate(this.getResourceId(), container, false);
    }

    @Nullable
    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        return enter ? AnimationUtils.loadAnimation((Context)this.requireContext(), (int)this.config.getWindowAnimStyle().getEnterAnimRes()) : AnimationUtils.loadAnimation((Context)this.requireContext(), (int)this.config.getWindowAnimStyle().getExitAnimRes());
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.setRequestedOrientation();
        this.setTranslucentStatusBar();
        this.isSavedInstanceState = savedInstanceState != null;
        this.getViewModel().onRestoreInstanceState(savedInstanceState);
        OnFragmentLifecycleListener onFragmentLifecycleListener = this.config.getMListenerInfo().getOnFragmentLifecycleListener();
        if (onFragmentLifecycleListener != null) {
            onFragmentLifecycleListener.onViewCreated(this, view, savedInstanceState);
        }
        this.restoreEngine();
        this.createLoadingDialog();
        this.setFragmentKeyBackListener();
    }

    @NotNull
    public final List<LocalMedia> getSelectResult() {
        return TempDataProvider.Companion.getInstance().getSelectResult();
    }

    public void setRequestedOrientation() {
        this.requireActivity().setRequestedOrientation(this.config.getActivityOrientation());
    }

    public void restoreEngine() {
        block1: {
            if (this.config.getImageEngine() != null) break block1;
            SelectorEngine selectorEngine = SelectorAppMaster.Companion.getInstance().getSelectorEngine();
            if (selectorEngine != null) {
                SelectorEngine selectorEngine2;
                SelectorEngine $this$restoreEngine_u24lambda_u2d0 = selectorEngine2 = selectorEngine;
                boolean bl = false;
                this.config.setImageEngine($this$restoreEngine_u24lambda_u2d0.createImageLoaderEngine());
            }
        }
    }

    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        this.restoreEngine();
        this.getViewModel().onSaveInstanceState();
    }

    public void showPermissionDescription(boolean isDisplay, @NotNull String[] permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        OnPermissionDescriptionListener onPermissionDescriptionListener = this.config.getMListenerInfo().getOnPermissionDescriptionListener();
        if (onPermissionDescriptionListener != null) {
            if (isDisplay) {
                Context context = this.requireContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                if (PermissionChecker.INSTANCE.checkSelfPermission(context, permission)) {
                    Context context2 = this.requireContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"requireContext()");
                    SpUtils.INSTANCE.putBoolean(context2, permission[0], false);
                } else {
                    Context context3 = this.requireContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"requireContext()");
                    if (!SpUtils.INSTANCE.getBoolean(context3, permission[0], false)) {
                        onPermissionDescriptionListener.onDescription(this, permission);
                    }
                }
            } else {
                onPermissionDescriptionListener.onDismiss(this);
            }
        }
    }

    public void handlePermissionDenied(@NotNull String[] permission) {
        OnPermissionDeniedListener onPermissionDeniedListener;
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        TempDataProvider.Companion.getInstance().setCurrentRequestPermission(permission);
        if (!(permission.length == 0)) {
            Context context = this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
            SpUtils.INSTANCE.putBoolean(context, permission[0], true);
        }
        if ((onPermissionDeniedListener = this.config.getMListenerInfo().getOnPermissionDeniedListener()) != null) {
            this.showPermissionDescription(false, permission);
            onPermissionDeniedListener.onDenied(this, permission, 10003, new OnCallbackListener<Boolean>(this){
                final /* synthetic */ BaseSelectorFragment this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onCall(boolean data) {
                    if (data) {
                        this.this$0.handlePermissionSettingResult(TempDataProvider.Companion.getInstance().getCurrentRequestPermission());
                    }
                }
            });
        } else {
            PermissionUtil.goIntentSetting(this, 10003);
        }
    }

    private final void setTranslucentStatusBar() {
        if (this.config.isPreviewFullScreenMode() && !this.config.isOnlyCamera()) {
            FragmentActivity fragmentActivity = this.requireActivity();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
            ImmersiveManager.INSTANCE.translucentStatusBar((Activity)fragmentActivity, this.config.getStatusBarStyle().isDarkStatusBar());
        }
    }

    private final void setFragmentKeyBackListener() {
        this.requireView().setFocusableInTouchMode(true);
        this.requireView().requestFocus();
        this.requireView().setOnKeyListener((arg_0, arg_1, arg_2) -> BaseSelectorFragment.setFragmentKeyBackListener$lambda-1(this, arg_0, arg_1, arg_2));
    }

    public void onKeyBackAction() {
        this.onBackPressed();
    }

    public void onBackPressed() {
        OnFragmentLifecycleListener onFragmentLifecycleListener = this.config.getMListenerInfo().getOnFragmentLifecycleListener();
        if (onFragmentLifecycleListener != null) {
            onFragmentLifecycleListener.onDestroy(this);
        }
        if (!this.isStateSaved()) {
            if (this.isRootExit()) {
                if (this instanceof SelectorMainFragment || this instanceof SelectorCameraFragment) {
                    OnResultCallbackListener onResultCallbackListener = this.config.getMListenerInfo().getOnResultCallbackListener();
                    if (onResultCallbackListener != null) {
                        onResultCallbackListener.onCancel();
                    }
                }
                if (this.isNormalDefaultEnter()) {
                    this.requireActivity().finish();
                } else {
                    this.requireActivity().getSupportFragmentManager().popBackStack();
                }
                SelectorProviders.Companion.getInstance().destroy();
            } else {
                this.requireActivity().getSupportFragmentManager().popBackStack();
            }
        }
    }

    public boolean isRootExit() {
        return this instanceof SelectorMainFragment || this instanceof SelectorCameraFragment && this.config.isOnlyCamera() || this instanceof SelectorPreviewFragment && this instanceof SelectorExternalPreviewFragment || this instanceof SelectorSystemFragment && this.config.getSystemGallery();
    }

    public void onConfirmComplete() {
        this.requireActivity().runOnUiThread(() -> BaseSelectorFragment.onConfirmComplete$lambda-2(this));
    }

    public boolean checkCompleteValidity() {
        boolean bl;
        List<LocalMedia> selectResult = this.getSelectResult();
        OnConfirmListener onConfirmListener = this.config.getMListenerInfo().getOnConfirmListener();
        if (onConfirmListener != null) {
            Context context = this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
            bl = onConfirmListener.onConfirm(context, selectResult);
        } else {
            bl = false;
        }
        if (bl) {
            return false;
        }
        if (this.config.getMediaType() == MediaType.ALL) {
            int videoSize = 0;
            int imageSize = 0;
            Iterable $this$forEach$iv = selectResult;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LocalMedia it = (LocalMedia)element$iv;
                boolean bl2 = false;
                if (MediaUtils.INSTANCE.hasMimeTypeOfVideo(it.getMimeType())) {
                    ++videoSize;
                    continue;
                }
                if (!MediaUtils.INSTANCE.hasMimeTypeOfImage(it.getMimeType())) continue;
                ++imageSize;
            }
            if (this.config.getMinSelectNum() > 0 && imageSize < this.config.getMinSelectNum()) {
                Object[] objectArray = new Object[]{String.valueOf(this.config.getMinSelectNum())};
                String string2 = this.getString(R.string.ps_min_img_num, objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(\n             \u2026g()\n                    )");
                this.showTipsDialog(string2);
                return false;
            }
            if (this.config.getMinVideoSelectNum() > 0 && videoSize < this.config.getMinVideoSelectNum()) {
                Object[] objectArray = new Object[]{String.valueOf(this.config.getMinVideoSelectNum())};
                String string3 = this.getString(R.string.ps_min_video_num, objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(\n             \u2026g()\n                    )");
                this.showTipsDialog(string3);
                return false;
            }
        } else if (this.config.getMinSelectNum() > 0 && selectResult.size() <= 0) {
            String string4;
            switch (WhenMappings.$EnumSwitchMapping$0[this.config.getMediaType().ordinal()]) {
                case 1: {
                    Object[] objectArray = new Object[]{String.valueOf(this.config.getMinSelectNum())};
                    string4 = this.getString(R.string.ps_min_video_num, objectArray);
                    break;
                }
                case 2: {
                    Object[] objectArray = new Object[]{String.valueOf(this.config.getMinSelectNum())};
                    string4 = this.getString(R.string.ps_min_audio_num, objectArray);
                    break;
                }
                default: {
                    Object[] objectArray = new Object[]{String.valueOf(this.config.getMinSelectNum())};
                    string4 = this.getString(R.string.ps_min_img_num, objectArray);
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"when (config.mediaType) \u2026      }\n                }");
            String msg = string4;
            this.showTipsDialog(msg);
            return false;
        }
        return true;
    }

    public void openSelectedCamera() {
        if (this.config.getMediaType() == MediaType.ALL) {
            if (this.config.getAllCameraMediaType() == MediaType.ALL) {
                this.onSelectedOnlyCameraDialog();
            } else {
                this.startCameraAction(this.config.getAllCameraMediaType());
            }
        } else {
            this.startCameraAction(this.config.getMediaType());
        }
    }

    public void startCameraAction(@NotNull MediaType mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        if (mode == MediaType.AUDIO) {
            this.soundRecording();
        } else {
            String[] stringArray = new String[]{"android.permission.CAMERA"};
            String[] permission = stringArray;
            Context context = this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
            if (PermissionChecker.INSTANCE.checkSelfPermission(context, permission)) {
                if (mode == MediaType.VIDEO) {
                    this.recordVideo();
                } else {
                    this.takePictures();
                }
            } else {
                this.showPermissionDescription(true, permission);
                OnPermissionApplyListener onPermissionApplyListener = this.config.getMListenerInfo().getOnPermissionApplyListener();
                if (onPermissionApplyListener != null) {
                    this.showCustomPermissionApply(permission);
                } else {
                    PermissionChecker.INSTANCE.requestPermissions((Fragment)this, permission, new OnPermissionResultListener(this, permission, mode){
                        final /* synthetic */ BaseSelectorFragment this$0;
                        final /* synthetic */ String[] $permission;
                        final /* synthetic */ MediaType $mode;
                        {
                            this.this$0 = $receiver;
                            this.$permission = $permission;
                            this.$mode = $mode;
                        }

                        public void onGranted() {
                            this.this$0.showPermissionDescription(false, this.$permission);
                            if (this.$mode == MediaType.VIDEO) {
                                this.this$0.recordVideo();
                            } else {
                                this.this$0.takePictures();
                            }
                        }

                        public void onDenied() {
                            this.this$0.handlePermissionDenied(this.$permission);
                        }
                    });
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void soundRecording() {
        Class<SoundCaptureComponent> soundCaptureComponent;
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        Context context2 = context;
        String outputDir = this.config.getAudioOutputDir();
        if (!TextUtils.isEmpty((CharSequence)outputDir)) {
            String defaultFileName = FileUtils.INSTANCE.createFileName("AUD") + ".amr";
            OnReplaceFileNameListener applyFileNameListener = this.config.getMListenerInfo().getOnReplaceFileNameListener();
            Object object = applyFileNameListener;
            if (object == null || (object = object.apply(defaultFileName)) == null) {
                object = defaultFileName;
            }
            Object fileName = object;
            this.getViewModel().setOutputUri(Uri.fromFile((File)new File(outputDir, (String)fileName)));
        }
        if ((soundCaptureComponent = this.config.getRegistry().get(SoundCaptureComponent.class)).isAssignableFrom(SoundCaptureComponent.class)) {
            OnRecordAudioListener onRecordAudioListener = this.config.getMListenerInfo().getOnRecordAudioListener();
            if (onRecordAudioListener == null) throw new NullPointerException("Please implement the " + OnRecordAudioListener.class.getSimpleName() + " interface to achieve recording functionality");
            ForegroundService.startService(context2, this.config.isForegroundService());
            onRecordAudioListener.onRecordAudio(this, 10000);
            return;
        } else {
            SoundCaptureComponent soundCaptureActivity = this.factory.create(soundCaptureComponent);
            Intent intent = new Intent(context2, soundCaptureActivity.getClass());
            intent.putExtra("output", (Parcelable)this.getViewModel().getOutputUri());
            this.startActivityForResult(intent, 10000);
            ForegroundService.startService(context2, this.config.isForegroundService());
        }
    }

    public void takePictures() {
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        Context context2 = context;
        String outputDir = this.config.getImageOutputDir();
        String defaultFileName = FileUtils.INSTANCE.createFileName("IMG") + ".jpg";
        OnReplaceFileNameListener applyFileNameListener = this.config.getMListenerInfo().getOnReplaceFileNameListener();
        Object object = applyFileNameListener;
        if (object == null || (object = object.apply(defaultFileName)) == null) {
            object = defaultFileName;
        }
        Object fileName = object;
        Uri outputUri = null;
        if (TextUtils.isEmpty((CharSequence)outputDir)) {
            Uri uri = MediaStoreUtils.INSTANCE.insertImage(context2, (String)fileName);
            Intrinsics.checkNotNull((Object)uri);
            outputUri = uri;
            this.getViewModel().setOutputUri(outputUri);
        } else {
            File outputFile = new File(outputDir, (String)fileName);
            outputUri = MediaUtils.INSTANCE.parUri(context2, outputFile);
            this.getViewModel().setOutputUri(Uri.fromFile((File)outputFile));
        }
        OnCustomCameraListener customCameraListener = this.config.getMListenerInfo().getOnCustomCameraListener();
        if (customCameraListener != null) {
            customCameraListener.onCamera(this, MediaType.IMAGE, outputUri, 10000);
        } else {
            Class<ImageCaptureComponent> imageCaptureComponent = this.config.getRegistry().get(ImageCaptureComponent.class);
            if (imageCaptureComponent.isAssignableFrom(ImageCaptureComponent.class)) {
                Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                if (intent.resolveActivity(context2.getPackageManager()) != null) {
                    intent.putExtra("output", (Parcelable)outputUri);
                    this.startActivityForResult(intent, 10000);
                    ForegroundService.startService(context2, this.config.isForegroundService());
                }
            } else {
                ImageCaptureComponent imageCaptureActivity = this.factory.create(imageCaptureComponent);
                Intent intent = new Intent(context2, imageCaptureActivity.getClass());
                intent.putExtra("output", (Parcelable)this.getViewModel().getOutputUri());
                this.startActivityForResult(intent, 10000);
                ForegroundService.startService(context2, this.config.isForegroundService());
            }
        }
    }

    public void recordVideo() {
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        Context context2 = context;
        String outputDir = this.config.getVideoOutputDir();
        String defaultFileName = FileUtils.INSTANCE.createFileName("VID") + ".mp4";
        OnReplaceFileNameListener applyFileNameListener = this.config.getMListenerInfo().getOnReplaceFileNameListener();
        Object object = applyFileNameListener;
        if (object == null || (object = object.apply(defaultFileName)) == null) {
            object = defaultFileName;
        }
        Object fileName = object;
        Uri outputUri = null;
        if (TextUtils.isEmpty((CharSequence)outputDir)) {
            Uri uri = MediaStoreUtils.INSTANCE.insertVideo(context2, (String)fileName);
            Intrinsics.checkNotNull((Object)uri);
            outputUri = uri;
            this.getViewModel().setOutputUri(outputUri);
        } else {
            File outputFile = new File(outputDir, (String)fileName);
            outputUri = MediaUtils.INSTANCE.parUri(context2, outputFile);
            this.getViewModel().setOutputUri(Uri.fromFile((File)outputFile));
        }
        OnCustomCameraListener customCameraListener = this.config.getMListenerInfo().getOnCustomCameraListener();
        if (customCameraListener != null) {
            customCameraListener.onCamera(this, MediaType.VIDEO, outputUri, 10000);
        } else {
            Class<VideoCaptureComponent> videoCaptureComponent = this.config.getRegistry().get(VideoCaptureComponent.class);
            if (videoCaptureComponent.isAssignableFrom(VideoCaptureComponent.class)) {
                Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
                if (intent.resolveActivity(context2.getPackageManager()) != null) {
                    intent.putExtra("output", (Parcelable)outputUri);
                    intent.putExtra("android.intent.extra.quickCapture", this.config.isQuickCapture());
                    this.startActivityForResult(intent, 10000);
                    ForegroundService.startService(context2, this.config.isForegroundService());
                }
            } else {
                VideoCaptureComponent videoCaptureActivity = this.factory.create(videoCaptureComponent);
                Intent intent = new Intent(context2, videoCaptureActivity.getClass());
                intent.putExtra("output", (Parcelable)this.getViewModel().getOutputUri());
                this.startActivityForResult(intent, 10000);
                ForegroundService.startService(context2, this.config.isForegroundService());
            }
        }
    }

    public void onSelectedOnlyCameraDialog() {
        PhotoItemSelectedDialog selectedDialog = PhotoItemSelectedDialog.newInstance();
        selectedDialog.setOnItemClickListener(new OnItemClickListener<View>(this){
            final /* synthetic */ BaseSelectorFragment this$0;
            {
                this.this$0 = $receiver;
            }

            public void onItemClick(int position, @NotNull View data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                switch (position) {
                    case 0: {
                        this.this$0.startCameraAction(MediaType.IMAGE);
                        break;
                    }
                    case 1: {
                        this.this$0.startCameraAction(MediaType.VIDEO);
                    }
                }
            }
        });
        selectedDialog.setOnDismissListener((arg_0, arg_1) -> BaseSelectorFragment.onSelectedOnlyCameraDialog$lambda-4(this, arg_0, arg_1));
        selectedDialog.show(this.getChildFragmentManager(), "PhotoItemSelectedDialog");
    }

    public int confirmSelect(@NotNull LocalMedia media, boolean isSelected) {
        int n;
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        if (!isSelected) {
            boolean bl;
            if (this.config.getSelectionMode() == SelectionMode.MULTIPLE && this.onCheckSelectValidity(media, isSelected) != 0) {
                return -1;
            }
            OnSelectFilterListener onSelectFilterListener = this.config.getMListenerInfo().getOnSelectFilterListener();
            if (onSelectFilterListener != null) {
                Context context = this.requireContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                bl = onSelectFilterListener.onSelectFilter(context, media);
            } else {
                bl = false;
            }
            if (bl) {
                return -1;
            }
        }
        if (isSelected) {
            if (this.getSelectResult().contains(media)) {
                this.getSelectResult().remove(media);
                this.getGlobalViewMode().setSelectResultLiveData(media);
            }
            n = 1;
        } else {
            if (this.config.getSelectionMode() == SelectionMode.SINGLE && !((Collection)this.getSelectResult()).isEmpty()) {
                this.getGlobalViewMode().setSelectResultLiveData((LocalMedia)CollectionsKt.first(this.getSelectResult()));
                this.getSelectResult().clear();
            }
            if (!this.getSelectResult().contains(media)) {
                this.getSelectResult().add(media);
                this.getGlobalViewMode().setSelectResultLiveData(media);
            }
            n = 0;
        }
        return n;
    }

    public int onCheckSelectValidity(@NotNull LocalMedia media, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        int count = this.getSelectResult().size();
        switch (WhenMappings.$EnumSwitchMapping$0[this.config.getMediaType().ordinal()]) {
            case 3: {
                if (this.config.isAllWithImageVideo()) {
                    int videoSize = 0;
                    int imageSize = 0;
                    Iterable $this$forEach$iv = this.getSelectResult();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        LocalMedia it = (LocalMedia)element$iv;
                        boolean bl = false;
                        if (MediaUtils.INSTANCE.hasMimeTypeOfVideo(it.getMimeType())) {
                            ++videoSize;
                            continue;
                        }
                        if (!MediaUtils.INSTANCE.hasMimeTypeOfImage(it.getMimeType())) continue;
                        ++imageSize;
                    }
                    if (this.config.isAsTotalCount()) {
                        if (count >= this.config.getTotalCount()) {
                            Object[] objectArray = new Object[]{String.valueOf(this.config.getTotalCount())};
                            String string2 = this.getString(R.string.ps_message_max_num, objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(\n             \u2026                        )");
                            this.showTipsDialog(string2);
                            return -1;
                        }
                        if (!MediaUtils.INSTANCE.hasMimeTypeOfVideo(media.getMimeType()) || videoSize < this.config.getMaxVideoSelectNum()) break;
                        Object[] objectArray = new Object[]{String.valueOf(this.config.getMaxVideoSelectNum())};
                        String string3 = this.getString(R.string.ps_message_video_max_num, objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(\n             \u2026                        )");
                        this.showTipsDialog(string3);
                        return -1;
                    }
                    if (MediaUtils.INSTANCE.hasMimeTypeOfVideo(media.getMimeType())) {
                        if (videoSize < this.config.getMaxVideoSelectNum()) break;
                        Object[] objectArray = new Object[]{String.valueOf(this.config.getMaxVideoSelectNum())};
                        String string4 = this.getString(R.string.ps_message_video_max_num, objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(\n             \u2026                        )");
                        this.showTipsDialog(string4);
                        return -1;
                    }
                    if (!MediaUtils.INSTANCE.hasMimeTypeOfImage(media.getMimeType()) || imageSize < this.config.getTotalCount()) break;
                    Object[] objectArray = new Object[]{String.valueOf(this.config.getTotalCount())};
                    String string5 = this.getString(R.string.ps_message_max_num, objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(\n             \u2026                        )");
                    this.showTipsDialog(string5);
                    return -1;
                }
                if (!(!((Collection)this.getSelectResult()).isEmpty())) break;
                LocalMedia first = (LocalMedia)CollectionsKt.first(this.getSelectResult());
                if (MediaUtils.INSTANCE.hasMimeTypeOfImage(first.getMimeType())) {
                    if (MediaUtils.INSTANCE.hasMimeTypeOfVideo(media.getMimeType())) {
                        String string6 = this.getString(R.string.ps_rule);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getString(R.string.ps_rule)");
                        this.showTipsDialog(string6);
                        return -1;
                    }
                    if (count < this.config.getTotalCount()) break;
                    Object[] objectArray = new Object[]{String.valueOf(this.config.getTotalCount())};
                    String string7 = this.getString(R.string.ps_message_max_num, objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getString(\n             \u2026                        )");
                    this.showTipsDialog(string7);
                    return -1;
                }
                if (!MediaUtils.INSTANCE.hasMimeTypeOfVideo(first.getMimeType())) break;
                if (MediaUtils.INSTANCE.hasMimeTypeOfImage(media.getMimeType())) {
                    String string8 = this.getString(R.string.ps_rule);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getString(R.string.ps_rule)");
                    this.showTipsDialog(string8);
                    return -1;
                }
                if (count < this.config.getTotalCount()) break;
                Object[] objectArray = new Object[]{String.valueOf(this.config.getTotalCount())};
                String string9 = this.getString(R.string.ps_message_video_max_num, objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getString(\n             \u2026                        )");
                this.showTipsDialog(string9);
                return -1;
            }
            case 4: {
                if (count < this.config.getTotalCount()) break;
                Object[] objectArray = new Object[]{String.valueOf(this.config.getTotalCount())};
                String string10 = this.getString(R.string.ps_message_max_num, objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getString(\n             \u2026                        )");
                this.showTipsDialog(string10);
                return -1;
            }
            case 1: {
                if (count < this.config.getTotalCount()) break;
                Object[] objectArray = new Object[]{String.valueOf(this.config.getTotalCount())};
                String string11 = this.getString(R.string.ps_message_video_max_num, objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getString(\n             \u2026                        )");
                this.showTipsDialog(string11);
                return -1;
            }
            case 2: {
                if (count < this.config.getTotalCount()) break;
                Object[] objectArray = new Object[]{String.valueOf(this.config.getTotalCount())};
                String string12 = this.getString(R.string.ps_message_audio_max_num, objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"getString(\n             \u2026                        )");
                this.showTipsDialog(string12);
                return -1;
            }
        }
        return 0;
    }

    private final void showTipsDialog(String tips) {
        try {
            if (ActivityCompatHelper.INSTANCE.isDestroy((Activity)this.getActivity())) {
                return;
            }
            if (this.tipsDialog != null) {
                Dialog dialog = this.tipsDialog;
                boolean bl = dialog != null ? dialog.isShowing() : false;
                if (bl) {
                    return;
                }
            }
            Context context = this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
            Dialog dialog = this.tipsDialog = ReminderDialog.Companion.buildDialog(context, tips);
            if (dialog != null) {
                dialog.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleSelectResult() {
        CropEngine cropEngine = this.config.getCropEngine();
        if (cropEngine != null && this.isCrop()) {
            cropEngine.onCrop(this, this.getSelectResult(), 10001);
        } else {
            this.onConfirmComplete();
        }
    }

    public boolean isCrop() {
        Iterable $this$forEach$iv = this.getSelectResult();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalMedia media = (LocalMedia)element$iv;
            boolean bl = false;
            if (CollectionsKt.contains((Iterable)this.config.getSkipCropFormat(), (Object)media.getMimeType()) || !MediaUtils.INSTANCE.hasMimeTypeOfImage(media.getMimeType())) continue;
            return true;
        }
        return false;
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        super.onConfigurationChanged(newConfig);
        this.initAppLanguage();
    }

    public void onAttach(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.initAppLanguage();
        super.onAttach(context);
    }

    public void initAppLanguage() {
        if (this.config.getLanguage() != Language.UNKNOWN_LANGUAGE) {
            Context context = this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
            PictureLanguageUtils.INSTANCE.setAppLanguage(context, this.config.getLanguage(), this.config.getDefaultLanguage());
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (this.mPermissionResultListener != null) {
            PermissionChecker.INSTANCE.onRequestPermissionsResult(grantResults, this.mPermissionResultListener);
            this.mPermissionResultListener = null;
        }
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        Context context2 = context;
        ForegroundService.stopService(context2);
        switch (resultCode) {
            case -1: {
                switch (requestCode) {
                    case 10000: {
                        Intent outputUri;
                        Object object;
                        Uri uri = this.getViewModel().getOutputUri();
                        boolean schemeFile = StringsKt.equals$default((String)(uri != null ? uri.getScheme() : null), (String)"file", (boolean)false, (int)2, null);
                        if (schemeFile) {
                            object = this.getViewModel().getOutputUri();
                        } else {
                            object = data;
                            if (object == null || (object = (Uri)object.getParcelableExtra("output")) == null) {
                                Intent intent = data;
                                object = intent != null ? intent.getData() : null;
                                if (object == null) {
                                    object = outputUri = this.getViewModel().getOutputUri();
                                }
                            }
                        }
                        if (outputUri != null) {
                            if (this.config.getMediaType() == MediaType.AUDIO && schemeFile) {
                                Intent intent = data;
                                if ((intent != null ? intent.getData() : null) != null) {
                                    Uri uri2 = data.getData();
                                    Intrinsics.checkNotNull((Object)uri2);
                                    this.copyAudioUriToFile(uri2);
                                    break;
                                }
                            }
                            this.analysisCameraData((Uri)outputUri);
                            break;
                        }
                        throw new IllegalStateException("Camera output uri is empty");
                    }
                    case 10001: {
                        List<LocalMedia> selectResult = this.getSelectResult();
                        if (!(!((Collection)selectResult).isEmpty())) break;
                        if (selectResult.size() == 1) {
                            this.mergeSingleCrop(data, selectResult);
                            break;
                        }
                        this.mergeMultipleCrop(data, selectResult);
                    }
                }
                break;
            }
            case 0: {
                this.onResultCanceled(requestCode, resultCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyAudioUriToFile(@NotNull Uri data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        InputStream inputStream = this.requireContext().getContentResolver().openInputStream(data);
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                Unit unit;
                InputStream inputStream2 = (InputStream)closeable;
                boolean bl = false;
                Uri uri = this.getViewModel().getOutputUri();
                if (uri != null) {
                    Uri outputUri = uri;
                    boolean bl2 = false;
                    if (FileUtils.INSTANCE.writeFileFromIS(inputStream2, new FileOutputStream(outputUri.getPath()))) {
                        this.analysisCameraData(outputUri);
                        Context context = this.requireContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                        MediaUtils.INSTANCE.deleteUri(context, data);
                    }
                    FileUtils.INSTANCE.close(inputStream2);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public void analysisCameraData(@NotNull Uri uri) {
        String realPath;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        Context context2 = context;
        boolean isContent = StringsKt.equals$default((String)uri.getScheme(), (String)"content", (boolean)false, (int)2, null);
        String string2 = realPath = isContent ? MediaUtils.INSTANCE.getPath(context2, uri) : uri.getPath();
        if (TextUtils.isEmpty((CharSequence)realPath)) {
            return;
        }
        this.getViewModel().scanFile(isContent ? realPath : null, new ScanListener(this, isContent, context2, realPath){
            final /* synthetic */ BaseSelectorFragment this$0;
            final /* synthetic */ boolean $isContent;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $realPath;
            {
                this.this$0 = $receiver;
                this.$isContent = $isContent;
                this.$context = $context;
                this.$realPath = $realPath;
            }

            public void onScanFinish() {
                BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)((ViewModel)this.this$0.getViewModel())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$isContent, this.$context, this.$realPath, this.this$0, null){
                    int label;
                    final /* synthetic */ boolean $isContent;
                    final /* synthetic */ Context $context;
                    final /* synthetic */ String $realPath;
                    final /* synthetic */ BaseSelectorFragment this$0;
                    {
                        this.$isContent = $isContent;
                        this.$context = $context;
                        this.$realPath = $realPath;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                if (!this.$isContent) break;
                                v0 = this.$realPath;
                                Intrinsics.checkNotNull((Object)v0);
                                this.label = 1;
                                v1 = MediaUtils.INSTANCE.getAssignPathMedia(this.$context, v0, (Continuation<? super LocalMedia>)((Continuation)this));
                                if (v1 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl16
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl16:
                                // 2 sources

                                v2 = (LocalMedia)v1;
                                ** GOTO lbl29
                            }
                        }
                        v3 = this.$realPath;
                        Intrinsics.checkNotNull((Object)v3);
                        this.label = 2;
                        v4 = MediaUtils.INSTANCE.getAssignFileMedia(this.$context, v3, (Continuation<? super LocalMedia>)((Continuation)this));
                        if (v4 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl28
                        {
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
lbl28:
                                // 2 sources

                                v2 = (LocalMedia)v4;
lbl29:
                                // 2 sources

                                media = v2;
                                this.this$0.onMergeCameraResult(media);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
    }

    public void onMergeCameraResult(@Nullable LocalMedia media) {
    }

    public void onResultCanceled(int requestCode, int resultCode) {
        if (requestCode == 10003) {
            this.handlePermissionSettingResult(TempDataProvider.Companion.getInstance().getCurrentRequestPermission());
        }
    }

    public void mergeSingleCrop(@Nullable Intent data, @NotNull List<LocalMedia> selectResult) {
        String string2;
        Object object;
        Intrinsics.checkNotNullParameter(selectResult, (String)"selectResult");
        LocalMedia media = (LocalMedia)CollectionsKt.first(selectResult);
        Intent intent = data;
        boolean bl = intent != null ? intent.hasExtra("com.yalantis.ucrop.OutputUri") : false;
        if (bl) {
            object = (Uri)data.getParcelableExtra("com.yalantis.ucrop.OutputUri");
        } else {
            Intent intent2 = data;
            object = intent2 != null ? (Uri)intent2.getParcelableExtra("output") : null;
        }
        Uri outputUri = object;
        Intent intent3 = data;
        media.setCropWidth(intent3 != null ? intent3.getIntExtra("com.yalantis.ucrop.ImageWidth", 0) : 0);
        Intent intent4 = data;
        media.setCropHeight(intent4 != null ? intent4.getIntExtra("com.yalantis.ucrop.ImageHeight", 0) : 0);
        Intent intent5 = data;
        media.setCropOffsetX(intent5 != null ? intent5.getIntExtra("com.yalantis.ucrop.OffsetX", 0) : 0);
        Intent intent6 = data;
        media.setCropOffsetY(intent6 != null ? intent6.getIntExtra("com.yalantis.ucrop.OffsetY", 0) : 0);
        Intent intent7 = data;
        media.setCropAspectRatio(intent7 != null ? intent7.getFloatExtra("com.yalantis.ucrop.CropAspectRatio", 0.0f) : 0.0f);
        if (MediaUtils.INSTANCE.isContent(String.valueOf(outputUri))) {
            string2 = String.valueOf(outputUri);
        } else {
            Uri uri = outputUri;
            string2 = uri != null ? uri.getPath() : null;
        }
        media.setCropPath(string2);
        this.onConfirmComplete();
    }

    /*
     * WARNING - void declaration
     */
    public void mergeMultipleCrop(@Nullable Intent data, @NotNull List<LocalMedia> selectResult) {
        String json;
        Intrinsics.checkNotNullParameter(selectResult, (String)"selectResult");
        Intent intent = data;
        String string2 = json = intent != null ? intent.getStringExtra("output") : null;
        if (json == null || TextUtils.isEmpty((CharSequence)json)) {
            return;
        }
        JSONArray array = new JSONArray(json);
        if (array.length() == selectResult.size()) {
            Iterable $this$forEachIndexed$iv = selectResult;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void media;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                LocalMedia localMedia = (LocalMedia)item$iv;
                int i = n;
                boolean bl = false;
                JSONObject item = array.optJSONObject(i);
                media.setCropPath(item.optString("outPutPath"));
                media.setCropWidth(item.optInt("imageWidth"));
                media.setCropHeight(item.optInt("imageHeight"));
                media.setCropOffsetX(item.optInt("offsetX"));
                media.setCropOffsetY(item.optInt("offsetY"));
                media.setCropAspectRatio((float)item.optDouble("aspectRatio"));
            }
        } else {
            throw new IllegalStateException("Multiple image cropping results do not match selection results:::" + array.length() + "!=" + selectResult.size());
        }
        this.onConfirmComplete();
    }

    public void setOnPermissionResultListener(@Nullable OnPermissionResultListener listener) {
        this.mPermissionResultListener = listener;
    }

    public void createLoadingDialog() {
        OnCustomLoadingListener onCustomLoadingListener;
        block3: {
            block2: {
                onCustomLoadingListener = this.config.getMListenerInfo().getOnCustomLoadingListener();
                if (onCustomLoadingListener == null) break block2;
                Context context = this.requireContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                if ((onCustomLoadingListener = onCustomLoadingListener.create(context)) != null) break block3;
            }
            Context context = this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
            onCustomLoadingListener = new PictureLoadingDialog(context);
        }
        this.mLoadingDialog = onCustomLoadingListener;
    }

    public final void showLoading() {
        try {
            if (!ActivityCompatHelper.INSTANCE.isDestroy((Activity)this.getActivity())) {
                Dialog dialog = this.mLoadingDialog;
                if (dialog != null) {
                    Dialog dialog2 = dialog;
                    boolean bl = false;
                    if (!dialog2.isShowing()) {
                        dialog2.show();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void dismissLoading() {
        try {
            if (!ActivityCompatHelper.INSTANCE.isDestroy((Activity)this.getActivity())) {
                Dialog dialog = this.mLoadingDialog;
                if (dialog != null) {
                    Dialog dialog2 = dialog;
                    boolean bl = false;
                    if (dialog2.isShowing()) {
                        dialog2.dismiss();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final boolean setFragmentKeyBackListener$lambda-1(BaseSelectorFragment this$0, View view, int keyCode, KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (keyCode == 4 && event.getAction() == 1) {
            this$0.onKeyBackAction();
            return true;
        }
        return false;
    }

    private static final void onConfirmComplete$lambda-2(BaseSelectorFragment this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (!this$0.checkCompleteValidity()) {
            return;
        }
        List selectResult = CollectionsKt.toMutableList((Collection)this$0.getSelectResult());
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)((ViewModel)this$0.getViewModel())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, (List<LocalMedia>)selectResult, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ BaseSelectorFragment this$0;
            final /* synthetic */ List<LocalMedia> $selectResult;
            {
                this.this$0 = $receiver;
                this.$selectResult = $selectResult;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block14: {
                    var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            mediaConverterEngine = this.this$0.getConfig().getMediaConverterEngine();
                            if (mediaConverterEngine != null) {
                                this.this$0.showLoading();
                                var3_4 = this.$selectResult;
                                var4_5 = this.this$0;
                                $i$f$forEach = false;
                                var6_9 = $this$forEach$iv.iterator();
lbl12:
                                // 3 sources

                                while (var6_9.hasNext()) {
                                    element$iv /* !! */  = var6_9.next();
                                    media = (LocalMedia)element$iv /* !! */ ;
                                    $i$a$-forEach-BaseSelectorFragment$onConfirmComplete$1$1$1 = false;
                                    v0 = var4_5.requireContext();
                                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"requireContext()");
                                    this.L$0 = mediaConverterEngine;
                                    this.L$1 = var4_5;
                                    this.L$2 = var6_9;
                                    this.label = 1;
                                    v1 = mediaConverterEngine.converter(v0, media, (Continuation<? super LocalMedia>)this);
                                    if (v1 != var10_2) continue;
                                    return var10_2;
                                }
                                break;
                            }
                            break block14;
                        }
                        case 1: {
                            $i$f$forEach = false;
                            $i$a$-forEach-BaseSelectorFragment$onConfirmComplete$1$1$1 = false;
                            var6_9 = (Iterator<T>)this.L$2;
                            var4_5 = (BaseSelectorFragment)this.L$1;
                            mediaConverterEngine = (MediaConverterEngine)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl12
                        }
                    }
                    this.this$0.dismissLoading();
                }
                if (this.this$0.getConfig().isActivityResult()) {
                    v2 = this.this$0.requireActivity().getIntent();
                    if (v2 != null) {
                        var4_5 = v2;
                        $i$f$forEach = this.$selectResult;
                        var6_9 = this.this$0;
                        $this$invokeSuspend_u24lambda_u2d1 = var4_5;
                        $i$a$-apply-BaseSelectorFragment$onConfirmComplete$1$1$2 = false;
                        result = new ArrayList<E>();
                        result.addAll($i$f$forEach);
                        $this$invokeSuspend_u24lambda_u2d1.putParcelableArrayListExtra("extra_result_media", result);
                        var6_9.requireActivity().setResult(-1, (Intent)$this$invokeSuspend_u24lambda_u2d1);
                    }
                } else {
                    v3 = this.this$0.getConfig().getMListenerInfo().getOnResultCallbackListener();
                    if (v3 != null) {
                        v3.onResult(this.$selectResult);
                    }
                }
                if (!this.this$0.isStateSaved()) {
                    if (this.this$0.isNormalDefaultEnter()) {
                        this.this$0.requireActivity().finish();
                    } else {
                        v4 = this.this$0.requireActivity().getSupportFragmentManager().getFragments();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"requireActivity().supportFragmentManager.fragments");
                        $this$forEach$iv = v4;
                        var4_5 = this.this$0;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            (Fragment)element$iv /* !! */ ;
                            $i$a$-forEach-BaseSelectorFragment$onConfirmComplete$1$1$3 = false;
                            var4_5.requireActivity().getSupportFragmentManager().popBackStack();
                        }
                    }
                }
                SelectorProviders.Companion.getInstance().destroy();
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void onSelectedOnlyCameraDialog$lambda-4(BaseSelectorFragment this$0, boolean isCancel, DialogInterface dialogInterface) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.config.isOnlyCamera() && isCancel) {
            this$0.onBackPressed();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MediaType.values().length];
            nArray[MediaType.VIDEO.ordinal()] = 1;
            nArray[MediaType.AUDIO.ordinal()] = 2;
            nArray[MediaType.ALL.ordinal()] = 3;
            nArray[MediaType.IMAGE.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

