/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.dialog;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.MediaAlbumAdapter;
import com.luck.picture.lib.config.LayoutSource;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaAlbum;
import com.luck.picture.lib.interfaces.OnItemClickListener;
import com.luck.picture.lib.provider.SelectorProviders;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.widget.WrapContentLinearLayoutManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001NB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u000209J\f\u0010:\u001a\b\u0012\u0004\u0012\u0002070;J\u0010\u0010<\u001a\u00020=2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010>\u001a\u000205H\u0016J\u0010\u0010?\u001a\u0002052\u0006\u0010@\u001a\u00020-H\u0016J\u0016\u0010A\u001a\u0002052\f\u0010B\u001a\b\u0012\u0004\u0012\u00020C0;H\u0016J\u0006\u0010D\u001a\u000205J\u0016\u0010E\u001a\u0002052\f\u0010F\u001a\b\u0012\u0004\u0012\u0002070;H\u0016J\u0016\u0010G\u001a\u0002052\u000e\u0010H\u001a\n\u0012\u0004\u0012\u000207\u0018\u00010IJ\u000e\u0010J\u001a\u0002052\u0006\u0010H\u001a\u000203J\u0010\u0010K\u001a\u00020=2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010L\u001a\u0002052\u0006\u0010M\u001a\u00020-H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/luck/picture/lib/dialog/AlbumListPopWindow;", "Landroid/widget/PopupWindow;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "bodyLayout", "Landroid/view/ViewGroup;", "getBodyLayout", "()Landroid/view/ViewGroup;", "setBodyLayout", "(Landroid/view/ViewGroup;)V", "config", "Lcom/luck/picture/lib/config/SelectorConfig;", "getConfig", "()Lcom/luck/picture/lib/config/SelectorConfig;", "defaultMaxCount", "", "getDefaultMaxCount", "()I", "setDefaultMaxCount", "(I)V", "isExecuteDismiss", "", "()Z", "setExecuteDismiss", "(Z)V", "mediaAlbumAdapter", "Lcom/luck/picture/lib/adapter/MediaAlbumAdapter;", "getMediaAlbumAdapter", "()Lcom/luck/picture/lib/adapter/MediaAlbumAdapter;", "setMediaAlbumAdapter", "(Lcom/luck/picture/lib/adapter/MediaAlbumAdapter;)V", "rootView", "Landroid/widget/RelativeLayout;", "getRootView", "()Landroid/widget/RelativeLayout;", "setRootView", "(Landroid/widget/RelativeLayout;)V", "rvList", "Landroidx/recyclerview/widget/RecyclerView;", "getRvList", "()Landroidx/recyclerview/widget/RecyclerView;", "setRvList", "(Landroidx/recyclerview/widget/RecyclerView;)V", "windMask", "Landroid/view/View;", "getWindMask", "()Landroid/view/View;", "setWindMask", "(Landroid/view/View;)V", "windowStatusListener", "Lcom/luck/picture/lib/dialog/AlbumListPopWindow$OnWindowStatusListener;", "dismiss", "", "getAlbum", "Lcom/luck/picture/lib/entity/LocalMediaAlbum;", "bucketId", "", "getAlbumList", "", "hideAnimation", "Landroid/view/animation/Animation;", "initRecyclerView", "initViews", "contentView", "notifyChangedSelectTag", "result", "Lcom/luck/picture/lib/entity/LocalMedia;", "notifyItemRangeChanged", "setAlbumList", "albumList", "setOnItemClickListener", "listener", "Lcom/luck/picture/lib/interfaces/OnItemClickListener;", "setOnWindowStatusListener", "showAnimation", "showAsDropDown", "anchor", "OnWindowStatusListener", "selector_release"})
public class AlbumListPopWindow
extends PopupWindow {
    @NotNull
    private final SelectorConfig config;
    @NotNull
    private View windMask;
    @NotNull
    private RecyclerView rvList;
    @NotNull
    private RelativeLayout rootView;
    @NotNull
    private ViewGroup bodyLayout;
    public MediaAlbumAdapter mediaAlbumAdapter;
    private int defaultMaxCount;
    private boolean isExecuteDismiss;
    @Nullable
    private OnWindowStatusListener windowStatusListener;

    public AlbumListPopWindow(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.config = SelectorProviders.Companion.getInstance().getConfig();
        this.defaultMaxCount = 10;
        Integer n = this.config.getLayoutSource().get((Object)LayoutSource.ALBUM_WINDOW);
        if (n == null) {
            n = R.layout.ps_album_window;
        }
        int resource = ((Number)n).intValue();
        this.setContentView(LayoutInflater.from((Context)context).inflate(resource, null));
        View view = this.getContentView().findViewById(R.id.round_group);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"contentView.findViewById(R.id.round_group)");
        this.bodyLayout = (ViewGroup)view;
        View view2 = this.getContentView().findViewById(R.id.rootView);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"contentView.findViewById(R.id.rootView)");
        this.rootView = (RelativeLayout)view2;
        View view3 = this.getContentView().findViewById(R.id.album_list);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"contentView.findViewById(R.id.album_list)");
        this.rvList = (RecyclerView)view3;
        View view4 = this.getContentView().findViewById(R.id.view_mask);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"contentView.findViewById(R.id.view_mask)");
        this.windMask = view4;
        View view5 = this.getContentView();
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"contentView");
        this.initViews(view5);
        this.setWidth(-1);
        this.setHeight(-2);
        this.setAnimationStyle(0);
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.update();
        this.rootView.setOnClickListener(arg_0 -> AlbumListPopWindow._init_$lambda-0(this, arg_0));
        this.windMask.setOnClickListener(arg_0 -> AlbumListPopWindow._init_$lambda-1(this, arg_0));
        this.initRecyclerView();
    }

    @NotNull
    public final SelectorConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final View getWindMask() {
        return this.windMask;
    }

    public final void setWindMask(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
        this.windMask = view;
    }

    @NotNull
    public final RecyclerView getRvList() {
        return this.rvList;
    }

    public final void setRvList(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"<set-?>");
        this.rvList = recyclerView;
    }

    @NotNull
    public final RelativeLayout getRootView() {
        return this.rootView;
    }

    public final void setRootView(@NotNull RelativeLayout relativeLayout) {
        Intrinsics.checkNotNullParameter((Object)relativeLayout, (String)"<set-?>");
        this.rootView = relativeLayout;
    }

    @NotNull
    public final ViewGroup getBodyLayout() {
        return this.bodyLayout;
    }

    public final void setBodyLayout(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"<set-?>");
        this.bodyLayout = viewGroup;
    }

    @NotNull
    public final MediaAlbumAdapter getMediaAlbumAdapter() {
        MediaAlbumAdapter mediaAlbumAdapter = this.mediaAlbumAdapter;
        if (mediaAlbumAdapter != null) {
            return mediaAlbumAdapter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mediaAlbumAdapter");
        return null;
    }

    public final void setMediaAlbumAdapter(@NotNull MediaAlbumAdapter mediaAlbumAdapter) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaAlbumAdapter), (String)"<set-?>");
        this.mediaAlbumAdapter = mediaAlbumAdapter;
    }

    public final int getDefaultMaxCount() {
        return this.defaultMaxCount;
    }

    public final void setDefaultMaxCount(int n) {
        this.defaultMaxCount = n;
    }

    public final boolean isExecuteDismiss() {
        return this.isExecuteDismiss;
    }

    public final void setExecuteDismiss(boolean bl) {
        this.isExecuteDismiss = bl;
    }

    public void initViews(@NotNull View contentView) {
        Intrinsics.checkNotNullParameter((Object)contentView, (String)"contentView");
    }

    public void initRecyclerView() {
        this.rvList.setLayoutManager((RecyclerView.LayoutManager)new WrapContentLinearLayoutManager(this.rvList.getContext()));
        RecyclerView.ItemAnimator itemAnimator = this.rvList.getItemAnimator();
        if (itemAnimator == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.SimpleItemAnimator");
        }
        ((SimpleItemAnimator)itemAnimator).setSupportsChangeAnimations(false);
        this.rvList.setItemAnimator(null);
        this.setMediaAlbumAdapter(new MediaAlbumAdapter(this.config));
        this.rvList.setAdapter((RecyclerView.Adapter)this.getMediaAlbumAdapter());
    }

    public void setAlbumList(@NotNull List<LocalMediaAlbum> albumList) {
        Intrinsics.checkNotNullParameter(albumList, (String)"albumList");
        this.getMediaAlbumAdapter().setAlbumList(albumList);
        Context context = this.rvList.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"rvList.context");
        int windowMaxHeight = (int)((double)DensityUtil.INSTANCE.getScreenHeight(context) * 0.6);
        ViewGroup.LayoutParams layoutParams = this.rvList.getLayoutParams();
        layoutParams.height = albumList.size() > this.defaultMaxCount ? windowMaxHeight : -2;
    }

    public final void notifyItemRangeChanged() {
        this.getMediaAlbumAdapter().notifyItemRangeChanged(0, this.getMediaAlbumAdapter().getItemCount());
    }

    @NotNull
    public final List<LocalMediaAlbum> getAlbumList() {
        return this.getMediaAlbumAdapter().getAlbumList();
    }

    @Nullable
    public final LocalMediaAlbum getAlbum(long bucketId) {
        return this.getMediaAlbumAdapter().getAlbum(bucketId);
    }

    public final void setOnItemClickListener(@Nullable OnItemClickListener<LocalMediaAlbum> listener) {
        this.getMediaAlbumAdapter().setOnItemClickListener(listener);
    }

    public void notifyChangedSelectTag(@NotNull List<LocalMedia> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        List<LocalMediaAlbum> albumList = this.getMediaAlbumAdapter().getAlbumList();
        int n = albumList.size();
        block0: for (int i = 0; i < n; ++i) {
            LocalMediaAlbum mediaAlbum = albumList.get(i);
            mediaAlbum.setSelectedTag(false);
            this.getMediaAlbumAdapter().notifyItemChanged(i);
            int n2 = result.size();
            for (int j = 0; j < n2; ++j) {
                LocalMedia media = result.get(j);
                if (!TextUtils.equals((CharSequence)mediaAlbum.getBucketDisplayName(), (CharSequence)media.getBucketDisplayName()) && !mediaAlbum.isAllAlbum()) continue;
                mediaAlbum.setSelectedTag(true);
                this.getMediaAlbumAdapter().notifyItemChanged(i);
                continue block0;
            }
        }
    }

    public void showAsDropDown(@NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        if (SdkVersionUtils.INSTANCE.isN()) {
            int[] location = new int[2];
            anchor.getLocationInWindow(location);
            this.showAtLocation(anchor, 0, 0, location[1] + anchor.getHeight());
        } else {
            super.showAsDropDown(anchor);
        }
        this.isExecuteDismiss = false;
        OnWindowStatusListener onWindowStatusListener = this.windowStatusListener;
        if (onWindowStatusListener != null) {
            onWindowStatusListener.onShowing(true);
        }
        Context context = anchor.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"anchor.context");
        this.bodyLayout.startAnimation(this.showAnimation(context));
        this.windMask.animate().alpha(1.0f).setDuration(this.bodyLayout.getAnimation().getDuration()).start();
    }

    public void dismiss() {
        if (this.isExecuteDismiss) {
            return;
        }
        this.isExecuteDismiss = true;
        OnWindowStatusListener onWindowStatusListener = this.windowStatusListener;
        if (onWindowStatusListener != null) {
            onWindowStatusListener.onShowing(false);
        }
        Context context = this.bodyLayout.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"bodyLayout.context");
        this.bodyLayout.startAnimation(this.hideAnimation(context));
        this.windMask.animate().alpha(0.0f).setDuration(this.bodyLayout.getAnimation().getDuration()).start();
        this.bodyLayout.postDelayed(() -> AlbumListPopWindow.dismiss$lambda-2(this), this.bodyLayout.getAnimation().getDuration());
    }

    @NotNull
    public Animation showAnimation(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Animation animation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.ps_anim_album_show);
        Intrinsics.checkNotNullExpressionValue((Object)animation, (String)"loadAnimation(context, R.anim.ps_anim_album_show)");
        return animation;
    }

    @NotNull
    public Animation hideAnimation(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Animation animation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.ps_anim_album_dismiss);
        Intrinsics.checkNotNullExpressionValue((Object)animation, (String)"loadAnimation(context, R\u2026im.ps_anim_album_dismiss)");
        return animation;
    }

    public final void setOnWindowStatusListener(@NotNull OnWindowStatusListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.windowStatusListener = listener;
    }

    private static final void _init_$lambda-0(AlbumListPopWindow this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (SdkVersionUtils.INSTANCE.isMinM()) {
            this$0.dismiss();
        }
    }

    private static final void _init_$lambda-1(AlbumListPopWindow this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.dismiss();
    }

    private static final void dismiss$lambda-2(AlbumListPopWindow this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        super.dismiss();
        this$0.isExecuteDismiss = false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/luck/picture/lib/dialog/AlbumListPopWindow$OnWindowStatusListener;", "", "onShowing", "", "isShowing", "", "selector_release"})
    public static interface OnWindowStatusListener {
        public void onShowing(boolean var1);
    }
}

