/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.helper;

import android.app.Activity;
import androidx.annotation.IdRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.helper.ActivityCompatHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ*\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0011"}, d2={"Lcom/luck/picture/lib/helper/FragmentInjectManager;", "", "()V", "checkFragmentNonExits", "", "activity", "Landroidx/fragment/app/FragmentActivity;", "fragmentTag", "", "injectFragment", "", "targetFragmentTag", "targetFragment", "Landroidx/fragment/app/Fragment;", "injectSystemRoomFragment", "containerViewId", "", "selector_release"})
public final class FragmentInjectManager {
    @NotNull
    public static final FragmentInjectManager INSTANCE = new FragmentInjectManager();

    private FragmentInjectManager() {
    }

    public final void injectFragment(@NotNull FragmentActivity activity, @Nullable String targetFragmentTag, @NotNull Fragment targetFragment) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)targetFragment, (String)"targetFragment");
        if (this.checkFragmentNonExits(activity, targetFragmentTag)) {
            activity.getSupportFragmentManager().beginTransaction().add(R.id.fragment_container, targetFragment, targetFragmentTag).addToBackStack(targetFragmentTag).commitAllowingStateLoss();
        }
    }

    public final void injectSystemRoomFragment(@NotNull FragmentActivity activity, @Nullable String targetFragmentTag, @NotNull Fragment targetFragment) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)targetFragment, (String)"targetFragment");
        if (this.checkFragmentNonExits(activity, targetFragmentTag)) {
            activity.getSupportFragmentManager().beginTransaction().add(0x1020002, targetFragment, targetFragmentTag).addToBackStack(targetFragmentTag).commitAllowingStateLoss();
        }
    }

    public final void injectSystemRoomFragment(@NotNull FragmentActivity activity, @IdRes int containerViewId, @Nullable String targetFragmentTag, @NotNull Fragment targetFragment) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)targetFragment, (String)"targetFragment");
        if (this.checkFragmentNonExits(activity, targetFragmentTag)) {
            activity.getSupportFragmentManager().beginTransaction().add(containerViewId, targetFragment, targetFragmentTag).addToBackStack(targetFragmentTag).commitAllowingStateLoss();
        }
    }

    private final boolean checkFragmentNonExits(FragmentActivity activity, String fragmentTag) {
        if (ActivityCompatHelper.INSTANCE.isDestroy((Activity)activity)) {
            return false;
        }
        return activity.getSupportFragmentManager().findFragmentByTag(fragmentTag) == null;
    }
}

