/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.immersive;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.ViewCompat;
import com.luck.picture.lib.immersive.LightStatusBarUtils;
import com.luck.picture.lib.utils.DensityUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J6\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000fJ&\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000fJ\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/luck/picture/lib/immersive/ImmersiveManager;", "", "()V", "TAG_FAKE_STATUS_BAR_VIEW", "", "TAG_MARGIN_ADDED", "TAG_NAVIGATION_BAR_VIEW", "fitsNotchScreen", "", "activity", "Landroid/app/Activity;", "immersiveAboveAPI23", "baseActivity", "Landroidx/appcompat/app/AppCompatActivity;", "isMarginStatusBar", "", "isMarginNavigationBar", "statusBarColor", "", "navigationBarColor", "isDarkStatusBarIcon", "initBarBelowLOLLIPOP", "setupNavBarView", "setupStatusBarView", "translucentStatusBar", "isDarkStatusBarBlack", "selector_release"})
public final class ImmersiveManager {
    @NotNull
    public static final ImmersiveManager INSTANCE = new ImmersiveManager();
    @NotNull
    private static final String TAG_FAKE_STATUS_BAR_VIEW = "TAG_FAKE_STATUS_BAR_VIEW";
    @NotNull
    private static final String TAG_MARGIN_ADDED = "TAG_MARGIN_ADDED";
    @NotNull
    private static final String TAG_NAVIGATION_BAR_VIEW = "TAG_NAVIGATION_BAR_VIEW";

    private ImmersiveManager() {
    }

    public final void immersiveAboveAPI23(@NotNull AppCompatActivity baseActivity, int statusBarColor, int navigationBarColor, boolean isDarkStatusBarIcon) {
        Intrinsics.checkNotNullParameter((Object)baseActivity, (String)"baseActivity");
        this.immersiveAboveAPI23(baseActivity, false, false, statusBarColor, navigationBarColor, isDarkStatusBarIcon);
    }

    public final void immersiveAboveAPI23(@NotNull AppCompatActivity baseActivity, boolean isMarginStatusBar, boolean isMarginNavigationBar, int statusBarColor, int navigationBarColor, boolean isDarkStatusBarIcon) {
        Intrinsics.checkNotNullParameter((Object)baseActivity, (String)"baseActivity");
        try {
            Window window = baseActivity.getWindow();
            if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
                if (isDarkStatusBarIcon) {
                    this.initBarBelowLOLLIPOP((Activity)baseActivity);
                } else {
                    window.setFlags(0x4000000, 0x4000000);
                }
            } else if (Build.VERSION.SDK_INT >= 21) {
                if (isMarginStatusBar && isMarginNavigationBar) {
                    window.clearFlags(0xC000000);
                    LightStatusBarUtils.INSTANCE.setLightStatusBar((Activity)baseActivity, true, true, statusBarColor == 0, isDarkStatusBarIcon);
                    window.addFlags(Integer.MIN_VALUE);
                } else if (!isMarginStatusBar && !isMarginNavigationBar) {
                    if (Build.VERSION.SDK_INT < 23 && isDarkStatusBarIcon) {
                        this.initBarBelowLOLLIPOP((Activity)baseActivity);
                    } else {
                        window.requestFeature(1);
                        window.clearFlags(0xC000000);
                        LightStatusBarUtils.INSTANCE.setLightStatusBar((Activity)baseActivity, false, false, statusBarColor == 0, isDarkStatusBarIcon);
                        window.addFlags(Integer.MIN_VALUE);
                    }
                } else if (!isMarginStatusBar) {
                    window.requestFeature(1);
                    window.clearFlags(0xC000000);
                    LightStatusBarUtils.INSTANCE.setLightStatusBar((Activity)baseActivity, false, true, statusBarColor == 0, isDarkStatusBarIcon);
                    window.addFlags(Integer.MIN_VALUE);
                } else {
                    return;
                }
                window.setStatusBarColor(statusBarColor);
                window.setNavigationBarColor(navigationBarColor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void translucentStatusBar(@NotNull Activity activity, boolean isDarkStatusBarBlack) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 21) {
            window.addFlags(Integer.MIN_VALUE);
        }
        window.clearFlags(0x4000000);
        if (Build.VERSION.SDK_INT >= 21) {
            window.setStatusBarColor(0);
        }
        this.fitsNotchScreen(activity);
        View view = window.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
        View decor = view;
        if (Build.VERSION.SDK_INT >= 23) {
            if (isDarkStatusBarBlack) {
                decor.setSystemUiVisibility(9472);
            } else {
                window.getDecorView().setSystemUiVisibility(1280);
            }
        } else if (isDarkStatusBarBlack) {
            this.initBarBelowLOLLIPOP(activity);
        } else {
            window.getDecorView().setSystemUiVisibility(1280);
        }
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mChildView = mContentView.getChildAt(0);
        if (mChildView != null) {
            mChildView.setFitsSystemWindows(false);
            ViewCompat.requestApplyInsets((View)mChildView);
        }
    }

    private final void fitsNotchScreen(Activity activity) {
        if (Build.VERSION.SDK_INT >= 28) {
            try {
                WindowManager.LayoutParams layoutParams = activity.getWindow().getAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)layoutParams, (String)"activity.window.attributes");
                WindowManager.LayoutParams lp = layoutParams;
                lp.layoutInDisplayCutoutMode = 1;
                activity.getWindow().setAttributes(lp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void initBarBelowLOLLIPOP(Activity activity) {
        Window mWindow = activity.getWindow();
        mWindow.addFlags(0x4000000);
        this.setupStatusBarView(activity);
        if (DensityUtil.INSTANCE.isNavBarVisible((Context)activity)) {
            mWindow.addFlags(0x8000000);
            this.setupNavBarView(activity);
        }
    }

    private final void setupStatusBarView(Activity activity) {
        Window mWindow = activity.getWindow();
        View statusBarView = mWindow.getDecorView().findViewWithTag((Object)TAG_FAKE_STATUS_BAR_VIEW);
        if (statusBarView == null) {
            statusBarView = new View((Context)activity);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, DensityUtil.INSTANCE.getStatusBarHeight((Context)activity));
            params.gravity = 48;
            statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
            statusBarView.setVisibility(0);
            statusBarView.setTag((Object)TAG_MARGIN_ADDED);
            ((ViewGroup)mWindow.getDecorView()).addView(statusBarView);
        }
        statusBarView.setBackgroundColor(0);
    }

    private final void setupNavBarView(Activity activity) {
        Window window = activity.getWindow();
        View navigationBarView = window.getDecorView().findViewWithTag((Object)TAG_NAVIGATION_BAR_VIEW);
        if (navigationBarView == null) {
            navigationBarView = new View((Context)activity);
            navigationBarView.setTag((Object)TAG_NAVIGATION_BAR_VIEW);
            ((ViewGroup)window.getDecorView()).addView(navigationBarView);
        }
        FrameLayout.LayoutParams params = null;
        if (DensityUtil.INSTANCE.isNavigationAtBottom(activity)) {
            params = new FrameLayout.LayoutParams(-1, DensityUtil.INSTANCE.getNavigationBarHeight((Context)activity));
            params.gravity = 80;
        } else {
            params = new FrameLayout.LayoutParams(DensityUtil.INSTANCE.getNavigationBarWidth((Context)activity), -1);
            params.gravity = 0x800005;
        }
        navigationBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        navigationBarView.setBackgroundColor(0);
        navigationBarView.setVisibility(0);
    }
}

