/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.immersive;

import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.luck.picture.lib.immersive.RomUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J0\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0003J2\u0010\r\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bJ.\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ.\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ0\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/luck/picture/lib/immersive/LightStatusBarUtils;", "", "()V", "initStatusBarStyle", "", "activity", "Landroid/app/Activity;", "isMarginStatusBar", "", "isMarginNavigationBar", "setAndroidNativeLightStatusBar", "isTransStatusBar", "isDarkStatusBarIcon", "setFlymeLightStatusBar", "dark", "setLightStatusBar", "setLightStatusBarAboveAPI23", "setMIUILightStatusBar", "darkmode", "selector_release"})
public final class LightStatusBarUtils {
    @NotNull
    public static final LightStatusBarUtils INSTANCE = new LightStatusBarUtils();

    private LightStatusBarUtils() {
    }

    public final void setLightStatusBarAboveAPI23(@NotNull Activity activity, boolean isMarginStatusBar, boolean isMarginNavigationBar, boolean isTransStatusBar, boolean dark) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 23) {
            this.setLightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, dark);
        }
    }

    public final void setLightStatusBar(@NotNull Activity activity, boolean dark) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.setLightStatusBar(activity, false, false, false, dark);
    }

    public final void setLightStatusBar(@NotNull Activity activity, boolean isMarginStatusBar, boolean isMarginNavigationBar, boolean isTransStatusBar, boolean dark) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        switch (RomUtils.INSTANCE.getLightStatusBarAvailableRomType()) {
            case 1: {
                if (RomUtils.INSTANCE.getMIUIVersionCode() >= 7) {
                    this.setAndroidNativeLightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, dark);
                    break;
                }
                this.setMIUILightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, dark);
                break;
            }
            case 2: {
                this.setFlymeLightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, dark);
                break;
            }
            case 3: {
                this.setAndroidNativeLightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, dark);
            }
        }
    }

    private final boolean setMIUILightStatusBar(Activity activity, boolean isMarginStatusBar, boolean isMarginNavigationBar, boolean isTransStatusBar, boolean darkmode) {
        this.initStatusBarStyle(activity, isMarginStatusBar, isMarginNavigationBar);
        Class<?> clazz = activity.getWindow().getClass();
        try {
            int darkModeFlag = 0;
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            darkModeFlag = field.getInt(layoutParams);
            Object[] objectArray = new Class[]{Integer.TYPE, Integer.TYPE};
            Method extraFlagField = clazz.getMethod("setExtraFlags", (Class<?>[])objectArray);
            objectArray = new Object[]{darkmode ? darkModeFlag : 0, darkModeFlag};
            extraFlagField.invoke((Object)activity.getWindow(), objectArray);
            return true;
        }
        catch (Exception e) {
            this.setAndroidNativeLightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, darkmode);
            return false;
        }
    }

    private final boolean setFlymeLightStatusBar(Activity activity, boolean isMarginStatusBar, boolean isMarginNavigationBar, boolean isTransStatusBar, boolean dark) {
        boolean result = false;
        if (activity != null) {
            this.initStatusBarStyle(activity, isMarginStatusBar, isMarginNavigationBar);
            try {
                WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(lp);
                value = dark ? value | bit : value & ~bit;
                meizuFlags.setInt(lp, value);
                activity.getWindow().setAttributes(lp);
                result = true;
                if (RomUtils.INSTANCE.getFlymeVersion() >= 7) {
                    this.setAndroidNativeLightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, dark);
                }
            }
            catch (Exception e) {
                this.setAndroidNativeLightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, dark);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=11)
    private final void setAndroidNativeLightStatusBar(Activity activity, boolean isMarginStatusBar, boolean isMarginNavigationBar, boolean isTransStatusBar, boolean isDarkStatusBarIcon) {
        try {
            if (isTransStatusBar) {
                Window window = activity.getWindow();
                if (Build.VERSION.SDK_INT < 21) return;
                if (isMarginStatusBar && isMarginNavigationBar) {
                    if (isDarkStatusBarIcon && Build.VERSION.SDK_INT >= 23) {
                        window.getDecorView().setSystemUiVisibility(8448);
                        return;
                    } else {
                        window.getDecorView().setSystemUiVisibility(256);
                    }
                    return;
                } else if (!isMarginStatusBar && !isMarginNavigationBar) {
                    if (isDarkStatusBarIcon && Build.VERSION.SDK_INT >= 23) {
                        window.getDecorView().setSystemUiVisibility(9472);
                        return;
                    } else {
                        window.getDecorView().setSystemUiVisibility(1280);
                    }
                    return;
                } else {
                    if (isMarginStatusBar || !isMarginNavigationBar) return;
                    if (isDarkStatusBarIcon && Build.VERSION.SDK_INT >= 23) {
                        window.getDecorView().setSystemUiVisibility(9472);
                        return;
                    } else {
                        window.getDecorView().setSystemUiVisibility(1280);
                    }
                }
                return;
            } else {
                View view = activity.getWindow().getDecorView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"activity.window.decorView");
                View decor = view;
                if (isDarkStatusBarIcon && Build.VERSION.SDK_INT >= 23) {
                    decor.setSystemUiVisibility(8192);
                    return;
                } else {
                    decor.setSystemUiVisibility(0);
                }
            }
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void initStatusBarStyle(Activity activity, boolean isMarginStatusBar, boolean isMarginNavigationBar) {
        if (Build.VERSION.SDK_INT >= 16) {
            if (isMarginStatusBar && isMarginNavigationBar) {
                activity.getWindow().getDecorView().setSystemUiVisibility(256);
            } else if (!isMarginStatusBar && !isMarginNavigationBar) {
                activity.getWindow().getDecorView().setSystemUiVisibility(1280);
            } else if (!isMarginStatusBar && isMarginNavigationBar) {
                activity.getWindow().getDecorView().setSystemUiVisibility(1280);
            }
        }
    }
}

