/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.language;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import com.luck.picture.lib.language.Language;
import com.luck.picture.lib.language.LocaleTransform;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002J\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/luck/picture/lib/language/PictureLanguageUtils;", "", "()V", "applyLanguage", "", "context", "Landroid/content/Context;", "locale", "Ljava/util/Locale;", "equals", "", "s1", "", "s2", "setAppLanguage", "language", "Lcom/luck/picture/lib/language/Language;", "defaultLanguage", "setDefaultLanguage", "selector_release"})
public final class PictureLanguageUtils {
    @NotNull
    public static final PictureLanguageUtils INSTANCE = new PictureLanguageUtils();

    private PictureLanguageUtils() {
    }

    public final void setAppLanguage(@NotNull Context context, @NotNull Language language, @NotNull Language defaultLanguage) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)((Object)defaultLanguage), (String)"defaultLanguage");
        if (language != Language.SYSTEM_LANGUAGE || language != Language.UNKNOWN_LANGUAGE) {
            this.applyLanguage(context, LocaleTransform.INSTANCE.getLanguage(language));
        } else if (defaultLanguage != Language.SYSTEM_LANGUAGE || defaultLanguage != Language.UNKNOWN_LANGUAGE) {
            this.applyLanguage(context, LocaleTransform.INSTANCE.getLanguage(defaultLanguage));
        } else {
            this.setDefaultLanguage(context);
        }
    }

    private final void applyLanguage(Context context, Locale locale) {
        Resources resources = context.getResources();
        Configuration config = resources.getConfiguration();
        Locale contextLocale = config.locale;
        if (this.equals(contextLocale.getLanguage(), locale.getLanguage()) && this.equals(contextLocale.getCountry(), locale.getCountry())) {
            return;
        }
        DisplayMetrics dm = resources.getDisplayMetrics();
        config.setLocale(locale);
        context.createConfigurationContext(config);
        resources.updateConfiguration(config, dm);
    }

    private final void setDefaultLanguage(Context context) {
        Resources resources = context.getResources();
        Configuration config = resources.getConfiguration();
        DisplayMetrics dm = resources.getDisplayMetrics();
        config.setLocale(Locale.getDefault());
        context.createConfigurationContext(config);
        resources.updateConfiguration(config, dm);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean equals(CharSequence s1, CharSequence s2) {
        int n;
        if (s1 == s2) {
            return true;
        }
        int length = 0;
        if (s1 == null) return false;
        if (s2 == null) return false;
        int it = n = s1.length();
        boolean bl = false;
        length = it;
        if (n != s2.length()) return false;
        if (!(s1 instanceof String) || !(s2 instanceof String)) {
            int i = 0;
            int n2 = length;
            while (i < n2) {
                if (s1.charAt(i) != s2.charAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        boolean bl2 = Intrinsics.areEqual((Object)s1, (Object)s2);
        return bl2;
    }
}

