/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.magical;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Build;
import android.transition.ChangeBounds;
import android.transition.ChangeImageTransform;
import android.transition.ChangeTransform;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.FrameLayout;
import androidx.annotation.RequiresApi;
import androidx.viewpager2.widget.ViewPager2;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.interfaces.MagicalInterpolator;
import com.luck.picture.lib.magical.MagicalViewWrapper;
import com.luck.picture.lib.magical.OnMagicalViewListener;
import com.luck.picture.lib.provider.SelectorProviders;
import com.luck.picture.lib.utils.DensityUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u001d\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020)H\u0003J\b\u0010+\u001a\u00020)H\u0002J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0012H\u0002J\u0010\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020\u0012H\u0002J\u0010\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020\u0012H\u0002J\b\u00102\u001a\u00020)H\u0002J\u001e\u00103\u001a\u00020)2\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0012J\u0010\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020)H\u0002J\u0006\u0010:\u001a\u00020)J\u001e\u0010;\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0012J\u000e\u0010<\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010=\u001a\u00020)2\u0006\u0010>\u001a\u00020\u0007H\u0016J\u0010\u0010?\u001a\u00020)2\b\u0010@\u001a\u0004\u0018\u00010\rJ\u0010\u0010A\u001a\u00020)2\b\u0010B\u001a\u0004\u0018\u00010\u001dJ\b\u0010C\u001a\u00020)H\u0002J\b\u0010D\u001a\u00020)H\u0002J6\u0010E\u001a\u00020)2\u0006\u0010F\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u00072\u0006\u0010I\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007JX\u0010J\u001a\u00020)2\u0006\u0010/\u001a\u00020\u00122\u0006\u0010K\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00152\u0006\u0010L\u001a\u00020\u00152\u0006\u0010M\u001a\u00020\u00152\u0006\u0010N\u001a\u00020\u00152\u0006\u0010O\u001a\u00020\u00152\u0006\u0010P\u001a\u00020\u00152\u0006\u0010Q\u001a\u00020\u00152\u0006\u0010R\u001a\u00020\u0015H\u0002J(\u0010J\u001a\u00020)2\u0006\u0010L\u001a\u00020\u00152\u0006\u0010N\u001a\u00020\u00152\u0006\u0010P\u001a\u00020\u00152\u0006\u0010R\u001a\u00020\u0015H\u0002JP\u0010J\u001a\u00020)2\u0006\u0010K\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00152\u0006\u0010L\u001a\u00020\u00152\u0006\u0010M\u001a\u00020\u00152\u0006\u0010N\u001a\u00020\u00152\u0006\u0010O\u001a\u00020\u00152\u0006\u0010P\u001a\u00020\u00152\u0006\u0010Q\u001a\u00020\u00152\u0006\u0010R\u001a\u00020\u0015H\u0002J\u000e\u0010S\u001a\u00020)2\u0006\u0010/\u001a\u00020\u0012J\u001e\u0010T\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/luck/picture/lib/magical/MagicalView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "animationDuration", "", "appInScreenHeight", "backgroundView", "Landroid/view/View;", "config", "Lcom/luck/picture/lib/config/SelectorConfig;", "contentLayout", "isAnimating", "", "isPreviewFullScreenMode", "mAlpha", "", "mOriginHeight", "mOriginLeft", "mOriginTop", "mOriginWidth", "magicalWrapper", "Lcom/luck/picture/lib/magical/MagicalViewWrapper;", "onMagicalViewListener", "Lcom/luck/picture/lib/magical/OnMagicalViewListener;", "realHeight", "realWidth", "screenHeight", "screenWidth", "startX", "startY", "targetEndLeft", "targetImageHeight", "targetImageTop", "targetImageWidth", "backToMin", "", "backToMinWithTransition", "backToMinWithoutView", "beginBackToMin", "isResetSize", "beginShow", "showImmediately", "changeBackgroundViewAlpha", "isAlpha", "changeContentViewToFullscreen", "changeRealScreenHeight", "imageWidth", "imageHeight", "dispatchTouchEvent", "event", "Landroid/view/MotionEvent;", "getScreenSize", "resetStart", "resetStartNormal", "setBackgroundAlpha", "setBackgroundColor", "color", "setMagicalContent", "view", "setOnMagicalViewListener", "l", "setOriginParams", "setShowEndParams", "setViewParams", "left", "top", "originWidth", "originHeight", "showNormalMin", "animRatio", "endY", "startLeft", "endLeft", "startWidth", "endWidth", "startHeight", "endHeight", "start", "startNormal", "selector_release"})
public final class MagicalView
extends FrameLayout {
    private float mAlpha;
    private final long animationDuration;
    private int mOriginLeft;
    private int mOriginTop;
    private int mOriginHeight;
    private int mOriginWidth;
    private int screenWidth;
    private int screenHeight;
    private final int appInScreenHeight;
    private int targetImageTop;
    private int targetImageWidth;
    private int targetImageHeight;
    private int targetEndLeft;
    private int realWidth;
    private int realHeight;
    private boolean isAnimating;
    @NotNull
    private final FrameLayout contentLayout;
    @NotNull
    private final View backgroundView;
    @NotNull
    private final MagicalViewWrapper magicalWrapper;
    private final boolean isPreviewFullScreenMode;
    @NotNull
    private final SelectorConfig config;
    private int startX;
    private int startY;
    @Nullable
    private OnMagicalViewListener onMagicalViewListener;

    @JvmOverloads
    public MagicalView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.animationDuration = 250L;
        this.config = SelectorProviders.Companion.getInstance().getConfig();
        this.isPreviewFullScreenMode = this.config.isPreviewFullScreenMode();
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext()");
        this.appInScreenHeight = DensityUtil.INSTANCE.getRealScreenHeight(context2);
        this.getScreenSize();
        this.backgroundView = new View(context);
        this.backgroundView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.backgroundView.setAlpha(this.mAlpha);
        this.addView(this.backgroundView);
        this.contentLayout = new FrameLayout(context);
        this.contentLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.contentLayout);
        this.magicalWrapper = new MagicalViewWrapper((View)this.contentLayout);
    }

    public /* synthetic */ MagicalView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public void setBackgroundColor(int color2) {
        this.backgroundView.setBackgroundColor(color2);
    }

    public final void startNormal(int realWidth, int realHeight, boolean showImmediately) {
        this.realWidth = realWidth;
        this.realHeight = realHeight;
        this.mOriginLeft = 0;
        this.mOriginTop = 0;
        this.mOriginWidth = 0;
        this.mOriginHeight = 0;
        this.setVisibility(0);
        this.setOriginParams();
        this.showNormalMin(this.targetImageTop, this.targetEndLeft, this.targetImageWidth, this.targetImageHeight);
        if (showImmediately) {
            this.mAlpha = 1.0f;
            this.backgroundView.setAlpha(this.mAlpha);
        } else {
            this.mAlpha = 0.0f;
            this.backgroundView.setAlpha(this.mAlpha);
            this.contentLayout.setAlpha(0.0f);
            this.contentLayout.animate().alpha(1.0f).setDuration(this.animationDuration).start();
            this.backgroundView.animate().alpha(1.0f).setDuration(this.animationDuration).start();
        }
        this.setShowEndParams();
    }

    /*
     * WARNING - void declaration
     */
    public final void start(boolean showImmediately) {
        float f;
        MagicalView magicalView = this;
        if (showImmediately) {
            void it;
            float f2;
            float f3 = f2 = 1.0f;
            MagicalView magicalView2 = magicalView;
            boolean bl = false;
            this.mAlpha = it;
            magicalView = magicalView2;
            f = f2;
        } else {
            f = 0.0f;
        }
        magicalView.mAlpha = f;
        this.backgroundView.setAlpha(this.mAlpha);
        this.setVisibility(0);
        this.setOriginParams();
        this.beginShow(showImmediately);
    }

    public final void resetStart() {
        this.getScreenSize();
        this.start(true);
    }

    private final void getScreenSize() {
        int n;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.screenWidth = DensityUtil.INSTANCE.getRealScreenWidth(context);
        if (this.isPreviewFullScreenMode) {
            Context context2 = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            n = DensityUtil.INSTANCE.getRealScreenHeight(context2);
        } else {
            Context context3 = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
            n = DensityUtil.INSTANCE.getScreenHeight(context3);
        }
        this.screenHeight = n;
    }

    public final void changeRealScreenHeight(int imageWidth, int imageHeight, boolean showImmediately) {
        if (this.isPreviewFullScreenMode || this.screenWidth > this.screenHeight) {
            return;
        }
        float ratio = (float)imageWidth / (float)imageHeight;
        int displayHeight = (int)((float)this.screenWidth / ratio);
        if (displayHeight > this.screenHeight) {
            this.screenHeight = this.appInScreenHeight;
            if (showImmediately) {
                this.magicalWrapper.setWidth(this.screenWidth);
                this.magicalWrapper.setHeight(this.screenHeight);
            }
        }
    }

    public final void resetStartNormal(int realWidth, int realHeight, boolean showImmediately) {
        this.getScreenSize();
        this.startNormal(realWidth, realHeight, showImmediately);
    }

    public final void setViewParams(int left, int top, int originWidth, int originHeight, int realWidth, int realHeight) {
        this.realWidth = realWidth;
        this.realHeight = realHeight;
        this.mOriginLeft = left;
        this.mOriginTop = top;
        this.mOriginWidth = originWidth;
        this.mOriginHeight = originHeight;
    }

    private final void setOriginParams() {
        int[] locationImage = new int[2];
        this.contentLayout.getLocationOnScreen(locationImage);
        this.targetEndLeft = 0;
        if ((float)this.screenWidth / (float)this.screenHeight < (float)this.realWidth / (float)this.realHeight) {
            this.targetImageWidth = this.screenWidth;
            this.targetImageHeight = (int)((float)this.targetImageWidth * ((float)this.realHeight / (float)this.realWidth));
            this.targetImageTop = (this.screenHeight - this.targetImageHeight) / 2;
        } else {
            this.targetImageHeight = this.screenHeight;
            this.targetImageWidth = (int)((float)this.targetImageHeight * ((float)this.realWidth / (float)this.realHeight));
            this.targetImageTop = 0;
            this.targetEndLeft = (this.screenWidth - this.targetImageWidth) / 2;
        }
        this.magicalWrapper.setWidth(this.mOriginWidth);
        this.magicalWrapper.setHeight(this.mOriginHeight);
        this.magicalWrapper.setMarginLeft(this.mOriginLeft);
        this.magicalWrapper.setMarginTop(this.mOriginTop);
    }

    private final void beginShow(boolean showImmediately) {
        if (showImmediately) {
            this.mAlpha = 1.0f;
            this.backgroundView.setAlpha(this.mAlpha);
            this.showNormalMin(this.targetImageTop, this.targetEndLeft, this.targetImageWidth, this.targetImageHeight);
            this.setShowEndParams();
        } else {
            float[] fArray = new float[]{0.0f, 1.0f};
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])fArray);
            valueAnimator.addUpdateListener(arg_0 -> MagicalView.beginShow$lambda-1(this, arg_0));
            valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
                final /* synthetic */ MagicalView this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onAnimationEnd(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    MagicalView.access$setShowEndParams(this.this$0);
                }
            });
            MagicalInterpolator magicalInterpolator = this.config.getMagicalInterpolator();
            valueAnimator.setInterpolator(magicalInterpolator != null && (magicalInterpolator = magicalInterpolator.newInterpolator()) != null ? (TimeInterpolator)magicalInterpolator : (TimeInterpolator)new AccelerateDecelerateInterpolator());
            valueAnimator.setDuration(this.animationDuration).start();
            this.changeBackgroundViewAlpha(false);
        }
    }

    private final void setShowEndParams() {
        block0: {
            this.isAnimating = false;
            this.changeContentViewToFullscreen();
            OnMagicalViewListener onMagicalViewListener = this.onMagicalViewListener;
            if (onMagicalViewListener == null) break block0;
            onMagicalViewListener.onBeginMagicalAnimComplete(this, false);
        }
    }

    private final void showNormalMin(float animRatio, float startY, float endY, float startLeft, float endLeft, float startWidth, float endWidth, float startHeight, float endHeight) {
        this.showNormalMin(false, animRatio, startY, endY, startLeft, endLeft, startWidth, endWidth, startHeight, endHeight);
    }

    private final void showNormalMin(float endY, float endLeft, float endWidth, float endHeight) {
        this.showNormalMin(true, 0.0f, 0.0f, endY, 0.0f, endLeft, 0.0f, endWidth, 0.0f, endHeight);
    }

    private final void showNormalMin(boolean showImmediately, float animRatio, float startY, float endY, float startLeft, float endLeft, float startWidth, float endWidth, float startHeight, float endHeight) {
        if (showImmediately) {
            this.magicalWrapper.setWidth(endWidth);
            this.magicalWrapper.setHeight(endHeight);
            this.magicalWrapper.setMarginLeft((int)endLeft);
            this.magicalWrapper.setMarginTop((int)endY);
        } else {
            float xOffset = animRatio * (endLeft - startLeft);
            float widthOffset = animRatio * (endWidth - startWidth);
            float heightOffset = animRatio * (endHeight - startHeight);
            float topOffset = animRatio * (endY - startY);
            this.magicalWrapper.setWidth(startWidth + widthOffset);
            this.magicalWrapper.setHeight(startHeight + heightOffset);
            this.magicalWrapper.setMarginLeft((int)(startLeft + xOffset));
            this.magicalWrapper.setMarginTop((int)(startY + topOffset));
        }
    }

    public final void backToMin() {
        if (this.isAnimating) {
            return;
        }
        if (this.mOriginWidth == 0 || this.mOriginHeight == 0) {
            this.backToMinWithoutView();
            return;
        }
        OnMagicalViewListener onMagicalViewListener = this.onMagicalViewListener;
        if (onMagicalViewListener != null) {
            onMagicalViewListener.onBeginBackMinAnim();
        }
        this.beginBackToMin(false);
        if (Build.VERSION.SDK_INT >= 21) {
            this.backToMinWithTransition();
        }
    }

    @RequiresApi(api=21)
    private final void backToMinWithTransition() {
        this.contentLayout.post(() -> MagicalView.backToMinWithTransition$lambda-2(this));
    }

    private final void beginBackToMin(boolean isResetSize) {
        block1: {
            if (!isResetSize) break block1;
            OnMagicalViewListener onMagicalViewListener = this.onMagicalViewListener;
            if (onMagicalViewListener != null) {
                onMagicalViewListener.onBeginBackMinMagicalFinish(true);
            }
        }
    }

    private final void backToMinWithoutView() {
        this.contentLayout.animate().alpha(0.0f).setDuration(this.animationDuration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ MagicalView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    OnMagicalViewListener onMagicalViewListener = MagicalView.access$getOnMagicalViewListener$p(this.this$0);
                    if (onMagicalViewListener == null) break block0;
                    onMagicalViewListener.onMagicalViewFinish();
                }
            }
        }).start();
        this.backgroundView.animate().alpha(0.0f).setDuration(this.animationDuration).start();
    }

    private final void changeBackgroundViewAlpha(boolean isAlpha) {
        float end = isAlpha ? 0.0f : 1.0f;
        float[] fArray = new float[]{this.mAlpha, end};
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])fArray);
        valueAnimator.addUpdateListener(arg_0 -> MagicalView.changeBackgroundViewAlpha$lambda-3(this, arg_0));
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this, isAlpha){
            final /* synthetic */ MagicalView this$0;
            final /* synthetic */ boolean $isAlpha;
            {
                this.this$0 = $receiver;
                this.$isAlpha = $isAlpha;
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    MagicalView.access$setAnimating$p(this.this$0, false);
                    if (!this.$isAlpha) break block1;
                    OnMagicalViewListener onMagicalViewListener = MagicalView.access$getOnMagicalViewListener$p(this.this$0);
                    if (onMagicalViewListener != null) {
                        onMagicalViewListener.onMagicalViewFinish();
                    }
                }
            }
        });
        valueAnimator.setDuration(this.animationDuration);
        valueAnimator.start();
    }

    public final void setMagicalContent(@Nullable View view) {
        this.contentLayout.addView(view);
    }

    private final void changeContentViewToFullscreen() {
        this.targetImageHeight = this.screenHeight;
        this.targetImageWidth = this.screenWidth;
        this.targetImageTop = 0;
        this.magicalWrapper.setHeight(this.screenHeight);
        this.magicalWrapper.setWidth(this.screenWidth);
        this.magicalWrapper.setMarginTop(0);
        this.magicalWrapper.setMarginLeft(0);
    }

    public final void setBackgroundAlpha(float mAlpha) {
        this.mAlpha = mAlpha;
        this.backgroundView.setAlpha(mAlpha);
    }

    public boolean dispatchTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        View childView = this.contentLayout.getChildAt(0);
        ViewPager2 viewPager2 = null;
        if (childView instanceof ViewPager2) {
            viewPager2 = (ViewPager2)childView;
        }
        switch (event.getAction()) {
            case 0: {
                this.startX = (int)event.getX();
                this.startY = (int)event.getY();
                if (viewPager2 == null) break;
                viewPager2.setUserInputEnabled(true);
                break;
            }
            case 2: {
                int endX = (int)event.getX();
                int endY = (int)event.getY();
                int disX = Math.abs(endX - this.startX);
                int disY = Math.abs(endY - this.startY);
                if (disX > disY) {
                    if (viewPager2 == null) break;
                    viewPager2.setUserInputEnabled(true);
                    break;
                }
                if (viewPager2 == null) break;
                viewPager2.setUserInputEnabled(this.canScrollVertically(this.startY - endY));
                break;
            }
            case 1: 
            case 3: {
                if (viewPager2 == null) break;
                viewPager2.setUserInputEnabled(true);
            }
        }
        return super.dispatchTouchEvent(event);
    }

    public final void setOnMagicalViewListener(@Nullable OnMagicalViewListener l) {
        this.onMagicalViewListener = l;
    }

    @JvmOverloads
    public MagicalView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public MagicalView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void beginShow$lambda-1(MagicalView this$0, ValueAnimator animation) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Object object = animation.getAnimatedValue();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
        }
        float value = ((Float)object).floatValue();
        this$0.showNormalMin(value, this$0.mOriginTop, this$0.targetImageTop, this$0.mOriginLeft, this$0.targetEndLeft, this$0.mOriginWidth, this$0.targetImageWidth, this$0.mOriginHeight, this$0.targetImageHeight);
    }

    private static final void backToMinWithTransition$lambda-2(MagicalView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ViewParent viewParent = this$0.contentLayout.getParent();
        if (viewParent == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)viewParent), (Transition)((Transition)new TransitionSet().setDuration(this$0.animationDuration).addTransition((Transition)new ChangeBounds()).addTransition((Transition)new ChangeTransform()).addTransition((Transition)new ChangeImageTransform())));
        this$0.beginBackToMin(true);
        this$0.contentLayout.setTranslationX(0.0f);
        this$0.contentLayout.setTranslationY(0.0f);
        this$0.magicalWrapper.setWidth(this$0.mOriginWidth);
        this$0.magicalWrapper.setHeight(this$0.mOriginHeight);
        this$0.magicalWrapper.setMarginTop(this$0.mOriginTop);
        this$0.magicalWrapper.setMarginLeft(this$0.mOriginLeft);
        this$0.changeBackgroundViewAlpha(true);
    }

    private static final void changeBackgroundViewAlpha$lambda-3(MagicalView this$0, ValueAnimator animation) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.isAnimating = true;
            Object object = animation.getAnimatedValue();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
            }
            this$0.mAlpha = ((Float)object).floatValue();
            this$0.backgroundView.setAlpha(this$0.mAlpha);
            OnMagicalViewListener onMagicalViewListener = this$0.onMagicalViewListener;
            if (onMagicalViewListener == null) break block1;
            onMagicalViewListener.onBackgroundAlpha(this$0.mAlpha);
        }
    }

    public static final /* synthetic */ void access$setShowEndParams(MagicalView $this) {
        $this.setShowEndParams();
    }

    public static final /* synthetic */ OnMagicalViewListener access$getOnMagicalViewListener$p(MagicalView $this) {
        return $this.onMagicalViewListener;
    }

    public static final /* synthetic */ void access$setAnimating$p(MagicalView $this, boolean bl) {
        $this.isAnimating = bl;
    }
}

