/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.magical;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.magical.ViewParams;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0007J0\u0010\r\u001a\u00020\u00072\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00042\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u000bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/luck/picture/lib/magical/RecycleItemViewParams;", "", "()V", "viewParams", "", "Lcom/luck/picture/lib/magical/ViewParams;", "build", "", "viewGroup", "Landroid/view/ViewGroup;", "statusBarHeight", "", "clear", "fillPlaceHolder", "originImageList", "Landroid/view/View;", "totalCount", "firstPos", "lastPos", "getItemViewParams", "position", "selector_release"})
public final class RecycleItemViewParams {
    @NotNull
    public static final RecycleItemViewParams INSTANCE = new RecycleItemViewParams();
    @NotNull
    private static final List<ViewParams> viewParams = new ArrayList();

    private RecycleItemViewParams() {
    }

    public final void clear() {
        if (viewParams.size() > 0) {
            viewParams.clear();
        }
    }

    @Nullable
    public final ViewParams getItemViewParams(int position) {
        return viewParams.size() > position ? viewParams.get(position) : null;
    }

    public final void build(@NotNull ViewGroup viewGroup, int statusBarHeight) {
        int n;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        List views = new ArrayList();
        ViewGroup viewGroup2 = viewGroup;
        if (viewGroup2 instanceof RecyclerView) {
            n = ((RecyclerView)viewGroup).getChildCount();
        } else if (viewGroup2 instanceof ListView) {
            n = ((ListView)viewGroup).getChildCount();
        } else {
            throw new IllegalArgumentException(viewGroup.getClass().getCanonicalName() + " Must be " + RecyclerView.class + " or " + ListView.class);
        }
        int childCount = n;
        for (int i = 0; i < childCount; ++i) {
            View view;
            if (viewGroup.getChildAt(i) == null) continue;
            views.add(view);
        }
        int firstPos = 0;
        int lastPos = 0;
        int totalCount = 0;
        if (viewGroup instanceof RecyclerView) {
            GridLayoutManager gridLayoutManager = (GridLayoutManager)((RecyclerView)viewGroup).getLayoutManager();
            if (gridLayoutManager == null) {
                return;
            }
            GridLayoutManager layoutManager2 = gridLayoutManager;
            totalCount = layoutManager2.getItemCount();
            firstPos = layoutManager2.findFirstVisibleItemPosition();
            lastPos = layoutManager2.findLastVisibleItemPosition();
        } else {
            ListAdapter listAdapter = ((ListView)viewGroup).getAdapter();
            if (listAdapter == null) {
                return;
            }
            ListAdapter listAdapter2 = listAdapter;
            totalCount = listAdapter2.getCount();
            firstPos = ((ListView)viewGroup).getFirstVisiblePosition();
            lastPos = ((ListView)viewGroup).getLastVisiblePosition();
        }
        lastPos = lastPos > totalCount ? totalCount - 1 : lastPos;
        this.fillPlaceHolder(views, totalCount, firstPos, lastPos);
        viewParams.clear();
        int n2 = views.size();
        for (int i = 0; i < n2; ++i) {
            View view = (View)views.get(i);
            ViewParams viewParam = new ViewParams();
            if (view == null) {
                viewParam.setLeft(0);
                viewParam.setTop(0);
                viewParam.setWidth(0);
                viewParam.setHeight(0);
            } else {
                int[] location = new int[2];
                view.getLocationOnScreen(location);
                viewParam.setLeft(location[0]);
                viewParam.setTop(location[1] - statusBarHeight);
                viewParam.setWidth(view.getWidth());
                viewParam.setHeight(view.getHeight());
            }
            viewParams.add(viewParam);
        }
    }

    private final void fillPlaceHolder(List<View> originImageList, int totalCount, int firstPos, int lastPos) {
        int i;
        if (firstPos > 0) {
            for (i = firstPos; 0 < i; --i) {
                originImageList.add(0, null);
            }
        }
        if (lastPos < totalCount) {
            for (i = totalCount - 1 - lastPos; 0 < i; --i) {
                originImageList.add(null);
            }
        }
    }
}

