/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.model;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.luck.picture.lib.SelectorCameraFragment;
import com.luck.picture.lib.SelectorTransparentActivity;
import com.luck.picture.lib.config.MediaType;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.engine.CropEngine;
import com.luck.picture.lib.engine.MediaConverterEngine;
import com.luck.picture.lib.factory.ClassFactory;
import com.luck.picture.lib.helper.FragmentInjectManager;
import com.luck.picture.lib.interfaces.OnCustomCameraListener;
import com.luck.picture.lib.interfaces.OnCustomLoadingListener;
import com.luck.picture.lib.interfaces.OnFragmentLifecycleListener;
import com.luck.picture.lib.interfaces.OnPermissionApplyListener;
import com.luck.picture.lib.interfaces.OnPermissionDeniedListener;
import com.luck.picture.lib.interfaces.OnPermissionDescriptionListener;
import com.luck.picture.lib.interfaces.OnRecordAudioListener;
import com.luck.picture.lib.interfaces.OnReplaceFileNameListener;
import com.luck.picture.lib.interfaces.OnResultCallbackListener;
import com.luck.picture.lib.interfaces.OnSelectFilterListener;
import com.luck.picture.lib.language.Language;
import com.luck.picture.lib.model.PictureSelector;
import com.luck.picture.lib.provider.SelectorProviders;
import com.luck.picture.lib.registry.Registry;
import com.luck.picture.lib.utils.DoubleUtils;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0014\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\fJ2\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0014J\u0010\u0010\u0019\u001a\u00020\u00002\b\b\u0001\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010\u0019\u001a\u00020\u0000\"\u0004\b\u0000\u0010\u001b2\u000e\b\u0001\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001dJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0005J\u0010\u0010 \u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\"J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u0010\u0010'\u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010(J\u0010\u0010)\u001a\u00020\u00002\b\u0010*\u001a\u0004\u0018\u00010+J\u0010\u0010,\u001a\u00020\u00002\b\u0010-\u001a\u0004\u0018\u00010.J\u0010\u0010/\u001a\u00020\u00002\b\u0010*\u001a\u0004\u0018\u000100J\u0010\u00101\u001a\u00020\u00002\b\u0010*\u001a\u0004\u0018\u000102J\u0010\u00103\u001a\u00020\u00002\b\u0010*\u001a\u0004\u0018\u000104J\u0010\u00105\u001a\u00020\u00002\b\u0010*\u001a\u0004\u0018\u000106J\u0010\u00107\u001a\u00020\u00002\b\u0010*\u001a\u0004\u0018\u000108J\u0010\u00109\u001a\u00020\u00002\b\u0010*\u001a\u0004\u0018\u00010:J\u0010\u0010;\u001a\u00020\u00002\b\u0010<\u001a\u0004\u0018\u00010=J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020@J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020@J\u000e\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020@J\u000e\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\fJ\u001f\u0010G\u001a\u00020\u00002\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020@0I\"\u00020@\u00a2\u0006\u0002\u0010JJ\u001c\u0010K\u001a\u00020\u0000\"\u0004\b\u0000\u0010L2\u000e\b\u0001\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002HL0\u001dR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/luck/picture/lib/model/SelectionCameraModel;", "", "selector", "Lcom/luck/picture/lib/model/PictureSelector;", "mediaType", "Lcom/luck/picture/lib/config/MediaType;", "(Lcom/luck/picture/lib/model/PictureSelector;Lcom/luck/picture/lib/config/MediaType;)V", "config", "Lcom/luck/picture/lib/config/SelectorConfig;", "buildLaunch", "", "containerViewId", "", "call", "Lcom/luck/picture/lib/interfaces/OnResultCallbackListener;", "forResult", "launcher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "attachActivity", "", "requestCode", "isCameraForegroundService", "isForeground", "isQuickCapture", "registry", "Lcom/luck/picture/lib/registry/Registry;", "V", "targetClass", "Ljava/lang/Class;", "setAllOfCameraMode", "allCameraMediaType", "setCropEngine", "engine", "Lcom/luck/picture/lib/engine/CropEngine;", "setDefaultLanguage", "language", "Lcom/luck/picture/lib/language/Language;", "setLanguage", "setMediaConverterEngine", "Lcom/luck/picture/lib/engine/MediaConverterEngine;", "setOnCustomCameraListener", "l", "Lcom/luck/picture/lib/interfaces/OnCustomCameraListener;", "setOnCustomLoadingListener", "loading", "Lcom/luck/picture/lib/interfaces/OnCustomLoadingListener;", "setOnFragmentLifecycleListener", "Lcom/luck/picture/lib/interfaces/OnFragmentLifecycleListener;", "setOnPermissionDeniedListener", "Lcom/luck/picture/lib/interfaces/OnPermissionDeniedListener;", "setOnPermissionDescriptionListener", "Lcom/luck/picture/lib/interfaces/OnPermissionDescriptionListener;", "setOnPermissionsApplyListener", "Lcom/luck/picture/lib/interfaces/OnPermissionApplyListener;", "setOnRecordAudioListener", "Lcom/luck/picture/lib/interfaces/OnRecordAudioListener;", "setOnReplaceFileNameListener", "Lcom/luck/picture/lib/interfaces/OnReplaceFileNameListener;", "setOnSelectFilterListener", "filter", "Lcom/luck/picture/lib/interfaces/OnSelectFilterListener;", "setOutputAudioDir", "audioOutputDir", "", "setOutputImageDir", "imageOutputDir", "setOutputVideoDir", "videoOutputDir", "setRequestedOrientation", "activityOrientation", "setSkipCropFormat", "format", "", "([Ljava/lang/String;)Lcom/luck/picture/lib/model/SelectionCameraModel;", "unregister", "Model", "selector_release"})
public final class SelectionCameraModel {
    @NotNull
    private PictureSelector selector;
    @NotNull
    private SelectorConfig config;

    public SelectionCameraModel(@NotNull PictureSelector selector, @NotNull MediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        this.selector = selector;
        this.config = new SelectorConfig();
        this.config.setMediaType(mediaType);
        this.config.setOnlyCamera(true);
        this.config.setDisplayTimeAxis(false);
        this.config.setPreviewFullScreenMode(false);
        this.config.setPreviewZoomEffect(false);
        SelectorProviders.Companion.getInstance().addConfigQueue(this.config);
    }

    @NotNull
    public final <V> SelectionCameraModel registry(@NonNull @NotNull Class<V> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        this.config.getRegistry().register(targetClass);
        return this;
    }

    @NotNull
    public final SelectionCameraModel registry(@NonNull @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.config.setRegistry(registry);
        return this;
    }

    @NotNull
    public final <Model> SelectionCameraModel unregister(@NonNull @NotNull Class<Model> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        this.config.getRegistry().unregister(targetClass);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setCropEngine(@Nullable CropEngine engine) {
        this.config.setCropEngine(engine);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        this.config.setLanguage(language);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setDefaultLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        this.config.setDefaultLanguage(language);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setMediaConverterEngine(@Nullable MediaConverterEngine engine) {
        this.config.setMediaConverterEngine(engine);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setOnRecordAudioListener(@Nullable OnRecordAudioListener l) {
        this.config.getMListenerInfo().setOnRecordAudioListener(l);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setOnCustomCameraListener(@Nullable OnCustomCameraListener l) {
        this.config.getMListenerInfo().setOnCustomCameraListener(l);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setOnReplaceFileNameListener(@Nullable OnReplaceFileNameListener l) {
        this.config.getMListenerInfo().setOnReplaceFileNameListener(l);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setOnSelectFilterListener(@Nullable OnSelectFilterListener filter) {
        this.config.getMListenerInfo().setOnSelectFilterListener(filter);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setOutputImageDir(@NotNull String imageOutputDir) {
        Intrinsics.checkNotNullParameter((Object)imageOutputDir, (String)"imageOutputDir");
        this.config.setImageOutputDir(imageOutputDir);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setOutputVideoDir(@NotNull String videoOutputDir) {
        Intrinsics.checkNotNullParameter((Object)videoOutputDir, (String)"videoOutputDir");
        this.config.setVideoOutputDir(videoOutputDir);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setOutputAudioDir(@NotNull String audioOutputDir) {
        Intrinsics.checkNotNullParameter((Object)audioOutputDir, (String)"audioOutputDir");
        this.config.setAudioOutputDir(audioOutputDir);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setSkipCropFormat(String ... format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.config.getSkipCropFormat().addAll(ArraysKt.toMutableList((Object[])format));
        return this;
    }

    @NotNull
    public final SelectionCameraModel setRequestedOrientation(int activityOrientation) {
        this.config.setActivityOrientation(activityOrientation);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setAllOfCameraMode(@NotNull MediaType allCameraMediaType) {
        Intrinsics.checkNotNullParameter((Object)((Object)allCameraMediaType), (String)"allCameraMediaType");
        this.config.setAllCameraMediaType(allCameraMediaType);
        return this;
    }

    @NotNull
    public final SelectionCameraModel isCameraForegroundService(boolean isForeground) {
        this.config.setForegroundService(isForeground);
        return this;
    }

    @NotNull
    public final SelectionCameraModel isQuickCapture(boolean isQuickCapture) {
        this.config.setQuickCapture(isQuickCapture);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setOnCustomLoadingListener(@Nullable OnCustomLoadingListener loading) {
        this.config.getMListenerInfo().setOnCustomLoadingListener(loading);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setOnFragmentLifecycleListener(@Nullable OnFragmentLifecycleListener l) {
        this.config.getMListenerInfo().setOnFragmentLifecycleListener(l);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setOnPermissionsApplyListener(@Nullable OnPermissionApplyListener l) {
        this.config.getMListenerInfo().setOnPermissionApplyListener(l);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setOnPermissionDescriptionListener(@Nullable OnPermissionDescriptionListener l) {
        this.config.getMListenerInfo().setOnPermissionDescriptionListener(l);
        return this;
    }

    @NotNull
    public final SelectionCameraModel setOnPermissionDeniedListener(@Nullable OnPermissionDeniedListener l) {
        this.config.getMListenerInfo().setOnPermissionDeniedListener(l);
        return this;
    }

    public final void forResult(@NotNull OnResultCallbackListener call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        this.forResult(-2147483647, null, call, false);
    }

    public final void forResult(@NotNull OnResultCallbackListener call, boolean attachActivity) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        this.forResult(-2147483647, null, call, attachActivity);
    }

    public final void forResult(int requestCode) {
        this.forResult(requestCode, null, null, true);
    }

    public final void forResult(@NotNull ActivityResultLauncher<Intent> launcher) {
        Intrinsics.checkNotNullParameter(launcher, (String)"launcher");
        this.forResult(-2147483647, launcher, null, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void forResult(int requestCode, ActivityResultLauncher<Intent> launcher, OnResultCallbackListener call, boolean attachActivity) {
        if (DoubleUtils.INSTANCE.isFastDoubleClick()) {
            return;
        }
        Activity activity = this.selector.getActivity$selector_release();
        if (activity == null) {
            throw new NullPointerException("PictureSelector.create(); # Activity is empty");
        }
        Activity activity2 = activity;
        if (attachActivity) {
            Intent intent = new Intent((Context)activity2, SelectorTransparentActivity.class);
            if (call != null) {
                this.config.getMListenerInfo().setOnResultCallbackListener(call);
                activity2.startActivity(intent);
                return;
            } else if (launcher != null) {
                this.config.setActivityResult(true);
                launcher.launch((Object)intent);
                return;
            } else {
                if (requestCode == -2147483647) throw new IllegalStateException(".forResult(); did not specify a corresponding result listening type callback");
                this.config.setActivityResult(true);
                Fragment fragment = this.selector.getFragment$selector_release();
                if (fragment != null) {
                    fragment.startActivityForResult(intent, requestCode);
                    return;
                } else {
                    activity2.startActivityForResult(intent, requestCode);
                }
            }
            return;
        } else {
            FragmentManager fragmentManager = null;
            if (activity2 instanceof FragmentActivity) {
                fragmentManager = ((FragmentActivity)activity2).getSupportFragmentManager();
            }
            if (fragmentManager == null) {
                throw new NullPointerException("FragmentManager cannot be null");
            }
            if (call == null) {
                throw new IllegalStateException(".forResult(); did not specify a corresponding result listening type callback");
            }
            this.config.getMListenerInfo().setOnResultCallbackListener(call);
            SelectorCameraFragment instance = new ClassFactory.NewInstance().create(this.config.getRegistry().get(SelectorCameraFragment.class));
            Fragment fragment = fragmentManager.findFragmentByTag(instance.getFragmentTag());
            if (fragment != null) {
                fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
            }
            FragmentInjectManager.INSTANCE.injectSystemRoomFragment((FragmentActivity)activity2, instance.getFragmentTag(), instance);
        }
    }

    public final void buildLaunch(@IdRes int containerViewId, @Nullable OnResultCallbackListener call) {
        Activity activity = this.selector.getActivity$selector_release();
        if (activity == null) {
            throw new NullPointerException("PictureSelector.create(); # Activity is empty");
        }
        Activity activity2 = activity;
        FragmentManager fragmentManager = null;
        if (activity2 instanceof FragmentActivity) {
            fragmentManager = ((FragmentActivity)activity2).getSupportFragmentManager();
        }
        if (fragmentManager == null) {
            throw new NullPointerException("FragmentManager cannot be null");
        }
        if (call == null) {
            throw new IllegalStateException(".forResult(); did not specify a corresponding result listening type callback");
        }
        this.config.getMListenerInfo().setOnResultCallbackListener(call);
        SelectorCameraFragment instance = new ClassFactory.NewInstance().create(this.config.getRegistry().get(SelectorCameraFragment.class));
        Fragment fragment = fragmentManager.findFragmentByTag(instance.getFragmentTag());
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
        }
        FragmentInjectManager.INSTANCE.injectSystemRoomFragment((FragmentActivity)activity2, containerViewId, instance.getFragmentTag(), instance);
    }
}

