/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.model;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.ViewGroup;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.IdRes;
import androidx.annotation.IntRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.luck.picture.lib.R;
import com.luck.picture.lib.SelectorMainFragment;
import com.luck.picture.lib.SelectorNumberMainFragment;
import com.luck.picture.lib.SelectorNumberPreviewFragment;
import com.luck.picture.lib.SelectorSupporterActivity;
import com.luck.picture.lib.config.LayoutSource;
import com.luck.picture.lib.config.MediaType;
import com.luck.picture.lib.config.SelectionMode;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.engine.CropEngine;
import com.luck.picture.lib.engine.ImageEngine;
import com.luck.picture.lib.engine.MediaConverterEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.factory.ClassFactory;
import com.luck.picture.lib.helper.FragmentInjectManager;
import com.luck.picture.lib.interfaces.MagicalInterpolator;
import com.luck.picture.lib.interfaces.OnAnimationAdapterWrapListener;
import com.luck.picture.lib.interfaces.OnConfirmListener;
import com.luck.picture.lib.interfaces.OnCustomAnimationListener;
import com.luck.picture.lib.interfaces.OnCustomCameraListener;
import com.luck.picture.lib.interfaces.OnCustomLoadingListener;
import com.luck.picture.lib.interfaces.OnEditorMediaListener;
import com.luck.picture.lib.interfaces.OnFragmentLifecycleListener;
import com.luck.picture.lib.interfaces.OnPermissionApplyListener;
import com.luck.picture.lib.interfaces.OnPermissionDeniedListener;
import com.luck.picture.lib.interfaces.OnPermissionDescriptionListener;
import com.luck.picture.lib.interfaces.OnQueryFilterListener;
import com.luck.picture.lib.interfaces.OnRecordAudioListener;
import com.luck.picture.lib.interfaces.OnReplaceFileNameListener;
import com.luck.picture.lib.interfaces.OnResultCallbackListener;
import com.luck.picture.lib.interfaces.OnSelectFilterListener;
import com.luck.picture.lib.language.Language;
import com.luck.picture.lib.loader.MediaLoader;
import com.luck.picture.lib.magical.RecycleItemViewParams;
import com.luck.picture.lib.model.PictureSelector;
import com.luck.picture.lib.provider.SelectorProviders;
import com.luck.picture.lib.registry.Registry;
import com.luck.picture.lib.style.StatusBarStyle;
import com.luck.picture.lib.style.WindowAnimStyle;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.DoubleUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0014\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0014\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ*\u0010\u000f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0002J\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fJ\u0018\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\fJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0019J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0019J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0019J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0019J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0019J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0019J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0019J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0019J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0019J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0019J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0019J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0019J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0019J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0019J\u0016\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0019J\u001e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0019J\u000e\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0019J\u000e\u00105\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0019J\u0010\u00106\u001a\u00020\u00002\b\b\u0001\u00106\u001a\u000207J\u001c\u00106\u001a\u00020\u0000\"\u0004\b\u0000\u001082\u000e\b\u0001\u00109\u001a\b\u0012\u0004\u0012\u0002H80:J.\u00106\u001a\u00020\u0000\"\u0004\b\u0000\u001082\u000e\b\u0001\u00109\u001a\b\u0012\u0004\u0012\u0002H80:2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\fJ\u000e\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0005J\u0010\u0010=\u001a\u00020\u00002\b\u0010>\u001a\u0004\u0018\u00010?J\u0010\u0010@\u001a\u00020\u00002\b\u0010A\u001a\u0004\u0018\u00010BJ\u000e\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020EJ\u000e\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020HJ\u000e\u0010I\u001a\u00020\u00002\u0006\u0010J\u001a\u00020KJ\u000e\u0010L\u001a\u00020\u00002\u0006\u0010J\u001a\u00020KJ\u000e\u0010M\u001a\u00020\u00002\u0006\u0010N\u001a\u00020KJ\u000e\u0010O\u001a\u00020\u00002\u0006\u0010N\u001a\u00020KJ\u0010\u0010P\u001a\u00020\u00002\b\u0010>\u001a\u0004\u0018\u00010QJ\u000e\u0010R\u001a\u00020\u00002\u0006\u0010S\u001a\u00020\fJ\u000e\u0010T\u001a\u00020\u00002\u0006\u0010G\u001a\u00020HJ\u0010\u0010U\u001a\u00020\u00002\b\u0010V\u001a\u0004\u0018\u00010WJ\u000e\u0010X\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020\fJ\u001e\u0010X\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020\f2\u0006\u0010Z\u001a\u00020\f2\u0006\u0010[\u001a\u00020\u0019J\u0010\u0010\\\u001a\u00020\u00002\b\u0010>\u001a\u0004\u0018\u00010]J\u000e\u0010^\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\fJ\u000e\u0010`\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\fJ\u0010\u0010b\u001a\u00020\u00002\b\u0010c\u001a\u0004\u0018\u00010dJ\u0010\u0010e\u001a\u00020\u00002\b\u0010c\u001a\u0004\u0018\u00010fJ\u0010\u0010g\u001a\u00020\u00002\b\u0010c\u001a\u0004\u0018\u00010hJ\u0010\u0010i\u001a\u00020\u00002\b\u0010c\u001a\u0004\u0018\u00010jJ\u0010\u0010k\u001a\u00020\u00002\b\u0010l\u001a\u0004\u0018\u00010mJ\u0010\u0010n\u001a\u00020\u00002\b\u0010c\u001a\u0004\u0018\u00010oJ\u0010\u0010p\u001a\u00020\u00002\b\u0010c\u001a\u0004\u0018\u00010qJ\u0010\u0010r\u001a\u00020\u00002\b\u0010c\u001a\u0004\u0018\u00010sJ\u0010\u0010t\u001a\u00020\u00002\b\u0010c\u001a\u0004\u0018\u00010uJ\u0010\u0010v\u001a\u00020\u00002\b\u0010c\u001a\u0004\u0018\u00010wJ\u0010\u0010x\u001a\u00020\u00002\b\u0010c\u001a\u0004\u0018\u00010yJ\u0010\u0010z\u001a\u00020\u00002\b\u0010c\u001a\u0004\u0018\u00010{J\u0010\u0010|\u001a\u00020\u00002\b\u0010c\u001a\u0004\u0018\u00010}J\u0010\u0010~\u001a\u00020\u00002\b\u0010c\u001a\u0004\u0018\u00010\u007fJ#\u0010\u0080\u0001\u001a\u00020\u00002\u0014\u0010\u0081\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020E0\u0082\u0001\"\u00020E\u00a2\u0006\u0003\u0010\u0083\u0001J#\u0010\u0084\u0001\u001a\u00020\u00002\u0014\u0010\u0081\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020E0\u0082\u0001\"\u00020E\u00a2\u0006\u0003\u0010\u0083\u0001J#\u0010\u0085\u0001\u001a\u00020\u00002\u0014\u0010\u0081\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020E0\u0082\u0001\"\u00020E\u00a2\u0006\u0003\u0010\u0083\u0001J\u0010\u0010\u0086\u0001\u001a\u00020\u00002\u0007\u0010\u0087\u0001\u001a\u00020EJ\u0010\u0010\u0088\u0001\u001a\u00020\u00002\u0007\u0010\u0089\u0001\u001a\u00020EJ\u0010\u0010\u008a\u0001\u001a\u00020\u00002\u0007\u0010\u008b\u0001\u001a\u00020EJ\u0012\u0010\u008c\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u008d\u0001\u001a\u00020\fJ\u001b\u0010\u008e\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u008f\u0001\u001a\u00020E2\u0007\u0010\u0090\u0001\u001a\u00020\u0019J\u0012\u0010\u0091\u0001\u001a\u00020\u00002\t\u0010\u0092\u0001\u001a\u0004\u0018\u00010EJ\u0010\u0010\u0093\u0001\u001a\u00020\u00002\u0007\u0010\u0094\u0001\u001a\u00020\fJ\u0018\u0010\u0095\u0001\u001a\u00020\u00002\u000f\u0010\u0096\u0001\u001a\n\u0012\u0005\u0012\u00030\u0098\u00010\u0097\u0001J\u0011\u0010\u0099\u0001\u001a\u00020\u00002\b\u0010\u009a\u0001\u001a\u00030\u009b\u0001J#\u0010\u009c\u0001\u001a\u00020\u00002\u0014\u0010\u0081\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020E0\u0082\u0001\"\u00020E\u00a2\u0006\u0003\u0010\u0083\u0001J\u0011\u0010\u009d\u0001\u001a\u00020\u00002\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001J\u0011\u0010\u00a0\u0001\u001a\u00020\u00002\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001J\u001f\u0010\u00a3\u0001\u001a\u00020\u0000\"\u0005\b\u0000\u0010\u00a4\u00012\u000f\b\u0001\u00109\u001a\t\u0012\u0005\u0012\u0003H\u00a4\u00010:R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a5\u0001"}, d2={"Lcom/luck/picture/lib/model/SelectionMainModel;", "", "selector", "Lcom/luck/picture/lib/model/PictureSelector;", "mediaType", "Lcom/luck/picture/lib/config/MediaType;", "(Lcom/luck/picture/lib/model/PictureSelector;Lcom/luck/picture/lib/config/MediaType;)V", "config", "Lcom/luck/picture/lib/config/SelectorConfig;", "buildLaunch", "", "containerViewId", "", "call", "Lcom/luck/picture/lib/interfaces/OnResultCallbackListener;", "forResult", "launcher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "requestCode", "inflateCustomLayout", "key", "Lcom/luck/picture/lib/config/LayoutSource;", "resource", "isAutoPlay", "", "isBmp", "isCameraForegroundService", "isForeground", "isDisplayCamera", "isDisplayTimeAxis", "isEmptyResultBack", "isFastSlidingSelect", "isGif", "isHeic", "isLoopAutoVideoPlay", "isLoopAutoPlay", "isMaxSelectEnabledMask", "isNewNumTemplate", "isOriginalControl", "isPreviewAudio", "isPreviewFullScreenMode", "isFullScreenModel", "isPreviewImage", "isPreviewVideo", "isPreviewZoomEffect", "isPreviewEffect", "isFullScreen", "listView", "Landroid/view/ViewGroup;", "isQuickCapture", "isVideoPauseResumePlay", "isPauseResumePlay", "isWebp", "registry", "Lcom/luck/picture/lib/registry/Registry;", "V", "targetClass", "Ljava/lang/Class;", "setAllOfCameraMode", "allCameraMediaType", "setCropEngine", "engine", "Lcom/luck/picture/lib/engine/CropEngine;", "setCustomMediaLoader", "loader", "Lcom/luck/picture/lib/loader/MediaLoader;", "setDefaultAlbumName", "defaultAlbumName", "", "setDefaultLanguage", "language", "Lcom/luck/picture/lib/language/Language;", "setFilterMaxFileSize", "sizeKb", "", "setFilterMinFileSize", "setFilterVideoMaxSecond", "second", "setFilterVideoMinSecond", "setImageEngine", "Lcom/luck/picture/lib/engine/ImageEngine;", "setImageSpanCount", "imageSpanCount", "setLanguage", "setMagicalInterpolator", "interpolator", "Lcom/luck/picture/lib/interfaces/MagicalInterpolator;", "setMaxSelectNum", "totalCount", "maxVideoNum", "isAsTotalCount", "setMediaConverterEngine", "Lcom/luck/picture/lib/engine/MediaConverterEngine;", "setMinSelectNum", "minSelectNum", "setMinVideoSelectNum", "minVideoSelectNum", "setOnAnimationAdapterWrapListener", "l", "Lcom/luck/picture/lib/interfaces/OnAnimationAdapterWrapListener;", "setOnConfirmListener", "Lcom/luck/picture/lib/interfaces/OnConfirmListener;", "setOnCustomAnimationListener", "Lcom/luck/picture/lib/interfaces/OnCustomAnimationListener;", "setOnCustomCameraListener", "Lcom/luck/picture/lib/interfaces/OnCustomCameraListener;", "setOnCustomLoadingListener", "loading", "Lcom/luck/picture/lib/interfaces/OnCustomLoadingListener;", "setOnEditorMediaListener", "Lcom/luck/picture/lib/interfaces/OnEditorMediaListener;", "setOnFragmentLifecycleListener", "Lcom/luck/picture/lib/interfaces/OnFragmentLifecycleListener;", "setOnPermissionDeniedListener", "Lcom/luck/picture/lib/interfaces/OnPermissionDeniedListener;", "setOnPermissionDescriptionListener", "Lcom/luck/picture/lib/interfaces/OnPermissionDescriptionListener;", "setOnPermissionsApplyListener", "Lcom/luck/picture/lib/interfaces/OnPermissionApplyListener;", "setOnQueryFilterListener", "Lcom/luck/picture/lib/interfaces/OnQueryFilterListener;", "setOnRecordAudioListener", "Lcom/luck/picture/lib/interfaces/OnRecordAudioListener;", "setOnReplaceFileNameListener", "Lcom/luck/picture/lib/interfaces/OnReplaceFileNameListener;", "setOnSelectFilterListener", "Lcom/luck/picture/lib/interfaces/OnSelectFilterListener;", "setOnlyQueryAudioFormat", "format", "", "([Ljava/lang/String;)Lcom/luck/picture/lib/model/SelectionMainModel;", "setOnlyQueryImageFormat", "setOnlyQueryVideoFormat", "setOutputAudioDir", "audioOutputDir", "setOutputImageDir", "imageOutputDir", "setOutputVideoDir", "videoOutputDir", "setPageSize", "pageSize", "setQuerySandboxDir", "dir", "isOnlySandboxDir", "setQuerySortOrder", "sortOrder", "setRequestedOrientation", "activityOrientation", "setSelectedData", "source", "", "Lcom/luck/picture/lib/entity/LocalMedia;", "setSelectionMode", "selectionMode", "Lcom/luck/picture/lib/config/SelectionMode;", "setSkipCropFormat", "setStatusBarStyle", "statusBar", "Lcom/luck/picture/lib/style/StatusBarStyle;", "setWindowAnimStyle", "windowAnimStyle", "Lcom/luck/picture/lib/style/WindowAnimStyle;", "unregister", "Model", "selector_release"})
public final class SelectionMainModel {
    @NotNull
    private PictureSelector selector;
    @NotNull
    private SelectorConfig config;

    public SelectionMainModel(@NotNull PictureSelector selector, @NotNull MediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        this.selector = selector;
        this.config = new SelectorConfig();
        this.config.setMediaType(mediaType);
        SelectorProviders.Companion.getInstance().addConfigQueue(this.config);
    }

    @NotNull
    public final <V> SelectionMainModel registry(@NonNull @NotNull Class<V> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        this.config.getRegistry().register(targetClass);
        return this;
    }

    @NotNull
    public final <V> SelectionMainModel registry(@NonNull @NotNull Class<V> targetClass, @NotNull LayoutSource key, @LayoutRes int resource) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        this.config.getRegistry().register(targetClass);
        this.inflateCustomLayout(key, resource);
        return this;
    }

    @NotNull
    public final SelectionMainModel registry(@NonNull @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.config.setRegistry(registry);
        return this;
    }

    @NotNull
    public final <Model> SelectionMainModel unregister(@NonNull @NotNull Class<Model> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        this.config.getRegistry().unregister(targetClass);
        return this;
    }

    @NotNull
    public final SelectionMainModel inflateCustomLayout(@NotNull LayoutSource key, @LayoutRes int resource) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Integer n = resource;
        ((Map)this.config.getLayoutSource()).put(key, n);
        return this;
    }

    @NotNull
    public final SelectionMainModel setStatusBarStyle(@NotNull StatusBarStyle statusBar) {
        Intrinsics.checkNotNullParameter((Object)statusBar, (String)"statusBar");
        this.config.setStatusBarStyle(statusBar);
        return this;
    }

    @NotNull
    public final SelectionMainModel setWindowAnimStyle(@NotNull WindowAnimStyle windowAnimStyle) {
        Intrinsics.checkNotNullParameter((Object)windowAnimStyle, (String)"windowAnimStyle");
        this.config.setWindowAnimStyle(windowAnimStyle);
        return this;
    }

    @NotNull
    public final SelectionMainModel setCustomMediaLoader(@Nullable MediaLoader loader) {
        this.config.setDataLoader(loader);
        return this;
    }

    @NotNull
    public final SelectionMainModel setImageEngine(@Nullable ImageEngine engine) {
        this.config.setImageEngine(engine);
        return this;
    }

    @NotNull
    public final SelectionMainModel setCropEngine(@Nullable CropEngine engine) {
        this.config.setCropEngine(engine);
        return this;
    }

    @NotNull
    public final SelectionMainModel setMediaConverterEngine(@Nullable MediaConverterEngine engine) {
        this.config.setMediaConverterEngine(engine);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnEditorMediaListener(@Nullable OnEditorMediaListener l) {
        this.config.getMListenerInfo().setOnEditorMediaListener(l);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnAnimationAdapterWrapListener(@Nullable OnAnimationAdapterWrapListener l) {
        this.config.getMListenerInfo().setOnAnimationAdapterWrapListener(l);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnRecordAudioListener(@Nullable OnRecordAudioListener l) {
        this.config.getMListenerInfo().setOnRecordAudioListener(l);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnCustomCameraListener(@Nullable OnCustomCameraListener l) {
        this.config.getMListenerInfo().setOnCustomCameraListener(l);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnReplaceFileNameListener(@Nullable OnReplaceFileNameListener l) {
        this.config.getMListenerInfo().setOnReplaceFileNameListener(l);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnSelectFilterListener(@Nullable OnSelectFilterListener l) {
        this.config.getMListenerInfo().setOnSelectFilterListener(l);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnConfirmListener(@Nullable OnConfirmListener l) {
        this.config.getMListenerInfo().setOnConfirmListener(l);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnQueryFilterListener(@Nullable OnQueryFilterListener l) {
        this.config.getMListenerInfo().setOnQueryFilterListener(l);
        return this;
    }

    @NotNull
    public final SelectionMainModel isNewNumTemplate(boolean isNewNumTemplate) {
        if (isNewNumTemplate) {
            this.registry(SelectorNumberMainFragment.class);
            this.registry(SelectorNumberPreviewFragment.class);
        } else {
            this.unregister(SelectorNumberMainFragment.class);
            this.unregister(SelectorNumberPreviewFragment.class);
        }
        return this;
    }

    @NotNull
    public final SelectionMainModel isLoopAutoVideoPlay(boolean isLoopAutoPlay) {
        this.config.setLoopAutoPlay(isLoopAutoPlay);
        return this;
    }

    @NotNull
    public final SelectionMainModel isAutoPlay(boolean isAutoPlay) {
        this.config.setAutoPlay(isAutoPlay);
        return this;
    }

    @NotNull
    public final SelectionMainModel isVideoPauseResumePlay(boolean isPauseResumePlay) {
        this.config.setPauseResumePlay(isPauseResumePlay);
        return this;
    }

    @NotNull
    public final SelectionMainModel isDisplayTimeAxis(boolean isDisplayTimeAxis) {
        this.config.setDisplayTimeAxis(isDisplayTimeAxis);
        return this;
    }

    @NotNull
    public final SelectionMainModel isEmptyResultBack(boolean isEmptyResultBack) {
        this.config.setEmptyResultBack(isEmptyResultBack);
        return this;
    }

    @NotNull
    public final SelectionMainModel isFastSlidingSelect(boolean isFastSlidingSelect) {
        if (this.config.getSelectionMode() == SelectionMode.ONLY_SINGLE) {
            this.config.setFastSlidingSelect(false);
        } else {
            this.config.setFastSlidingSelect(isFastSlidingSelect);
        }
        return this;
    }

    @NotNull
    public final SelectionMainModel setOutputImageDir(@NotNull String imageOutputDir) {
        Intrinsics.checkNotNullParameter((Object)imageOutputDir, (String)"imageOutputDir");
        this.config.setImageOutputDir(imageOutputDir);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOutputVideoDir(@NotNull String videoOutputDir) {
        Intrinsics.checkNotNullParameter((Object)videoOutputDir, (String)"videoOutputDir");
        this.config.setVideoOutputDir(videoOutputDir);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOutputAudioDir(@NotNull String audioOutputDir) {
        Intrinsics.checkNotNullParameter((Object)audioOutputDir, (String)"audioOutputDir");
        this.config.setAudioOutputDir(audioOutputDir);
        return this;
    }

    @NotNull
    public final SelectionMainModel setAllOfCameraMode(@NotNull MediaType allCameraMediaType) {
        Intrinsics.checkNotNullParameter((Object)((Object)allCameraMediaType), (String)"allCameraMediaType");
        this.config.setAllCameraMediaType(allCameraMediaType);
        return this;
    }

    @NotNull
    public final SelectionMainModel setLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        this.config.setLanguage(language);
        return this;
    }

    @NotNull
    public final SelectionMainModel setDefaultLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        this.config.setDefaultLanguage(language);
        return this;
    }

    @NotNull
    public final SelectionMainModel setSelectionMode(@NotNull SelectionMode selectionMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)selectionMode), (String)"selectionMode");
        this.config.setSelectionMode(selectionMode);
        return this;
    }

    @NotNull
    public final SelectionMainModel setImageSpanCount(int imageSpanCount) {
        this.config.setImageSpanCount(imageSpanCount);
        return this;
    }

    @NotNull
    public final SelectionMainModel setPageSize(@IntRange(from=1L, to=0x7FFFFFFFFFFFFFFFL) int pageSize) {
        this.config.setPageSize(pageSize);
        return this;
    }

    @NotNull
    public final SelectionMainModel setMaxSelectNum(int totalCount) {
        return this.setMaxSelectNum(totalCount, 0, false);
    }

    @NotNull
    public final SelectionMainModel setMaxSelectNum(int totalCount, int maxVideoNum, boolean isAsTotalCount) {
        this.config.setTotalCount(totalCount);
        if (this.config.getMediaType() == MediaType.ALL) {
            this.config.setMaxVideoSelectNum(maxVideoNum);
            this.config.setAsTotalCount(isAsTotalCount);
            this.config.setAllWithImageVideo(maxVideoNum > 0);
        }
        return this;
    }

    @NotNull
    public final SelectionMainModel setMinSelectNum(int minSelectNum) {
        this.config.setMinSelectNum(minSelectNum);
        return this;
    }

    @NotNull
    public final SelectionMainModel setMinVideoSelectNum(int minVideoSelectNum) {
        this.config.setMinVideoSelectNum(minVideoSelectNum);
        return this;
    }

    @NotNull
    public final SelectionMainModel setFilterMaxFileSize(long sizeKb) {
        if (sizeKb >= 0x100000L) {
            this.config.setFilterMaxFileSize(sizeKb);
        } else {
            this.config.setFilterMaxFileSize(sizeKb * 1024L);
        }
        return this;
    }

    @NotNull
    public final SelectionMainModel setFilterMinFileSize(long sizeKb) {
        if (sizeKb >= 0x100000L) {
            this.config.setFilterMinFileSize(sizeKb);
        } else {
            this.config.setFilterMinFileSize(sizeKb * 1024L);
        }
        return this;
    }

    @NotNull
    public final SelectionMainModel setFilterVideoMaxSecond(long second) {
        this.config.setFilterVideoMaxSecond(second * (long)1000);
        return this;
    }

    @NotNull
    public final SelectionMainModel setFilterVideoMinSecond(long second) {
        this.config.setFilterVideoMinSecond(second * (long)1000);
        return this;
    }

    @NotNull
    public final SelectionMainModel setQuerySortOrder(@Nullable String sortOrder) {
        this.config.setSortOrder(sortOrder);
        return this;
    }

    @NotNull
    public final SelectionMainModel setSkipCropFormat(String ... format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.config.getSkipCropFormat().addAll(ArraysKt.toMutableList((Object[])format));
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnlyQueryImageFormat(String ... format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String[] $this$forEach$iv = format;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String mimeType = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (TextUtils.isEmpty((CharSequence)mimeType)) continue;
            this.config.getOnlyQueryImageFormat().add(mimeType);
        }
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnlyQueryVideoFormat(String ... format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String[] $this$forEach$iv = format;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String mimeType = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (TextUtils.isEmpty((CharSequence)mimeType)) continue;
            this.config.getOnlyQueryVideoFormat().add(mimeType);
        }
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnlyQueryAudioFormat(String ... format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String[] $this$forEach$iv = format;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String mimeType = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (TextUtils.isEmpty((CharSequence)mimeType)) continue;
            this.config.getOnlyQueryAudioFormat().add(mimeType);
        }
        return this;
    }

    @NotNull
    public final SelectionMainModel isDisplayCamera(boolean isDisplayCamera) {
        this.config.setDisplayCamera(isDisplayCamera);
        return this;
    }

    @NotNull
    public final SelectionMainModel isMaxSelectEnabledMask(boolean isMaxSelectEnabledMask) {
        this.config.setMaxSelectEnabledMask(isMaxSelectEnabledMask);
        return this;
    }

    @NotNull
    public final SelectionMainModel isCameraForegroundService(boolean isForeground) {
        this.config.setForegroundService(isForeground);
        return this;
    }

    @NotNull
    public final SelectionMainModel isQuickCapture(boolean isQuickCapture) {
        this.config.setQuickCapture(isQuickCapture);
        return this;
    }

    @NotNull
    public final SelectionMainModel isGif(boolean isGif) {
        this.config.setGif(isGif);
        return this;
    }

    @NotNull
    public final SelectionMainModel isWebp(boolean isWebp) {
        this.config.setWebp(isWebp);
        return this;
    }

    @NotNull
    public final SelectionMainModel isBmp(boolean isBmp) {
        this.config.setBmp(isBmp);
        return this;
    }

    @NotNull
    public final SelectionMainModel isHeic(boolean isHeic) {
        this.config.setHeic(isHeic);
        return this;
    }

    @NotNull
    public final SelectionMainModel setRequestedOrientation(int activityOrientation) {
        this.config.setActivityOrientation(activityOrientation);
        return this;
    }

    @NotNull
    public final SelectionMainModel isPreviewFullScreenMode(boolean isFullScreenModel) {
        this.config.setPreviewFullScreenMode(isFullScreenModel);
        return this;
    }

    @NotNull
    public final SelectionMainModel setSelectedData(@NotNull List<LocalMedia> source) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        if (this.config.getSelectionMode() == SelectionMode.ONLY_SINGLE) {
            this.config.getSelectedSource().clear();
        } else {
            this.config.getSelectedSource().addAll(CollectionsKt.toMutableList((Collection)source));
        }
        return this;
    }

    @NotNull
    public final SelectionMainModel isPreviewZoomEffect(boolean isPreviewEffect, boolean isFullScreen) {
        if (this.config.getMediaType() != MediaType.AUDIO) {
            this.config.setPreviewZoomEffect(isPreviewEffect);
        }
        this.config.setPreviewFullScreenMode(isFullScreen);
        return this;
    }

    @NotNull
    public final SelectionMainModel isPreviewZoomEffect(boolean isPreviewEffect, boolean isFullScreen, @NotNull ViewGroup listView) {
        Intrinsics.checkNotNullParameter((Object)listView, (String)"listView");
        if (this.config.getMediaType() != MediaType.AUDIO) {
            this.config.setPreviewZoomEffect(isPreviewEffect);
            if (isPreviewEffect) {
                int n;
                if (isFullScreen) {
                    n = 0;
                } else {
                    Context context = listView.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"listView.context");
                    n = DensityUtil.INSTANCE.getStatusBarHeight(context);
                }
                RecycleItemViewParams.INSTANCE.build(listView, n);
            }
        }
        this.config.setPreviewFullScreenMode(isFullScreen);
        return this;
    }

    @NotNull
    public final SelectionMainModel setDefaultAlbumName(@NotNull String defaultAlbumName) {
        Intrinsics.checkNotNullParameter((Object)defaultAlbumName, (String)"defaultAlbumName");
        this.config.setDefaultAlbumName(defaultAlbumName);
        return this;
    }

    @NotNull
    public final SelectionMainModel setQuerySandboxDir(@NotNull String dir, boolean isOnlySandboxDir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.config.setSandboxDir(dir);
        this.config.setOnlySandboxDir(isOnlySandboxDir);
        return this;
    }

    @NotNull
    public final SelectionMainModel isPreviewAudio(boolean isPreviewAudio) {
        this.config.setEnablePreviewAudio(isPreviewAudio);
        return this;
    }

    @NotNull
    public final SelectionMainModel isPreviewImage(boolean isPreviewImage) {
        this.config.setEnablePreviewImage(isPreviewImage);
        return this;
    }

    @NotNull
    public final SelectionMainModel isPreviewVideo(boolean isPreviewVideo) {
        this.config.setEnablePreviewVideo(isPreviewVideo);
        return this;
    }

    @NotNull
    public final SelectionMainModel isOriginalControl(boolean isOriginalControl) {
        this.config.setOriginalControl(isOriginalControl);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnFragmentLifecycleListener(@Nullable OnFragmentLifecycleListener l) {
        this.config.getMListenerInfo().setOnFragmentLifecycleListener(l);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnCustomAnimationListener(@Nullable OnCustomAnimationListener l) {
        this.config.getMListenerInfo().setOnCustomAnimationListener(l);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnCustomLoadingListener(@Nullable OnCustomLoadingListener loading) {
        this.config.getMListenerInfo().setOnCustomLoadingListener(loading);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnPermissionsApplyListener(@Nullable OnPermissionApplyListener l) {
        this.config.getMListenerInfo().setOnPermissionApplyListener(l);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnPermissionDescriptionListener(@Nullable OnPermissionDescriptionListener l) {
        this.config.getMListenerInfo().setOnPermissionDescriptionListener(l);
        return this;
    }

    @NotNull
    public final SelectionMainModel setOnPermissionDeniedListener(@Nullable OnPermissionDeniedListener l) {
        this.config.getMListenerInfo().setOnPermissionDeniedListener(l);
        return this;
    }

    @NotNull
    public final SelectionMainModel setMagicalInterpolator(@Nullable MagicalInterpolator interpolator) {
        this.config.setMagicalInterpolator(interpolator);
        return this;
    }

    public final void forResult(int requestCode) {
        this.forResult(null, requestCode, null);
    }

    public final void forResult(@NotNull OnResultCallbackListener call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        this.forResult(call, -2147483647, null);
    }

    public final void forResult(@NotNull ActivityResultLauncher<Intent> launcher) {
        Intrinsics.checkNotNullParameter(launcher, (String)"launcher");
        this.forResult(null, -2147483647, launcher);
    }

    private final void forResult(OnResultCallbackListener call, int requestCode, ActivityResultLauncher<Intent> launcher) {
        if (DoubleUtils.INSTANCE.isFastDoubleClick()) {
            return;
        }
        Activity activity = this.selector.getActivity$selector_release();
        if (activity == null) {
            throw new NullPointerException("PictureSelector.create(); # Activity is empty");
        }
        Activity activity2 = activity;
        if (this.config.getImageEngine() == null && this.config.getMediaType() != MediaType.AUDIO) {
            throw new NullPointerException("Please set the API # .setImageEngine(" + Reflection.getOrCreateKotlinClass(ImageEngine.class).getSimpleName() + ");");
        }
        Intent intent = new Intent((Context)activity2, SelectorSupporterActivity.class);
        if (call != null) {
            this.config.getMListenerInfo().setOnResultCallbackListener(call);
            activity2.startActivity(intent);
        } else if (launcher != null) {
            this.config.setActivityResult(true);
            launcher.launch((Object)intent);
        } else if (requestCode != -2147483647) {
            this.config.setActivityResult(true);
            Fragment fragment = this.selector.getFragment$selector_release();
            if (fragment != null) {
                fragment.startActivityForResult(intent, requestCode);
            } else {
                activity2.startActivityForResult(intent, requestCode);
            }
        } else {
            throw new IllegalStateException(".forResult(); did not specify a corresponding result listening type callback");
        }
        activity2.overridePendingTransition(this.config.getWindowAnimStyle().getEnterAnimRes(), R.anim.ps_anim_fade_in);
    }

    public final void buildLaunch(@IdRes int containerViewId, @Nullable OnResultCallbackListener call) {
        Activity activity = this.selector.getActivity$selector_release();
        if (activity == null) {
            throw new NullPointerException("PictureSelector.create(); # Activity is empty");
        }
        Activity activity2 = activity;
        FragmentManager fragmentManager = null;
        if (activity2 instanceof FragmentActivity) {
            fragmentManager = ((FragmentActivity)activity2).getSupportFragmentManager();
        }
        if (fragmentManager == null) {
            throw new NullPointerException("FragmentManager cannot be null");
        }
        if (call == null) {
            throw new IllegalStateException(".forResult(); did not specify a corresponding result listening type callback");
        }
        this.config.getMListenerInfo().setOnResultCallbackListener(call);
        SelectorMainFragment instance = new ClassFactory.NewInstance().create(this.config.getRegistry().get(SelectorMainFragment.class));
        Fragment fragment = fragmentManager.findFragmentByTag(instance.getFragmentTag());
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
        }
        FragmentInjectManager.INSTANCE.injectSystemRoomFragment((FragmentActivity)activity2, containerViewId, instance.getFragmentTag(), instance);
    }
}

