/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.model;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.luck.picture.lib.R;
import com.luck.picture.lib.SelectorExternalPreviewFragment;
import com.luck.picture.lib.SelectorPreviewFragment;
import com.luck.picture.lib.SelectorTransparentActivity;
import com.luck.picture.lib.config.LayoutSource;
import com.luck.picture.lib.config.MediaType;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.engine.ImageEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.factory.ClassFactory;
import com.luck.picture.lib.helper.FragmentInjectManager;
import com.luck.picture.lib.interfaces.OnCustomAnimationListener;
import com.luck.picture.lib.interfaces.OnCustomLoadingListener;
import com.luck.picture.lib.interfaces.OnExternalPreviewListener;
import com.luck.picture.lib.interfaces.OnFragmentLifecycleListener;
import com.luck.picture.lib.language.Language;
import com.luck.picture.lib.magical.RecycleItemViewParams;
import com.luck.picture.lib.model.PictureSelector;
import com.luck.picture.lib.provider.SelectorProviders;
import com.luck.picture.lib.registry.Registry;
import com.luck.picture.lib.style.StatusBarStyle;
import com.luck.picture.lib.style.WindowAnimStyle;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.DoubleUtils;
import com.luck.picture.lib.utils.MediaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u000fJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u000fJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000fJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000fJ\u001e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u000fJ\u0010\u0010&\u001a\u00020\u00002\b\b\u0001\u0010&\u001a\u00020'J\u001c\u0010&\u001a\u00020\u0000\"\u0004\b\u0000\u0010(2\u000e\b\u0001\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*J.\u0010&\u001a\u00020\u0000\"\u0004\b\u0000\u0010(2\u000e\b\u0001\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\nJ\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020\u00002\b\u0010/\u001a\u0004\u0018\u000100J\u000e\u00101\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-J\u0010\u00102\u001a\u00020\u00002\b\u00103\u001a\u0004\u0018\u000104J\u0010\u00105\u001a\u00020\u00002\b\u00106\u001a\u0004\u0018\u000107J\u0010\u00108\u001a\u00020\u00002\b\u00103\u001a\u0004\u0018\u000109J\u0010\u0010:\u001a\u00020\u00002\b\u00103\u001a\u0004\u0018\u00010;J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020AJ\u001c\u0010B\u001a\u00020\u0000\"\u0004\b\u0000\u0010C2\u000e\b\u0001\u0010D\u001a\b\u0012\u0004\u0012\u0002HC0*R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/luck/picture/lib/model/SelectionPreviewModel;", "", "selector", "Lcom/luck/picture/lib/model/PictureSelector;", "(Lcom/luck/picture/lib/model/PictureSelector;)V", "config", "Lcom/luck/picture/lib/config/SelectorConfig;", "forPreview", "", "position", "", "source", "", "Lcom/luck/picture/lib/entity/LocalMedia;", "attachActivity", "", "forPreviewUrl", "strings", "", "inflateCustomLayout", "key", "Lcom/luck/picture/lib/config/LayoutSource;", "resource", "isAutoPlay", "isDisplayDelete", "isLongPressDownload", "isDownload", "isLoopAutoVideoPlay", "isLoopAutoPlay", "isPreviewFullScreenMode", "isFullScreenModel", "isPreviewZoomEffect", "isPreviewEffect", "isFullScreen", "listView", "Landroid/view/ViewGroup;", "isVideoPauseResumePlay", "isPauseResumePlay", "registry", "Lcom/luck/picture/lib/registry/Registry;", "V", "targetClass", "Ljava/lang/Class;", "setDefaultLanguage", "language", "Lcom/luck/picture/lib/language/Language;", "setImageEngine", "engine", "Lcom/luck/picture/lib/engine/ImageEngine;", "setLanguage", "setOnCustomAnimationListener", "l", "Lcom/luck/picture/lib/interfaces/OnCustomAnimationListener;", "setOnCustomLoadingListener", "loading", "Lcom/luck/picture/lib/interfaces/OnCustomLoadingListener;", "setOnExternalPreviewListener", "Lcom/luck/picture/lib/interfaces/OnExternalPreviewListener;", "setOnFragmentLifecycleListener", "Lcom/luck/picture/lib/interfaces/OnFragmentLifecycleListener;", "setStatusBarStyle", "statusBar", "Lcom/luck/picture/lib/style/StatusBarStyle;", "setWindowAnimStyle", "windowAnimStyle", "Lcom/luck/picture/lib/style/WindowAnimStyle;", "unregister", "Model", "fragmentClass", "selector_release"})
public final class SelectionPreviewModel {
    @NotNull
    private PictureSelector selector;
    @NotNull
    private SelectorConfig config;

    public SelectionPreviewModel(@NotNull PictureSelector selector) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        this.selector = selector;
        this.config = new SelectorConfig();
        SelectorProviders.Companion.getInstance().addConfigQueue(this.config);
    }

    @NotNull
    public final <V> SelectionPreviewModel registry(@NonNull @NotNull Class<V> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        this.config.getRegistry().register(targetClass);
        return this;
    }

    @NotNull
    public final <V> SelectionPreviewModel registry(@NonNull @NotNull Class<V> targetClass, @NotNull LayoutSource key, @LayoutRes int resource) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        this.config.getRegistry().register(targetClass);
        this.inflateCustomLayout(key, resource);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel registry(@NonNull @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.config.setRegistry(registry);
        return this;
    }

    @NotNull
    public final <Model> SelectionPreviewModel unregister(@NonNull @NotNull Class<Model> fragmentClass) {
        Intrinsics.checkNotNullParameter(fragmentClass, (String)"fragmentClass");
        this.config.getRegistry().unregister(fragmentClass);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel inflateCustomLayout(@NotNull LayoutSource key, @LayoutRes int resource) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Integer n = resource;
        ((Map)this.config.getLayoutSource()).put(key, n);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel setStatusBarStyle(@NotNull StatusBarStyle statusBar) {
        Intrinsics.checkNotNullParameter((Object)statusBar, (String)"statusBar");
        this.config.setStatusBarStyle(statusBar);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel setWindowAnimStyle(@NotNull WindowAnimStyle windowAnimStyle) {
        Intrinsics.checkNotNullParameter((Object)windowAnimStyle, (String)"windowAnimStyle");
        this.config.setWindowAnimStyle(windowAnimStyle);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel setImageEngine(@Nullable ImageEngine engine) {
        this.config.setImageEngine(engine);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel isAutoPlay(boolean isAutoPlay) {
        this.config.setAutoPlay(isAutoPlay);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel isLoopAutoVideoPlay(boolean isLoopAutoPlay) {
        this.config.setLoopAutoPlay(isLoopAutoPlay);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel isVideoPauseResumePlay(boolean isPauseResumePlay) {
        this.config.setPauseResumePlay(isPauseResumePlay);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel setLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        this.config.setLanguage(language);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel setDefaultLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        this.config.setDefaultLanguage(language);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel isPreviewFullScreenMode(boolean isFullScreenModel) {
        this.config.setPreviewFullScreenMode(isFullScreenModel);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel isPreviewZoomEffect(boolean isPreviewEffect, boolean isFullScreen, @NotNull ViewGroup listView) {
        Intrinsics.checkNotNullParameter((Object)listView, (String)"listView");
        this.config.setPreviewFullScreenMode(isFullScreen);
        this.config.setPreviewZoomEffect(isPreviewEffect);
        if (isPreviewEffect) {
            int n;
            if (isFullScreen) {
                n = 0;
            } else {
                Context context = listView.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"listView.context");
                n = DensityUtil.INSTANCE.getStatusBarHeight(context);
            }
            RecycleItemViewParams.INSTANCE.build(listView, n);
        }
        return this;
    }

    @NotNull
    public final SelectionPreviewModel isDisplayDelete(boolean isDisplayDelete) {
        this.config.getPreviewWrap().setDisplayDelete(isDisplayDelete);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel isLongPressDownload(boolean isDownload) {
        this.config.getPreviewWrap().setDownload(isDownload);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel setOnFragmentLifecycleListener(@Nullable OnFragmentLifecycleListener l) {
        this.config.getMListenerInfo().setOnFragmentLifecycleListener(l);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel setOnCustomAnimationListener(@Nullable OnCustomAnimationListener l) {
        this.config.getMListenerInfo().setOnCustomAnimationListener(l);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel setOnExternalPreviewListener(@Nullable OnExternalPreviewListener l) {
        this.config.getMListenerInfo().setOnExternalPreviewListener(l);
        return this;
    }

    @NotNull
    public final SelectionPreviewModel setOnCustomLoadingListener(@Nullable OnCustomLoadingListener loading) {
        this.config.getMListenerInfo().setOnCustomLoadingListener(loading);
        return this;
    }

    public final void forPreviewUrl(int position, @NotNull List<String> strings, boolean attachActivity) {
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        List source = new ArrayList();
        Iterable $this$forEach$iv = strings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String path = (String)element$iv;
            boolean bl = false;
            LocalMedia media = new LocalMedia();
            media.setPath(path);
            if (MediaUtils.INSTANCE.isHasHttp(path)) {
                media.setMimeType(MediaUtils.INSTANCE.getUrlMimeType(path));
            } else if (MediaUtils.INSTANCE.isContent(path)) {
                Activity activity = this.selector.getActivity$selector_release();
                Intrinsics.checkNotNull((Object)activity);
                Context context = (Context)activity;
                Uri uri = Uri.parse((String)path);
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(path)");
                String absolutePath = MediaUtils.INSTANCE.getPath(context, uri);
                media.setMimeType(MediaUtils.INSTANCE.getMimeType(absolutePath));
                media.setAbsolutePath(absolutePath);
            } else {
                media.setMimeType(MediaUtils.INSTANCE.getMimeType(path));
                media.setAbsolutePath(path);
            }
            source.add(media);
        }
        this.forPreview(position, source, attachActivity);
    }

    public final void forPreview(int position, @NotNull List<LocalMedia> source) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        this.forPreview(position, source, false);
    }

    public final void forPreview(int position, @NotNull List<LocalMedia> source, boolean attachActivity) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        if (DoubleUtils.INSTANCE.isFastDoubleClick()) {
            return;
        }
        Activity activity = this.selector.getActivity$selector_release();
        if (activity == null) {
            throw new NullPointerException("PictureSelector.create(); # Activity is empty");
        }
        Activity activity2 = activity;
        if (source.isEmpty()) {
            throw new NullPointerException("Preview source not null");
        }
        if (position >= source.size()) {
            throw new NullPointerException("#position# cannot be greater than #source.size#");
        }
        if (this.config.getImageEngine() == null && this.config.getMediaType() != MediaType.AUDIO) {
            throw new NullPointerException("Please set the API # .setImageEngine(" + Reflection.getOrCreateKotlinClass(ImageEngine.class).getSimpleName() + ");");
        }
        if (MediaUtils.INSTANCE.hasMimeTypeOfAudio(source.get(position).getMimeType())) {
            this.config.setPreviewZoomEffect(false);
        }
        this.config.getPreviewWrap().setSource(CollectionsKt.toMutableList((Collection)source));
        this.config.getPreviewWrap().setPosition(position);
        this.config.getPreviewWrap().setExternalPreview(true);
        this.config.getPreviewWrap().setTotalCount(source.size());
        if (attachActivity) {
            Intent intent = new Intent((Context)activity2, SelectorTransparentActivity.class);
            Fragment fragment = this.selector.getFragment$selector_release();
            if (fragment != null) {
                fragment.startActivity(intent);
            } else {
                activity2.startActivity(intent);
            }
            if (this.config.isPreviewZoomEffect()) {
                activity2.overridePendingTransition(R.anim.ps_anim_fade_in, R.anim.ps_anim_fade_in);
            } else {
                activity2.overridePendingTransition(this.config.getWindowAnimStyle().getEnterAnimRes(), R.anim.ps_anim_fade_in);
            }
        } else {
            Fragment fragment;
            FragmentManager fragmentManager = null;
            if (activity2 instanceof FragmentActivity) {
                fragmentManager = ((FragmentActivity)activity2).getSupportFragmentManager();
            }
            if (fragmentManager == null) {
                throw new NullPointerException("FragmentManager cannot be null");
            }
            ClassFactory.NewInstance factory = new ClassFactory.NewInstance();
            Registry registry = this.config.getRegistry();
            SelectorPreviewFragment instance = factory.create(registry.get(SelectorPreviewFragment.class));
            if (((Object)((Object)instance)).getClass().isAssignableFrom(SelectorPreviewFragment.class)) {
                instance = factory.create(registry.get(SelectorExternalPreviewFragment.class));
            }
            if ((fragment = fragmentManager.findFragmentByTag(instance.getFragmentTag())) != null) {
                fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
            }
            FragmentInjectManager.INSTANCE.injectSystemRoomFragment((FragmentActivity)activity2, instance.getFragmentTag(), instance);
        }
    }
}

