/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.model;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.luck.picture.lib.SelectorSystemFragment;
import com.luck.picture.lib.SelectorTransparentActivity;
import com.luck.picture.lib.config.MediaType;
import com.luck.picture.lib.config.SelectionMode;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.engine.CropEngine;
import com.luck.picture.lib.engine.MediaConverterEngine;
import com.luck.picture.lib.factory.ClassFactory;
import com.luck.picture.lib.helper.FragmentInjectManager;
import com.luck.picture.lib.interfaces.OnCustomLoadingListener;
import com.luck.picture.lib.interfaces.OnPermissionApplyListener;
import com.luck.picture.lib.interfaces.OnPermissionDeniedListener;
import com.luck.picture.lib.interfaces.OnPermissionDescriptionListener;
import com.luck.picture.lib.interfaces.OnResultCallbackListener;
import com.luck.picture.lib.model.PictureSelector;
import com.luck.picture.lib.provider.SelectorProviders;
import com.luck.picture.lib.registry.Registry;
import com.luck.picture.lib.utils.DoubleUtils;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J2\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00002\b\b\u0001\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0014\u001a\u00020\u0000\"\u0004\b\u0000\u0010\u00162\u000e\b\u0001\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018J\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0010\u0010!\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010#J\u0010\u0010$\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010%J\u0010\u0010&\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010'J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*J\u001f\u0010+\u001a\u00020\u00002\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0-\"\u00020.\u00a2\u0006\u0002\u0010/J\u001c\u00100\u001a\u00020\u0000\"\u0004\b\u0000\u001012\u000e\b\u0001\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H10\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/luck/picture/lib/model/SelectionSystemModel;", "", "selector", "Lcom/luck/picture/lib/model/PictureSelector;", "mediaType", "Lcom/luck/picture/lib/config/MediaType;", "(Lcom/luck/picture/lib/model/PictureSelector;Lcom/luck/picture/lib/config/MediaType;)V", "config", "Lcom/luck/picture/lib/config/SelectorConfig;", "forResult", "", "launcher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "call", "Lcom/luck/picture/lib/interfaces/OnResultCallbackListener;", "attachActivity", "", "requestCode", "", "registry", "Lcom/luck/picture/lib/registry/Registry;", "V", "targetClass", "Ljava/lang/Class;", "setCropEngine", "engine", "Lcom/luck/picture/lib/engine/CropEngine;", "setMediaConverterEngine", "Lcom/luck/picture/lib/engine/MediaConverterEngine;", "setOnCustomLoadingListener", "loading", "Lcom/luck/picture/lib/interfaces/OnCustomLoadingListener;", "setOnPermissionDeniedListener", "l", "Lcom/luck/picture/lib/interfaces/OnPermissionDeniedListener;", "setOnPermissionDescriptionListener", "Lcom/luck/picture/lib/interfaces/OnPermissionDescriptionListener;", "setOnPermissionsApplyListener", "Lcom/luck/picture/lib/interfaces/OnPermissionApplyListener;", "setSelectionMode", "selectionMode", "Lcom/luck/picture/lib/config/SelectionMode;", "setSkipCropFormat", "format", "", "", "([Ljava/lang/String;)Lcom/luck/picture/lib/model/SelectionSystemModel;", "unregister", "Model", "selector_release"})
public final class SelectionSystemModel {
    @NotNull
    private PictureSelector selector;
    @NotNull
    private SelectorConfig config;

    public SelectionSystemModel(@NotNull PictureSelector selector, @NotNull MediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        this.selector = selector;
        this.config = new SelectorConfig();
        this.config.setMediaType(mediaType);
        this.config.setPreviewZoomEffect(false);
        this.config.setPreviewFullScreenMode(false);
        SelectorProviders.Companion.getInstance().addConfigQueue(this.config);
    }

    @NotNull
    public final <V> SelectionSystemModel registry(@NonNull @NotNull Class<V> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        this.config.getRegistry().register(targetClass);
        return this;
    }

    @NotNull
    public final SelectionSystemModel registry(@NonNull @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.config.setRegistry(registry);
        return this;
    }

    @NotNull
    public final <Model> SelectionSystemModel unregister(@NonNull @NotNull Class<Model> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        this.config.getRegistry().unregister(targetClass);
        return this;
    }

    @NotNull
    public final SelectionSystemModel setSelectionMode(@NotNull SelectionMode selectionMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)selectionMode), (String)"selectionMode");
        this.config.setSelectionMode(selectionMode);
        return this;
    }

    @NotNull
    public final SelectionSystemModel setSkipCropFormat(String ... format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.config.getSkipCropFormat().addAll(ArraysKt.toMutableList((Object[])format));
        return this;
    }

    @NotNull
    public final SelectionSystemModel setOnPermissionsApplyListener(@Nullable OnPermissionApplyListener l) {
        this.config.getMListenerInfo().setOnPermissionApplyListener(l);
        return this;
    }

    @NotNull
    public final SelectionSystemModel setOnPermissionDescriptionListener(@Nullable OnPermissionDescriptionListener l) {
        this.config.getMListenerInfo().setOnPermissionDescriptionListener(l);
        return this;
    }

    @NotNull
    public final SelectionSystemModel setOnPermissionDeniedListener(@Nullable OnPermissionDeniedListener l) {
        this.config.getMListenerInfo().setOnPermissionDeniedListener(l);
        return this;
    }

    @NotNull
    public final SelectionSystemModel setOnCustomLoadingListener(@Nullable OnCustomLoadingListener loading) {
        this.config.getMListenerInfo().setOnCustomLoadingListener(loading);
        return this;
    }

    @NotNull
    public final SelectionSystemModel setMediaConverterEngine(@Nullable MediaConverterEngine engine) {
        this.config.setMediaConverterEngine(engine);
        return this;
    }

    @NotNull
    public final SelectionSystemModel setCropEngine(@Nullable CropEngine engine) {
        this.config.setCropEngine(engine);
        return this;
    }

    public final void forResult(@Nullable OnResultCallbackListener call) {
        this.forResult(call, -2147483647, null, false);
    }

    public final void forResult(@Nullable OnResultCallbackListener call, boolean attachActivity) {
        this.forResult(call, -2147483647, null, attachActivity);
    }

    public final void forResult(int requestCode) {
        this.forResult(null, requestCode, null, true);
    }

    public final void forResult(@NotNull ActivityResultLauncher<Intent> launcher) {
        Intrinsics.checkNotNullParameter(launcher, (String)"launcher");
        this.forResult(null, -2147483647, launcher, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void forResult(OnResultCallbackListener call, int requestCode, ActivityResultLauncher<Intent> launcher, boolean attachActivity) {
        if (DoubleUtils.INSTANCE.isFastDoubleClick()) {
            return;
        }
        Activity activity = this.selector.getActivity$selector_release();
        if (activity == null) {
            throw new NullPointerException("PictureSelector.create(); # Activity is empty");
        }
        Activity activity2 = activity;
        this.config.setSystemGallery(true);
        if (attachActivity) {
            Intent intent = new Intent((Context)activity2, SelectorTransparentActivity.class);
            if (call != null) {
                this.config.getMListenerInfo().setOnResultCallbackListener(call);
                activity2.startActivity(intent);
                return;
            } else if (launcher != null) {
                this.config.setActivityResult(true);
                launcher.launch((Object)intent);
                return;
            } else {
                if (requestCode == -2147483647) throw new IllegalStateException(".forResult(); did not specify a corresponding result listening type callback");
                this.config.setActivityResult(true);
                Fragment fragment = this.selector.getFragment$selector_release();
                if (fragment != null) {
                    fragment.startActivityForResult(intent, requestCode);
                    return;
                } else {
                    activity2.startActivityForResult(intent, requestCode);
                }
            }
            return;
        } else {
            FragmentManager fragmentManager = null;
            if (activity2 instanceof FragmentActivity) {
                fragmentManager = ((FragmentActivity)activity2).getSupportFragmentManager();
            }
            if (fragmentManager == null) {
                throw new NullPointerException("FragmentManager cannot be null");
            }
            if (call == null) {
                throw new IllegalStateException(".forResult(); did not specify a corresponding result listening type callback");
            }
            this.config.getMListenerInfo().setOnResultCallbackListener(call);
            SelectorSystemFragment instance = new ClassFactory.NewInstance().create(this.config.getRegistry().get(SelectorSystemFragment.class));
            Fragment fragment = fragmentManager.findFragmentByTag(instance.getFragmentTag());
            if (fragment != null) {
                fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
            }
            FragmentInjectManager.INSTANCE.injectSystemRoomFragment((FragmentActivity)activity2, instance.getFragmentTag(), instance);
        }
    }
}

